/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.IScsiSessionConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetPortalConfigurator;
import com.sanrad.nms.server.mgr.SrSCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class SCSIRemoteTargetConfigurator
extends ElementConfigurator {
    private static final Object s_createLock = new Object();
    static Integer[] lastRemoteTargetIndex = new Integer[0];

    public SCSIRemoteTargetConfigurator() {
        super(ClassID.SCSI_REMOTE_TARGET, "scsiDscTgtTable", MibItem.SCSI_DISCOVER_TARGET_ROW_STATUS, MibItem.SCSI_REMOTE_TARGET_LAST_CHANGE);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.DISCOVERED_TARGET_NAME, null);
        paramList.put(ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED, null);
        paramList.put(ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED, null);
        paramList.put(ParameterCode.ISCSI_REMOTE_TARGET_NUM_OF_PORTALS, null);
        return paramList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        Integer[] integerArray = lastRemoteTargetIndex;
        synchronized (lastRemoteTargetIndex) {
            Object rTargetAlias = element.removeParameter(ParameterCode.SCSI_REMOTE_TARGET_ALIAS);
            Object rTargetIdentityAlias = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_IDENTITY_ALIAS);
            Object rTargetCHAPUserName = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_USER_NAME);
            Object rTargetCHAPPassword = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_CHAP_PASSWORD);
            Object arrayOfrTargetPortalIPs = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP);
            Object arrayOfrTargetPortalPorts = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT);
            Object arrayOfrTargetPortalGroupTags = element.removeParameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG);
            this.calculateRemoteTargetCommKey(element);
            super.internalCreate(element);
            SrSCSIRemoteTargetConfigurator srSCSIRemoteTargetCfg = new SrSCSIRemoteTargetConfigurator();
            element = new ConfigElementData(element.getCommKeyClassId());
            this.changeRemoteTargetAliasOnCreate(srSCSIRemoteTargetCfg, element, rTargetAlias);
            element = new ConfigElementData(element.getCommKeyClassId());
            srSCSIRemoteTargetCfg.internalRead(element);
            this.changeRemoteTargetIdentityAndCHAPCredOnCreate(element, rTargetIdentityAlias, rTargetCHAPUserName, rTargetCHAPPassword);
            if (arrayOfrTargetPortalIPs != null) {
                this.createRemoteTargetPortalsOnCreate(element, arrayOfrTargetPortalIPs, arrayOfrTargetPortalPorts, arrayOfrTargetPortalGroupTags);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void calculateRemoteTargetCommKey(ConfigElementData element) throws SrCommunicationException {
        CommKeyClassId vswitchData = (CommKeyClassId)element.removeParameter(ParameterCode.VSWITCH_ID);
        SnmpCommKey snmpCommKey = CommKeyUtil.getSnmpCommKey(vswitchData);
        char agentIndex = snmpCommKey.getSnmpAgentIndex();
        CommKeyClassId[] initiatorsIds = (CommKeyClassId[])element.getValue(ParameterCode.ISCSI_INITIATOR_ID);
        CommKeyClassId initiatorId = CommKeyUtil.getSpecificCommKeyClassId(initiatorsIds, agentIndex);
        String initiatorCommKey = CommKeyUtil.getSpecificSnmpKey(initiatorId, agentIndex).getKey();
        if (lastRemoteTargetIndex.length <= agentIndex) {
            Integer[] newArray = new Integer[agentIndex + '\u0001'];
            System.arraycopy(lastRemoteTargetIndex, 0, newArray, 0, lastRemoteTargetIndex.length);
            newArray[agentIndex] = new Integer(0);
            lastRemoteTargetIndex = newArray;
        } else if (lastRemoteTargetIndex[agentIndex] == null) {
            SCSIRemoteTargetConfigurator.lastRemoteTargetIndex[agentIndex] = new Integer(0);
        }
        this.getAll(agentIndex, null, null);
        Integer newIndex = new Integer(lastRemoteTargetIndex[agentIndex] + 1);
        element.setCommKey(new SnmpCommKey(initiatorCommKey + ".0." + newIndex.toString(), agentIndex));
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        SrTimeTicks noLastUpdateValuePerTable = null;
        ConfigElementDataList remoteTargetList = this.getAll(snmpAgentIndex, noLastUpdateValuePerTable, checkListElement);
        if (remoteTargetList != null && remoteTargetList.size() > 0) {
            this.removeNotSupportedRemoteTargets(remoteTargetList);
            SrSCSIRemoteTargetConfigurator srSCSIRemoteTargetCfg = new SrSCSIRemoteTargetConfigurator();
            ConfigElementDataList srRemoteTargetList = srSCSIRemoteTargetCfg.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            srSCSIRemoteTargetCfg.mergeElementLists(remoteTargetList, srRemoteTargetList, true);
            SCSIRemoteTargetPortalConfigurator remoteTargetPortalConfig = new SCSIRemoteTargetPortalConfigurator();
            ConfigElementDataList remoteTargetPortalList = remoteTargetPortalConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            remoteTargetList.addAll((Collection)remoteTargetPortalList);
        }
        if (remoteTargetList == null) {
            remoteTargetList = new ConfigElementDataList();
        }
        return remoteTargetList;
    }

    public boolean readAfterCreate(ConfigElementData element) throws SrCommunicationException {
        ConfigElementData newElement = new ConfigElementData(element.getCommKeyClassId());
        ConfigElementDataList retrievedElements = new ConfigElementDataList();
        this.internalRead(newElement, retrievedElements);
        SrEventHandler.getEventMgr().sendAddElementEvent(retrievedElements);
        return true;
    }

    public void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        IdentityConfigurator identityCfg = new IdentityConfigurator();
        CommKeyClassId identityCommKeyClassId = (CommKeyClassId)element.getValue(ParameterCode.IDENTITY_ID);
        if (identityCommKeyClassId != null) {
            ConfigElementData identityElement = new ConfigElementData(identityCommKeyClassId);
            identityCfg.internalRead(identityElement, retrievedElements);
        }
        ConfigElementData mergedElement = this.readAndMergeRemoteTarget(element);
        SCSIRemoteTargetPortalConfigurator remoteTargetPortalConfig = new SCSIRemoteTargetPortalConfigurator();
        ConfigElementDataList portalsByPrefix = remoteTargetPortalConfig.getAllByPrefix(snmpAgentIndex, element.getSnmpKey().toString());
        if (retrievedElements != null) {
            retrievedElements.add(mergedElement);
            retrievedElements.addAll((Collection)portalsByPrefix);
        }
    }

    public ConfigElementData readAndMergeRemoteTarget(ConfigElementData element) throws SrCommunicationException {
        ConfigElementData newElement = new ConfigElementData(element.getCommKeyClassId());
        SrSCSIRemoteTargetConfigurator srSCSIRemoteTargetCfg = new SrSCSIRemoteTargetConfigurator();
        srSCSIRemoteTargetCfg.internalRead(newElement);
        ConfigElementDataList srRemoteTargetList = new ConfigElementDataList();
        srRemoteTargetList.add(newElement);
        ConfigElementDataList remoteTargetList = new ConfigElementDataList();
        remoteTargetList.add(element);
        srSCSIRemoteTargetCfg.mergeElementLists(remoteTargetList, srRemoteTargetList, true);
        return remoteTargetList.getConfigElementDataAt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        String index = element.getSnmpKey().toString();
        int pos = index.lastIndexOf(".") + 1;
        index = index.substring(pos);
        Integer idIndex = new Integer(index);
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        Integer[] integerArray = lastRemoteTargetIndex;
        synchronized (lastRemoteTargetIndex) {
            SrInteger isDiscoveredInt;
            if (lastRemoteTargetIndex.length <= agentIndex) {
                Integer[] newArray = new Integer[agentIndex + '\u0001'];
                System.arraycopy(lastRemoteTargetIndex, 0, newArray, 0, lastRemoteTargetIndex.length);
                newArray[agentIndex] = idIndex;
                lastRemoteTargetIndex = newArray;
            } else if (lastRemoteTargetIndex[agentIndex] == null || idIndex > lastRemoteTargetIndex[agentIndex]) {
                SCSIRemoteTargetConfigurator.lastRemoteTargetIndex[agentIndex] = idIndex;
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            SrInteger isConfiguredInt = (SrInteger)element.getValue(ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED);
            if (isConfiguredInt != null) {
                element.setValue(ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED, new SrBoolean(isConfiguredInt.intValue()));
            }
            if ((isDiscoveredInt = (SrInteger)element.getValue(ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED)) != null) {
                element.setValue(ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED, new SrBoolean(isDiscoveredInt.intValue()));
            }
            return;
        }
    }

    private void changeRemoteTargetAliasOnCreate(SrSCSIRemoteTargetConfigurator srSCSIRemoteTargetCfg, ConfigElementData remoteTargetElement, Object alias) {
        remoteTargetElement.addParameter(new Parameter(ParameterCode.SCSI_REMOTE_TARGET_ALIAS, alias));
        try {
            srSCSIRemoteTargetCfg.internalChange(remoteTargetElement);
        }
        catch (SrCommunicationException e) {
            e.printStackTrace();
        }
        catch (SrElementOperationException e) {
            e.printStackTrace();
        }
    }

    private ConfigElementData getIdentityIdFromRemoteTargetElement(ConfigElementData remoteTargetElement) throws SrCommunicationException {
        CommKeyClassId identityCommKeyClassId = (CommKeyClassId)remoteTargetElement.getValue(ParameterCode.IDENTITY_ID);
        IdentityConfigurator identityConfigurator = new IdentityConfigurator();
        ConfigElementData identityElement = new ConfigElementData(identityCommKeyClassId);
        ConfigElementDataList retrievedElements = new ConfigElementDataList();
        identityConfigurator.internalRead(identityElement, retrievedElements);
        Iterator elementsItr = retrievedElements.iterator();
        while (elementsItr.hasNext()) {
            ConfigElementData retreivedElement = (ConfigElementData)elementsItr.next();
            SrEventHandler.getEventMgr().sendAddElementEvent(retreivedElement);
            if (!retreivedElement.getClassId().equals(ClassID.CHAP_CREDENTIALS)) continue;
            return retreivedElement;
        }
        return null;
    }

    private ConfigElementData getChapIdFromRemoteTargetElement(ConfigElementData remoteTargetElement) throws SrCommunicationException {
        CommKeyClassId identityCommKeyClassId = (CommKeyClassId)remoteTargetElement.getValue(ParameterCode.IDENTITY_ID);
        IdentityConfigurator identityConfigurator = new IdentityConfigurator();
        ConfigElementData identityElement = new ConfigElementData(identityCommKeyClassId);
        ConfigElementDataList retrievedElements = new ConfigElementDataList();
        identityConfigurator.internalRead(identityElement, retrievedElements);
        Iterator elementsItr = retrievedElements.iterator();
        while (elementsItr.hasNext()) {
            ConfigElementData retreivedElement = (ConfigElementData)elementsItr.next();
            SrEventHandler.getEventMgr().sendAddElementEvent(retreivedElement);
            if (!retreivedElement.getClassId().equals(ClassID.CHAP_CREDENTIALS)) continue;
            return retreivedElement;
        }
        return null;
    }

    private void changeRemoteTargetIdentityAndCHAPCredOnCreate(ConfigElementData remoteTargetElement, Object identityAlias, Object userName, Object password) {
        try {
            IdentityConfigurator identityConfigurator = new IdentityConfigurator();
            CommKeyClassId identityCommKeyClassId = (CommKeyClassId)remoteTargetElement.getValue(ParameterCode.IDENTITY_ID);
            ConfigElementData identityElement = new ConfigElementData(identityCommKeyClassId);
            ConfigElementDataList retrievedElements = new ConfigElementDataList();
            identityConfigurator.internalRead(identityElement, retrievedElements);
            Iterator elementsItr = retrievedElements.iterator();
            while (elementsItr.hasNext()) {
                ConfigElementData retreivedElement = (ConfigElementData)elementsItr.next();
                SrEventHandler.getEventMgr().sendAddElementEvent(retreivedElement);
                if (!retreivedElement.getClassId().equals(ClassID.CHAP_CREDENTIALS)) continue;
                if (userName != null || password != null) {
                    CommKeyClassId chapCredId = retreivedElement.getCommKeyClassId();
                    ConfigElementData newChapCredElement = new ConfigElementData(chapCredId);
                    if (userName != null) {
                        newChapCredElement.addParameter(new Parameter(ParameterCode.CHAP_CREDENTIALS_USER_NAME, userName));
                    }
                    if (password != null) {
                        newChapCredElement.addParameter(new Parameter(ParameterCode.CHAP_CREDENTIALS_PASSWORD, password));
                    }
                    CHAPCredentialsConfigurator chapCredConfigurator = new CHAPCredentialsConfigurator();
                    chapCredConfigurator.internalChange(newChapCredElement);
                }
                return;
            }
        }
        catch (SrCommunicationException e) {
            e.printStackTrace();
        }
        catch (SrElementOperationException e) {
            e.printStackTrace();
        }
    }

    private void createRemoteTargetPortalsOnCreate(ConfigElementData remoteTargetElement, Object arrayOfrTargetPortalIPs, Object arrayOfrTargetPortalPorts, Object arrayOfrTargetPortalGroupTags) throws SrCommunicationException, SrElementOperationException {
        CommKeyClassId vswitchData = CommKeyUtil.getVSwitchData(remoteTargetElement.getMyFirstSnmpAgentIndex());
        SrString[] remoteTargetPortalIPs = (SrString[])arrayOfrTargetPortalIPs;
        SrGauge[] remoteTargetPortalPorts = (SrGauge[])arrayOfrTargetPortalPorts;
        SrInteger[] remoteTargetPortalGroupTags = (SrInteger[])arrayOfrTargetPortalGroupTags;
        SCSIRemoteTargetPortalConfigurator portalConfigurator = new SCSIRemoteTargetPortalConfigurator();
        ConfigElementData remoteTargetPortalElement = new ConfigElementData(ClassID.ISCSI_REMOTE_TARGET_PORTAL);
        for (int index = 0; index < remoteTargetPortalIPs.length; ++index) {
            remoteTargetPortalElement.setValue(ParameterCode.VSWITCH_ID, vswitchData);
            remoteTargetPortalElement.setValue(ParameterCode.ISCSI_REMOTE_TARGET_ID, remoteTargetElement.getCommKeyClassId());
            SrString remoteTargetPortalIP = remoteTargetPortalIPs[index];
            SrGauge remoteTargetPortalPort = remoteTargetPortalPorts[index];
            SrInteger remoteTargetPortalGroupTag = remoteTargetPortalGroupTags[index];
            remoteTargetPortalElement.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, new SrIpAddress(remoteTargetPortalIP.toString())));
            remoteTargetPortalElement.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, remoteTargetPortalPort));
            remoteTargetPortalElement.addParameter(new Parameter(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, remoteTargetPortalGroupTag));
            portalConfigurator.internalCreate(remoteTargetPortalElement);
        }
    }

    public void refreshRemoteTargetsForDependantOnOperations(char snmpAgent) {
        try {
            ConfigElementDataList elements = this.getAllExtended(snmpAgent, null, null);
            IdentityConfigurator identityCfg = new IdentityConfigurator();
            ConfigElementDataList retrievedElements = new ConfigElementDataList();
            for (int index = 0; index < elements.size(); ++index) {
                retrievedElements.clear();
                ConfigElementData nextElement = (ConfigElementData)elements.get(index);
                if (!nextElement.getClassId().equals(ClassID.ISCSI_REMOTE_TARGET)) continue;
                CommKeyClassId identityCommKeyClassId = (CommKeyClassId)nextElement.getValue(ParameterCode.IDENTITY_ID);
                ConfigElementData identityElement = new ConfigElementData(identityCommKeyClassId);
                identityCfg.internalRead(identityElement, retrievedElements);
                SrEventHandler.getEventMgr().sendRefreshElementEvent(retrievedElements);
            }
            SrEventHandler.getEventMgr().sendRefreshElementEvent(elements);
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to refresh remote targets table after storage creation");
            return;
        }
        try {
            DataMgr.getInstance().waitForDataUpdatesInVSwitches(4000L);
            IScsiSessionConfigurator sessionsConfigurator = new IScsiSessionConfigurator();
            sessionsConfigurator.refreshSessions(snmpAgent);
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().debug("Failed to refresh iscsi sessions after dependant on operations");
            return;
        }
    }

    private void removeNotSupportedRemoteTargets(ConfigElementDataList remoteTargetList) {
        ConfigElementDataList supportedElements = new ConfigElementDataList();
        for (int index0 = 0; index0 < remoteTargetList.size(); ++index0) {
            ConfigElementData element = remoteTargetList.getConfigElementDataAt(index0);
            String elementSnmpKey = element.getSnmpKey().getKey();
            String prefix = elementSnmpKey.substring(0, elementSnmpKey.lastIndexOf("."));
            String thirdNumberInPrefix = prefix.substring(prefix.lastIndexOf(".") + 1);
            String secondNumberInPrefix = prefix.substring(prefix.indexOf(".") + 1, prefix.lastIndexOf("."));
            if (secondNumberInPrefix.equals("2")) {
                if (!thirdNumberInPrefix.equals("0")) continue;
                supportedElements.add(element);
                continue;
            }
            supportedElements.add(element);
        }
        remoteTargetList.clear();
        remoteTargetList.addAll((Collection)supportedElements);
    }
}

