/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiPortalConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrIpAddress;
import java.util.HashMap;

public class NetConfigConfigurator
extends ElementConfigurator {
    static Integer[] lastIpIndex = new Integer[0];

    public NetConfigConfigurator() {
        super(ClassID.NETWORK_CONFIGURATION, "srNetworkConfigurationTable", MibItem.IP_TABLE_RS, MibItem.IP_TABLE_LAST_UPDATE);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.NETWORK_CONFIG_ACTIVITY, null);
        paramList.put(ParameterCode.NETWORK_CONFIG_INTERFACE, null);
        paramList.put(ParameterCode.NETWORK_CONFIG_IP_ADDRESS, null);
        paramList.put(ParameterCode.NETWORK_CONFIG_NET_MASK, null);
        return paramList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        Integer ipIndex = new Integer(element.getSnmpKey().toString());
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        if (lastIpIndex.length <= agentIndex) {
            Integer[] newArray = new Integer[agentIndex + '\u0001'];
            System.arraycopy(lastIpIndex, 0, newArray, 0, lastIpIndex.length);
            newArray[agentIndex] = ipIndex;
            lastIpIndex = newArray;
        } else if (lastIpIndex[agentIndex] == null || ipIndex > lastIpIndex[agentIndex]) {
            NetConfigConfigurator.lastIpIndex[agentIndex] = ipIndex;
        }
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        char agentIndex = element.getSnmpAgentFromParameter();
        if (lastIpIndex.length <= agentIndex) {
            Integer[] newArray = new Integer[agentIndex + '\u0001'];
            System.arraycopy(lastIpIndex, 0, newArray, 0, lastIpIndex.length);
            newArray[agentIndex] = new Integer(0);
            lastIpIndex = newArray;
        } else if (lastIpIndex[agentIndex] == null) {
            NetConfigConfigurator.lastIpIndex[agentIndex] = new Integer(0);
        }
        this.getAll(agentIndex, null, null);
        Integer newIndex = new Integer(lastIpIndex[agentIndex] + 1);
        element.setCommKey(new SnmpCommKey(newIndex.toString(), agentIndex));
        super.internalCreate(element);
    }

    public void postSendCreateEvent(ConfigElementData myElement) throws SrCommunicationException {
        SrIpAddress ipAddress = (SrIpAddress)myElement.getValue(ParameterCode.NETWORK_CONFIG_IP_ADDRESS);
        char snmpAgent = myElement.getSnmpAgentFromParameter();
        IscsiPortalConfigurator portalCfg = new IscsiPortalConfigurator();
        ConfigElementDataList list = portalCfg.refreshTable(snmpAgent, null, null);
        for (int index = 0; index < list.size(); ++index) {
            ConfigElementData portalElement = (ConfigElementData)list.elementAt(index);
            SrIpAddress portalIpAddress = (SrIpAddress)portalElement.getValue(ParameterCode.ISCSI_PORTAL_IP_ADDRESS);
            if (!portalIpAddress.toDisplayString().equals(ipAddress.toDisplayString())) continue;
            SrEventHandler.getEventMgr().sendAddElementEvent(portalElement);
        }
    }

    public void postSendRemoveEvent(ConfigElementData myElement) throws SrCommunicationException {
        char snmpAgent = myElement.getMyFirstSnmpAgentIndex();
        CheckListConfigElementData checkList = new CheckListConfigElementData(ClassID.PORTAL);
        IscsiPortalConfigurator portalCfg = new IscsiPortalConfigurator();
        ConfigElementDataList list = portalCfg.refreshTable(snmpAgent, null, checkList);
        SrEventHandler.getEventMgr().sendCheckListEvent(checkList);
        SrEventHandler.getEventMgr().sendRefreshElementEvent(list);
    }
}

