/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.TargetTypeConstants;
import java.util.HashMap;

public class LUNConfigurator
extends ElementConfigurator {
    public LUNConfigurator() {
        super(ClassID.LUN, "srVirtLogUnTable", MibItem.LUN_RS, MibItem.LUN_TBL_LAST_UPDATE, false);
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        char snmpAgentIndex = element.getSnmpAgentFromParameter();
        this.updateCedAfterCreate(element);
        CommKeyClassId target = (CommKeyClassId)element.getValue(ParameterCode.LU_PARENT);
        if (!target.getClassID().equals(ClassID.ISCSI_TARGET)) {
            LogMgr.getServerLog().info("Failed to create LU: Target of unknown type");
            throw new UnsupportedOperationException("Cannot create LU under target of unknown type");
        }
        CommKeyClassId volume = (CommKeyClassId)element.getValue(ParameterCode.LU_VOLUME_ID);
        boolean simpleVolumeWasCreated = false;
        if (this.isNewVersion()) {
            SrInteger indexNext = (SrInteger)this.getScalarFromComm(MibItem.LUN_NEXT_INDEX, snmpAgentIndex);
            SnmpCommKey key = new SnmpCommKey("1." + indexNext.toString(), snmpAgentIndex);
            element.setCommKey(key);
            if (volume.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || volume.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
                CommKeyClassId physStorData = volume;
                CommKey[] simpleVolKey = this.createSimpleVolume(physStorData, (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID));
                simpleVolumeWasCreated = true;
                element.setValue(ParameterCode.LU_VOLUME_ID, new CommKeyClassId(simpleVolKey, ClassID.SIMPLE_VOLUME));
            }
        } else if (volume.getClassID().equals(ClassID.CONCAT_VOLUME) || volume.getClassID().equals(ClassID.MIRROR_VOLUME) || volume.getClassID().equals(ClassID.STRIPE_VOLUME) || volume.getClassID().equals(ClassID.TRANSPARENT_VOLUME)) {
            SnmpCommKey snmpKey = CommKeyUtil.getSpecificSnmpKey(volume, snmpAgentIndex);
            element.setCommKey(snmpKey);
        } else if (volume.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || volume.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            CommKeyClassId physStorData = volume;
            CommKey[] simpleVolKey = this.createSimpleVolume(physStorData, (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID));
            simpleVolumeWasCreated = true;
            element.setCommKeys(simpleVolKey);
        } else {
            LogMgr.getServerLog().info("Failed to reate LU: Volume of unknown type.");
            throw new TypeMismatchException("The Volume exposed by the new LU is of unrecognized type");
        }
        try {
            super.internalCreate(element);
            if (simpleVolumeWasCreated) {
                element.setValue(ParameterCode.LU_VOLUME_ID, volume);
            }
        }
        catch (SrCommunicationException e) {
            if (simpleVolumeWasCreated) {
                this.removeSimpleVolume(volume, snmpAgentIndex);
                element.setValue(ParameterCode.LU_VOLUME_ID, volume);
            }
            e.setElement(element);
            throw e;
        }
    }

    public void internalRemove(ConfigElementData element) throws SrCommunicationException {
        CommKeyClassId volume = (CommKeyClassId)element.getValue(ParameterCode.LU_VOLUME_ID);
        char agentIndex = element.getSnmpAgentFromParameter();
        super.internalRemove(element);
        if (volume.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || volume.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            this.removeSimpleVolume(volume, agentIndex);
        }
    }

    protected void addCommVarBindsToCreateList(CommVarBindList list, ConfigElementData element) {
        SnmpCommKey luSnmpKey = element.getSnmpKey();
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        CommKeyClassId target = (CommKeyClassId)element.getValue(ParameterCode.LU_PARENT);
        SnmpCommKey specificTgtKey = CommKeyUtil.getSpecificSnmpKey(target, snmpAgentIndex);
        String targetIndices = specificTgtKey.getKey();
        String targetIdStr = targetIndices.substring(targetIndices.lastIndexOf(".") + 1);
        SrOid tgtIndexOid = new SrOid(MibItem.LUN_PARENT_INDEX.toString(), luSnmpKey.toString());
        list.add(new SrSnmpVarBind(tgtIndexOid, (SrType)new SrInteger(targetIdStr)));
        SrOid tgtTypeOid = new SrOid(MibItem.LUN_TARGET_TYPE.toString(), luSnmpKey.toString());
        list.add(new SrSnmpVarBind(tgtTypeOid, (SrType)TargetTypeConstants.TARGET_TYPE_ISCSI));
        if (this.isNewVersion()) {
            CommKeyClassId volume = (CommKeyClassId)element.getValue(ParameterCode.LU_VOLUME_ID);
            String volIndex = CommKeyUtil.getSpecificCommKey(volume, snmpAgentIndex).getKey();
            SrGauge volId = new SrGauge(volIndex.substring(volIndex.indexOf(".") + 1));
            SrOid volIdOid = new SrOid(MibItem.LUN_VOLUME_ID.toString(), luSnmpKey.toString());
            list.add(new SrSnmpVarBind(volIdOid, (SrType)volId));
        }
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.LU_LUN_NUMBER, null);
        paramList.put(ParameterCode.LU_PARENT, null);
        paramList.put(ParameterCode.LU_OPER_STATUS, null);
        paramList.put(ParameterCode.LU_CREATION_DATE, null);
        paramList.put(ParameterCode.LU_LAST_UPDATE, null);
        paramList.put(ParameterCode.LU_SERIAL_NUMBER, null);
        return paramList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        this.createTargetDataFromTypeAndIndex(element, list);
        SrGauge volId = (SrGauge)this.getVarBindValueFromList(list, MibItem.LUN_VOLUME_ID);
        if (volId != null) {
            String fullVolId = "1." + volId.toString();
            CommKeyClassId volData = DiscoverMgr.getInstance().getPhysStorOfVolId(fullVolId, list.getSnmpAgentIndex());
            if (volData == null) {
                volData = new CommKeyClassId(new SnmpCommKey(fullVolId, list.getSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
            } else {
                VolumeConfigurator volumeCfg = new VolumeConfigurator();
                CommKeyClassId volElementCommKeyClassId = new CommKeyClassId(new SnmpCommKey(fullVolId, list.getSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
                ConfigElementData volElement = new ConfigElementData(volElementCommKeyClassId);
                volumeCfg.internalRead(volElement);
                if (volElement.getClassId().equals(ClassID.TRANSPARENT_VOLUME)) {
                    volData = volElementCommKeyClassId;
                }
            }
            CommKeyClassId volumeData = (CommKeyClassId)element.getValue(ParameterCode.LU_VOLUME_ID);
            if (volumeData == null || !volumeData.getClassID().equals(ClassID.TRANSPARENT_VOLUME)) {
                element.setValue(ParameterCode.LU_VOLUME_ID, volData);
            }
        }
    }

    protected void discoveryPostDiscoverOpration(ConfigElementData element, CommVarBindList list) {
        SnmpCommKey luSnmpKey = element.getSnmpKey();
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        Object luChild = element.getValue(ParameterCode.LU_VOLUME_ID);
        if (luChild == null && !this.isNewVersion()) {
            String volumeId = luSnmpKey.toString();
            CommKeyClassId childData = DiscoverMgr.getInstance().getPhysStorOfVolId(volumeId, agentIndex);
            if (childData == null) {
                childData = new CommKeyClassId(new SnmpCommKey("1." + volumeId, list.getSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
            }
            element.setValue(ParameterCode.LU_VOLUME_ID, childData);
        }
    }

    private void createTargetDataFromTypeAndIndex(ConfigElementData element, CommVarBindList list) {
        SrType tgtIndx = this.getVarBindValueFromList(list, MibItem.LUN_PARENT_INDEX);
        if (tgtIndx != null) {
            SnmpCommKey tgtCommKey = new SnmpCommKey("1.1." + String.valueOf(((SrInteger)tgtIndx).intValue()), element.getMyFirstSnmpAgentIndex());
            CommKeyClassId tgtData = new CommKeyClassId(tgtCommKey, ClassID.ISCSI_TARGET);
            element.setValue(ParameterCode.LU_PARENT, tgtData);
        }
    }

    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        SnmpCommKey luSnmpKey = element.getSnmpKey();
        SrOid oid = new SrOid(MibItem.LUN_TARGET_TYPE.toString(), luSnmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
        oid = new SrOid(MibItem.LUN_VOLUME_ID.toString(), luSnmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
        oid = new SrOid(MibItem.LUN_PARENT_INDEX.toString(), luSnmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 6: {
                return MibItem.LUN_OPER_STATUS;
            }
        }
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        LogMgr.getServerLog().debug("Changed by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendChangeElementEvent(element);
    }

    boolean isNewVersion() {
        return true;
    }
}

