/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.IfXStatisticConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import java.util.HashMap;
import java.util.Iterator;

public class IfStatisticConfigurator
extends ElementConfigurator {
    public IfStatisticConfigurator() {
        super(ClassID.STATISTIC_INTERFACE, "ifTable", null, null);
    }

    protected IfStatisticConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib) {
        super(classId, tableName, rowStatusMib, lastUpdateMib);
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList ifList = this.getAllExtended(snmpAgentIndex, null, null);
        Iterator i = ifList.iterator();
        while (i.hasNext()) {
            ((ConfigElementData)i.next()).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        }
        if (ifList.size() > 0) {
            this.sendDiscoveredElementsToEventMgr(ifList, vSwitchData);
        }
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        SrTimeTicks noLastUpdateValuePerTable = null;
        ConfigElementDataList ifStatList = this.getAll(snmpAgentIndex, noLastUpdateValuePerTable, checkListElement);
        if (ifStatList.size() > 0) {
            IfXStatisticConfigurator ifXStatConfig = new IfXStatisticConfigurator();
            ConfigElementDataList ifXStatList = ifXStatConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            this.mergeElementLists(ifStatList, ifXStatList, true);
        }
        return ifStatList;
    }

    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
        ClassID elementClassId = element.getClassId();
        SnmpCommKey elementCommKey = element.getSnmpKey();
        ConfigElementData newElement = new ConfigElementData(elementCommKey, elementClassId);
        IfXStatisticConfigurator ifXStatConfig = new IfXStatisticConfigurator();
        ifXStatConfig.internalRead(newElement);
        element.addParameter(newElement.getParametersList());
        if (retrievedElements != null) {
            retrievedElements.add(element);
        }
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>();
        paramList.put(ParameterCode.IF_TYPE, null);
        paramList.put(ParameterCode.IF_IN_DISCARDS, null);
        paramList.put(ParameterCode.IF_OUT_DISCARDS, null);
        paramList.put(ParameterCode.IF_IN_ERRORS, null);
        paramList.put(ParameterCode.IF_OUT_ERRORS, null);
        paramList.put(ParameterCode.IF_IN_UNKNOWN_PROTOCOLS, null);
        return paramList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        Object[] keySet = element.getParametersList().keySet().toArray();
        HashMap relevantKeys = this.getListOfParams();
        for (int i = 0; i < keySet.length; ++i) {
            ParameterCode currParam = (ParameterCode)keySet[i];
            if (relevantKeys.containsKey(currParam) || currParam.equals(ParameterCode.VSWITCH_ID)) continue;
            element.removeParameter(currParam);
        }
        IANAifTypeConstant type = (IANAifTypeConstant)element.getValue(ParameterCode.IF_TYPE);
        ClassID ifClassId = ClassID.INTERFACE;
        if (type.equals(IANAifTypeConstant.IANA_IF_TYPE_FC)) {
            ifClassId = ClassID.FC_INTERFACE;
        } else if (type.equals(IANAifTypeConstant.IANA_IF_TYPE_PARALLEL_SCSI)) {
            ifClassId = ClassID.PSCSI_INTERFACE;
        } else if (type.equals(IANAifTypeConstant.IANA_IF_TYPE_ETHERNET)) {
            ifClassId = ClassID.ETHERNET_INTERFACE;
        }
        SnmpCommKey commKey = element.getSnmpKey();
        CommKeyClassId interfaceCommKeyClassId = new CommKeyClassId(commKey, ifClassId);
        element.setValue(ParameterCode.INTERFACE_ID, interfaceCommKeyClassId);
    }

    protected ElementConfigurator getElementConfigurator() {
        return this;
    }
}

