/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.FCIfConfigurator;
import com.sanrad.nms.server.mgr.IfConnectedSFPConfigurator;
import com.sanrad.nms.server.mgr.IfSrXConfigurator;
import com.sanrad.nms.server.mgr.IfXConfigurator;
import com.sanrad.nms.server.mgr.PScsiIfConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import java.util.HashMap;

public class IfConfigurator
extends ElementConfigurator {
    public IfConfigurator() {
        super(ClassID.INTERFACE, "ifTable", null, null);
    }

    protected IfConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib) {
        super(classId, tableName, rowStatusMib, lastUpdateMib, true);
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList ifList = this.getAllExtended(snmpAgentIndex, null, null);
        if (ifList.size() > 0) {
            this.sendDiscoveredElementsToEventMgr(ifList, vSwitchData);
        }
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        SrTimeTicks noLastUpdateValuePerTable = null;
        ConfigElementDataList ifList = this.getAll(snmpAgentIndex, noLastUpdateValuePerTable, checkListElement);
        if (ifList.size() > 0) {
            IfXConfigurator ifXConfig = new IfXConfigurator();
            ConfigElementDataList ifXList = ifXConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            this.mergeElementLists(ifList, ifXList, false);
            IfSrXConfigurator ifSrXConfig = new IfSrXConfigurator();
            ConfigElementDataList ifSrXList = ifSrXConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            this.mergeElementLists(ifList, ifSrXList, false);
            FCIfConfigurator fcConfig = new FCIfConfigurator();
            ConfigElementDataList fcList = fcConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            fcConfig.mergeElementLists(ifList, fcList, false);
            PScsiIfConfigurator pscsiConf = new PScsiIfConfigurator();
            ConfigElementDataList pscsiList = pscsiConf.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            pscsiConf.mergeElementLists(ifList, pscsiList, false);
            IfConnectedSFPConfigurator sfpConfigurator = new IfConnectedSFPConfigurator();
            ConfigElementDataList sfpEntriesList = sfpConfigurator.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            if (sfpEntriesList.size() > 0) {
                sfpConfigurator.mergeElementLists(ifList, sfpEntriesList, false);
            }
        }
        return ifList;
    }

    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
        IANAifTypeConstant ifType;
        ClassID elementClassId = element.getClassId();
        SnmpCommKey elementCommKey = element.getSnmpKey();
        ConfigElementData newElement = new ConfigElementData(elementCommKey, elementClassId);
        IfXConfigurator ifXConfig = new IfXConfigurator();
        ifXConfig.internalRead(newElement);
        element.addParameter(newElement.getParametersList());
        newElement = new ConfigElementData(elementCommKey, elementClassId);
        IfSrXConfigurator ifSrXConfig = new IfSrXConfigurator();
        ifSrXConfig.internalRead(newElement);
        element.addParameter(newElement.getParametersList());
        SrString ifName = (SrString)element.getValue(ParameterCode.IF_NAME);
        if (!ifName.toDisplayString().equals("Cons") && !ifName.toDisplayString().equals("mgnt")) {
            newElement = new ConfigElementData(elementCommKey, elementClassId);
            IfConnectedSFPConfigurator sfpConfigurator = new IfConnectedSFPConfigurator();
            sfpConfigurator.internalRead(newElement);
            element.addParameter(newElement.getParametersList());
        }
        if ((ifType = (IANAifTypeConstant)element.getValue(ParameterCode.IF_TYPE)).equals(IANAifTypeConstant.IANA_IF_TYPE_FC)) {
            newElement = new ConfigElementData(elementCommKey, ClassID.FC_INTERFACE);
            FCIfConfigurator fcConfig = new FCIfConfigurator();
            fcConfig.internalRead(newElement);
            element.addParameter(newElement.getParametersList());
            element.setClassId(ClassID.FC_INTERFACE);
        }
        if (ifType.equals(IANAifTypeConstant.IANA_IF_TYPE_PARALLEL_SCSI)) {
            newElement = new ConfigElementData(elementCommKey, ClassID.PSCSI_INTERFACE);
            PScsiIfConfigurator pscsiConf = new PScsiIfConfigurator();
            pscsiConf.internalRead(newElement);
            element.addParameter(newElement.getParametersList());
            element.setClassId(ClassID.PSCSI_INTERFACE);
        }
        if (ifType.equals(IANAifTypeConstant.IANA_IF_TYPE_ETHERNET)) {
            element.setClassId(ClassID.ETHERNET_INTERFACE);
        }
        if (ifType.equals(IANAifTypeConstant.IANA_IF_TYPE_FC) || ifType.equals(IANAifTypeConstant.IANA_IF_TYPE_ETHERNET)) {
            newElement = new ConfigElementData(elementCommKey, ClassID.INTERFACE);
            IfConnectedSFPConfigurator sfpConfigurator = new IfConnectedSFPConfigurator();
            sfpConfigurator.internalRead(newElement);
            element.addParameter(newElement.getParametersList());
        }
        if (retrievedElements != null) {
            retrievedElements.add(element);
        }
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.IF_DESCRIPTION, null);
        paramList.put(ParameterCode.IF_OPER_STAT, null);
        paramList.put(ParameterCode.IF_TYPE, null);
        return paramList;
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 15: 
            case 16: {
                return MibItem.IF_OPER_STAT;
            }
        }
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.getTrapType().toString());
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        try {
            String index = CommKeyUtil.getSnmpCommKey(element.getCommKey()).getKey();
            SrType[] ifType = this.readTableCells(new MibItem[]{MibItem.IF_TYPE}, index, element.getSnmpAgentFromParameter());
            element.setValue(ParameterCode.IF_TYPE, ifType[0]);
            this.readDiscoverPostOperation(element, trap.getVarBindList());
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().warning(e);
            return;
        }
        switch (trap.getTrapType().getTrapId()) {
            case 15: 
            case 16: {
                LogMgr.getServerLog().debug("Changed by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
                SrEventHandler.getEventMgr().sendChangeElementEvent(element);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation not supported for trap ID " + trap.getTrapType().getTrapId());
            }
        }
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        SrString ifDescription;
        IANAifTypeConstant ifType = (IANAifTypeConstant)element.getValue(ParameterCode.IF_TYPE);
        if (ifType != null) {
            if (ifType.equals(IANAifTypeConstant.IANA_IF_TYPE_FC)) {
                element.setClassId(ClassID.FC_INTERFACE);
            }
            if (ifType.equals(IANAifTypeConstant.IANA_IF_TYPE_PARALLEL_SCSI)) {
                element.setClassId(ClassID.PSCSI_INTERFACE);
            }
            if (ifType.equals(IANAifTypeConstant.IANA_IF_TYPE_ETHERNET)) {
                element.setClassId(ClassID.ETHERNET_INTERFACE);
            }
        }
        if ((ifDescription = (SrString)element.getValue(ParameterCode.IF_DESCRIPTION)) != null) {
            SrString convertedValue = new SrString(new String(new SrEntityNameFormat(ifDescription.toString()).getBytes()));
            element.setValue(ParameterCode.IF_DESCRIPTION, convertedValue);
        }
    }
}

