/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.IScsiConnectionConfigurator;
import com.sanrad.nms.server.mgr.IScsiInstanceConfigurator;
import com.sanrad.nms.server.mgr.IScsiSessionErrorConfigurator;
import com.sanrad.nms.server.mgr.IScsiSessionStatisticConfigurator;
import com.sanrad.nms.server.mgr.ScsiDeviceConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import com.sanrad.nms.server.util.types.constants.SessionTypeConstant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

public class IScsiSessionConfigurator
extends ElementConfigurator {
    private static final SrOidType IDENTITY_INDEX = new SrOidType("1.3.6.1.4.1.10059.1.11.4.1.3.1.1.1");

    public IScsiSessionConfigurator() {
        super(ClassID.ISCSI_SESSION, "iscsiSessionAttributesTable", null, null);
    }

    protected IScsiSessionConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib) {
        super(classId, tableName, rowStatusMib, lastUpdateMib);
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        SrTimeTicks noLastUpdateValuePerTable = null;
        ConfigElementDataList sessionList = this.getAll(snmpAgentIndex, noLastUpdateValuePerTable, checkListElement);
        if (sessionList != null && sessionList.size() > 0) {
            IScsiSessionStatisticConfigurator sessionStatConfig = new IScsiSessionStatisticConfigurator();
            ConfigElementDataList sessionStatList = sessionStatConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            sessionList.addAll((Collection)sessionStatList);
            IScsiConnectionConfigurator iscsiConConfig = new IScsiConnectionConfigurator();
            ConfigElementDataList connectionsList = iscsiConConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            if (connectionsList.size() > 0) {
                sessionList.addAll((Collection)connectionsList);
            }
        }
        return sessionList;
    }

    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
        ClassID elementClassId = element.getClassId();
        SnmpCommKey elementCommKey = element.getSnmpKey();
        ConfigElementData newElement = new ConfigElementData(elementCommKey, elementClassId);
        IScsiSessionStatisticConfigurator sessionStatConfig = new IScsiSessionStatisticConfigurator();
        sessionStatConfig.internalRead(newElement);
        if (retrievedElements != null) {
            retrievedElements.add(newElement);
        }
        newElement = new ConfigElementData(elementCommKey, elementClassId);
        IScsiSessionErrorConfigurator SessionErrConfig = new IScsiSessionErrorConfigurator();
        SessionErrConfig.internalRead(newElement);
        if (retrievedElements != null) {
            retrievedElements.add(newElement);
        }
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(10);
        paramList.put(ParameterCode.ISCSI_SESSION_AUTH_IDENTITY, null);
        paramList.put(ParameterCode.ISCSI_SESSION_INITIATOR_ALIAS, null);
        paramList.put(ParameterCode.ISCSI_SESSION_INITIATOR_NAME, null);
        paramList.put(ParameterCode.ISCSI_SESSION_ISID, null);
        paramList.put(ParameterCode.ISCSI_SESSION_TARGET_ALIAS, null);
        paramList.put(ParameterCode.ISCSI_SESSION_TARGET_NAME, null);
        paramList.put(ParameterCode.ISCSI_SESSION_TSIH, null);
        paramList.put(ParameterCode.ISCSI_SESSION_TYPE, null);
        paramList.put(ParameterCode.ISCSI_SESSION_DIRECTION, null);
        return paramList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        SrInteger sessionDirectionInteger;
        SrInteger sessionTypeInteger = (SrInteger)element.getValue(ParameterCode.ISCSI_SESSION_TYPE);
        if (sessionTypeInteger != null) {
            SessionTypeConstant sessionType = SessionTypeConstant.getSessionTypeStat(sessionTypeInteger.intValue());
            element.setValue(ParameterCode.ISCSI_SESSION_TYPE, sessionType);
        }
        if ((sessionDirectionInteger = (SrInteger)element.getValue(ParameterCode.ISCSI_SESSION_DIRECTION)) != null) {
            SessionDirectionConstant sessionDirection = SessionDirectionConstant.getSessionDirectionStat(sessionDirectionInteger.intValue());
            element.setValue(ParameterCode.ISCSI_SESSION_DIRECTION, sessionDirection);
        }
        CommKeyClassId identityCommKeyClassId = null;
        SrOidType authenticationOid = (SrOidType)element.getValue(ParameterCode.ISCSI_SESSION_AUTH_IDENTITY);
        if (!authenticationOid.equals(SrOidType.NULL_OID)) {
            String identityKey = authenticationOid.getIndexFromOidType(IDENTITY_INDEX);
            SnmpCommKey identityCommKey = new SnmpCommKey(identityKey, element.getMyFirstSnmpAgentIndex());
            identityCommKeyClassId = new CommKeyClassId(identityCommKey, ClassID.IDENTITY);
        }
        element.addParameter(new Parameter(ParameterCode.ISCSI_SESSION_AUTH_IDENTITY, identityCommKeyClassId));
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        LogMgr.getServerLog().debug("Changed by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendChangeElementEvent(element);
    }

    public void refreshSessions(char snmpAgent) throws SrCommunicationException {
        ScsiDeviceConfigurator deviceConfigurator = new ScsiDeviceConfigurator();
        deviceConfigurator.refreshTableForPolling(snmpAgent);
        IScsiInstanceConfigurator iscsiInstanceConfigurator = new IScsiInstanceConfigurator();
        ConfigElementDataList instanceElements = iscsiInstanceConfigurator.refreshTable(snmpAgent, null, null);
        SrEventHandler.getEventMgr().sendRefreshElementEvent(instanceElements);
        ConfigElementDataList elements = new ConfigElementDataList();
        CheckListConfigElementData sessionsElementsCheckList = new CheckListConfigElementData(ClassID.ISCSI_SESSION);
        Vector<CommKeyClassId> sessionsCommKeysToCheckList = new Vector<CommKeyClassId>();
        CheckListConfigElementData sessionsStatisticsElementsCheckList = new CheckListConfigElementData(ClassID.ISCSI_SESSION_STATISTICS);
        Vector<CommKeyClassId> sessionsStatisticsCommKeysToCheckList = new Vector<CommKeyClassId>();
        ConfigElementDataList sessionsElements = this.refreshTable(snmpAgent, null, sessionsElementsCheckList);
        for (int index = 0; index < sessionsElements.size(); ++index) {
            ConfigElementData element = sessionsElements.getConfigElementDataAt(index);
            if (element.getClassId().equals(ClassID.ISCSI_SESSION)) {
                elements.add(element);
                sessionsCommKeysToCheckList.add(element.getCommKeyClassId());
                continue;
            }
            if (!element.getClassId().equals(ClassID.ISCSI_SESSION_STATISTICS)) continue;
            elements.add(element);
            sessionsStatisticsCommKeysToCheckList.add(element.getCommKeyClassId());
        }
        sessionsElementsCheckList.setCheckList(sessionsCommKeysToCheckList);
        sessionsStatisticsElementsCheckList.setCheckList(sessionsStatisticsCommKeysToCheckList);
        SrEventHandler.getEventMgr().sendRefreshElementEvent(elements);
        SrEventHandler.getEventMgr().sendCheckListEvent(sessionsElementsCheckList);
        SrEventHandler.getEventMgr().sendCheckListEvent(sessionsStatisticsElementsCheckList);
        CheckListConfigElementData checkList = new CheckListConfigElementData(ClassID.ISCSI_CONNECTION);
        IScsiConnectionConfigurator connectionConfigurator = new IScsiConnectionConfigurator();
        ConfigElementDataList connectionsElements = connectionConfigurator.refreshTable(snmpAgent, null, checkList);
        SrEventHandler.getEventMgr().sendRefreshElementEvent(connectionsElements);
        SrEventHandler.getEventMgr().sendCheckListEvent(checkList);
    }
}

