/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.IscsiRemoteInitatoresStatisticsConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.Collection;
import java.util.HashMap;

public class IScsiRemoteInitatoresConfigurator
extends ElementConfigurator {
    public IScsiRemoteInitatoresConfigurator() {
        super(ClassID.ISCSI_REMOTE_INITIATOR, "scsiAuthorizedIntrTable", null, null);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.ISCSI_REMOTE_INITIATOR_NAME, null);
        return paramList;
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        SrTimeTicks noLastUpdateValuePerTable = null;
        ConfigElementDataList remoteInitiatorList = this.getAll(snmpAgentIndex, noLastUpdateValuePerTable, checkListElement);
        if (remoteInitiatorList.size() > 0) {
            IscsiRemoteInitatoresStatisticsConfigurator iscsiRInitStatConfig = new IscsiRemoteInitatoresStatisticsConfigurator();
            ConfigElementDataList remoteInitiatorsStatisticsList = iscsiRInitStatConfig.getAllExtended(snmpAgentIndex, noLastUpdateValuePerTable, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
            remoteInitiatorList.addAll((Collection)remoteInitiatorsStatisticsList);
        }
        return remoteInitiatorList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        super.readDiscoverPostOperation(element, list);
        String elementKey = element.getSnmpKey().getKey();
        String remoteInitiatorPortKey = elementKey.substring(0, elementKey.lastIndexOf("."));
        String localTargetKey = elementKey.substring(0, remoteInitiatorPortKey.lastIndexOf("."));
        CommKeyClassId targetCommKeyClassId = new CommKeyClassId(new SnmpCommKey(localTargetKey, element.getMyFirstSnmpAgentIndex()), ClassID.SCSI_TARGET);
        element.setValue(ParameterCode.SCSI_TARGET_ID, targetCommKeyClassId);
    }
}

