/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.IScsiSessionConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.constants.SessionFailureTypeConstant;
import java.util.HashMap;
import java.util.Iterator;

public class IScsiInstanceConfigurator
extends ElementConfigurator {
    public IScsiInstanceConfigurator() {
        super(ClassID.ISCSI_INSTANCE, "iscsiInstanceAttributesTable", null, null);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.ISCSI_INSTANCE_DESCRIPTION, null);
        paramList.put(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_REMOTE_NODE_NAME, null);
        paramList.put(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_TYPE, null);
        paramList.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_NODES, null);
        paramList.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_PORTALS, null);
        paramList.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE, null);
        paramList.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSIONS, null);
        paramList.put(ParameterCode.ISCSI_INSTANCE_VENDOR_ID, null);
        paramList.put(ParameterCode.ISCSI_INSTANCE_VENDOR_VERSION, null);
        paramList.put(ParameterCode.ISCSI_INSTANCE_VERSION_MAX, null);
        paramList.put(ParameterCode.ISCSI_INSTANCE_VERSION_MIN, null);
        return paramList;
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        SrOidType identOid = (SrOidType)element.getValue(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_TYPE);
        if (identOid != null) {
            SessionFailureTypeConstant failType = SessionFailureTypeConstant.getFailerType(SessionFailureTypeConstant.getFailerTypeIndex(identOid));
            element.setValue(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_TYPE, failType);
        }
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList elements = this.getAllExtended(snmpAgentIndex, null, null);
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            ((ConfigElementData)i.next()).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        }
        if (elements.size() > 0) {
            this.sendDiscoveredElementsToEventMgr(elements, vSwitchData);
        }
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 21: {
                return MibItem.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE;
            }
        }
        return super.getCommItemForTrapCommKey(trap);
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        if (trap.getTrapType().getTrapId() == 21) {
            LogMgr.getServerLog().debug("IScsiInstanceConfigurator: session failure!");
            try {
                IScsiSessionConfigurator sessionsConfigurator = new IScsiSessionConfigurator();
                CheckListConfigElementData checkList = new CheckListConfigElementData(ClassID.ISCSI_SESSION);
                ConfigElementDataList dataList = sessionsConfigurator.refreshTable(element.getSnmpAgentFromParameter(), null, checkList);
                SrEventHandler.getEventMgr().sendChangeElementEvent(element);
                if (dataList != null) {
                    SrEventHandler.getEventMgr().sendRefreshElementEvent(dataList);
                    SrEventHandler.getEventMgr().sendCheckListEvent(checkList);
                }
            }
            catch (SrCommunicationException ce) {
                LogMgr.getServerLog().debug("IScsiInstanceConfigurator: failed to read session failure!");
            }
        } else {
            throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
        }
    }
}

