/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.constants.ISCSIRemotePortalDiscoveryFailureTypeConstant;
import com.sanrad.nms.server.util.types.constants.ISCSIRemotePortalDiscoveryStateConstant;
import java.util.HashMap;
import java.util.StringTokenizer;

public class ISCSIRemotePortalDiscoveryConfigurator
extends ElementConfigurator {
    private SrInteger m_period = null;
    private final SrInteger PERIOD_DEFAULT_VALUE = new SrInteger(120);

    public ISCSIRemotePortalDiscoveryConfigurator() {
        super(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL, "srRemotePortalDiscoveryTable", MibItem.REMOTE_PORTAL_DISC_ROW_STATUS, MibItem.REMOTE_PORTAL_DISC_LAST_CHANGED);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(5);
        paramList.put(ParameterCode.REMOTE_PORTAL_DISC_PERIOD, null);
        paramList.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, null);
        paramList.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME, null);
        paramList.put(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY, null);
        paramList.put(ParameterCode.REMOTE_PORTAL_DISC_STATE, null);
        return paramList;
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        CommKeyClassId initiatorId = (CommKeyClassId)element.removeParameter(ParameterCode.SCSI_INITIATOR_ID);
        SrIpAddress ipAddress = (SrIpAddress)element.removeParameter(ParameterCode.REMOTE_PORTAL_DISC_ADDRESS);
        SrInteger port = (SrInteger)element.removeParameter(ParameterCode.REMOTE_PORTAL_DISC_PORT);
        String initiatorPort = "0";
        String addressType = "1";
        StringBuffer remoteDiscoveryPortalIndex = new StringBuffer();
        remoteDiscoveryPortalIndex.append(CommKeyUtil.getSnmpCommKey(initiatorId).getKey());
        remoteDiscoveryPortalIndex.append(".");
        remoteDiscoveryPortalIndex.append(initiatorPort);
        remoteDiscoveryPortalIndex.append(".");
        remoteDiscoveryPortalIndex.append(addressType);
        remoteDiscoveryPortalIndex.append(".");
        remoteDiscoveryPortalIndex.append(ipAddress.toDisplayString());
        remoteDiscoveryPortalIndex.append(".");
        remoteDiscoveryPortalIndex.append(port.toDisplayString());
        SnmpCommKey snmpCommKey = new SnmpCommKey(remoteDiscoveryPortalIndex.toString(), element.getSnmpAgentFromParameter());
        element.setCommKey(snmpCommKey);
        super.internalCreate(element);
    }

    public void postCreateOperation(ConfigElementData element) throws SrCommunicationException {
        ConfigElementData changeElement = new ConfigElementData(element.getCommKeyClassId());
        if (this.m_period != null && !this.m_period.equals(this.PERIOD_DEFAULT_VALUE)) {
            changeElement.setValue(ParameterCode.REMOTE_PORTAL_DISC_PERIOD, this.m_period);
            try {
                this.internalChange(changeElement);
            }
            catch (SrElementOperationException srElementOperationException) {
                // empty catch block
            }
        }
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        ISCSIRemotePortalDiscoveryStateConstant operation = (ISCSIRemotePortalDiscoveryStateConstant)element.getValue(ParameterCode.REMOTE_PORTAL_DISC_ACTIVATE);
        if (operation != null) {
            element.setValue(ParameterCode.REMOTE_PORTAL_DISC_ACTIVATE, new SrInteger(operation.intValue()));
            super.internalChange(element);
            DataMgr.getInstance().waitForDataUpdatesInVSwitches(1000L);
            element.removeAll();
            this.internalRead(element);
            SCSIRemoteTargetConfigurator cfg = new SCSIRemoteTargetConfigurator();
            cfg.refreshRemoteTargetsForDependantOnOperations(element.getSnmpAgentFromParameter());
        }
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
        SnmpCommKey elementIndex = element.getSnmpKey();
        String[] ipPortValues = this.retreiveIPPortFromIndex(elementIndex);
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_ADDRESS_TYPE, new SrInteger(ipPortValues[0]));
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_ADDRESS, new SrIpAddress(ipPortValues[1]));
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_PORT, new SrInteger(ipPortValues[2]));
        SrOidType portalDiscoveryLastFailureTypeOid = (SrOidType)element.getValue(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE);
        ISCSIRemotePortalDiscoveryFailureTypeConstant portalDiscoveryFailureTypeConst = ISCSIRemotePortalDiscoveryFailureTypeConstant.valueOf(portalDiscoveryLastFailureTypeOid);
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, portalDiscoveryFailureTypeConst);
        super.readDiscoverPostOperation(element, list);
    }

    private String[] retreiveIPPortFromIndex(SnmpCommKey snmpKey) {
        String[] values = new String[9];
        String snmpKeyStr = snmpKey.toString();
        StringTokenizer st = new StringTokenizer(snmpKeyStr, ".");
        int index = 0;
        while (st.hasMoreTokens()) {
            values[index++] = st.nextToken();
        }
        String addressType = values[3];
        StringBuffer sb = new StringBuffer();
        sb.append(values[4]);
        sb.append(".");
        sb.append(values[5]);
        sb.append(".");
        sb.append(values[6]);
        sb.append(".");
        sb.append(values[7]);
        String ipAddress = sb.toString();
        String port = values[8];
        values = new String[]{addressType, ipAddress, port};
        return values;
    }
}

