/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import java.util.HashMap;

public class ISCSIInitiatorConfigurator
extends ElementConfigurator {
    public ISCSIInitiatorConfigurator() {
        super(ClassID.ISCSI_INITIATOR, "iscsiInitiatorAttributesTable", null, null);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(2);
        paramList.put(ParameterCode.ISCSI_INITAITOR_NUM_OF_LOGIN_FAILURES, null);
        return paramList;
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 23: {
                return MibItem.ISCSI_INITIATOR_LAST_TARGET_FAILURE_NAME;
            }
        }
        return super.getCommItemForTrapCommKey(trap);
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        if (trap.getTrapType().getTrapId() == 23) {
            LogMgr.getServerLog().debug("ISCSIInitiatorConfigurator: Local initiator failed to login to a remote target!");
            SrString remoteTargetName = (SrString)element.getValue(ParameterCode.ISCSI_INITAITOR_LAST_TARGET_FAILURE_NAME);
            try {
                SCSIRemoteTargetConfigurator remoteTargetConfigurator = new SCSIRemoteTargetConfigurator();
                ConfigElementDataList allRemoteTargetElements = remoteTargetConfigurator.getAllExtended(element.getSnmpAgentFromParameter(), null, null);
                ConfigElementData remoteTargetElement = this.getRemoteTargetElementByName(allRemoteTargetElements, remoteTargetName.toString());
                SrEventHandler.getEventMgr().sendChangeElementEvent(remoteTargetElement);
            }
            catch (SrCommunicationException ce) {
                LogMgr.getServerLog().debug("ISCSIInitiatorConfigurator: Failed to read remote target login failure!");
            }
        } else {
            throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
        }
    }

    private ConfigElementData getRemoteTargetElementByName(ConfigElementDataList remoteTargetElements, String remoteTargetName) {
        for (int index = 0; index < remoteTargetElements.size(); ++index) {
            ConfigElementData remoteTargetElement = (ConfigElementData)remoteTargetElements.elementAt(index);
            SrString currentRemoteTargetName = (SrString)remoteTargetElement.getValue(ParameterCode.DISCOVERED_TARGET_NAME);
            if (!currentRemoteTargetName.toString().equals(remoteTargetName)) continue;
            return remoteTargetElement;
        }
        return null;
    }
}

