/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import java.util.HashMap;

public class HardwareConfigurator
extends ElementConfigurator {
    public HardwareConfigurator() {
        super(ClassID.HARDWARE, "", null, null);
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        CommKeyClassId hardwareData = new CommKeyClassId(vSwitchData.getCommKeys(), ClassID.HARDWARE);
        ConfigElementData hardware = new ConfigElementData(hardwareData.getCommKeys(), hardwareData.getClassID());
        hardware.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        try {
            this.internalRead(hardware);
        }
        catch (SrSnmpTimeoutException e) {
            logger.error(e.getMessage());
            throw e;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().warning("Failed to Read data of " + hardware.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(hardware.getCommKey()), e);
            throw e;
        }
        ConfigElementDataList list = new ConfigElementDataList();
        list.add(hardware);
        this.sendDiscoveredElementsToEventMgr(list, vSwitchData);
    }

    public HashMap getListOfParams() {
        HashMap<ParameterCode, Object> paramList = new HashMap<ParameterCode, Object>(20);
        paramList.put(ParameterCode.CPU_FACTORY_TEMP_TRESH, null);
        paramList.put(ParameterCode.CPU_TEMP, null);
        paramList.put(ParameterCode.CPU_WARNING_TEMP_TRESH, null);
        paramList.put(ParameterCode.CURR_NUM_OF_WORKING_FANS, null);
        paramList.put(ParameterCode.CURR_NUM_OF_WORKING_POWER_SUPPLIERS, null);
        paramList.put(ParameterCode.MAX_NUM_OF_FANS, null);
        paramList.put(ParameterCode.MAX_NUM_OF_POWER_SUPPLIERS, null);
        paramList.put(ParameterCode.ON_BOARD_FACTORY_TEMP_TRESH, null);
        paramList.put(ParameterCode.ON_BOARD_TEMP, null);
        paramList.put(ParameterCode.ON_BOARD_WARNING_TEMP_TRESH, null);
        return paramList;
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
        LogMgr.getServerLog().debug("Changed by Trap for " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendChangeElementEvent(element);
    }
}

