/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationErrorException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;

public class EmailContactConfigurator
extends ElementConfigurator {
    public EmailContactConfigurator() {
        super(ClassID.EMAIL_CONTACT, "", null, null);
    }

    public ConfigElementDataList getAll() throws SrCommunicationException {
        CommVarBindList[] contact = CommMgr.getInstance('z').getEmailContactData();
        ConfigElementDataList elementList = new ConfigElementDataList();
        if (contact != null && contact.length != 0) {
            ConfigElementData element = this.createConfigElementFromTableRow(contact[0]);
            SrString key = (SrString)element.getValue(ParameterCode.EMAIL_CONTACT_FROM_ADDRESS);
            CommKey[] allKeys = new CommKey[]{new DataBaseCommKey(key.toString())};
            element.setCommKeys(allKeys);
            elementList.add(element);
            this.sendDiscoveredElementsToEventMgr(elementList, null);
        }
        return elementList;
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, MissingValueException, SrElementOperationErrorException {
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationErrorException {
        SrString fromKey = (SrString)element.getValue(ParameterCode.EMAIL_CONTACT_FROM_ADDRESS);
        DataBaseCommKey dbKey = new DataBaseCommKey(fromKey.toString());
        CommKey[] key = new CommKey[]{dbKey};
        element.setCommKeys(key);
        CommVarBindList varBindList = new CommVarBindList();
        this.convertParamsToVarBinds(element, varBindList);
        CommMgr.getInstance('z').setContactData(varBindList);
    }

    public void internalRead(ConfigElementData element) throws SrCommunicationException {
    }

    public void internalRemove(ConfigElementData element) throws SrCommunicationException {
    }
}

