/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindKey;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.database.DBKey;
import com.sanrad.nms.server.comm.database.DBVarBind;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpTable;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.EventMgr;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.CodeToKeyMap;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeChildrenConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyFetcher;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class ElementConfigurator {
    public static final String UNKNOWN_TABLE = "";
    public static final String SNMP_MANAGER_TABLE = "srManagersTable";
    public static final String IP_ROUTE_TABLE = "ipCidrRouteTable";
    public static final String NET_CONFIG_TABLE = "srNetworkConfigurationTable";
    public static final String ISCSI_PORTAL_ATTRIBUTES_TABLE = "iscsiPortalAttributesTable";
    public static final String ISCSI_TARGET_TABLE = "iscsiTargetAttributesTable";
    public static final String ISCSI_TARGET_TABLE_EX = "srIscsiTgtTable";
    public static final String ISCSI_TARGET_PORTAL_ATTRIBUTES_TABLE = "iscsiTgtPortalAttributesTable";
    public static final String ISCSI_INTR_PORTAL_ATTRIBUTES_TABLE = "iscsiIntrPortalAttributesTable";
    public static final String NEIGHBOURS_TABLE = "srSDNeighboursTable";
    public static final String SNMP_TARGET_ADDRESS_TABLE = "snmpTargetAddrTable";
    public static final String STORAGE_DOMAIN_TABLE = "srStorageDomainsTable";
    public static final String PHYSICAL_STORAGE_TABLE = "srPhysStorTable";
    public static final String PHYSICAL_STORAGE_COMMAND_TABLE = "srPhysStorComTable";
    public static final String PHYSICAL_DISK_TABLE = "srPhysDiskTable";
    public static final String SUB_DISK_TABLE = "srPhysDiskSplitTable";
    public static final String LU_TABLE = "srVirtLogUnTable";
    public static final String VOLUME_CHILDREN_TABLE = "srVirtVolChildrenTable";
    public static final String STRIP_VOLUME_TABLE = "srVirtVolSpecStrippedTable";
    public static final String SNAPSHOT_VOLUME_TABLE = "srVirtVolSpecSnapshotTable";
    public static final String SNAPSHOT_VOLUME_RELATION_TABLE = "srVirtVolSpecSnapRelationTable";
    public static final String VOLUMES_TABLE = "srVirtVolTable";
    public static final String MIRROR_VOLUME_TABLE = "srVirtVolSpecMirrorTable";
    public static final String VOLUME_OPERATION_TABLE = "srVirtVolOperTable";
    public static final String JOURNAL_VOLUME_TABLE = "srVirtVolSpecJournalTable";
    public static final String IDENTITY_TABLE = "ipsAuthIdentAttributesTable";
    public static final String IDENTITY_X_TABLE = "srAuthIdentExtensionTable";
    public static final String IDENTITY_NAME_TABLE = "ipsAuthIdentNameAttributesTable";
    public static final String CREDENTIALS_TABLE = "ipsAuthCredentialAttributesTable";
    public static final String IDENTITY_ADDRESS_TABLE = "ipsAuthIdentAddrAttributesTable";
    public static final String CREDENTIALS_CHAP_TABLE = "ipsAuthCredChapAttributesTable";
    public static final String CREDENTIALS_SRP_TABLE = "ipsAuthCredSrpAttributesTable";
    public static final String CREDENTIALS_CHAP_EXTENTION_TABLE = "srAuthCredChapAttributesTable";
    public static final String TARGET_AUTH_TABLE = "iscsiTgtAuthAttributesTable";
    public static final String LU_IDENTIFIER_TABLE = "srPhysStorLunIdTable";
    public static final String DISCOVERED_TARGET_TABLE = "scsiDscTgtTable";
    public static final String DISCOVERED_LU_TABLE = "scsiLuTable";
    public static final String PHYS_STOR_DISC_TARGET_LU_MAP_TABLE = "srPhysStorMapDscLunTable";
    public static final String RADIUS_SERVER_TABLE = "srRadiusAuthServerTable";
    public static final String ISNS_SERVER_TABLE = "srIsnsLocalAddrCfgTable";
    public static final String FC_NODE_TABLE = "fcmInstanceTable";
    public static final String IFX_FC_PORT_TABLE = "fcmPortTable";
    public static final String FC_EXTENTION_TABLE = "srFCTable";
    public static final String ISCSI_INSTANCES_TABLE = "iscsiInstanceAttributesTable";
    public static final String ISCSI_SESSIONS_TABLE = "iscsiSessionAttributesTable";
    public static final String ISCSI_SESSIONS_STATISTICS_TABLE = "iscsiSessionStatsTable";
    public static final String ISCSI_SESSIONS_ERROR_COUNTERS_TABLE = "iscsiSessionCxnErrorStatsTable";
    public static final String ISCSI_CONNECTION_TABLE = "iscsiConnectionAttributesTable";
    public static final String ISCSI_REMOTE_INITIATORS_TABLE = "scsiAuthorizedIntrTable";
    public static final String SCSI_TRANSPORT_TABLE = "scsiTrnsptTable";
    public static final String ASYNC_PAIR_PIT_TABLE = "srAsyncPairPiTTable";
    public static final String CONSISTENCY_GROUP_PIT_TABLE = "srDRGroupPiTTable";
    public static final String VIRT_GROUP_TABLE = "srVirtGroupTable";
    public static final String CF_ASYNC_PAIR_TABLE = "srAsyncPairSendCFTable";
    public static final String CF_SYNC_PAIR_TABLE = "srSyncPairSendCFTable";
    public static final String CF_CONSISTENCY_GROUP_TABLE = "srDRGroupSendCFTable";
    public static final String DR_PAIR_TABLE = "srPairTable";
    public static final String ASYNC_PAIR_TABLE = "srAsyncPairTable";
    public static final String SYNC_PAIR_TABLE = "srSynchPairTable";
    public static final String CONSISTENCY_GROUP_TABLE = "srDRGroupTable";
    public static final String POLICY_TABLE = "srPolicyTable";
    public static final String POLICY_PARAM_TABLE = "srPolicyParamTable";
    public static final String SCSI_TARGETS_PORTS_TABLE = "scsiTgtPortTable";
    public static final String TCP_CONN_TABLE = "tcpConnTable";
    public static final String UDP_TABLE = "udpTable";
    public static final String IF_STATISTIC_TABLE = "ifTable";
    public static final String IF_X_STATISTIC_TABLE = "ifXTable";
    public static final String TARGET_AUTH_EXTENTION_TABLE = "srIscsiTgtAccessListTable";
    public static final String IF_TABLE = "ifTable";
    public static final String IF_EXTENTION_TABLE = "ifXTable";
    public static final String IF_SR_EXTENTION_TABLE = "srIfTable";
    public static final String IF_CONNECTED_SFP_TABLE = "srIfConnectedSFPTable";
    public static final String IFX_PSCSI_TABLE = "srPSCSITable";
    public static final String SCSI_DEVICE_TABLE = "scsiDeviceTable";
    public static final String SCSI_PORT_TABLE = "scsiPortTable";
    public static final String SCSI_INITIATOR_DEVICE_TABLE = "scsiIntrDevTable";
    public static final String SCSI_DISCOVERY_REMOTE_TARGET_TABLE = "scsiDscTgtTable";
    public static final String ISCSI_REMOTE_TARGET_PORTAL = "srRemoteTgtPortalTable";
    public static final String SCSI_DISCOVERY_LUN_TABLE = "scsiDscLunTable";
    public static final String SCSI_DISCOVERY_LUN_ID_TABLE = "scsiDscLunIdTable";
    public static final String SCSI_TARGET_DEVICE_TABLE = "scsiTgtDevTable";
    public static final String SCSI_AUTHRIZED_INITIATOR_TABLE = "scsiAuthrizedIntrTable";
    public static final String SCSI_AUTHRIZED_INITIATOR_PORT_TABLE = "scsiAttIntrPortTable";
    public static final String SCSI_INITIATOR_PORT_TABLE = "scsiIntrPortTable";
    public static final String SCSI_REMOTE_TARGET_TABLE = "srRemoteTgtTable";
    public static final String ISCSI_INITIATOR_TABLE = "iscsiInitiatorAttributesTable";
    public static final String ISCSI_REMOTE_PORTAL_DISCOVERY_TABLE = "srRemotePortalDiscoveryTable";
    protected static Log logger = LogMgr.getServerLog();
    protected ClassID myClassId = null;
    protected String myTableName = null;
    protected MibItem myRowStatusMib = null;
    protected MibItem myLastUpdateMib = null;
    protected boolean hasLastUpdatePerEntry = false;
    private static final int MAX_RETRIES_FOR_GET_ALL = 5;

    public ElementConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib) {
        this.myClassId = classId;
        this.myTableName = tableName;
        this.myRowStatusMib = rowStatusMib;
        this.myLastUpdateMib = lastUpdateMib;
    }

    public ElementConfigurator(ClassID classId, String tableName, MibItem rowStatusMib, MibItem lastUpdateMib, boolean hasLastUpdateForEntry) {
        this.myClassId = classId;
        this.myTableName = tableName;
        this.myRowStatusMib = rowStatusMib;
        this.myLastUpdateMib = lastUpdateMib;
        this.hasLastUpdatePerEntry = hasLastUpdateForEntry;
    }

    public ElementConfigurator() {
    }

    protected void setClassId(ClassID classId) {
        this.myClassId = classId;
    }

    protected String getMyTableName() {
        return this.myTableName;
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        this.updateCedAfterCreate(element);
        CommVarBindList varBindList = new CommVarBindList();
        CommKey[] commKeys = element.getCommKey();
        if (CommKeyUtil.isNullKeys(commKeys)) {
            throw new NullPointerException("Try to create element " + element.getClassId().toString() + " with no CommKey");
        }
        if (this.myRowStatusMib != null) {
            for (int i = 0; i < commKeys.length; ++i) {
                if (((CommKeyFetcher)((Object)commKeys[i])).getSnmpCommKey() == null) continue;
                varBindList = this.addRowStatusVarBind(varBindList, commKeys[i]);
                break;
            }
        }
        this.convertParamsToVarBinds(element, varBindList);
        this.addCommVarBindsToCreateList(varBindList, element);
        try {
            CommMgr.getInstance(element.getMyFirstSnmpAgentIndex()).setList(varBindList, element.getMyFirstSnmpAgentIndex());
        }
        catch (SrCommunicationException ce) {
            ce.setElement(element);
            throw ce;
        }
    }

    protected CommVarBindList addRowStatusVarBind(CommVarBindList varBindList, CommKey commKey) {
        SrSnmpVarBind srVarBind = this.createRowStatusVarBind(commKey);
        varBindList.add(srVarBind);
        return varBindList;
    }

    protected SrSnmpVarBind createRowStatusVarBind(CommKey commKey) {
        SrOid oid = new SrOid(this.myRowStatusMib.toString(), commKey.getKey());
        SrSnmpVarBind srVarBind = new SrSnmpVarBind(oid, (SrType)RowStatusConstants.ROW_STATUS_CREATE_AND_GO);
        return srVarBind;
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationException {
        try {
            CommVarBindList varBindList = new CommVarBindList();
            this.convertParamsToVarBinds(element, varBindList);
            this.addCommVarBindsToChangeList(varBindList, element);
            CommMgr.getInstance(element.getMyFirstSnmpAgentIndex()).setList(varBindList, element.getMyFirstSnmpAgentIndex());
        }
        catch (SrCommunicationException ce) {
            logger.error(ce.getMessage());
            ce.setElement(element);
            throw ce;
        }
    }

    public CommVarBindList getVarBindsForChangeOperation(ConfigElementData element) {
        return null;
    }

    public CommVarBindList getVarBindsForRemoveOperation(ConfigElementData element) {
        CommVarBindList varBindList = new CommVarBindList();
        if (this.myRowStatusMib != null) {
            SnmpCommKey mySnmpKey = element.getSnmpKey();
            SrOid oid = new SrOid(this.myRowStatusMib.toString(), mySnmpKey.getKey());
            SrSnmpVarBind rsVarBind = new SrSnmpVarBind(oid, (SrType)RowStatusConstants.ROW_STATUS_DESTROY);
            varBindList.add(rsVarBind);
        }
        this.addCommVarBindsToRemoveList(varBindList, element);
        return varBindList;
    }

    public CommVarBindList getVarBindsForCreateOperation(ConfigElementData element) throws SrCommunicationException {
        CommVarBindList vbList = new CommVarBindList();
        CommKey[] commKeys = element.getCommKey();
        if (this.myRowStatusMib != null) {
            for (int i = 0; i < commKeys.length; ++i) {
                if (((CommKeyFetcher)((Object)commKeys[i])).getSnmpCommKey() == null) continue;
                vbList.add(this.createRowStatusVarBind(commKeys[i]));
                break;
            }
        }
        this.convertParamsToVarBinds(element, vbList);
        this.addCommVarBindsToCreateList(vbList, element);
        return vbList;
    }

    public void postRemoveOperation(ConfigElementData element) throws SrCommunicationException {
    }

    public void postCreateOperation(ConfigElementData element) throws SrCommunicationException {
    }

    public void postChangeOperation(ConfigElementData element) throws SrCommunicationException {
    }

    public void internalReadFields(ConfigElementData element) throws SrCommunicationException {
        this.read(element);
    }

    protected boolean isFilteredElementForCheckList(CommKeyClassId elementData) {
        return false;
    }

    public void internalRead(ConfigElementData element) throws SrCommunicationException {
        this.internalRead(element, null);
    }

    public void internalRead(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
        element.addParameter(this.getListOfParams());
        this.read(element);
        this.internalReadExtentionTable(element, retrievedElements);
    }

    public void read(ConfigElementData element) throws SrCommunicationException {
        CommVarBindList list = new CommVarBindList();
        this.convertParamsToVarBinds(element, list);
        this.addCommVarBindsToReadList(list, element);
        char agentIndex = element.containParameter(ParameterCode.VSWITCH_ID) ? element.getSnmpAgentFromParameter() : element.getMyFirstSnmpAgentIndex();
        CommMgr.getInstance(agentIndex).getList(list, agentIndex);
        for (int i = list.size() - 1; i >= 0; --i) {
            Parameter param = this.convertVarBindToParam((CommVarBind)list.get(i));
            if (param == null) continue;
            element.addParameter(param);
            list.remove(i);
        }
        this.readDiscoverPostOperation(element, list);
        CommKeyClassId vSwitch = CommKeyUtil.getVSwitchData(agentIndex);
        element.setValue(ParameterCode.VSWITCH_ID, vSwitch);
    }

    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommunicationException {
    }

    protected SrType[] readTableCells(MibItem[] columns, String index, char agentIndex) throws SrCommunicationException {
        CommVarBindList vbList = new CommVarBindList();
        for (int i = 0; i < columns.length; ++i) {
            SrOid oid = new SrOid(columns[i].toString(), index);
            vbList.add(new SrSnmpVarBind(oid, null));
        }
        CommMgr.getInstance(agentIndex).getList(vbList, agentIndex);
        SrType[] values = new SrType[columns.length];
        int i = values.length;
        while (i-- > 0) {
            values[i] = ((SrSnmpVarBind)vbList.elementAt(i)).getValue();
        }
        return values;
    }

    public ConfigElementDataList internalReadForSuperPrefix(char snmpAgentIndex, ConfigElementData sourcePrefixElement, ConfigElementData internalReadElement) throws SrCommunicationException {
        return this.getAllByPrefix(snmpAgentIndex, sourcePrefixElement.getSnmpKey().toString());
    }

    public ConfigElementDataList getAllByPrefix(char snmpAgentIndex, String keyPrefix) throws SrCommunicationException {
        ConfigElementData tableColumnsToRead = new ConfigElementData(this.myClassId);
        tableColumnsToRead.addParameter(this.getListOfParams());
        return this.getAllByPrefix(tableColumnsToRead, snmpAgentIndex, keyPrefix);
    }

    public ConfigElementDataList getAllByPrefix(ConfigElementData tableColumns, char snmpAgentIndex, String keyPrefix) throws SrCommunicationException {
        CommVarBindList list = new CommVarBindList();
        this.convertParamsToVarBinds(tableColumns, list);
        CommVarBindList[] varBindLists = CommMgr.getInstance(snmpAgentIndex).getListsByKeyPrefix(list, keyPrefix, snmpAgentIndex);
        ConfigElementDataList elementDataList = null;
        if (varBindLists != null) {
            elementDataList = this.convertDataToElements(varBindLists, snmpAgentIndex);
            for (int index = 0; index < elementDataList.size(); ++index) {
                this.readDiscoverPostOperation((ConfigElementData)elementDataList.elementAt(index), list);
            }
        } else {
            elementDataList = new ConfigElementDataList();
        }
        return elementDataList;
    }

    public ConfigElementDataList internalReadExtendedForSuperPrefix(char snmpAgentIndex, ConfigElementData sourcePrefixElement, ConfigElementData internalReadElement) throws SrCommunicationException {
        ConfigElementDataList elementDataList = this.internalReadForSuperPrefix(snmpAgentIndex, sourcePrefixElement, internalReadElement);
        ConfigElementDataList retrievedElements = new ConfigElementDataList();
        for (int index = 0; index < elementDataList.size(); ++index) {
            ConfigElementData currElement = (ConfigElementData)elementDataList.elementAt(index);
            ElementConfigurator elementConfig = DataMgr.getElementConfigFromClassID(currElement.getClassId());
            elementConfig.internalReadExtentionTable(currElement, retrievedElements);
        }
        elementDataList.addAll((Collection)retrievedElements);
        return elementDataList;
    }

    public void internalRemove(ConfigElementData element) throws SrCommunicationException {
        CommVarBindList varBindList = new CommVarBindList();
        if (this.myRowStatusMib != null) {
            SnmpCommKey mySnmpKey = element.getSnmpKey();
            SrOid oid = new SrOid(this.myRowStatusMib.toString(), mySnmpKey.getKey());
            SrSnmpVarBind rsVarBind = new SrSnmpVarBind(oid, (SrType)RowStatusConstants.ROW_STATUS_DESTROY);
            varBindList.add(rsVarBind);
        }
        this.addCommVarBindsToRemoveList(varBindList, element);
        CommMgr.getInstance(element.getMyFirstSnmpAgentIndex()).setList(varBindList, element.getMyFirstSnmpAgentIndex());
    }

    public boolean readAfterCreate(ConfigElementData element) throws SrCommunicationException {
        this.internalRead(element);
        return false;
    }

    public boolean readAfterChange(ConfigElementData element) throws SrCommunicationException {
        this.internalRead(element);
        return false;
    }

    public void discover(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList elementsList = this.getAllExtended(snmpAgentIndex, null, null);
        this.sendDiscoveredElementsToEventMgr(elementsList, vSwitchData);
    }

    public void discover(CommKeyClassId vSwitchData, ClassID classId) throws SrCommunicationException {
        CommKeyClassId elementData = new CommKeyClassId(vSwitchData.getCommKeys(), classId);
        ConfigElementData element = new ConfigElementData(elementData.getCommKeys(), elementData.getClassID());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
        try {
            this.internalRead(element);
        }
        catch (SrSnmpTimeoutException e) {
            logger.error(e.getMessage());
            throw e;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().warning("Failed to Read data of " + element.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(element.getCommKey()), e);
            throw e;
        }
        ConfigElementDataList list = new ConfigElementDataList();
        list.add(element);
        this.sendDiscoveredElementsToEventMgr(list, vSwitchData);
    }

    public void refreshAll(CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList elementsList = this.getAllExtended(snmpAgentIndex, null, null);
        this.sendRefreshedElementsToEventMgr(elementsList, vSwitchData);
    }

    public void refreshElement(ConfigElementData element, ConfigElementDataList retrievedElementsList) throws SrCommunicationException {
        this.internalRead(element, retrievedElementsList);
    }

    public ConfigElementDataList readTableColumns(char agentIndex, ConfigElementData fieldsData, MibItem rowStatusMibItem, MibItem lastUpdateMibItem, SrTimeTicks lastUpdateValue, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        SrTimeTicks prevLastUpdate = lastUpdateValue;
        if (prevLastUpdate == null && lastUpdateMibItem != null) {
            prevLastUpdate = (SrTimeTicks)this.getScalarFromComm(lastUpdateMibItem, agentIndex);
        }
        CommVarBindList varBindsColumns = new CommVarBindList();
        this.convertParamsToVarBinds(fieldsData, varBindsColumns);
        if (rowStatusMibItem != null) {
            varBindsColumns.add(new SrSnmpVarBind(rowStatusMibItem.toString()));
        }
        CommVarBindList[] allData = CommMgr.getInstance(agentIndex).snmpGetBulk(varBindsColumns, agentIndex);
        if (lastUpdateMibItem != null) {
            SrTimeTicks currLastUpdate = (SrTimeTicks)this.getScalarFromComm(lastUpdateMibItem, agentIndex);
            int retryCount = 0;
            while (retryCount < 5 && prevLastUpdate != null && currLastUpdate != null && !prevLastUpdate.equals(currLastUpdate)) {
                ++retryCount;
                prevLastUpdate = currLastUpdate;
                varBindsColumns = new CommVarBindList();
                this.convertParamsToVarBinds(fieldsData, varBindsColumns);
                if (rowStatusMibItem != null) {
                    varBindsColumns.add(new SrSnmpVarBind(rowStatusMibItem.toString()));
                }
                allData = CommMgr.getInstance(agentIndex).snmpGetBulk(varBindsColumns, agentIndex);
                currLastUpdate = (SrTimeTicks)this.getScalarFromComm(lastUpdateMibItem, agentIndex);
            }
        }
        if (rowStatusMibItem != null) {
            allData = this.ignoreRowsWithRowStatus(agentIndex, allData, rowStatusMibItem, RowStatusConstants.ROW_STATUS_DESTROY);
            allData = this.ignoreRowsWithRowStatus(agentIndex, allData, rowStatusMibItem, RowStatusConstants.ROW_STATUS_NOT_READY);
        }
        ConfigElementDataList tableOfElements = new ConfigElementDataList();
        for (int i = 0; i < allData.length; ++i) {
            ConfigElementData elementData = this.createConfigElementFromTableRow(allData[i], agentIndex);
            tableOfElements.add(elementData);
        }
        if (checkListElement != null) {
            this.buildCheckListElement(tableOfElements, checkListElement, agentIndex, prevLastUpdate);
        }
        return tableOfElements;
    }

    public void rebuildAll(CommKeyClassId vSwitchData) throws SrCommunicationException {
        this.refreshAll(vSwitchData);
    }

    public ConfigElementDataList getAll(char agentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        return this.getAll(this.myTableName, agentIndex, lastUpdate, checkListElement);
    }

    public ConfigElementDataList getAll(String tableName, char agentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        SrTimeTicks lastUpdateVal = lastUpdate;
        if (lastUpdateVal == null && this.myLastUpdateMib != null) {
            lastUpdateVal = (SrTimeTicks)this.getScalarFromComm(this.myLastUpdateMib, agentIndex);
        }
        CommVarBindList[] table = CommMgr.getInstance(agentIndex).getAll(tableName, agentIndex);
        int maxRetries = 0;
        if (this.myLastUpdateMib != null) {
            SrTimeTicks newLastUpdateVal = (SrTimeTicks)this.getScalarFromComm(this.myLastUpdateMib, agentIndex);
            while (lastUpdateVal != null && newLastUpdateVal != null && !lastUpdateVal.equals(newLastUpdateVal) && maxRetries++ < 5) {
                lastUpdateVal = newLastUpdateVal;
                table = CommMgr.getInstance(agentIndex).getAll(tableName, agentIndex);
                newLastUpdateVal = (SrTimeTicks)this.getScalarFromComm(this.myLastUpdateMib, agentIndex);
            }
        }
        table = this.ignoreDestroyedRows(agentIndex, table);
        table = this.ignoreNotReadyRows(agentIndex, table);
        ConfigElementDataList tableOfElements = new ConfigElementDataList();
        if (table != null) {
            int numOfRows = table.length;
            for (int i = 0; i < numOfRows; ++i) {
                ConfigElementData element = this.createConfigElementFromTableRow(table[i], agentIndex);
                if (element == null) continue;
                if (!this.hasLastUpdatePerEntry && lastUpdateVal != null) {
                    element.setValue(ParameterCode.LAST_UPDATE, lastUpdateVal);
                }
                tableOfElements.add(element);
            }
            if (checkListElement != null) {
                this.buildCheckListElement(tableOfElements, checkListElement, agentIndex, lastUpdateVal);
            }
        }
        return tableOfElements;
    }

    protected final void buildCheckListElement(ConfigElementDataList listOfElements, CheckListConfigElementData checkListElement, char agentIndex, SrTimeTicks lastUpdateVal) {
        Vector<CommKeyClassId> commKeysToCheckList = new Vector<CommKeyClassId>();
        Iterator i = listOfElements.iterator();
        while (i.hasNext()) {
            ConfigElementData element = (ConfigElementData)i.next();
            CommKeyClassId commKeyClassIdToCheck = element.getCommKeyClassId();
            if (this.isFilteredElementForCheckList(commKeyClassIdToCheck)) continue;
            commKeysToCheckList.add(commKeyClassIdToCheck);
        }
        checkListElement.setCheckList(commKeysToCheckList);
        checkListElement.setValue(ParameterCode.LAST_UPDATE, lastUpdateVal);
        checkListElement.setValue(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(agentIndex));
        if (checkListElement.getClassId() == null) {
            checkListElement.setClassId(this.myClassId);
        }
    }

    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        return this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
    }

    public ConfigElementDataList refreshTable(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommunicationException {
        return this.getAllExtended(snmpAgentIndex, lastUpdate, checkListElement);
    }

    public ConfigElementData getTableRow(SrSnmpTable table, CommKey rowIndex, CommKeyClassId vSwitchData) throws SrCommunicationException {
        CommVarBindList row = CommMgr.getInstance(table.getAgentIndex()).getTableRow(table, rowIndex);
        if (row != null) {
            ConfigElementData element = this.createConfigElementFromTableRow(row, table.getAgentIndex());
            return element;
        }
        return null;
    }

    public HashMap getListOfParams() {
        return new HashMap();
    }

    protected ConfigElementData createConfigElementFromTableRow(CommVarBindList rowList) throws SrCommunicationException {
        String key = ((CommVarBind)rowList.elementAt(0)).getIndexForCommKey();
        DataBaseCommKey commKey = new DataBaseCommKey(key);
        ConfigElementData element = new ConfigElementData(commKey, this.myClassId);
        for (int i = rowList.size() - 1; i >= 0; --i) {
            CommVarBind varBind = (CommVarBind)rowList.get(i);
            Parameter param = this.convertVarBindToParam(varBind);
            if (param == null) continue;
            element.addParameter(param);
            rowList.remove(i);
        }
        this.readDiscoverPostOperation(element, rowList);
        this.discoveryPostDiscoverOpration(element, rowList);
        return element;
    }

    protected ConfigElementData createConfigElementFromTableRow(CommVarBindList rowList, char agentIndex) throws SrCommunicationException {
        String key = ((CommVarBind)rowList.elementAt(0)).getIndexForCommKey();
        SnmpCommKey commKey = new SnmpCommKey(key, agentIndex);
        ConfigElementData element = new ConfigElementData(commKey, this.myClassId);
        Iterator rowItr = rowList.iterator();
        while (rowItr.hasNext()) {
            CommVarBind varBind = (CommVarBind)rowItr.next();
            Parameter param = this.convertVarBindToParam(varBind);
            if (param == null) continue;
            element.addParameter(param);
            rowItr.remove();
        }
        CommKeyClassId vSwitch = CommKeyUtil.getVSwitchData(agentIndex);
        element.setValue(ParameterCode.VSWITCH_ID, vSwitch);
        rowList.setSnmpAgentIndex(agentIndex);
        this.readDiscoverPostOperation(element, rowList);
        this.discoveryPostDiscoverOpration(element, rowList);
        return element;
    }

    protected ConfigElementData createConfigElementFromOneVarBind(CommVarBind vb, char agentIndex) throws SrCommunicationException {
        CommVarBindList vbList = new CommVarBindList();
        vbList.add(vb);
        vbList.setSnmpAgentIndex(agentIndex);
        ConfigElementData element = this.createConfigElementFromTableRow(vbList, agentIndex);
        return element;
    }

    protected CommVarBindList createCommVarBinds(CommKey[] commKey, Parameter param) {
        CommVarBindList varBindList = new CommVarBindList();
        CommVarBindKey[] varBindKeys = CodeToKeyMap.getInstance().getKeyByParamCode(param.getCode());
        if (varBindKeys == null) {
            return null;
        }
        if (commKey == null) {
            CommVarBind varBind;
            int j;
            for (j = 0; j < varBindKeys.length; ++j) {
                if (!(varBindKeys[j] instanceof SrOid)) continue;
                String oidName = ((SrOid)varBindKeys[j]).getVarBindName();
                SrOid srOid = new SrOid(oidName);
                varBind = new SrSnmpVarBind(srOid, (SrType)param.getValue());
                varBindList.add(varBind);
            }
            for (j = 0; j < varBindKeys.length; ++j) {
                if (!(varBindKeys[j] instanceof DBKey)) continue;
                String keyName = ((DBKey)varBindKeys[j]).getVarBindName();
                DBKey dbKey = new DBKey(keyName);
                varBind = new DBVarBind(dbKey, (SrType)param.getValue());
                varBindList.add(varBind);
            }
            return varBindList;
        }
        for (int i = 0; i < commKey.length; ++i) {
            CommVarBind varBind;
            int j;
            if (((CommKeyFetcher)((Object)commKey[i])).getSnmpCommKey() != null) {
                for (j = 0; j < varBindKeys.length; ++j) {
                    if (!(varBindKeys[j] instanceof SrOid)) continue;
                    String oidName = ((SrOid)varBindKeys[j]).getVarBindName();
                    SrOid srOid = new SrOid(oidName, commKey[i].getKey());
                    varBind = new SrSnmpVarBind(srOid, (SrType)param.getValue());
                    varBindList.add(varBind);
                }
                continue;
            }
            if (((CommKeyFetcher)((Object)commKey[i])).getDBCommKey() == null) continue;
            for (j = 0; j < varBindKeys.length; ++j) {
                if (!(varBindKeys[j] instanceof DBKey)) continue;
                String keyName = ((DBKey)varBindKeys[j]).getVarBindName();
                DBKey dbKey = new DBKey(keyName, commKey[i].getKey());
                varBind = new DBVarBind(dbKey, (SrType)param.getValue());
                varBindList.add(varBind);
            }
        }
        return varBindList;
    }

    protected Parameter convertVarBindToParam(CommVarBind varBind) {
        CommVarBindKey varBindKey = varBind.getVarBindKey();
        ParameterCode code = varBindKey.getParameterCode();
        if (code != null) {
            Parameter param = new Parameter(code, varBind.getValue());
            return param;
        }
        return null;
    }

    public CommVarBindList createCommVarBindListFromElement(ConfigElementData element) {
        CommVarBindList varBindList = new CommVarBindList();
        CommKey[] commKeys = element.getCommKey();
        Iterator paramIter = element.getParametersList().keySet().iterator();
        while (paramIter.hasNext()) {
            ParameterCode code = (ParameterCode)paramIter.next();
            SrType value = (SrType)element.getValue(code);
            Parameter tmpParam = new Parameter(code, value);
            varBindList.add(this.createCommVarBinds(commKeys, tmpParam));
        }
        return varBindList;
    }

    protected void convertParamsToVarBinds(ConfigElementData element, CommVarBindList list) {
        CommKey[] commKeys = element.getCommKey();
        Iterator paramIter = element.getParametersList().keySet().iterator();
        while (paramIter.hasNext()) {
            ParameterCode code = (ParameterCode)paramIter.next();
            Object tmpObj = element.getValue(code);
            SrType value = null;
            try {
                value = (SrType)tmpObj;
            }
            catch (ClassCastException e) {
                continue;
            }
            Parameter tmpParam = new Parameter(code, value);
            list.add(this.createCommVarBinds(commKeys, tmpParam));
        }
    }

    protected CommKey[] createSimpleVolume(CommKeyClassId physStorData, CommKeyClassId vSwitchData) throws SrCommunicationException, SrElementOperationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        CommKeyClassId physStorSpecificData = CommKeyUtil.getSpecificCommKeyClassId(physStorData, snmpAgentIndex);
        if (physStorSpecificData == null) {
            return null;
        }
        String volId = DiscoverMgr.getInstance().getVolIdForPhysStor(physStorSpecificData, snmpAgentIndex);
        if (volId != null) {
            CommKey[] volCommKey = new CommKey[]{new SnmpCommKey(volId, snmpAgentIndex)};
            return volCommKey;
        }
        CommKeyClassId[] dataInArray = new CommKeyClassId[]{physStorSpecificData};
        ConfigElementData newSimpleVolume = new ConfigElementData(new SnmpCommKey("0", snmpAgentIndex), ClassID.SIMPLE_VOLUME);
        newSimpleVolume.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, dataInArray));
        CommKeyClassId[] vSwitchDataInArray = new CommKeyClassId[]{vSwitchData};
        newSimpleVolume.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchDataInArray));
        SimpleVolumeConfigurator simpleConfig = new SimpleVolumeConfigurator();
        try {
            simpleConfig.internalCreate(newSimpleVolume);
        }
        catch (SrCommunicationException e) {
            volId = DiscoverMgr.getInstance().getVolIdForPhysStor(physStorSpecificData, snmpAgentIndex);
            if (volId != null) {
                CommKey[] volCommKey = new CommKey[]{new SnmpCommKey(volId, snmpAgentIndex)};
                return volCommKey;
            }
            throw e;
        }
        String volIndex = newSimpleVolume.getSnmpKey().getKey();
        DiscoverMgr.getInstance().addEntryToVolPhysStorMap(volIndex, physStorSpecificData);
        CommKey[] newVolumeKey = newSimpleVolume.getCommKey();
        return newVolumeKey;
    }

    protected void removeSimpleVolume(CommKeyClassId physStorData, char snmpAgentIndex) throws SrCommunicationException {
        CommKeyClassId specificPhysStorData = CommKeyUtil.getSpecificCommKeyClassId(physStorData, snmpAgentIndex);
        String volId = DiscoverMgr.getInstance().getVolIdForPhysStor(specificPhysStorData, snmpAgentIndex);
        if (volId == null) {
            return;
        }
        this.removeSimpleVolume(volId, snmpAgentIndex, false);
    }

    public void removeSimpleVolume(String volId, char snmpAgetnIndex) throws SrCommunicationException {
        this.removeSimpleVolume(volId, snmpAgetnIndex, false);
    }

    public void removeSimpleVolume(String volId, char snmpAgetnIndex, boolean removeOnlyFromAgent) throws SrCommunicationException {
        String volIndex = volId;
        if (DiscoverMgr.getInstance().isVolInvolvedInOtherOper(volIndex, snmpAgetnIndex)) {
            LogMgr.getServerLog().debug("Simple volume: " + volId + " is involved in other operation and cannot be removed");
            return;
        }
        if (volId.indexOf(".") < 0) {
            volIndex = new String("1." + volId);
        }
        ConfigElementData simpleVolumeData = new ConfigElementData(new SnmpCommKey(volIndex, snmpAgetnIndex), ClassID.SIMPLE_VOLUME);
        SimpleVolumeConfigurator simpleVolConfig = new SimpleVolumeConfigurator();
        try {
            simpleVolConfig.internalRemove(simpleVolumeData);
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().error("Failed to Remove " + simpleVolumeData.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(simpleVolumeData.getCommKey()) + " on " + CommKeyUtil.getIpFromIndex(snmpAgetnIndex));
            throw e;
        }
        CommKeyClassId physStor = DiscoverMgr.getInstance().getPhysStorOfVolId(volIndex, snmpAgetnIndex);
        ConfigElementData physStorData = new ConfigElementData(physStor);
        physStorData.setValue(ParameterCode.VOLUME_STATE, VolumeStateConstant.VOLUME_STATE_NONE);
        physStorData.setValue(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(snmpAgetnIndex));
        SrEventHandler.getEventMgr().sendChangeElementEvent(physStorData);
        if (!removeOnlyFromAgent) {
            DiscoverMgr.getInstance().removePhysStorOfVolId(volIndex, snmpAgetnIndex);
        }
        LogMgr.getServerLog().debug("Remove element " + simpleVolumeData.getClassId().toString() + " CommKey is: " + CommKeyUtil.getKeyForMessage(simpleVolumeData.getCommKey()));
    }

    protected void mergeElementLists(ConfigElementDataList mainList, ConfigElementDataList secondList, boolean setClassId) {
        try {
            Iterator secondItr = secondList.iterator();
            while (secondItr.hasNext()) {
                ConfigElementData secondElem = (ConfigElementData)secondItr.next();
                CommKey[] secondElemKey = secondElem.getCommKey();
                Iterator mainItr = mainList.iterator();
                ConfigElementData mainElem = null;
                while (mainItr.hasNext() && mainElem == null) {
                    ConfigElementData currentMainElem = (ConfigElementData)mainItr.next();
                    CommKey[] mainElemKey = currentMainElem.getCommKey();
                    if (!CommKey.compare(secondElemKey, mainElemKey)) continue;
                    mainElem = currentMainElem;
                    break;
                }
                if (mainElem == null) {
                    SrEventHandler.getErrorMgr().sendConfigurationError("Misconfigured " + secondElem.getClassId().toString() + " index: " + secondElem.getSnmpKey().toDisplayString(), secondElem.getSnmpKey().getSnmpAgentIndex());
                    continue;
                }
                mainElem.addParameter(secondElem.getParametersList());
                if (!setClassId) continue;
                mainElem.setClassId(this.myClassId);
            }
        }
        catch (RuntimeException e) {
            String msg = "Merge Failed at: " + CommKeyUtil.getKeyForMessage(((ConfigElementData)mainList.get(0)).getCommKey());
            LogMgr.getServerLog().debug(msg, e);
            throw e;
        }
    }

    protected void sendDiscoveredElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (int i = 0; i < list.size(); ++i) {
            if (vSwitchData != null) {
                ((ConfigElementData)list.elementAt(i)).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            LogMgr.getServerLog().debug("Discover: " + ((ConfigElementData)list.elementAt(i)).getClassId().toString() + " CommKey is:" + CommKeyUtil.getKeyForMessage(((ConfigElementData)list.elementAt(i)).getCommKey()));
        }
        SrEventHandler.getEventMgr().sendAddElementEvent(list);
    }

    protected void sendRefreshedElementsToEventMgr(ConfigElementDataList list, CommKeyClassId vSwitchData) {
        for (int i = 0; i < list.size(); ++i) {
            if (vSwitchData != null) {
                ((ConfigElementData)list.elementAt(i)).addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
            }
            LogMgr.getServerLog().debug("Refresh: " + ((ConfigElementData)list.elementAt(i)).getClassId().toString() + " CommKey is:" + CommKeyUtil.getKeyForMessage(((ConfigElementData)list.elementAt(i)).getCommKey()));
        }
        SrEventHandler.getEventMgr().sendRefreshElementEvent(list);
    }

    protected void addCommVarBindsToCreateList(CommVarBindList list, ConfigElementData element) {
    }

    protected void addCommVarBindsToRemoveList(CommVarBindList list, ConfigElementData element) {
    }

    protected void addCommVarBindsToChangeList(CommVarBindList list, ConfigElementData element) {
    }

    protected void discoveryPostDiscoverOpration(ConfigElementData element, CommVarBindList list) {
    }

    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommunicationException {
    }

    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        if (this.myLastUpdateMib != null && !this.hasLastUpdatePerEntry) {
            SrOid oid = new SrOid(this.myLastUpdateMib.toString(), "0");
            SrSnmpVarBind varBind = new SrSnmpVarBind(oid, null);
            list.add(varBind);
        }
    }

    protected void splitParameterListOfDifferentElement(ConfigElementData mainList, HashMap paramsToSplit) {
        Iterator paramsToSplitItr = paramsToSplit.keySet().iterator();
        while (paramsToSplitItr.hasNext()) {
            ParameterCode splitCode = (ParameterCode)paramsToSplitItr.next();
            if (mainList.containParameter(splitCode)) {
                paramsToSplit.put(splitCode, mainList.removeParameter(splitCode));
                continue;
            }
            paramsToSplitItr.remove();
        }
    }

    public SrType getVarBindValueFromList(CommVarBindList list, CommItem item) {
        for (int i = list.size() - 1; i >= 0; --i) {
            CommVarBind varBind = (CommVarBind)list.get(i);
            CommVarBindKey vbKey = varBind.getVarBindKey();
            String strKey = ((SrOid)vbKey).getOid();
            if (!strKey.equals(item.toString())) continue;
            list.remove(i);
            return varBind.getValue();
        }
        return null;
    }

    protected CommVarBindKey getVarBindFromList(CommVarBindList list, CommItem item) {
        if (item != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                CommVarBind varBind = (CommVarBind)list.get(i);
                CommVarBindKey vbKey = varBind.getVarBindKey();
                String strKey = ((SrOid)vbKey).getOid();
                if (!strKey.equals(item.toString())) continue;
                return varBind.getVarBindKey();
            }
        }
        return null;
    }

    public void handleTrap(SrTrap trap) {
        Object commKey;
        ConfigElementData element = new ConfigElementData(this.myClassId);
        SrSnmpVarBindList vbList = trap.getVarBindList();
        char agentIndex = trap.getSourceIndex();
        String key = null;
        if (!this.myClassId.equals(ClassID.VSWITCH) && !this.myClassId.equals(ClassID.HARDWARE)) {
            CommItem trapCommKey = this.getCommItemForTrapCommKey(trap);
            if (trapCommKey == null) {
                return;
            }
            CommVarBindKey varBindKey = this.getVarBindFromList(vbList, trapCommKey);
            if (varBindKey == null) {
                logger.warning("CommVarBindKey of trap " + trap + " (" + trapCommKey + ") is null");
            } else {
                key = varBindKey.getIndex();
            }
        }
        if (this.myClassId.equals(ClassID.HARDWARE)) {
            commKey = CommKeyUtil.getVSwitchData(agentIndex).getCommKeys();
            element.setCommKeys((CommKey[])commKey);
        } else {
            commKey = new SnmpCommKey(key, agentIndex);
            element.setCommKey((CommKey)commKey);
        }
        Iterator itr = vbList.iterator();
        while (itr.hasNext()) {
            CommVarBind varBind = (CommVarBind)itr.next();
            Parameter parameter = this.convertVarBindToParam(varBind);
            if (parameter == null) continue;
            element.addParameter(parameter);
            itr.remove();
        }
        CommKeyClassId vSwitchData = CommKeyUtil.getVSwitchData(agentIndex);
        if (vSwitchData != null) {
            element.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
            this.trapProccessingPostOperation(element, trap);
        }
    }

    protected void proccessTrapParameters(SrTrap trap, ConfigElementData element) {
        throw new UnsupportedOperationException();
    }

    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        logger.warning("Unssuported trap: " + trap.toString());
        return null;
    }

    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) {
    }

    protected void unknownElementTrapOperation(ConfigElementData element, SrTrap trap) {
    }

    public void readOneRowFromTable(ConfigElementData element) throws SrCommunicationException {
        String[] tableList = new String[]{this.myTableName};
        CommVarBindList rowData = CommMgr.getInstance(element.getMyFirstSnmpAgentIndex()).getOneRow(tableList, element.getSnmpKey());
        for (int i = rowData.size() - 1; i >= 0; --i) {
            Parameter param = this.convertVarBindToParam((CommVarBind)rowData.get(i));
            if (param == null) continue;
            element.addParameter(param);
            rowData.remove(i);
        }
        this.readDiscoverPostOperation(element, rowData);
    }

    public ConfigElementDataList getElementsByFilter(ConfigElementData element, SrSnmpTable table) throws SrCommunicationException {
        CommVarBindList list = new CommVarBindList();
        this.convertParamsToVarBinds(element, list);
        return this.getElementsByFilter(list, table);
    }

    public ConfigElementDataList getElementsByFilter(CommVarBindList vbList, SrSnmpTable table) throws SrCommunicationException {
        CommVarBindList[] rows = CommMgr.getInstance(table.getAgentIndex()).filterTableRowsByValue(table, (CommVarBind)vbList.get(0));
        ConfigElementDataList elements = new ConfigElementDataList();
        for (int i = 0; i < rows.length; ++i) {
            elements.add(this.createConfigElementFromTableRow(rows[i], table.getAgentIndex()));
        }
        return elements;
    }

    public ConfigElementDataList readTableRowsByValue(String table, MibItem column, SrType value, char agentIndex) throws SrCommunicationException {
        CommVarBindList[] rows = CommMgr.getInstance(agentIndex).getTableRowsByValue(table, column.toString(), value, agentIndex);
        ConfigElementDataList elements = new ConfigElementDataList();
        for (int i = 0; i < rows.length; ++i) {
            elements.add(this.createConfigElementFromTableRow(rows[i], agentIndex));
        }
        return elements;
    }

    public ConfigElementDataList refreshTableFields(ConfigElementData fieldsData) throws SrCommunicationException {
        char agentIndex = fieldsData.getSnmpAgentFromParameter();
        CommVarBindList varBindsToGet = new CommVarBindList();
        this.convertParamsToVarBinds(fieldsData, varBindsToGet);
        this.addCommVarBindsToReadList(varBindsToGet, fieldsData);
        CommVarBindList[] allData = CommMgr.getInstance(agentIndex).snmpGetTable(varBindsToGet, agentIndex);
        ConfigElementDataList tableOfElements = this.convertDataToElements(allData, agentIndex);
        return tableOfElements;
    }

    protected ConfigElementDataList convertDataToElements(CommVarBindList[] data, char agentIndex) throws SrCommunicationException {
        ConfigElementDataList tableOfElements = new ConfigElementDataList();
        int numOfRows = data.length;
        for (int i = 0; i < numOfRows; ++i) {
            ConfigElementData element = this.createConfigElementFromTableRow(data[i], agentIndex);
            if (element == null) continue;
            tableOfElements.add(element);
        }
        return tableOfElements;
    }

    public ConfigElementDataList readTableColumns(ConfigElementData fieldsData) throws SrCommunicationException {
        char agentIndex = fieldsData.getSnmpAgentFromParameter();
        CommVarBindList varBindsToGet = new CommVarBindList();
        this.convertParamsToVarBinds(fieldsData, varBindsToGet);
        this.addCommVarBindsToReadList(varBindsToGet, fieldsData);
        CommVarBindList[] getBulkData = CommMgr.getInstance(agentIndex).snmpGetBulk(varBindsToGet, agentIndex);
        ConfigElementDataList listOfElements = new ConfigElementDataList();
        int numOfRows = getBulkData.length;
        for (int i = 0; i < numOfRows; ++i) {
            ConfigElementData element = this.createConfigElementFromTableRow(getBulkData[i], agentIndex);
            if (element == null) continue;
            listOfElements.add(element);
        }
        return listOfElements;
    }

    public CommVarBindList[] readTableColumn(char agentIndex, MibItem mibItem) throws SrCommunicationException {
        CommVarBindList varBindsToGet = new CommVarBindList();
        SrOid oid = new SrOid(mibItem.toString(), "0");
        SrSnmpVarBind varBind = new SrSnmpVarBind(oid, null);
        varBindsToGet.add(varBind);
        CommVarBindList[] getBulkData = CommMgr.getInstance(agentIndex).snmpGetBulk(varBindsToGet, agentIndex);
        return getBulkData;
    }

    public void postSendCreateEvent(ConfigElementData myElement) throws SrCommunicationException {
    }

    public void postSendRemoveEvent(ConfigElementData myElement) throws SrCommunicationException {
    }

    protected void readVolumePosition(CommKeyClassId[] childrenCommKeys, CommKeyClassId parentData) throws SrCommunicationException, SrElementOperationException {
        CommVarBindList positions = new CommVarBindList();
        SnmpCommKey parentCommKey = CommKeyUtil.getSnmpCommKey(parentData);
        String parentIndex = parentCommKey.getKey();
        char agentIndex = parentCommKey.getSnmpAgentIndex();
        for (int i = 0; i < childrenCommKeys.length; ++i) {
            String childKey = UNKNOWN_TABLE;
            childKey = childrenCommKeys[i].getClassID().isVolume() ? CommKeyUtil.getSpecificSnmpKey(childrenCommKeys[i], agentIndex).getKey() : DiscoverMgr.getInstance().getVolIdForPhysStor(childrenCommKeys[i], agentIndex);
            String childIndex = childKey.substring(childKey.indexOf(".") + 1);
            SrOid oid = new SrOid(MibItem.VIRTUAL_VOLUME_CHILDREN_POSITION.toString(), parentIndex + "." + childIndex);
            SrSnmpVarBind vb = new SrSnmpVarBind(oid, null);
            positions.add(vb);
        }
        try {
            CommMgr.getInstance(agentIndex).getList(positions, agentIndex);
        }
        catch (SrSnmpTimeoutException e) {
            logger.error(e.getMessage());
            throw e;
        }
        catch (SrCommunicationException e) {
            LogMgr.getServerLog().error("Failed to read volume position", e);
            throw e;
        }
        VolumeChildrenConfigurator childrenConfig = new VolumeChildrenConfigurator();
        ConfigElementDataList listOfElements = new ConfigElementDataList();
        for (int i = 0; i < positions.size(); ++i) {
            ConfigElementData element = childrenConfig.createConfigElementFromOneVarBind((CommVarBind)positions.elementAt(i), agentIndex);
            element.setClassId(childrenCommKeys[i].getClassID());
            element.setCommKeys(childrenCommKeys[i].getCommKeys());
            if (element == null) continue;
            listOfElements.add(element);
        }
        SrEventHandler.getEventMgr().sendChangeElementEvent(listOfElements);
    }

    public boolean removeSimpleVolumeIfNeed(CommKeyClassId vol, CommKeyClassId vSwitch) throws SrCommunicationException {
        if (vol == null) {
            return false;
        }
        if (vol.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || vol.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            this.removeSimpleVolume(vol, vSwitch.getMyFirstSnmpAgentIndex());
            return true;
        }
        return false;
    }

    protected SrDateAndTime getDate(SrDateAndTime lastReset, SrTimeTicks timeStamp) {
        if (lastReset != null && timeStamp != null) {
            Long lastResetLong = (Long)lastReset.value();
            long eventTime = lastResetLong + timeStamp.longValue() * 500L / 30L;
            SrDateAndTime dateOfEvent = new SrDateAndTime(new Long(eventTime));
            return dateOfEvent;
        }
        return null;
    }

    protected SrDateAndTime getDate(char agentIndex, SrTimeTicks timeStamp) throws SrCommunicationException {
        SrDateAndTime lastReset = this.getLastReset(agentIndex);
        return this.getDate(lastReset, timeStamp);
    }

    protected SrDateAndTime getLastReset(SrDateAndTime currentTime, SrTimeTicks sysUpTime) {
        if (sysUpTime != null && currentTime != null) {
            Long currentDate = (Long)currentTime.value();
            long lastReset = currentDate - sysUpTime.longValue() * 10L;
            SrDateAndTime dateOfLastReset = new SrDateAndTime(new Long(lastReset));
            return dateOfLastReset;
        }
        return null;
    }

    protected SrDateAndTime getLastReset(char agentIndex) throws SrCommunicationException {
        SnmpCommKey vSwitchKey = new SnmpCommKey("0", agentIndex);
        ConfigElementData vSwitch = new ConfigElementData(vSwitchKey, ClassID.VSWITCH);
        vSwitch.addParameter(new Parameter(ParameterCode.VSWITCH_LAST_RESET));
        VSwitchConfigurator vSwitchConfig = new VSwitchConfigurator();
        vSwitchConfig.internalReadFields(vSwitch);
        SrDateAndTime time = (SrDateAndTime)vSwitch.getValue(ParameterCode.VSWITCH_LAST_RESET);
        return time;
    }

    protected SrType getScalarFromComm(MibItem valToGet, char agentIndex) throws SrCommunicationException {
        SrOid oid = new SrOid(valToGet.toString(), "0");
        SrSnmpVarBind varBind = new SrSnmpVarBind(oid, null);
        CommVarBindList vbList = new CommVarBindList();
        vbList.add(varBind);
        CommMgr.getInstance(agentIndex).getList(vbList, agentIndex);
        int index = vbList.indexOf(varBind);
        return ((SrSnmpVarBind)vbList.elementAt(index)).getValue();
    }

    public void removeNotReadyRows(SrSnmpTable table, CommKeyClassId vSwitchData) throws SrCommunicationException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        CommMgr commMgr = CommMgr.getInstance(snmpAgentIndex);
        if (table == null) {
            table = commMgr.createTableRef(this.myTableName, snmpAgentIndex);
        }
        commMgr.refreshTable(table);
        CommVarBindList vbList = new CommVarBindList();
        SrSnmpVarBind volRs = new SrSnmpVarBind(this.myRowStatusMib.toString(), (SrType)RowStatusConstants.ROW_STATUS_NOT_READY);
        vbList.add(volRs);
        ConfigElementDataList notReadyElements = this.getElementsByFilter(vbList, table);
        for (int i = 0; i < notReadyElements.size(); ++i) {
            ConfigElementData elementToRemove = (ConfigElementData)notReadyElements.get(i);
            ElementConfigurator elementToRemoveConfig = DataMgr.getElementConfigFromClassID(elementToRemove.getClassId());
            try {
                elementToRemoveConfig.internalRemove(elementToRemove);
            }
            catch (SrCommunicationException e) {
                LogMgr.getServerLog().warning("Failed to remove Invalid Element: " + elementToRemove.getCommKeyClassId() + " from " + vSwitchData.toString(), e);
                continue;
            }
            LogMgr.getServerLog().warning("Invalid Element: " + elementToRemove.getCommKeyClassId() + " was removed from " + vSwitchData.toString());
        }
    }

    public ConfigElementData createConfigElementFromVarBindList(CommVarBindList vbList, char agentIndex) throws SrCommunicationException {
        ConfigElementData element = this.createConfigElementFromTableRow(vbList, agentIndex);
        return element;
    }

    private CommVarBindList[] ignoreRowsWithRowStatus(char agentIndex, CommVarBindList[] table, MibItem rowStatusMibItem, RowStatusConstants rowStatus) {
        if (table != null) {
            Vector<CommVarBindList> varBindLists = null;
            if (rowStatusMibItem != null) {
                for (int i = 0; i < table.length; ++i) {
                    Enumeration e = table[i].elements();
                    while (e.hasMoreElements()) {
                        RowStatusConstants value;
                        CommVarBind varBind = (CommVarBind)e.nextElement();
                        String key = ((SrOid)varBind.getVarBindKey()).getKey();
                        String rsKey = key.substring(0, key.indexOf("."));
                        if (!rsKey.equals(rowStatusMibItem.toString()) || !(value = (RowStatusConstants)varBind.getValue()).equals(rowStatus)) continue;
                        CommKeyClassId vSwitchData = null;
                        if (varBindLists == null) {
                            varBindLists = new Vector<CommVarBindList>(Arrays.asList(table));
                            vSwitchData = CommKeyUtil.getVSwitchData(agentIndex);
                        }
                        varBindLists.removeElement(table[i]);
                        logger.warning("Row status of " + key + " is " + rowStatus + " on " + vSwitchData);
                    }
                }
            }
            if (varBindLists != null) {
                CommVarBindList[] list = new CommVarBindList[varBindLists.size()];
                for (int i = 0; i < list.length; ++i) {
                    list[i] = (CommVarBindList)varBindLists.elementAt(i);
                }
                return list;
            }
        }
        return table;
    }

    private CommVarBindList[] ignoreRowsWithRowStatus(char agentIndex, CommVarBindList[] table, RowStatusConstants rowStatus) {
        return this.ignoreRowsWithRowStatus(agentIndex, table, this.myRowStatusMib, rowStatus);
    }

    protected CommVarBindList[] ignoreNotReadyRows(char agentIndex, CommVarBindList[] table) {
        return this.ignoreRowsWithRowStatus(agentIndex, table, RowStatusConstants.ROW_STATUS_NOT_READY);
    }

    protected CommVarBindList[] ignoreDestroyedRows(char agentIndex, CommVarBindList[] table) {
        return this.ignoreRowsWithRowStatus(agentIndex, table, RowStatusConstants.ROW_STATUS_DESTROY);
    }

    protected final String getIndexNext(String tableName, char agentIndex) throws SrCommunicationException {
        return this.getIndexNext(tableName, "1", null, false, agentIndex);
    }

    protected final String getIndexNext(String tableName, String firstIndex, String parent, boolean fillGaps, char agentIndex) throws SrCommunicationException {
        String parentIndex;
        String string = parentIndex = parent == null ? UNKNOWN_TABLE : parent;
        if (firstIndex == null || firstIndex.length() == 0) {
            throw new IllegalArgumentException("You must provide first index in order to create next index");
        }
        CommVarBindList[] table = CommMgr.getInstance(agentIndex).getAll(tableName, agentIndex);
        if (table.length == 0) {
            return firstIndex;
        }
        String[] tableIndices = new String[table.length];
        int i = tableIndices.length;
        while (i-- > 0) {
            tableIndices[i] = ((CommVarBind)table[i].elementAt(0)).getIndexForCommKey();
        }
        int rowCursor = 0;
        for (int i2 = 0; i2 < table.length; ++i2) {
            if (parentIndex.compareTo(tableIndices[i2]) >= 0) continue;
            rowCursor = i2;
            break;
        }
        long prevIndexPostfix = 0L;
        for (int i3 = rowCursor; i3 < tableIndices.length && SrOid.isParentOf(parentIndex, tableIndices[i3]); ++i3) {
            rowCursor = i3;
            long[] cursorIndexComponents = SrOid.getComponents(tableIndices[i3]);
            long cursorIndexPostfix = cursorIndexComponents[cursorIndexComponents.length - 1];
            if (fillGaps && cursorIndexPostfix - prevIndexPostfix > 1L) break;
            prevIndexPostfix = cursorIndexPostfix;
        }
        if (parent == null) {
            long[] cursorIndexComponents = SrOid.getComponents(tableIndices[rowCursor]);
            cursorIndexComponents[cursorIndexComponents.length - 1] = prevIndexPostfix + 1L;
            StringBuffer buff = new StringBuffer();
            for (int i4 = 0; i4 < cursorIndexComponents.length - 1; ++i4) {
                buff.append(cursorIndexComponents[i4]).append('.');
            }
            buff.append(cursorIndexComponents[cursorIndexComponents.length - 1]);
            return buff.toString();
        }
        return parent + '.' + (prevIndexPostfix + 1L);
    }

    public final void stimulateRefresh(char agentIndex) throws SrCommunicationException {
        CheckListConfigElementData checkList = new CheckListConfigElementData(this.myClassId);
        ConfigElementDataList dataList = this.refreshTable(agentIndex, null, checkList);
        if (dataList != null) {
            this.sendRefreshedElementsToEventMgr(dataList, CommKeyUtil.getVSwitchData(agentIndex));
            EventMgr.getInstance().sendCheckListEvent(checkList);
        }
    }

    protected void updateCedAfterCreate(ConfigElementData element) {
        Iterator paramIter = element.getParametersList().keySet().iterator();
        while (paramIter.hasNext()) {
            ParameterCode code = (ParameterCode)paramIter.next();
            Object value = element.getValue(code);
            if (value instanceof ConfigElementData) {
                ConfigElementData father = (ConfigElementData)value;
                if (!father.isCreated()) {
                    logger.debug("create" + element + "from" + father);
                    this.create(element, father);
                }
                this.getParametersFromChild(father, element);
            }
            if (!(value instanceof ConfigElementDataList)) continue;
            ConfigElementDataList sonList = (ConfigElementDataList)value;
            for (int index = 0; index < sonList.size(); ++index) {
                ConfigElementData son = (ConfigElementData)sonList.elementAt(index);
                if (son.isCreated()) continue;
                logger.debug("create" + son + "from" + element);
                this.create(element, son);
            }
            this.getParametersFromSon(element, sonList);
        }
    }

    private void getParametersFromSon(ConfigElementData element, ConfigElementDataList sonList) {
        Iterator paramIter = element.getParametersList().keySet().iterator();
        while (paramIter.hasNext()) {
            ParameterCode code = (ParameterCode)paramIter.next();
            Object value = element.getValue(code);
            if (!(value instanceof ConfigElementDataList)) continue;
            SrType[] arrayOfCommKeyClassId = sonList.getArrayOfCommKeyClassId();
            element.setValues(code, arrayOfCommKeyClassId);
        }
    }

    private void create(ConfigElementData element, ConfigElementData son) {
        ElementConfigurator config = DataMgr.getElementConfigFromClassID(son.getClassId());
        try {
            config.internalCreate(son);
            boolean isElementSentByEvent = config.readAfterCreate(son);
            if (!isElementSentByEvent) {
                SrEventHandler.getEventMgr().sendAddElementEvent(son);
            }
            config.postCreateOperation(son);
        }
        catch (SrCommunicationException e) {
            e.printStackTrace();
        }
        catch (SrElementOperationException e) {
            e.printStackTrace();
        }
    }

    protected void getParametersFromChild(ConfigElementData child, ConfigElementData element) {
        Iterator paramIter = element.getParametersList().keySet().iterator();
        while (paramIter.hasNext()) {
            ParameterCode code = (ParameterCode)paramIter.next();
            Object value = element.getValue(code);
            if (!(value instanceof ConfigElementData)) continue;
            element.setValue(code, child.getCommKeyClassId());
        }
    }

    public final void stimulateRefreshByPrefix(char agentIndex, String indexPrefix) throws SrCommunicationException {
        ConfigElementDataList subTable = this.getAllByPrefix(agentIndex, indexPrefix);
        if (subTable != null) {
            CheckListConfigElementData checkList = new CheckListConfigElementData(this.myClassId);
            this.buildCheckListElement(subTable, checkList, agentIndex, null);
            EventMgr.getInstance().sendRefreshElementEvent(subTable);
            EventMgr.getInstance().sendCheckListEvent(checkList);
        }
    }

    protected HashMap createMapFromList(ConfigElementDataList dataList) {
        HashMap<SnmpCommKey, ConfigElementData> ret = new HashMap<SnmpCommKey, ConfigElementData>();
        int i = dataList.size();
        while (i-- > 0) {
            ConfigElementData ced = dataList.getConfigElementDataAt(i);
            ret.put(ced.getSnmpKey(), ced);
        }
        return ret;
    }
}

