/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.comm.snmp.trap.TrapEvent;
import com.sanrad.nms.server.comm.snmp.trap.TrapListener;
import com.sanrad.nms.server.event.ErrorListener;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.AlarmTypeConfigurator;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ClusterConfigurator;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.EmailContactConfigurator;
import com.sanrad.nms.server.mgr.FCIfConfigurator;
import com.sanrad.nms.server.mgr.FCNodeConfigurator;
import com.sanrad.nms.server.mgr.HardwareConfigurator;
import com.sanrad.nms.server.mgr.ISCSIRemotePortalDiscoveryConfigurator;
import com.sanrad.nms.server.mgr.IScsiConnectionConfigurator;
import com.sanrad.nms.server.mgr.IScsiInstanceConfigurator;
import com.sanrad.nms.server.mgr.IScsiRemoteInitatoresConfigurator;
import com.sanrad.nms.server.mgr.IScsiSessionConfigurator;
import com.sanrad.nms.server.mgr.IfConfigurator;
import com.sanrad.nms.server.mgr.IfStatisticConfigurator;
import com.sanrad.nms.server.mgr.IpRouteConfigurator;
import com.sanrad.nms.server.mgr.LUNConfigurator;
import com.sanrad.nms.server.mgr.NetConfigConfigurator;
import com.sanrad.nms.server.mgr.PScsiIfConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetPortalConfigurator;
import com.sanrad.nms.server.mgr.ScsiDeviceConfigurator;
import com.sanrad.nms.server.mgr.ScsiInitiatorDeviceConfigurator;
import com.sanrad.nms.server.mgr.ScsiPortConfigurator;
import com.sanrad.nms.server.mgr.SiteConfigurator;
import com.sanrad.nms.server.mgr.SnmpManagerConfigurator;
import com.sanrad.nms.server.mgr.SnmpTargetAddressConfigurator;
import com.sanrad.nms.server.mgr.StorageDomainConfigurator;
import com.sanrad.nms.server.mgr.TcpConnectionConfigurator;
import com.sanrad.nms.server.mgr.TrapHandler;
import com.sanrad.nms.server.mgr.UDPListenerConfigurator;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.mgr.acl.TargetAuthorizationConfigurator;
import com.sanrad.nms.server.mgr.discover.DiscoverMgr;
import com.sanrad.nms.server.mgr.dr.AsyncPairConfigurator;
import com.sanrad.nms.server.mgr.dr.AsyncPairPiTConfigurator;
import com.sanrad.nms.server.mgr.dr.ConsistencyGroupConfigurator;
import com.sanrad.nms.server.mgr.dr.ConsistencyGroupPiTConfigurator;
import com.sanrad.nms.server.mgr.dr.ExtendedPairConfigurator;
import com.sanrad.nms.server.mgr.dr.PairConfigurator;
import com.sanrad.nms.server.mgr.dr.SyncPairConfigurator;
import com.sanrad.nms.server.mgr.dr.cf.AsyncPairControlFunctionsConfigurator;
import com.sanrad.nms.server.mgr.dr.cf.CGControlFunctionsConfigurator;
import com.sanrad.nms.server.mgr.dr.cf.SyncPairControlFunctionsConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityNameConfigurator;
import com.sanrad.nms.server.mgr.identity.SRPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.lu.SCSILunConfigurator;
import com.sanrad.nms.server.mgr.operation.ElementOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperationList;
import com.sanrad.nms.server.mgr.policy.PolicyConfigurator;
import com.sanrad.nms.server.mgr.policy.PolicyParamConfigurator;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.mgr.polling.PollingMgr;
import com.sanrad.nms.server.mgr.srv.isns.ISNSServerConfigurator;
import com.sanrad.nms.server.mgr.srv.radius.RadiusServerConfigurator;
import com.sanrad.nms.server.mgr.storage.DirectAccessDeviceConfigurator;
import com.sanrad.nms.server.mgr.storage.LUIdentifierConfigurator;
import com.sanrad.nms.server.mgr.storage.PhysicalStorageConfigurator;
import com.sanrad.nms.server.mgr.storage.SubDirectAccessDeviceConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiPortalConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiTargetConfigurator;
import com.sanrad.nms.server.mgr.threads.ChangeElementThread;
import com.sanrad.nms.server.mgr.threads.CreateElementThread;
import com.sanrad.nms.server.mgr.threads.MultiOperationsThread;
import com.sanrad.nms.server.mgr.threads.ReadElementThread;
import com.sanrad.nms.server.mgr.threads.ReadFieldsThread;
import com.sanrad.nms.server.mgr.threads.RefreshFieldsThread;
import com.sanrad.nms.server.mgr.threads.RemoveElementThread;
import com.sanrad.nms.server.mgr.threads.SrThreadCreationException;
import com.sanrad.nms.server.mgr.threads.VolumeOperationThread;
import com.sanrad.nms.server.mgr.volume.ConcatVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.CubeVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.JournalVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.MirrorVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.MirrorVolumeSyncConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.SnapshotVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.StripeVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.TransparentVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeOperationConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class DataMgr
implements TrapListener {
    private static DiscoverMgr discoverMgr = DiscoverMgr.getInstance();
    private static TrapHandler trapsHandler = TrapHandler.getInstance();
    private static DataMgr theInstance = new DataMgr();

    private DataMgr() {
        CommMgr.addTrapListenerToAllMonitors(this);
    }

    public static DiscoverMgr getDiscoverMgr() {
        return discoverMgr;
    }

    public static DataMgr getInstance() {
        return theInstance;
    }

    public void removeErrorDataMgrListener(ErrorListener listener) {
        SrEventHandler.getErrorMgr().removeListener(listener);
    }

    public void changeElementAsync(ConfigElementDataList elementsList) {
        Iterator elementIter = elementsList.iterator();
        while (elementIter.hasNext()) {
            this.changeElement((ConfigElementData)elementIter.next());
        }
    }

    public void changeElement(ConfigElementData element) {
        ClassID classId = element.getClassId();
        if (classId.equals(ClassID.CLUSTER) || classId.equals(ClassID.SITE) || classId.equals(ClassID.ALARM_TYPE) || classId.equals(ClassID.EMAIL_CONTACT)) {
            try {
                ChangeElementThread thread = new ChangeElementThread(element);
                thread.start();
            }
            catch (SrThreadCreationException e) {
                LogMgr.getServerLog().error(e);
            }
        } else {
            ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(element);
            for (int i = 0; i < elementsAccordingToAgents.size(); ++i) {
                try {
                    ChangeElementThread thread = new ChangeElementThread((ConfigElementData)elementsAccordingToAgents.elementAt(i));
                    thread.start();
                    continue;
                }
                catch (SrThreadCreationException e) {
                    LogMgr.getServerLog().error(e);
                }
            }
        }
    }

    public void changeElement(ConfigElementDataList elementList) {
        ConfigElementDataList[] elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(elementList);
        for (int i = 0; i < elementsAccordingToAgents.length; ++i) {
            ChangeElementThread thread = new ChangeElementThread(elementsAccordingToAgents[i]);
            thread.start();
        }
    }

    public void createElementAsync(ConfigElementDataList elementsList) {
        Iterator elementIter = elementsList.iterator();
        while (elementIter.hasNext()) {
            this.createElement((ConfigElementData)elementIter.next());
        }
    }

    public void createElement(ConfigElementData element) {
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(element);
        if (elementsAccordingToAgents == null) {
            CreateElementThread thread = new CreateElementThread(element);
            thread.start();
        } else {
            for (int i = 0; i < elementsAccordingToAgents.size(); ++i) {
                CreateElementThread thread = new CreateElementThread((ConfigElementData)elementsAccordingToAgents.elementAt(i));
                thread.start();
            }
        }
    }

    public void createElement(ConfigElementDataList elementList) {
        ConfigElementDataList[] elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(elementList);
        if (elementsAccordingToAgents == null) {
            CreateElementThread thread = new CreateElementThread(elementList);
            thread.start();
        } else {
            for (int i = 0; i < elementsAccordingToAgents.length; ++i) {
                CreateElementThread thread = new CreateElementThread(elementsAccordingToAgents[i]);
                thread.start();
            }
        }
    }

    public void executeOperations(ElementOperationList operationsList) {
        Hashtable<Character, ElementOperationList> lists = new Hashtable<Character, ElementOperationList>();
        ElementOperation elementOperation = (ElementOperation)operationsList.get(0);
        ConfigElementData element = elementOperation.getElement();
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(element);
        for (int j = 0; j < elementsAccordingToAgents.size(); ++j) {
            ConfigElementData configElementData = (ConfigElementData)elementsAccordingToAgents.get(j);
            ElementOperationList opList = new ElementOperationList();
            ElementOperation operation = elementOperation.clone(configElementData);
            opList.addElement(operation);
            char key = configElementData.getSnmpAgentFromParameter();
            lists.put(new Character(key), opList);
        }
        for (int i = 1; i < operationsList.size(); ++i) {
            ElementOperation op = (ElementOperation)operationsList.get(i);
            ConfigElementData dataElement = op.getElement();
            elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(dataElement);
            for (int j = 0; j < elementsAccordingToAgents.size(); ++j) {
                ConfigElementData ced = (ConfigElementData)elementsAccordingToAgents.get(j);
                ElementOperation operation = op.clone(ced);
                Character keyChar = new Character(ced.getSnmpAgentFromParameter());
                if (lists.containsKey(keyChar)) {
                    ((ElementOperationList)lists.get(keyChar)).addElement(operation);
                    continue;
                }
                ElementOperationList eol = new ElementOperationList();
                eol.addElement(operation);
                lists.put(keyChar, eol);
            }
        }
        Enumeration values = lists.elements();
        while (values.hasMoreElements()) {
            try {
                MultiOperationsThread multiOperationsThread = new MultiOperationsThread((ElementOperationList)values.nextElement());
                multiOperationsThread.start();
            }
            catch (SrThreadCreationException e) {
                LogMgr.getServerLog().error(e);
            }
        }
    }

    public void removeElementAsync(ConfigElementDataList elementsList) {
        Iterator elementIter = elementsList.iterator();
        while (elementIter.hasNext()) {
            this.removeElement((ConfigElementData)elementIter.next());
        }
    }

    public void removeElement(ConfigElementData element) {
        if (element.getClassId().equals(ClassID.CLUSTER) || element.getClassId().equals(ClassID.SITE)) {
            try {
                RemoveElementThread thread = new RemoveElementThread(element);
                thread.start();
            }
            catch (SrThreadCreationException e) {
                LogMgr.getServerLog().error(e);
            }
        } else {
            ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(element);
            for (int i = 0; i < elementsAccordingToAgents.size(); ++i) {
                try {
                    RemoveElementThread thread = new RemoveElementThread((ConfigElementData)elementsAccordingToAgents.elementAt(i));
                    thread.start();
                    continue;
                }
                catch (SrThreadCreationException e) {
                    LogMgr.getServerLog().error(e);
                }
            }
        }
    }

    public void removeElement(ConfigElementDataList elementList) {
        ConfigElementDataList[] elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(elementList);
        for (int i = 0; i < elementsAccordingToAgents.length; ++i) {
            RemoveElementThread thread = new RemoveElementThread(elementsAccordingToAgents[i]);
            thread.start();
        }
    }

    public void readElement(ConfigElementDataList elementsList) {
        Iterator elementIter = elementsList.iterator();
        while (elementIter.hasNext()) {
            this.readElement((ConfigElementData)elementIter.next());
        }
    }

    public void readElement(ConfigElementData element) {
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(element);
        for (int i = 0; i < elementsAccordingToAgents.size(); ++i) {
            try {
                ReadElementThread thread = new ReadElementThread((ConfigElementData)elementsAccordingToAgents.elementAt(i));
                thread.start();
                continue;
            }
            catch (SrThreadCreationException e) {
                LogMgr.getServerLog().error(e);
            }
        }
    }

    public void readElementFields(ConfigElementDataList elementsList) {
        Iterator elementIter = elementsList.iterator();
        while (elementIter.hasNext()) {
            this.readElementFields((ConfigElementData)elementIter.next());
        }
    }

    public void readElementFields(ConfigElementData element) {
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(element);
        for (int i = 0; i < elementsAccordingToAgents.size(); ++i) {
            try {
                ReadFieldsThread thread = new ReadFieldsThread((ConfigElementData)elementsAccordingToAgents.elementAt(i));
                thread.start();
                continue;
            }
            catch (SrThreadCreationException e) {
                LogMgr.getServerLog().error(e);
            }
        }
    }

    public void refreshTableFields(ConfigElementData element) {
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(element);
        for (int i = 0; i < elementsAccordingToAgents.size(); ++i) {
            try {
                RefreshFieldsThread thread = new RefreshFieldsThread((ConfigElementData)elementsAccordingToAgents.elementAt(i));
                thread.start();
                continue;
            }
            catch (SrThreadCreationException e) {
                LogMgr.getServerLog().error(e);
            }
        }
    }

    public void operate(ConfigElementData element, VolumeOperationType operType) {
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(element);
        for (int i = 0; i < elementsAccordingToAgents.size(); ++i) {
            VolumeOperationThread thread = null;
            try {
                thread = new VolumeOperationThread((ConfigElementData)elementsAccordingToAgents.elementAt(i), operType);
                thread.start();
            }
            catch (SrThreadCreationException e) {
                LogMgr.getServerLog().error(e);
                continue;
            }
            try {
                thread.join();
                continue;
            }
            catch (InterruptedException ie) {
                LogMgr.getServerLog().error(ie);
            }
        }
    }

    public void discoverConfiguration(CommKeyClassId vSwitch) {
        discoverMgr.discover(vSwitch);
    }

    public void discoverConfiguration(CommKeyClassId[] vSwitch) {
        for (int i = 0; i < vSwitch.length; ++i) {
            discoverMgr.discover(vSwitch[i]);
        }
    }

    public void systemDiscovery() {
        discoverMgr.systemDiscovery();
    }

    public void siteDiscovery() {
        discoverMgr.siteDiscovevry(null);
    }

    public void siteDiscovery(Integer siteId) {
        discoverMgr.siteDiscovevry(siteId);
    }

    public void clusterDiscovery() {
        this.clusterDiscovery(null);
    }

    public void clusterDiscovery(Integer clusterId) {
        discoverMgr.clusterDiscovevry(clusterId);
    }

    public void vSwitchDiscovery(CommKeyClassId vSwitch) {
        discoverMgr.vSwitchDiscovery(vSwitch);
    }

    public static ElementConfigurator getElementConfigFromClassID(ClassID classId) {
        if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            return new DirectAccessDeviceConfigurator();
        }
        if (classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            return new SubDirectAccessDeviceConfigurator();
        }
        if (classId.equals(ClassID.SIMPLE_VOLUME)) {
            return new SimpleVolumeConfigurator();
        }
        if (classId.equals(ClassID.TRANSPARENT_VOLUME)) {
            return new TransparentVolumeConfigurator();
        }
        if (classId.equals(ClassID.MIRROR_VOLUME)) {
            return new MirrorVolumeConfigurator();
        }
        if (classId.equals(ClassID.CONCAT_VOLUME)) {
            return new ConcatVolumeConfigurator();
        }
        if (classId.equals(ClassID.CUBE_VOLUME)) {
            return new CubeVolumeConfigurator();
        }
        if (classId.equals(ClassID.STRIPE_VOLUME)) {
            return new StripeVolumeConfigurator();
        }
        if (classId.equals(ClassID.JOURNAL_VOLUME)) {
            return new JournalVolumeConfigurator();
        }
        if (classId.equals(ClassID.GENERAL_VOLUME)) {
            return new VolumeConfigurator();
        }
        if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            return new PhysicalStorageConfigurator();
        }
        if (classId.equals(ClassID.ISCSI_TARGET)) {
            return new IscsiTargetConfigurator();
        }
        if (classId.equals(ClassID.LUN)) {
            return new LUNConfigurator();
        }
        if (classId.equals(ClassID.SCSI_LUN)) {
            return new SCSILunConfigurator();
        }
        if (classId.equals(ClassID.VSWITCH)) {
            return new VSwitchConfigurator();
        }
        if (classId.equals(ClassID.CLUSTER)) {
            return new ClusterConfigurator();
        }
        if (classId.equals(ClassID.SITE)) {
            return new SiteConfigurator();
        }
        if (classId.equals(ClassID.INTERFACE)) {
            return new IfConfigurator();
        }
        if (classId.equals(ClassID.FC_INTERFACE)) {
            return new FCIfConfigurator();
        }
        if (classId.equals(ClassID.PSCSI_INTERFACE)) {
            return new PScsiIfConfigurator();
        }
        if (classId.equals(ClassID.NETWORK_CONFIGURATION)) {
            return new NetConfigConfigurator();
        }
        if (classId.equals(ClassID.PORTAL)) {
            return new IscsiPortalConfigurator();
        }
        if (classId.equals(ClassID.IP_ROUTE)) {
            return new IpRouteConfigurator();
        }
        if (classId.equals(ClassID.STORAGE_DOMAIN)) {
            return new StorageDomainConfigurator();
        }
        if (classId.equals(ClassID.NEIGHBORE)) {
            return new SnmpTargetAddressConfigurator();
        }
        if (classId.equals(ClassID.SNMP_MANAGER)) {
            return new SnmpManagerConfigurator();
        }
        if (classId.equals(ClassID.IDENTITY)) {
            return new IdentityConfigurator();
        }
        if (classId.equals(ClassID.SRP_CREDENTIALS)) {
            return new SRPCredentialsConfigurator();
        }
        if (classId.equals(ClassID.CHAP_CREDENTIALS)) {
            return new CHAPCredentialsConfigurator();
        }
        if (classId.equals(ClassID.VOLUME_OPERATION)) {
            return new VolumeOperationConfigurator();
        }
        if (classId.equals(ClassID.MIRROR_SYNC)) {
            return new MirrorVolumeSyncConfigurator();
        }
        if (classId.equals(ClassID.COPY_OPERATION)) {
            return new VolumeOperationConfigurator();
        }
        if (classId.equals(ClassID.IDENTITY_NAME)) {
            return new IdentityNameConfigurator();
        }
        if (classId.equals(ClassID.ACL_ENTRY)) {
            return new TargetAuthorizationConfigurator();
        }
        if (classId.equals(ClassID.ALARM_TYPE)) {
            return new AlarmTypeConfigurator();
        }
        if (classId.equals(ClassID.EMAIL_CONTACT)) {
            return new EmailContactConfigurator();
        }
        if (classId.equals(ClassID.LU_IDENTIFIER)) {
            return new LUIdentifierConfigurator();
        }
        if (classId.equals(ClassID.RADIUS_SERVER)) {
            return new RadiusServerConfigurator();
        }
        if (classId.equals(ClassID.ISNS_SERVER)) {
            return new ISNSServerConfigurator();
        }
        if (classId.equals(ClassID.SEQUENTIAL_ACCESS_DEVICE) || classId.equals(ClassID.GENERAL_SCSI_DEVICE) || classId.equals(ClassID.GENERAL_PHYSICAL_STORAGE)) {
            return new PhysicalStorageConfigurator();
        }
        if (classId.equals(ClassID.SNAPSHOT_VOLUME)) {
            return new SnapshotVolumeConfigurator();
        }
        if (classId.equals(ClassID.FC_NODE)) {
            return new FCNodeConfigurator();
        }
        if (classId.equals(ClassID.HARDWARE)) {
            return new HardwareConfigurator();
        }
        if (classId.equals(ClassID.STATISTIC_INTERFACE)) {
            return new IfStatisticConfigurator();
        }
        if (classId.equals(ClassID.ISCSI_CONNECTION)) {
            return new IScsiConnectionConfigurator();
        }
        if (classId.equals(ClassID.ISCSI_INSTANCE)) {
            return new IScsiInstanceConfigurator();
        }
        if (classId.equals(ClassID.ISCSI_SESSION)) {
            return new IScsiSessionConfigurator();
        }
        if (classId.equals(ClassID.ISCSI_REMOTE_INITIATOR)) {
            return new IScsiRemoteInitatoresConfigurator();
        }
        if (classId.equals(ClassID.ISCSI_REMOTE_INITIATOR_STATISTICS)) {
            return new IScsiRemoteInitatoresConfigurator();
        }
        if (classId.equals(ClassID.ISCSI_SESSION_STATISTICS)) {
            return new IScsiSessionConfigurator();
        }
        if (classId.equals(ClassID.STATISTIC_TCP_CONNECTION)) {
            return new TcpConnectionConfigurator();
        }
        if (classId.equals(ClassID.STATISTIC_UDP_LISTENER)) {
            return new UDPListenerConfigurator();
        }
        if (classId.equals(ClassID.SCSI_DEVICE)) {
            return new ScsiDeviceConfigurator();
        }
        if (classId.equals(ClassID.SCSI_INITIATOR)) {
            return new ScsiInitiatorDeviceConfigurator();
        }
        if (classId.equals(ClassID.SCSI_PORT)) {
            return new ScsiPortConfigurator();
        }
        if (classId.equals(ClassID.ISCSI_REMOTE_TARGET)) {
            return new SCSIRemoteTargetConfigurator();
        }
        if (classId.equals(ClassID.ISCSI_REMOTE_TARGET_PORTAL)) {
            return new SCSIRemoteTargetPortalConfigurator();
        }
        if (classId.equals(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL)) {
            return new ISCSIRemotePortalDiscoveryConfigurator();
        }
        if (classId.equals(ClassID.CONSISTENCY_GROUP)) {
            return new ConsistencyGroupConfigurator();
        }
        if (classId.equals(ClassID.DR_CONSISTENCY_GROUP_PIT)) {
            return new ConsistencyGroupPiTConfigurator();
        }
        if (classId.equals(ClassID.GENERAL_PAIR)) {
            return new PairConfigurator();
        }
        if (classId.equals(ClassID.SYNC_PAIR)) {
            return new SyncPairConfigurator();
        }
        if (classId.equals(ClassID.ASYNC_PAIR)) {
            return new AsyncPairConfigurator();
        }
        if (classId.equals(ClassID.DR_ASYNC_PAIR_PIT)) {
            return new AsyncPairPiTConfigurator();
        }
        if (classId.equals(ClassID.POLICY_START)) {
            return new PolicyConfigurator();
        }
        if (classId.equals(ClassID.POLICY_PARAMS)) {
            return new PolicyParamConfigurator();
        }
        if (classId.equals(ClassID.EXTENDED_PAIR)) {
            return new ExtendedPairConfigurator();
        }
        if (classId.equals(ClassID.SYNC_PAIR)) {
            return new SyncPairControlFunctionsConfigurator();
        }
        if (classId.equals(ClassID.ASYNC_PAIR)) {
            return new AsyncPairControlFunctionsConfigurator();
        }
        if (classId.equals(ClassID.CONSISTENCY_GROUP)) {
            return new CGControlFunctionsConfigurator();
        }
        if (classId.equals(ClassID.ETHERNET_INTERFACE)) {
            return new IfConfigurator();
        }
        throw new UnsupportedClassVersionError("Unknown ClassID " + classId.toString());
    }

    public static ElementConfigurator getElementConfigFromElementData(ConfigElementData element) {
        ClassID classId = element.getClassId();
        return DataMgr.getElementConfigFromClassID(classId);
    }

    private ConfigElementDataList[] splitElementAccordingToAgentIndices(ConfigElementDataList elementList) {
        HashMap<CommKeyClassId, ConfigElementDataList> map = new HashMap<CommKeyClassId, ConfigElementDataList>();
        Iterator iter = elementList.iterator();
        while (iter.hasNext()) {
            ConfigElementData element = (ConfigElementData)iter.next();
            ConfigElementDataList list = this.splitElementAccordingToAgentIndices(element);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ConfigElementData vswitchElement = (ConfigElementData)i.next();
                CommKeyClassId vswitchId = vswitchElement.getVswitchId();
                ConfigElementDataList vswitchList = (ConfigElementDataList)map.get(vswitchId);
                if (vswitchList == null) {
                    vswitchList = new ConfigElementDataList();
                    map.put(vswitchId, vswitchList);
                }
                vswitchList.addElement(vswitchElement);
            }
        }
        return map.values().toArray(new ConfigElementDataList[map.size()]);
    }

    private ConfigElementDataList splitElementAccordingToAgentIndices(ConfigElementData element) {
        ConfigElementDataList elementsList = new ConfigElementDataList();
        Object vswitchDataObject = element.getValue(ParameterCode.VSWITCH_ID);
        if (vswitchDataObject instanceof ConfigElementDataList) {
            return (ConfigElementDataList)vswitchDataObject;
        }
        CommKeyClassId[] vSwitchesData = null;
        if (vswitchDataObject != null) {
            vSwitchesData = vswitchDataObject instanceof CommKeyClassId[] ? (CommKeyClassId[])vswitchDataObject : new CommKeyClassId[]{(CommKeyClassId)vswitchDataObject};
        }
        CommKey[] elementKeys = element.getCommKey();
        CommKey[] snmpKeys = null;
        CommKey[] dbKey = null;
        if (elementKeys != null) {
            snmpKeys = CommKeyUtil.getSnmpCommKeys(element.getCommKey());
            dbKey = CommKeyUtil.geDbCommKeys(element.getCommKey());
        }
        if (vSwitchesData == null || vSwitchesData.length == 0) {
            // empty if block
        }
        if (vSwitchesData != null && vSwitchesData.length > 0) {
            for (int i = 0; i < vSwitchesData.length; ++i) {
                if (vSwitchesData[i] == null && !element.getClassId().equals(ClassID.VSWITCH)) continue;
                ConfigElementData newElement = (ConfigElementData)element.clone();
                if (elementKeys != null) {
                    SnmpCommKey snmpKey = CommKeyUtil.getSpecificSnmpKey(snmpKeys, vSwitchesData[i].getMyFirstSnmpAgentIndex());
                    CommKey[] newElementKeys = CommKeyUtil.createOneCommKeyList(dbKey, (CommKey)snmpKey);
                    newElement.setCommKeys(newElementKeys);
                }
                if (vSwitchesData[i] != null && !this.containsSpecificCommKeys(newElement, vSwitchesData[i])) continue;
                newElement.setValue(ParameterCode.VSWITCH_ID, vSwitchesData[i]);
                elementsList.add(newElement);
                this.splitChildrenCedForIndices(newElement);
            }
            element.setValue(ParameterCode.VSWITCH_ID, elementsList);
            return elementsList;
        }
        if (element.getCommKey() == null) {
            if (element.getClassId().equals(ClassID.VSWITCH)) {
                return null;
            }
            if (element.getClassId().equals(ClassID.SITE)) {
                return null;
            }
            if (element.getClassId().equals(ClassID.CLUSTER)) {
                return null;
            }
            if (element.getClassId().equals(ClassID.ALARM_TYPE)) {
                return null;
            }
            throw new MissingValueException("Missing VSwitch Id and CommKeys for element");
        }
        for (int i = 0; i < snmpKeys.length; ++i) {
            ConfigElementData newElement = (ConfigElementData)element.clone();
            CommKey[] newElementKeys = CommKeyUtil.createOneCommKeyList(dbKey, (CommKey)snmpKeys[i]);
            char snmpAgentIndex = snmpKeys[i].getSnmpAgentIndex();
            CommKeyClassId vswitchData = CommKeyUtil.getVSwitchData(snmpAgentIndex);
            newElement.setValue(ParameterCode.VSWITCH_ID, vswitchData);
            newElement.setCommKeys(newElementKeys);
            if (!this.containsSpecificCommKeys(newElement, vswitchData)) continue;
            elementsList.add(newElement);
            this.splitChildrenCedForIndices(newElement);
        }
        return elementsList;
    }

    private boolean containsSpecificCommKeys(ConfigElementData element, CommKeyClassId vsData) {
        Iterator i = element.getParametersList().keySet().iterator();
        while (i.hasNext()) {
            CommKeyClassId key;
            ParameterCode code = (ParameterCode)i.next();
            Object value = element.getParametersList().get(code);
            if (value instanceof ConfigElementData) {
                if (this.containsSpecificCommKeys((ConfigElementData)value, vsData)) continue;
                return false;
            }
            if (value instanceof ConfigElementDataList && !code.equals(ParameterCode.VSWITCH_ID)) {
                ConfigElementDataList list = (ConfigElementDataList)value;
                int index = list.size();
                while (index-- > 0) {
                    if (this.containsSpecificCommKeys(list.getConfigElementDataAt(index), vsData)) continue;
                    return false;
                }
                continue;
            }
            if (!(value instanceof CommKeyClassId) || (key = (CommKeyClassId)value).getClassID().isPolicyClassId() || CommKeyUtil.getSpecificCommKeyClassId(key, vsData) != null) continue;
            System.out.println("[WARNING!] - In element " + element.getClassId() + " the code " + code + " is not redundant for Switch " + vsData);
            return false;
        }
        return true;
    }

    private void splitChildrenCedForIndices(ConfigElementData element) {
        CommKeyClassId vswitch = element.getVswitchId();
        Iterator codes = element.getParametersList().keySet().iterator();
        while (codes.hasNext()) {
            ParameterCode code = (ParameterCode)codes.next();
            Object value = element.getValue(code);
            if (value instanceof ConfigElementData) {
                ConfigElementDataList list = this.splitElementAccordingToAgentIndices((ConfigElementData)value);
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    ConfigElementData elem = (ConfigElementData)iter.next();
                    if (!elem.getValue(ParameterCode.VSWITCH_ID).equals(vswitch)) continue;
                    elem.setValue(ParameterCode.VSWITCH_ID, vswitch);
                    element.setValue(code, elem);
                }
            }
            if (!(value instanceof ConfigElementDataList)) continue;
            ConfigElementDataList elementList = new ConfigElementDataList();
            Iterator listIter = ((ConfigElementDataList)value).iterator();
            while (listIter.hasNext()) {
                ConfigElementDataList list = this.splitElementAccordingToAgentIndices((ConfigElementData)listIter.next());
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    ConfigElementData elem = (ConfigElementData)iter.next();
                    if (!elem.getValue(ParameterCode.VSWITCH_ID).equals(vswitch)) continue;
                    elementList.addElement(elem);
                }
            }
            element.setValue(code, elementList);
        }
    }

    public void setToFile(String fileName, Serializable obj) throws SrCommunicationException {
        CommMgr.getInstance('z').setToFile(fileName, obj);
    }

    public Object loadFromFile(String fileName) throws SrCommunicationException, InvalidClassException {
        return CommMgr.getInstance('z').loadFromFile(fileName);
    }

    public void newTrap(TrapEvent event) {
        SrTrap trap = event.getTrap();
        trapsHandler.addTrap(trap);
    }

    public void unBlockTraps() {
        trapsHandler.unBlockTraps();
    }

    public void blockTraps() {
        trapsHandler.blockTraps();
    }

    public static String getSnmpManagerIPAddress(CommKey[] vSwitchCommKeys) {
        char snmpAgentIndex = CommKeyUtil.getSnmpAgentIndex(vSwitchCommKeys);
        return CommMgr.getInstance(snmpAgentIndex).getManagerIpAddress(snmpAgentIndex);
    }

    public void startPollingProcess(CommKeyClassId vSwitchToPoll) {
        PollingMgr.getInstance().startPollingProcess(vSwitchToPoll.getMyFirstSnmpAgentIndex(), PollingGroupType.ALL_GROUP_TYPE, 0L);
    }

    public void startPollingProcess(CommKeyClassId vSwitchToPoll, PollingGroupType groupType) {
        PollingMgr.getInstance().startPollingProcess(vSwitchToPoll.getMyFirstSnmpAgentIndex(), groupType, 0L);
    }

    public void stopPollingProcess(CommKeyClassId vSwitchToPoll, PollingGroupType groupType) {
        PollingMgr.getInstance().stopPollingProcess(vSwitchToPoll.getMyFirstSnmpAgentIndex(), groupType, true);
    }

    public void startPollingProcess(CommKeyClassId[] vSwitchToPoll) {
        for (int i = 0; i < vSwitchToPoll.length; ++i) {
            this.startPollingProcess(vSwitchToPoll[i]);
        }
    }

    public static Vector getElementsToRemoveByCheckList(Vector commKeysElements, CheckListConfigElementData checkListelement) {
        Vector checkList = checkListelement.getCheckList();
        Vector superCheckList = checkListelement.getSuperTblCheckList();
        Vector<CommKeyClassId> commKeysToRemove = new Vector<CommKeyClassId>();
        if (superCheckList != null) {
            for (int index1 = 0; index1 < superCheckList.size(); ++index1) {
                CommKeyClassId currSuperCheckListCommKey = (CommKeyClassId)superCheckList.elementAt(index1);
                for (int index2 = 0; index2 < commKeysElements.size(); ++index2) {
                    CommKeyClassId currExistedCommKey = (CommKeyClassId)commKeysElements.elementAt(index2);
                    if (!currExistedCommKey.startsWith(currSuperCheckListCommKey) || checkList.contains(currExistedCommKey)) continue;
                    commKeysToRemove.add(currExistedCommKey);
                }
            }
        } else {
            for (int index = 0; index < commKeysElements.size(); ++index) {
                CommKeyClassId currExistedCommKey = (CommKeyClassId)commKeysElements.elementAt(index);
                if (checkList.size() != 0 && checkList.contains(currExistedCommKey)) continue;
                commKeysToRemove.add(currExistedCommKey);
            }
        }
        return commKeysToRemove;
    }

    public void waitForDataUpdatesInVSwitches(long millisec) {
        try {
            Thread.sleep(millisec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void rediscoverISCSISessionsAndConnections(CommKeyClassId vswitchToReadFrom) {
        IScsiSessionConfigurator sessionCfg = new IScsiSessionConfigurator();
        try {
            sessionCfg.refreshSessions(vswitchToReadFrom.getMyFirstSnmpAgentIndex());
        }
        catch (SrCommunicationException ce) {
            LogMgr.getServerLog().error(ce.getMessage());
        }
    }

    public void refreshLocalSCSIDevices(CommKeyClassId[] vSwitchesToReadFrom) {
        for (int index = 0; index < vSwitchesToReadFrom.length; ++index) {
            this.refreshLocalSCSIDevices(vSwitchesToReadFrom[index]);
        }
    }

    public void refreshLocalSCSIDevices(CommKeyClassId vswitchToReadFrom) {
        ScsiDeviceConfigurator scsiDeviceCfg = new ScsiDeviceConfigurator();
        try {
            for (int index = 0; index < 5; ++index) {
                ConfigElementDataList devices = scsiDeviceCfg.refreshTable(vswitchToReadFrom.getMyFirstSnmpAgentIndex(), null, null);
                SrEventHandler.getEventMgr().sendRefreshElementEvent(devices);
            }
        }
        catch (SrCommunicationException ce) {
            LogMgr.getServerLog().error(ce.getMessage());
        }
    }

    public void attachIdentityToTargetACL(ConfigElementData identityElement, CommKeyClassId targetId) {
        TargetAuthorizationConfigurator aclEntriesConfigurator = new TargetAuthorizationConfigurator();
        ConfigElementDataList identityList = this.splitElementAccordingToAgentIndices(identityElement);
        int i = identityList.size();
        while (i-- > 0) {
            aclEntriesConfigurator.attachIdentityToTargetACL(identityList.getConfigElementDataAt(i), targetId);
        }
    }

    public synchronized void postPairCreationRefreshOperation(char snmpAgent) throws SrCommunicationException {
        this.waitForDataUpdatesInVSwitches(3000L);
        ScsiDeviceConfigurator scsiDeviceCfg = new ScsiDeviceConfigurator();
        scsiDeviceCfg.refreshTableForPolling(snmpAgent);
        this.rediscoverISCSISessionsAndConnections(CommKeyUtil.getVSwitchData(snmpAgent));
        JournalVolumeConfigurator journalVolumesConfigurator = new JournalVolumeConfigurator();
        journalVolumesConfigurator.refreshJournalVolumesTable(snmpAgent);
    }

    public void internalCreate(ConfigElementData element) {
        ConfigElementDataList elementsAccordingToAgents = this.splitElementAccordingToAgentIndices(element);
        for (int i = 0; i < elementsAccordingToAgents.size(); ++i) {
            ConfigElementData elem = (ConfigElementData)elementsAccordingToAgents.get(i);
            ElementConfigurator conf = DataMgr.getElementConfigFromClassID(elem.getClassId());
            try {
                conf.internalCreate(elem);
                boolean isElementSentByEvent = conf.readAfterCreate(elem);
                if (!isElementSentByEvent) {
                    SrEventHandler.getEventMgr().sendAddElementEvent(elem);
                }
                conf.postSendCreateEvent(elem);
                continue;
            }
            catch (SrCommunicationException e) {
                LogMgr.getServerLog().error(e);
                continue;
            }
            catch (SrElementOperationException e) {
                LogMgr.getServerLog().error(e);
            }
        }
    }
}

