/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyFetcher;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrType;
import java.util.HashMap;
import java.util.Iterator;

public class ConfigElementData {
    private CommKey[] myKeys = null;
    private ClassID myClassId = null;
    private CommKeyClassId operationInvoker = null;
    private HashMap parametersList = new HashMap(20);

    public ConfigElementData(CommKey key, ClassID classId) {
        this.myKeys = new CommKey[1];
        this.myKeys[0] = key;
        this.myClassId = classId;
        this.checkIfCommKeyIsNull();
    }

    public ConfigElementData(CommKeyClassId data) {
        this(data.getCommKeys(), data.getClassID());
    }

    public ConfigElementData(ConfigElementData element) {
        this(element.getCommKeyClassId());
        this.addParameter(element.getParametersList());
    }

    public ConfigElementData(CommKey[] key, ClassID classId) {
        if (key != null) {
            this.myKeys = new CommKey[key.length];
            System.arraycopy(key, 0, this.myKeys, 0, key.length);
            this.checkIfCommKeyIsNull();
        }
        this.myClassId = classId;
    }

    public ConfigElementData(CommKey key, ClassID classId, HashMap parameters) {
        this(key, classId);
        this.parametersList = parameters;
    }

    public ConfigElementData(CommKey[] key, ClassID classId, HashMap parameters) {
        this(key, classId);
        this.parametersList = parameters;
    }

    public ConfigElementData(CommKey[] key, ClassID classId, HashMap parameters, CommKeyClassId operInvoker) {
        this(key, classId);
        this.parametersList = parameters;
        this.operationInvoker = operInvoker;
    }

    public ConfigElementData(ClassID classId) {
        this.myClassId = classId;
    }

    public void setOperationInvoker(CommKeyClassId invoker) {
        this.operationInvoker = invoker;
    }

    public CommKeyClassId getOperationInvoker() {
        return this.operationInvoker;
    }

    public void setCommKey(CommKey keyIn) {
        CommKey[] tmp = new CommKey[]{keyIn};
        this.setCommKeys(tmp);
    }

    public void setCommKeys(CommKey[] keysIn) {
        this.myKeys = keysIn;
    }

    public void setCommKeyClassId(CommKeyClassId data) {
        this.myKeys = data.getCommKeys();
        this.myClassId = data.getClassID();
        this.checkIfCommKeyIsNull();
    }

    public CommKey[] getCommKey() {
        return this.myKeys;
    }

    public void setClassId(ClassID classIdIn) {
        this.myClassId = classIdIn;
    }

    public ClassID getClassId() {
        return this.myClassId;
    }

    public boolean compareCommKey(Object obj) {
        if (obj instanceof ConfigElementData) {
            CommKey[] objKeys = ((ConfigElementData)obj).getCommKey();
            if (objKeys == this.myKeys) {
                return true;
            }
            if (objKeys == null || this.myKeys == null) {
                return false;
            }
            if (this.myKeys.length != objKeys.length) {
                return false;
            }
            for (int i = 0; i < this.myKeys.length; ++i) {
                if (this.myKeys[i].equals(objKeys[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        boolean reply;
        if (obj instanceof ConfigElementData && (reply = this.compareCommKey(obj))) {
            return this.myClassId.equals(((ConfigElementData)obj).getClassId());
        }
        return false;
    }

    public SnmpCommKey getSnmpKey() {
        if (this.myKeys == null) {
            return null;
        }
        for (int i = 0; i < this.myKeys.length; ++i) {
            if (((CommKeyFetcher)((Object)this.myKeys[i])).getSnmpCommKey() == null) continue;
            return (SnmpCommKey)this.myKeys[i].clone();
        }
        return null;
    }

    public DataBaseCommKey getDbKey() {
        for (int i = 0; i < this.myKeys.length; ++i) {
            if (((CommKeyFetcher)((Object)this.myKeys[i])).getDBCommKey() == null) continue;
            return (DataBaseCommKey)this.myKeys[i].clone();
        }
        return null;
    }

    public void setSnmpAgentIndexToAllCommKeys(char snmpAgentIndex) {
        for (int i = 0; i < this.myKeys.length; ++i) {
            if (((CommKeyFetcher)((Object)this.myKeys[i])).getSnmpCommKey() == null) continue;
            ((SnmpCommKey)this.myKeys[i]).setSnmpAgentIndex(snmpAgentIndex);
        }
    }

    public char getMyFirstSnmpAgentIndex() {
        if (CommKeyUtil.getSnmpCommKeys(this.myKeys).length > 1) {
            LogMgr.getServerLog().error("SHOULDN'T BE HERE: ConfigElementData::getMyFirstSnmpAgentIndex()");
        }
        return CommKeyUtil.getSnmpCommKey(this.myKeys).getSnmpAgentIndex();
    }

    public char getSnmpAgentFromParameter() {
        try {
            CommKeyClassId[] vSwitch = (CommKeyClassId[])this.getValue(ParameterCode.VSWITCH_ID);
            return CommKeyUtil.getSnmpCommKey(vSwitch[0]).getSnmpAgentIndex();
        }
        catch (ClassCastException e) {
            CommKeyClassId vSwitch = (CommKeyClassId)this.getValue(ParameterCode.VSWITCH_ID);
            return CommKeyUtil.getSnmpCommKey(vSwitch).getSnmpAgentIndex();
        }
    }

    public Object clone() {
        ConfigElementData newElement = new ConfigElementData(this.getCommKey(), this.getClassId(), (HashMap)this.getParametersList().clone(), this.operationInvoker);
        return newElement;
    }

    public void addParameter(Parameter param) {
        ParameterCode code = param.getCode();
        Object value = param.getValue();
        this.parametersList.put(code, value);
    }

    public void addParameter(Parameter[] params) {
        for (int i = params.length - 1; i >= 0; --i) {
            this.addParameter(params[i]);
        }
    }

    public void addParameter(HashMap params) {
        Iterator keys = params.keySet().iterator();
        while (keys.hasNext()) {
            ParameterCode key = (ParameterCode)keys.next();
            Object value = params.get(key);
            if (value == null) {
                if (this.parametersList.containsKey(key)) continue;
                this.parametersList.put(key, value);
                continue;
            }
            this.parametersList.put(key, value);
        }
    }

    public HashMap getParametersList() {
        return this.parametersList;
    }

    public Object getValue(ParameterCode code) {
        return this.parametersList.get(code);
    }

    public void setValue(ParameterCode code, SrType value) {
        this.parametersList.put(code, value);
    }

    public void setValue(ParameterCode code, ConfigElementData value) {
        this.parametersList.put(code, value);
    }

    public void setValue(ParameterCode code, ConfigElementDataList value) {
        this.parametersList.put(code, value);
    }

    public void setValues(ParameterCode code, SrType[] values) {
        this.parametersList.put(code, values);
    }

    public Object removeParameter(ParameterCode code) {
        return this.parametersList.remove(code);
    }

    public void removeAll() {
        this.parametersList.clear();
    }

    public boolean containParameter(ParameterCode code) {
        return this.parametersList.containsKey(code);
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer("Element: ");
        if (this.getCommKey() != null) {
            retVal.append(this.getCommKeyClassId());
        } else {
            retVal.append(this.getClassId().toString());
        }
        retVal.append(", Parameters: ");
        retVal.append(this.parametersList);
        return retVal.toString();
    }

    public CommKeyClassId getCommKeyClassId() {
        return new CommKeyClassId(this.getCommKey(), this.getClassId());
    }

    private void checkIfCommKeyIsNull() {
        for (int i = 0; i < this.myKeys.length; ++i) {
            if (this.myKeys[i] != null) continue;
            throw new NullPointerException("CommKey is null");
        }
    }

    public void addParameterToElement(ConfigElementData src, ParameterCode code) {
        this.addParameterToElement(src, code, code);
    }

    public void addParameterToElement(ConfigElementData src, ParameterCode srcCode, ParameterCode destCode) {
        Object value = src.getValue(srcCode);
        if (src.getValue(srcCode) instanceof ConfigElementData) {
            this.setValue(destCode, (ConfigElementData)value);
            return;
        }
        if (src.getValue(srcCode) instanceof ConfigElementDataList) {
            this.setValue(destCode, (ConfigElementDataList)value);
            return;
        }
        if (value != null) {
            this.setValue(destCode, (SrType)value);
        }
    }

    public boolean isCreated() {
        return this.getCommKey() != null;
    }

    public ConfigElementData getFirstChild() {
        Iterator iter = this.parametersList.keySet().iterator();
        while (iter.hasNext()) {
            ParameterCode code = (ParameterCode)iter.next();
            if (this.parametersList.get(code) instanceof ConfigElementData) {
                return (ConfigElementData)this.parametersList.get(code);
            }
            if (!(this.parametersList.get(code) instanceof ConfigElementDataList)) continue;
            return ((ConfigElementDataList)this.parametersList.get(code)).getConfigElementDataAt(0);
        }
        return null;
    }

    public CommKeyClassId getVswitchId() {
        return (CommKeyClassId)this.getParametersList().get(ParameterCode.VSWITCH_ID);
    }

    public HashMap getAllValues() {
        return this.parametersList;
    }
}

