/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommVarBindKey;
import com.sanrad.nms.server.comm.database.DBItem;
import com.sanrad.nms.server.comm.database.DBKey;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.util.ParameterCode;
import java.util.HashMap;

public class CodeToKeyMap {
    private static CodeToKeyMap theInstance = null;
    private static HashMap paramCodeToKeyMap = new HashMap(250);
    private static HashMap snmpKeyToParamCodeMap = new HashMap(250);

    private CodeToKeyMap() {
        this.initParamCodeToKeyMap();
        this.initSnmpKeyToParamCodeMap();
    }

    public static CodeToKeyMap getInstance() {
        if (theInstance == null) {
            theInstance = new CodeToKeyMap();
        }
        return theInstance;
    }

    public ParameterCode getParamCodeBySnmpKey(String key) {
        return (ParameterCode)snmpKeyToParamCodeMap.get(key);
    }

    public ParameterCode getParamCodeBySnmpKey(CommVarBindKey key) {
        return (ParameterCode)snmpKeyToParamCodeMap.get(key.getKey());
    }

    public ParameterCode getParamCodeBySnmpKey(MibItem key) {
        return (ParameterCode)snmpKeyToParamCodeMap.get(key.toString());
    }

    public ParameterCode getParamCodeByDbKey(String key) {
        return (ParameterCode)snmpKeyToParamCodeMap.get(key);
    }

    public CommVarBindKey[] getKeyByParamCode(ParameterCode code) {
        return (CommVarBindKey[])paramCodeToKeyMap.get(code);
    }

    public CommVarBindKey getVarBindKeyBySnmpKey(MibItem mibItemKey) {
        ParameterCode parameterCode = this.getParamCodeBySnmpKey(mibItemKey);
        CommVarBindKey[] varBindKeys = this.getKeyByParamCode(parameterCode);
        return varBindKeys[0];
    }

    private CommVarBindKey[] makeKeyArrayFromMibItem(MibItem mibItem) {
        CommVarBindKey[] keys = new CommVarBindKey[1];
        SrOid oid = new SrOid(mibItem.toString(), "0");
        keys[0] = oid;
        return keys;
    }

    private CommVarBindKey[] makeKeyArrayFromDBItem(DBItem dbItem) {
        CommVarBindKey[] keys = new CommVarBindKey[1];
        DBKey db = new DBKey(dbItem.toString(), "0");
        keys[0] = db;
        return keys;
    }

    private void initParamCodeToKeyMap() {
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_SYS_OID, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_SYS_OID));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_MANUAL_DISCOVERY, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_MANUAL_DISCOVERY));
        paramCodeToKeyMap.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, this.makeKeyArrayFromMibItem(MibItem.SUB_DIRECT_ACCESS_DEVICE_LENGTH));
        paramCodeToKeyMap.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, this.makeKeyArrayFromMibItem(MibItem.SUB_DIRECT_ACCESS_DEVICE_INFO));
        paramCodeToKeyMap.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, this.makeKeyArrayFromMibItem(MibItem.SUB_DIRECT_ACCESS_DEVICE_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS, this.makeKeyArrayFromMibItem(MibItem.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS));
        paramCodeToKeyMap.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LAST_UPDATE, this.makeKeyArrayFromMibItem(MibItem.SUB_DIRECT_ACCESS_DEVICE_LAST_UPDATE));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_VENDOR_NAME));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_OPERATIONAL_STATUS, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_OPERATIONAL_STATUS));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_LUN, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_LUN));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_INFO, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_INFO));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_ENTITY_NAME));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_ALIAS, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_TRANSPORT_TYPE));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_TYPE, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_TYPE));
        paramCodeToKeyMap.put(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, this.makeKeyArrayFromMibItem(MibItem.DIRECT_ACCESS_DEVICE_BLOCK_SIZE));
        paramCodeToKeyMap.put(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, this.makeKeyArrayFromMibItem(MibItem.DIRECT_ACCESS_DEVICE_BLOCK_NUM));
        paramCodeToKeyMap.put(ParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE, this.makeKeyArrayFromMibItem(MibItem.DIRECT_ACCESS_DEVICE_ALLOCABLE));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_COM_ADMIN_STATUS, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_COM_ADMIN_STATUS));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_COM_DURATION, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_COM_DURATION));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_COM_OPER_STATUS, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_COM_OPER_STATUS));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_SERIAL_NUMBER));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_PRODUCT_ID, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_PRODUCT_ID));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_REVISION_LEVEL, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_REVISION_LEVEL));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_SCSI_VER, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_SCSI_VER));
        paramCodeToKeyMap.put(ParameterCode.PHYSICAL_STORAGE_LAST_UPDATE, this.makeKeyArrayFromMibItem(MibItem.PHYSICAL_STORAGE_LAST_UPDATE));
        paramCodeToKeyMap.put(ParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE, this.makeKeyArrayFromMibItem(MibItem.DIRECT_ACCESS_DEVICE_WCE_STATE));
        paramCodeToKeyMap.put(ParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE_ENABLE, this.makeKeyArrayFromMibItem(MibItem.DIRECT_ACCESS_DEVICE_WCE_STATE_ENABLE));
        paramCodeToKeyMap.put(ParameterCode.DIRECT_ACCESS_DEVICE_WP, this.makeKeyArrayFromMibItem(MibItem.DIRECT_ACCESS_DEVICE_WP));
        paramCodeToKeyMap.put(ParameterCode.LU_ID_CODE_SET, this.makeKeyArrayFromMibItem(MibItem.LU_ID_CODE_SET));
        paramCodeToKeyMap.put(ParameterCode.LU_ID_ASSOC, this.makeKeyArrayFromMibItem(MibItem.LU_ID_ASSOC));
        paramCodeToKeyMap.put(ParameterCode.LU_ID_TYPE, this.makeKeyArrayFromMibItem(MibItem.LU_ID_TYPE));
        paramCodeToKeyMap.put(ParameterCode.LU_ID_VALUE, this.makeKeyArrayFromMibItem(MibItem.LU_ID_VALUE));
        paramCodeToKeyMap.put(ParameterCode.DISCOVERED_TARGET_NAME, this.makeKeyArrayFromMibItem(MibItem.DISC_TARGET_NAME));
        paramCodeToKeyMap.put(ParameterCode.VOLUME_ALIAS, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.VIRTUAL_VOLUME_BLOCK_SIZE, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_BLOCK_SIZE));
        paramCodeToKeyMap.put(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS));
        paramCodeToKeyMap.put(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS));
        paramCodeToKeyMap.put(ParameterCode.VOLUME_STATE, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_STATE));
        paramCodeToKeyMap.put(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_STRIPE_SIZE));
        paramCodeToKeyMap.put(ParameterCode.VOLUME_POSITION, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_CHILDREN_POSITION));
        paramCodeToKeyMap.put(ParameterCode.VOLUME_LAST_UPDATE, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_LAST_UPDATE));
        paramCodeToKeyMap.put(ParameterCode.VIRTUAL_VOLUME_LU_ID, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_LU_ID));
        paramCodeToKeyMap.put(ParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, this.makeKeyArrayFromMibItem(MibItem.SNAPSHOT_VOLUME_DATE_AND_TIME));
        paramCodeToKeyMap.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD, this.makeKeyArrayFromMibItem(MibItem.SNAPSHOT_VOLUME_PERCENT_UTIL));
        paramCodeToKeyMap.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, this.makeKeyArrayFromMibItem(MibItem.SNAPSHOT_VOLUME_PERCENT_THRESH));
        paramCodeToKeyMap.put(ParameterCode.SNAPSHOT_VOLUME_SOURCE, this.makeKeyArrayFromMibItem(MibItem.SNAPSHOT_VOLUME_SOURCE));
        paramCodeToKeyMap.put(ParameterCode.SNAPSHOT_ACTIVATE, this.makeKeyArrayFromMibItem(MibItem.SNAPSHOT_ACTIVATE));
        paramCodeToKeyMap.put(ParameterCode.JOURNAL_VOLUME_DATE_AND_TIME, this.makeKeyArrayFromMibItem(MibItem.JOURNAL_VOLUME_DATE_AND_TIME));
        paramCodeToKeyMap.put(ParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION, this.makeKeyArrayFromMibItem(MibItem.JOURNAL_VOLUME_PRECENT_UTILIZATION));
        paramCodeToKeyMap.put(ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, this.makeKeyArrayFromMibItem(MibItem.JOURNAL_VOLUME_PRECENT_THRESH));
        paramCodeToKeyMap.put(ParameterCode.JOURNAL_VOLUME_ACTIVITY, this.makeKeyArrayFromMibItem(MibItem.JOURNAL_VOLUME_ACTIVITY));
        paramCodeToKeyMap.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_OPER_STATUS, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_OPER_STATUS));
        paramCodeToKeyMap.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_ADMIN_STATUS, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_ADMIN_STATUS));
        paramCodeToKeyMap.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_PERCENTAGE_COPIED, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_MIRROR_PERCENTAGE_SYNC_COPIED));
        paramCodeToKeyMap.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_SRC, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_SRC_ID));
        paramCodeToKeyMap.put(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_SRC_ALIAS, this.makeKeyArrayFromMibItem(MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_SRC_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, this.makeKeyArrayFromMibItem(MibItem.VOLUME_OPERATION_ADMIN_STATUS));
        paramCodeToKeyMap.put(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED, this.makeKeyArrayFromMibItem(MibItem.VOLUME_OPERATION_PERCENTAGE_COPIED));
        paramCodeToKeyMap.put(ParameterCode.VOLUME_OPERATION_SRC, this.makeKeyArrayFromMibItem(MibItem.VOLUME_OPERATION_FROM));
        paramCodeToKeyMap.put(ParameterCode.VOLUME_OPERATION_DST, this.makeKeyArrayFromMibItem(MibItem.VOLUME_OPERATION_TO));
        paramCodeToKeyMap.put(ParameterCode.VOLUME_OPERATION_OPER_STATUS, this.makeKeyArrayFromMibItem(MibItem.VOLUME_OPERATION_OPER_STATUS));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TARGET_NUM_OF_LUS, this.makeKeyArrayFromMibItem(MibItem.SCSI_TARGET_DEVICE_NUMBER_OF_LU));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TARGET_STATUS, this.makeKeyArrayFromMibItem(MibItem.SCSI_TARGET_DEVICE_STATUS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_TARGET_ALIAS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_TARGET_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON, this.makeKeyArrayFromMibItem(MibItem.ISCSI_TARGET_DEFAULT_EXPOSED_ON));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_TARGET_NAME, this.makeKeyArrayFromMibItem(MibItem.ISCSI_TARGET_NAME));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_TARGET_TRANSPORT_TYPE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_TARGET_TRANSPORT_TYPE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME, this.makeKeyArrayFromMibItem(MibItem.ISCSI_TARGET_LAST_FAILURE_TIME));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_TARGET_LAST_FAILURE_TYPE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME, this.makeKeyArrayFromMibItem(MibItem.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP, this.makeKeyArrayFromMibItem(MibItem.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP));
        paramCodeToKeyMap.put(ParameterCode.LU_LUN_NUMBER, this.makeKeyArrayFromMibItem(MibItem.LUN_LU_NUMBER));
        paramCodeToKeyMap.put(ParameterCode.LU_OPER_STATUS, this.makeKeyArrayFromMibItem(MibItem.LUN_OPER_STATUS));
        paramCodeToKeyMap.put(ParameterCode.LU_SERIAL_NUMBER, this.makeKeyArrayFromMibItem(MibItem.LUN_SERIAL_NUMBER));
        paramCodeToKeyMap.put(ParameterCode.LU_CREATION_DATE, this.makeKeyArrayFromMibItem(MibItem.LUN_CREATION_DATE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON, this.makeKeyArrayFromMibItem(MibItem.ISCSI_TARGET_DEFAULT_EXPOSED_ON));
        paramCodeToKeyMap.put(ParameterCode.LU_LAST_UPDATE, this.makeKeyArrayFromMibItem(MibItem.LUN_LAST_UPDATE));
        paramCodeToKeyMap.put(ParameterCode.SCSI_LUN_LU_NUMBER, this.makeKeyArrayFromMibItem(MibItem.SCSI_LUN_LU_NUMBER));
        paramCodeToKeyMap.put(ParameterCode.SCSI_LUN_REVISION_ID, this.makeKeyArrayFromMibItem(MibItem.SCSI_LUN_REVISION_ID));
        paramCodeToKeyMap.put(ParameterCode.SCSI_LUN_STATUS, this.makeKeyArrayFromMibItem(MibItem.SCSI_LUN_STATUS));
        paramCodeToKeyMap.put(ParameterCode.SCSI_LUN_STATE, this.makeKeyArrayFromMibItem(MibItem.SCSI_LUN_STATE));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TARGET_PORT_NAME, this.makeKeyArrayFromMibItem(MibItem.SCSI_TARGET_PORT_NAME));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TARGET_PORT_IN_COMMANDS, this.makeKeyArrayFromMibItem(MibItem.SCSI_TARGET_PORT_IN_COMMANDS));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TARGET_PORT_READ_MB, this.makeKeyArrayFromMibItem(MibItem.SCSI_TARGET_PORT_READ_MB));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TARGET_PORT_WRITTEN_MB, this.makeKeyArrayFromMibItem(MibItem.SCSI_TARGET_PORT_WRITTEN_MB));
        paramCodeToKeyMap.put(ParameterCode.SCSI_DEVICE_ROLE, this.makeKeyArrayFromMibItem(MibItem.SCSI_DEVICE_ROLE));
        paramCodeToKeyMap.put(ParameterCode.SCSI_DEVICE_NUM_OF_PORTS, this.makeKeyArrayFromMibItem(MibItem.SCSI_DEVICE_PORT_NUMBER));
        paramCodeToKeyMap.put(ParameterCode.SCSI_PORT_ROLE, this.makeKeyArrayFromMibItem(MibItem.SCSI_PORT_ROLE));
        paramCodeToKeyMap.put(ParameterCode.SCSI_DEVICE_ALIAS, this.makeKeyArrayFromMibItem(MibItem.SCSI_DEVICE_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TARGET_PORT_NAME, this.makeKeyArrayFromMibItem(MibItem.SCSI_TARGET_PORT_NAME));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TARGET_PORT_READ_MB, this.makeKeyArrayFromMibItem(MibItem.SCSI_TARGET_PORT_READ_MB));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TARGET_PORT_WRITTEN_MB, this.makeKeyArrayFromMibItem(MibItem.SCSI_TARGET_PORT_WRITTEN_MB));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TARGET_PORT_IN_COMMANDS, this.makeKeyArrayFromMibItem(MibItem.SCSI_TARGET_PORT_IN_COMMANDS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INITAITOR_NUM_OF_LOGIN_FAILURES, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INITAITOR_NUM_OF_LOGIN_FAILURES));
        paramCodeToKeyMap.put(ParameterCode.SCSI_INITIATOR_TARGET_ACCESS_MODE, this.makeKeyArrayFromMibItem(MibItem.SCSI_INITIATOR_DEVICE_TARGET_ACCESS_MODE));
        paramCodeToKeyMap.put(ParameterCode.SCSI_INITIATOR_PORT_NAME, this.makeKeyArrayFromMibItem(MibItem.SCSI_INITIATOR_PORT_NAME));
        paramCodeToKeyMap.put(ParameterCode.SCSI_INITIATOR_PORT_READ_MB, this.makeKeyArrayFromMibItem(MibItem.SCSI_INITIATOR_PORT_READ_MEGA_BYTES));
        paramCodeToKeyMap.put(ParameterCode.SCSI_INITIATOR_PORT_WRITTEN_MB, this.makeKeyArrayFromMibItem(MibItem.SCSI_INITIATOR_PORT_WRITTEN_MEGA_BYTES));
        paramCodeToKeyMap.put(ParameterCode.SCSI_INITIATOR_PORT_OUT_COMMANDS, this.makeKeyArrayFromMibItem(MibItem.SCSI_INITIATOR_PORT_OUT_COMMANDS));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TRANSPORT_TYPE, this.makeKeyArrayFromMibItem(MibItem.SCSI_TRANSPORT_TYPE));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TRANSPORT_POINTER, this.makeKeyArrayFromMibItem(MibItem.SCSI_TRANSPORT_POINTER));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TRANSPORT_DEVICE_NAME, this.makeKeyArrayFromMibItem(MibItem.SCSI_TRANSPORT_DEVICE_NAME));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INITAITOR_LAST_TARGET_FAILURE_NAME, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INITIATOR_LAST_TARGET_FAILURE_NAME));
        paramCodeToKeyMap.put(ParameterCode.SCSI_REMOTE_TARGET_LAST_CHANGE, this.makeKeyArrayFromMibItem(MibItem.SCSI_REMOTE_TARGET_LAST_CHANGE));
        paramCodeToKeyMap.put(ParameterCode.DISCOVERED_TARGET_NAME, this.makeKeyArrayFromMibItem(MibItem.DISC_TARGET_NAME));
        paramCodeToKeyMap.put(ParameterCode.SCSI_REMOTE_TARGET_ALIAS, this.makeKeyArrayFromMibItem(MibItem.SCSI_REMOTE_TARGET_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED, this.makeKeyArrayFromMibItem(MibItem.SCSI_DISCOVER_TARGET_CONFIGURED));
        paramCodeToKeyMap.put(ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED, this.makeKeyArrayFromMibItem(MibItem.SCSI_DISCOVER_TARGET_DISCOVERED));
        paramCodeToKeyMap.put(ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS, this.makeKeyArrayFromMibItem(MibItem.SCSI_REMOTE_TARGET_LOGIN_STATUS));
        paramCodeToKeyMap.put(ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE, this.makeKeyArrayFromMibItem(MibItem.SCSI_REMOTE_TARGET_FAILURE_TYPE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_REMOTE_TARGET_NUM_OF_PORTALS, this.makeKeyArrayFromMibItem(MibItem.SCSI_REMOTE_TARGET_NUM_OF_PORTAL));
        paramCodeToKeyMap.put(ParameterCode.IDENTITY_ID, this.makeKeyArrayFromMibItem(MibItem.SCSI_REMOTE_TARGET_IDENTITY));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP, this.makeKeyArrayFromMibItem(MibItem.SCSI_REMOTE_TARGET_PORTAL_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT, this.makeKeyArrayFromMibItem(MibItem.SCSI_REMOTE_TARGET_PORTAL_PORT));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG, this.makeKeyArrayFromMibItem(MibItem.SCSI_REMOTE_TARGET_PG_TAG));
        paramCodeToKeyMap.put(ParameterCode.REMOTE_PORTAL_DISC_ACTIVATE, this.makeKeyArrayFromMibItem(MibItem.REMOTE_PORTAL_DISC_ACTIVATE));
        paramCodeToKeyMap.put(ParameterCode.REMOTE_PORTAL_DISC_PERIOD, this.makeKeyArrayFromMibItem(MibItem.REMOTE_PORTAL_DISC_PERIOD));
        paramCodeToKeyMap.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, this.makeKeyArrayFromMibItem(MibItem.REMOTE_PORTAL_DISC_LAST_FAILURE));
        paramCodeToKeyMap.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME, this.makeKeyArrayFromMibItem(MibItem.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME));
        paramCodeToKeyMap.put(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY, this.makeKeyArrayFromMibItem(MibItem.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY));
        paramCodeToKeyMap.put(ParameterCode.REMOTE_PORTAL_DISC_STATE, this.makeKeyArrayFromMibItem(MibItem.REMOTE_PORTAL_DISC_STATE));
        paramCodeToKeyMap.put(ParameterCode.REMOTE_PORTAL_DISC_ROW_STATUS, this.makeKeyArrayFromMibItem(MibItem.REMOTE_PORTAL_DISC_ROW_STATUS));
        paramCodeToKeyMap.put(ParameterCode.REMOTE_PORTAL_DISC_LAST_CHANGED, this.makeKeyArrayFromMibItem(MibItem.REMOTE_PORTAL_DISC_LAST_CHANGED));
        paramCodeToKeyMap.put(ParameterCode.IDENTITY_ALIAS, this.makeKeyArrayFromMibItem(MibItem.IDENTITY_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.IDENTITY_DESCRIPTION, this.makeKeyArrayFromMibItem(MibItem.IDENTITY_DESCRIPTION));
        paramCodeToKeyMap.put(ParameterCode.IDENTITY_LAST_UPDATE, this.makeKeyArrayFromMibItem(MibItem.IDENTITY_ENTRY_LAST_UPDATED));
        paramCodeToKeyMap.put(ParameterCode.IDENTITY_PURPOSE, this.makeKeyArrayFromMibItem(MibItem.IDENTITY_PURPOSE));
        paramCodeToKeyMap.put(ParameterCode.IDENTITY_NAME_VALUE, this.makeKeyArrayFromMibItem(MibItem.IDENTITY_NAME_VALUE));
        paramCodeToKeyMap.put(ParameterCode.CREDENTIALS_AUTH_METHOD, this.makeKeyArrayFromMibItem(MibItem.CREDENTIALS_AUTH_METHOD));
        paramCodeToKeyMap.put(ParameterCode.CHAP_CREDENTIALS_USER_NAME, this.makeKeyArrayFromMibItem(MibItem.CHAP_CREDENTIALS_USER_NAME));
        paramCodeToKeyMap.put(ParameterCode.SRP_CREDENTIALS_USER_NAME, this.makeKeyArrayFromMibItem(MibItem.SRP_CREDENTIALS_USER_NAME));
        paramCodeToKeyMap.put(ParameterCode.SRP_CREDENTIALS_PASSWORD, this.makeKeyArrayFromMibItem(MibItem.SRP_CREDENTIALS_PASSWORD));
        paramCodeToKeyMap.put(ParameterCode.CHAP_CREDENTIALS_PASSWORD, this.makeKeyArrayFromMibItem(MibItem.CHAP_CREDENTIALS_PASSWORD));
        paramCodeToKeyMap.put(ParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, this.makeKeyArrayFromMibItem(MibItem.CHAP_CREDENTIALS_RADIUS_ENABLED));
        paramCodeToKeyMap.put(ParameterCode.RADIUS_SERVER_IP_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.RADIUS_SERVER_IP_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.RADIUS_SERVER_PORT, this.makeKeyArrayFromMibItem(MibItem.RADIUS_SERVER_PORT));
        paramCodeToKeyMap.put(ParameterCode.RADIUS_SERVER_KEY, this.makeKeyArrayFromMibItem(MibItem.RADIUS_SERVER_KEY));
        paramCodeToKeyMap.put(ParameterCode.ISNS_SERVER_IP_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.ISNS_SERVER_IP_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.ACL_ENTRY_ACCESS, this.makeKeyArrayFromMibItem(MibItem.ACL_ENTRY_ACCESS));
        paramCodeToKeyMap.put(ParameterCode.ACL_ENTRY_IDENTITY, this.makeKeyArrayFromMibItem(MibItem.ACL_ENTRY_IDENTITY));
        paramCodeToKeyMap.put(ParameterCode.ACL_ENTRY_POSITION, this.makeKeyArrayFromMibItem(MibItem.ACL_ENTRY_POSITION));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_RESET, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_RESET));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_CONTACT, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_CONTACT));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_DATE_AND_TIME, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_DATE_AND_TIME));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_DESCRIPTION, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_DESCRIPTION));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_LOCATION, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_LOCATION));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_NAME, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_NAME));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_TELNET_PORT, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_TELNET_PORT));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_TADDRESS, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_MGM_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_SWITCH_ID, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_SWITCH_ID));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_REPORT_LUN_DISCOVERY, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_REPORT_LUN_DISCOVERY));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_STATUS, this.makeKeyArrayFromMibItem(MibItem.VSWITCH_STATUS));
        paramCodeToKeyMap.put(ParameterCode.MAX_NUM_OF_POWER_SUPPLIERS, this.makeKeyArrayFromMibItem(MibItem.HW_PS_MAX_NUMBER));
        paramCodeToKeyMap.put(ParameterCode.CURR_NUM_OF_WORKING_POWER_SUPPLIERS, this.makeKeyArrayFromMibItem(MibItem.HW_PS_CURRENT_NUMBER));
        paramCodeToKeyMap.put(ParameterCode.MAX_NUM_OF_FANS, this.makeKeyArrayFromMibItem(MibItem.HW_FAN_MAX_NUMBER));
        paramCodeToKeyMap.put(ParameterCode.CURR_NUM_OF_WORKING_FANS, this.makeKeyArrayFromMibItem(MibItem.HW_FAN_CURRENT_NUMBER));
        paramCodeToKeyMap.put(ParameterCode.ON_BOARD_TEMP, this.makeKeyArrayFromMibItem(MibItem.HW_ONBOARD_TEMP));
        paramCodeToKeyMap.put(ParameterCode.CPU_TEMP, this.makeKeyArrayFromMibItem(MibItem.HW_CPU_TEMP));
        paramCodeToKeyMap.put(ParameterCode.ON_BOARD_FACTORY_TEMP_TRESH, this.makeKeyArrayFromMibItem(MibItem.HW_ONBOARD_TEMP_THRESH));
        paramCodeToKeyMap.put(ParameterCode.TEMPERATURE_UNITS, this.makeKeyArrayFromMibItem(MibItem.HW_TEMP_UNIT));
        paramCodeToKeyMap.put(ParameterCode.CPU_FACTORY_TEMP_TRESH, this.makeKeyArrayFromMibItem(MibItem.HW_CPU_TEMP_THRESH));
        paramCodeToKeyMap.put(ParameterCode.ON_BOARD_WARNING_TEMP_TRESH, this.makeKeyArrayFromMibItem(MibItem.HW_ON_BOARD_WARN_TEMP));
        paramCodeToKeyMap.put(ParameterCode.CPU_WARNING_TEMP_TRESH, this.makeKeyArrayFromMibItem(MibItem.HW_CPU_WARN_TEMP));
        paramCodeToKeyMap.put(ParameterCode.NETWORK_CONFIG_ACTIVITY, this.makeKeyArrayFromMibItem(MibItem.IP_TABLE_ACTIVITY));
        paramCodeToKeyMap.put(ParameterCode.NETWORK_CONFIG_INTERFACE, this.makeKeyArrayFromMibItem(MibItem.IP_TABLE_IF_NAME));
        paramCodeToKeyMap.put(ParameterCode.NETWORK_CONFIG_IP_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.IP_TABLE_IP_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.NETWORK_CONFIG_NET_MASK, this.makeKeyArrayFromMibItem(MibItem.IP_TABLE_NET_MASK));
        paramCodeToKeyMap.put(ParameterCode.IF_ALIAS, this.makeKeyArrayFromMibItem(MibItem.IF_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.IF_DESCRIPTION, this.makeKeyArrayFromMibItem(MibItem.IF_DESCRIPTION));
        paramCodeToKeyMap.put(ParameterCode.IF_HIGH_SPEED, this.makeKeyArrayFromMibItem(MibItem.IF_HIGH_SPEED));
        paramCodeToKeyMap.put(ParameterCode.IF_NAME, this.makeKeyArrayFromMibItem(MibItem.IF_NAME));
        paramCodeToKeyMap.put(ParameterCode.IF_OPER_STAT, this.makeKeyArrayFromMibItem(MibItem.IF_OPER_STAT));
        paramCodeToKeyMap.put(ParameterCode.IF_TYPE, this.makeKeyArrayFromMibItem(MibItem.IF_TYPE));
        paramCodeToKeyMap.put(ParameterCode.IF_PHYSICAL_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.IF_PHYS_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.IF_LAST_UPDATE, this.makeKeyArrayFromMibItem(MibItem.IF_LAST_CHANGED));
        paramCodeToKeyMap.put(ParameterCode.IF_CONNECTED_SFP_CONNECTOR, this.makeKeyArrayFromMibItem(MibItem.IF_CONNECTED_SFP_CONNECTOR));
        paramCodeToKeyMap.put(ParameterCode.IF_CONNECTED_SFP_VENDOR_NAME, this.makeKeyArrayFromMibItem(MibItem.IF_CONNECTED_SFP_VENDOR_NAME));
        paramCodeToKeyMap.put(ParameterCode.IF_CONNECTED_SFP_SPEED, this.makeKeyArrayFromMibItem(MibItem.IF_CONNECTED_SFP_CAP_BIT_RATE));
        paramCodeToKeyMap.put(ParameterCode.IF_CONNECTED_SFP_VENDOR_OUI, this.makeKeyArrayFromMibItem(MibItem.IF_CONNECTED_SFP_VENDOR_OUI));
        paramCodeToKeyMap.put(ParameterCode.FC_IF_CONNECT_MODE, this.makeKeyArrayFromMibItem(MibItem.FC_IF_CONNECT_MODE));
        paramCodeToKeyMap.put(ParameterCode.FC_IF_PORT_ADMIN_SPEED, this.makeKeyArrayFromMibItem(MibItem.FC_IF_PORT_ADMIN_SPEED));
        paramCodeToKeyMap.put(ParameterCode.FC_IF_PORT_ADMIN_TYPE, this.makeKeyArrayFromMibItem(MibItem.FC_IF_PORT_ADMIN_TYPE));
        paramCodeToKeyMap.put(ParameterCode.FC_IF_PORT_OPER_TYPE, this.makeKeyArrayFromMibItem(MibItem.FC_IF_PORT_OPER_TYPE));
        paramCodeToKeyMap.put(ParameterCode.FC_IF_PORT_WWN, this.makeKeyArrayFromMibItem(MibItem.FC_IF_PORT_WWN));
        paramCodeToKeyMap.put(ParameterCode.PSCSI_BUS_ID, this.makeKeyArrayFromMibItem(MibItem.PSCSI_BUS_ID));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_PORTAL_IP_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_PORTAL_IP_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_PORTAL_PORT, this.makeKeyArrayFromMibItem(MibItem.ISCSI_PORTAL_PORT));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_PORTAL_ROLE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_PORTAL_ROLES));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_FAULTY_INTERVAL, this.makeKeyArrayFromMibItem(MibItem.STORAGE_DOMAIN_FAULTY_INTERVAL));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_KEEPALIVE_INTERVAL, this.makeKeyArrayFromMibItem(MibItem.STORAGE_DOMAIN_KEEPALIVE_INTERVAL));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_LAST_KEEPALIVE, this.makeKeyArrayFromMibItem(MibItem.STORAGE_DOMAIN_LAST_KEEPALIVE));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_SUSPICIOUS_INTERVAL, this.makeKeyArrayFromMibItem(MibItem.STORAGE_DOMAIN_SUSPICIOUS_INTERVAL));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_TAKE_OVER_STATE, this.makeKeyArrayFromMibItem(MibItem.STORAGE_DOMAIN_TAKE_OVER_STATE));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_FAILOVER_ENABLE, this.makeKeyArrayFromMibItem(MibItem.STORAGE_DOMAIN_FAILOVER_ENABLE));
        paramCodeToKeyMap.put(ParameterCode.NEIGHBOR_LAST_KEEPALIVE, this.makeKeyArrayFromMibItem(MibItem.NEIGHBOR_LAST_KEEPALIVE));
        paramCodeToKeyMap.put(ParameterCode.NEIGHBOR_RETRIES, this.makeKeyArrayFromMibItem(MibItem.NEIGHBOR_RETRIES));
        paramCodeToKeyMap.put(ParameterCode.NEIGHBOR_STATUS, this.makeKeyArrayFromMibItem(MibItem.NEIGHBOR_STATUS));
        paramCodeToKeyMap.put(ParameterCode.NEIGHBOR_TIMEOUT, this.makeKeyArrayFromMibItem(MibItem.NEIGHBOR_TIMEOUT));
        paramCodeToKeyMap.put(ParameterCode.NEIGHBOR_TADDRESS, this.makeKeyArrayFromMibItem(MibItem.NEIGHBOR_TADDRESS));
        paramCodeToKeyMap.put(ParameterCode.MANAGER_READ_COMMUNITY, this.makeKeyArrayFromMibItem(MibItem.MANAGER_READ_COMMUNITY));
        paramCodeToKeyMap.put(ParameterCode.MANAGER_TRAP_ENABLE, this.makeKeyArrayFromMibItem(MibItem.MANAGER_TRAPS_ENABLE));
        paramCodeToKeyMap.put(ParameterCode.MANAGER_TRAP_PORT, this.makeKeyArrayFromMibItem(MibItem.MANAGER_TRAP_PORT));
        paramCodeToKeyMap.put(ParameterCode.MANAGER_WRITE_COMMUNITY, this.makeKeyArrayFromMibItem(MibItem.MANAGER_WRITE_COMMUNITY));
        paramCodeToKeyMap.put(ParameterCode.MANAGER_IP_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.MANAGER_IP_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.FC_NODE_WWNN, this.makeKeyArrayFromMibItem(MibItem.FC_NODE_WWNN));
        paramCodeToKeyMap.put(ParameterCode.FC_NODE_FUNCTIONS, this.makeKeyArrayFromMibItem(MibItem.FC_NODE_FUNCTIONS));
        paramCodeToKeyMap.put(ParameterCode.IF_DISCONTINUITY, this.makeKeyArrayFromMibItem(MibItem.IF_DISCONTINUITY));
        paramCodeToKeyMap.put(ParameterCode.IF_IN_BROADCAST_PKTS, this.makeKeyArrayFromMibItem(MibItem.IF_IN_BROADCAST_PKTS));
        paramCodeToKeyMap.put(ParameterCode.IF_IN_DISCARDS, this.makeKeyArrayFromMibItem(MibItem.IF_IN_DISCARDS));
        paramCodeToKeyMap.put(ParameterCode.IF_IN_ERRORS, this.makeKeyArrayFromMibItem(MibItem.IF_IN_ERRORS));
        paramCodeToKeyMap.put(ParameterCode.IF_IN_MULTICAST_PKTS, this.makeKeyArrayFromMibItem(MibItem.IF_IN_MULTICAST_PKTS));
        paramCodeToKeyMap.put(ParameterCode.IF_IN_OCTET, this.makeKeyArrayFromMibItem(MibItem.IF_IN_OCTET));
        paramCodeToKeyMap.put(ParameterCode.IF_IN_UNKNOWN_PROTOCOLS, this.makeKeyArrayFromMibItem(MibItem.IF_IN_UNKNOWN_PROTOCOLS));
        paramCodeToKeyMap.put(ParameterCode.IF_OUT_BROADCAST_PKTS, this.makeKeyArrayFromMibItem(MibItem.IF_OUT_BROADCAST_PKTS));
        paramCodeToKeyMap.put(ParameterCode.IF_OUT_DISCARDS, this.makeKeyArrayFromMibItem(MibItem.IF_OUT_DISCARDS));
        paramCodeToKeyMap.put(ParameterCode.IF_OUT_ERRORS, this.makeKeyArrayFromMibItem(MibItem.IF_OUT_ERRORS));
        paramCodeToKeyMap.put(ParameterCode.IF_OUT_MULTICAST_PKTS, this.makeKeyArrayFromMibItem(MibItem.IF_OUT_MULTICAST_PKTS));
        paramCodeToKeyMap.put(ParameterCode.IF_OUT_OCTET, this.makeKeyArrayFromMibItem(MibItem.IF_OUT_OCTET));
        paramCodeToKeyMap.put(ParameterCode.IF_IN_UNICAST, this.makeKeyArrayFromMibItem(MibItem.IF_IN_UNICAST));
        paramCodeToKeyMap.put(ParameterCode.IF_OUT_UNICAST, this.makeKeyArrayFromMibItem(MibItem.IF_OUT_UNICAST));
        paramCodeToKeyMap.put(ParameterCode.IP_ROUTING_DISCARDS, this.makeKeyArrayFromMibItem(MibItem.IP_ROUTING_DISCARDS));
        paramCodeToKeyMap.put(ParameterCode.IP_FRAG_CREATES, this.makeKeyArrayFromMibItem(MibItem.IP_FRAG_CREATES));
        paramCodeToKeyMap.put(ParameterCode.IP_FRAG_FAIL, this.makeKeyArrayFromMibItem(MibItem.IP_FRAG_FAIL));
        paramCodeToKeyMap.put(ParameterCode.IP_FRAG_OK, this.makeKeyArrayFromMibItem(MibItem.IP_FRAG_OK));
        paramCodeToKeyMap.put(ParameterCode.IP_IN_ADDRESS_ERROR, this.makeKeyArrayFromMibItem(MibItem.IP_IN_ADDRESS_ERROR));
        paramCodeToKeyMap.put(ParameterCode.IP_IN_DELIVERS, this.makeKeyArrayFromMibItem(MibItem.IP_IN_DELIVERS));
        paramCodeToKeyMap.put(ParameterCode.IP_IN_DISCARDS, this.makeKeyArrayFromMibItem(MibItem.IP_IN_DISCARDS));
        paramCodeToKeyMap.put(ParameterCode.IP_IN_HEADER_ERROR, this.makeKeyArrayFromMibItem(MibItem.IP_IN_HEADER_ERROR));
        paramCodeToKeyMap.put(ParameterCode.IP_IN_RECIVES, this.makeKeyArrayFromMibItem(MibItem.IP_IN_RECIVES));
        paramCodeToKeyMap.put(ParameterCode.IP_IN_UNKNOWN_PROTOCOLS, this.makeKeyArrayFromMibItem(MibItem.IP_IN_UNKNOWN_PROTOCOLS));
        paramCodeToKeyMap.put(ParameterCode.IP_OUT_DISCARDS, this.makeKeyArrayFromMibItem(MibItem.IP_OUT_DISCARDS));
        paramCodeToKeyMap.put(ParameterCode.IP_OUT_NO_ROUTES, this.makeKeyArrayFromMibItem(MibItem.IP_OUT_NO_ROUTES));
        paramCodeToKeyMap.put(ParameterCode.IP_OUT_REQUESTS, this.makeKeyArrayFromMibItem(MibItem.IP_OUT_REQUESTS));
        paramCodeToKeyMap.put(ParameterCode.IP_REASM_FAIL, this.makeKeyArrayFromMibItem(MibItem.IP_REASM_FAIL));
        paramCodeToKeyMap.put(ParameterCode.IP_REASM_OK, this.makeKeyArrayFromMibItem(MibItem.IP_REASM_OK));
        paramCodeToKeyMap.put(ParameterCode.IP_REASM_REQDS, this.makeKeyArrayFromMibItem(MibItem.IP_REASM_REQDS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_ADDRESS_MASKS, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_ADDRESS_MASKS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_ADDRESS_REPS, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_ADDRESS_REPS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_DEST_UNREACH, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_DEST_UNREACH));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_ECHO_REPS, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_ECHO_REPS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_ECHOES, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_ECHOES));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_ERRORS, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_ERRORS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_MSGS, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_MSGS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_PARAMS_PROBS, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_PARAMS_PROBS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_REDIRECTS, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_REDIRECTS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_SRC_QUENCHES, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_SRC_QUENCHES));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_TIME_EXCDS, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_TIME_EXCDS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_TIMESTAMP_REPS, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_TIMESTAMP_REPS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_IN_TIMESTAMPS, this.makeKeyArrayFromMibItem(MibItem.ICMP_IN_TIMESTAMPS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_ADDRESS_MASKS, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_ADDRESS_MASKS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_ADDRESS_REPS, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_ADDRESS_REPS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_DEST_UNREACHS, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_DEST_UNREACHS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_ECHO_REPS, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_ECHO_REPS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_ECHOES, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_ECHOES));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_ERRORS, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_ERRORS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_MSGS, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_MSGS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_PARAMS_PROBS, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_PARAMS_PROBS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_REDIRECTS, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_REDIRECTS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_SRC_QUENCHES, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_SRC_QUENCHES));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_TIME_EXCDS, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_TIME_EXCDS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_TIMESTAMP_REPS, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_TIMESTAMP_REPS));
        paramCodeToKeyMap.put(ParameterCode.ICMP_OUT_TIMESTAMPS, this.makeKeyArrayFromMibItem(MibItem.ICMP_OUT_TIMESTAMPS));
        paramCodeToKeyMap.put(ParameterCode.TCP_ACTIVE_OPENS, this.makeKeyArrayFromMibItem(MibItem.TCP_ACTIVE_OPENS));
        paramCodeToKeyMap.put(ParameterCode.TCP_ATTEMPT_FAILS, this.makeKeyArrayFromMibItem(MibItem.TCP_ATTEMPT_FAILS));
        paramCodeToKeyMap.put(ParameterCode.TCP_CURR_ESTAB, this.makeKeyArrayFromMibItem(MibItem.TCP_CURR_ESTAB));
        paramCodeToKeyMap.put(ParameterCode.TCP_ESTAB_RESETS, this.makeKeyArrayFromMibItem(MibItem.TCP_ESTAB_RESETS));
        paramCodeToKeyMap.put(ParameterCode.TCP_IN_ERRORS, this.makeKeyArrayFromMibItem(MibItem.TCP_IN_ERRORS));
        paramCodeToKeyMap.put(ParameterCode.TCP_IN_SEGS, this.makeKeyArrayFromMibItem(MibItem.TCP_IN_SEGS));
        paramCodeToKeyMap.put(ParameterCode.TCP_OUT_RSTS, this.makeKeyArrayFromMibItem(MibItem.TCP_OUT_RSTS));
        paramCodeToKeyMap.put(ParameterCode.TCP_OUT_SEGS, this.makeKeyArrayFromMibItem(MibItem.TCP_OUT_SEGS));
        paramCodeToKeyMap.put(ParameterCode.TCP_PASSIVE_OPENS, this.makeKeyArrayFromMibItem(MibItem.TCP_PASSIVE_OPENS));
        paramCodeToKeyMap.put(ParameterCode.TCP_RETRANS_SEGS, this.makeKeyArrayFromMibItem(MibItem.TCP_RETRANS_SEGS));
        paramCodeToKeyMap.put(ParameterCode.TCP_CONN_LOCAL_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.TCP_CONN_LOCAL_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.TCP_CONN_LOCAL_PORTS, this.makeKeyArrayFromMibItem(MibItem.TCP_CONN_LOCAL_PORTS));
        paramCodeToKeyMap.put(ParameterCode.TCP_CONN_REMOTE_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.TCP_CONN_REMOTE_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.TCP_CONN_REMOTE_PORT, this.makeKeyArrayFromMibItem(MibItem.TCP_CONN_REMOTE_PORT));
        paramCodeToKeyMap.put(ParameterCode.TCP_CONN_STATE, this.makeKeyArrayFromMibItem(MibItem.TCP_CONN_STATE));
        paramCodeToKeyMap.put(ParameterCode.UDP_IN_DATAGRAMS, this.makeKeyArrayFromMibItem(MibItem.UDP_IN_DATAGRAMS));
        paramCodeToKeyMap.put(ParameterCode.UDP_IN_ERRORS, this.makeKeyArrayFromMibItem(MibItem.UDP_IN_ERRORS));
        paramCodeToKeyMap.put(ParameterCode.UDP_NO_PORTS, this.makeKeyArrayFromMibItem(MibItem.UDP_NO_PORTS));
        paramCodeToKeyMap.put(ParameterCode.UDP_OUT_DATAGRAMS, this.makeKeyArrayFromMibItem(MibItem.UDP_OUT_DATAGRAMS));
        paramCodeToKeyMap.put(ParameterCode.UDP_LOCAL_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.UDP_LOCAL_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.UDP_LOCAL_PORT, this.makeKeyArrayFromMibItem(MibItem.UDP_LOCAL_PORT));
        paramCodeToKeyMap.put(ParameterCode.DR_ASYNC_PAIR_PIT_STATE, this.makeKeyArrayFromMibItem(MibItem.DR_ASYNC_PAIR_PIT_STATE));
        paramCodeToKeyMap.put(ParameterCode.DR_ASYNC_PAIR_PIT_TOTAL_DATA, this.makeKeyArrayFromMibItem(MibItem.DR_ASYNC_PAIR_PIT_TOTAL_DATA));
        paramCodeToKeyMap.put(ParameterCode.DR_ASYNC_PAIR_PIT_PENDING_DATA, this.makeKeyArrayFromMibItem(MibItem.DR_ASYNC_PAIR_PIT_PENDING_DATA));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_PIT_STATE, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_PIT_STATE));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_PIT_TOTAL_DATA, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_PIT_TOTAL_DATA));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_PIT_PENDING_DATA, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_PIT_PENDING_DATA));
        paramCodeToKeyMap.put(ParameterCode.DR_VIRT_GROUP_TYPE, this.makeKeyArrayFromMibItem(MibItem.DR_VIRT_GROUP_TYPE));
        paramCodeToKeyMap.put(ParameterCode.DR_VIRT_GROUP_ELEMENTS_COUNT, this.makeKeyArrayFromMibItem(MibItem.DR_VIRT_GROUP_ELEMENTS_COUNT));
        paramCodeToKeyMap.put(ParameterCode.DR_VIRT_GROUP_ALIAS, this.makeKeyArrayFromMibItem(MibItem.DR_VIRT_GROUP_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.DR_VIRT_GROUP_STATE, this.makeKeyArrayFromMibItem(MibItem.DR_VIRT_GROUP_STATE));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_ROLE, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_ROLE));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_PIT_POLICY));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_TRANS_POLICY));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_MERGE_POLICY));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_ACTIVATE, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_ACTIVATE));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_MODE, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_MODE));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_OWNED_BY, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_OWNED_BY));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_STATE, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_REPLICATION_STATE));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_DATA, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_PENDING_DATA));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_PENDING_PITS));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_INITIAL_SYNC_STATE, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_INITIAL_SYNC_STATE));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_ROW_STATUS, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_ROW_STATUS));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_NEXT_REPLICATION_SCHEDULE, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_NEXT_REPLICATION_SCHEDULE));
        paramCodeToKeyMap.put(ParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE, this.makeKeyArrayFromMibItem(MibItem.DR_GROUP_LAST_PIT_MERGE));
        paramCodeToKeyMap.put(ParameterCode.DR_PAIR_TYPE, this.makeKeyArrayFromMibItem(MibItem.DR_PAIR_TYPE));
        paramCodeToKeyMap.put(ParameterCode.DR_PAIR_PRIMARY_ID, this.makeKeyArrayFromMibItem(MibItem.DR_PAIR_PRIMARY_ID));
        paramCodeToKeyMap.put(ParameterCode.DR_PAIR_SECONDARY_ID, this.makeKeyArrayFromMibItem(MibItem.DR_PAIR_SCONDARY_ID));
        paramCodeToKeyMap.put(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, this.makeKeyArrayFromMibItem(MibItem.DR_PAIR_INITIAL_SYNC_TYPE));
        paramCodeToKeyMap.put(ParameterCode.DR_PAIR_MODE, this.makeKeyArrayFromMibItem(MibItem.DR_PAIR_MODE));
        paramCodeToKeyMap.put(ParameterCode.DR_PAIR_STATE, this.makeKeyArrayFromMibItem(MibItem.DR_PAIR_STATE));
        paramCodeToKeyMap.put(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE, this.makeKeyArrayFromMibItem(MibItem.DR_PAIR_INITIAL_SYNC_STATE));
        paramCodeToKeyMap.put(ParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED, this.makeKeyArrayFromMibItem(MibItem.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED));
        paramCodeToKeyMap.put(ParameterCode.DR_PAIR_ROW_STATUS, this.makeKeyArrayFromMibItem(MibItem.DR_PAIR_ROW_STATUS));
        paramCodeToKeyMap.put(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, this.makeKeyArrayFromMibItem(MibItem.DR_ASYNC_PAIR_JOURNAL_ID));
        paramCodeToKeyMap.put(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, this.makeKeyArrayFromMibItem(MibItem.DR_ASYNC_PAIR_GROUP_ID));
        paramCodeToKeyMap.put(ParameterCode.DR_ASYNC_PAIR_ACTIVATE, this.makeKeyArrayFromMibItem(MibItem.DR_ASYNC_PAIR_ACTIVATE));
        paramCodeToKeyMap.put(ParameterCode.DR_ASYNC_PAIR_REPLICATION_STATE, this.makeKeyArrayFromMibItem(MibItem.DR_ASYNC_PAIR_REPLICATION_STATE));
        paramCodeToKeyMap.put(ParameterCode.DR_ASYNC_PAIR_PENDING_DATA, this.makeKeyArrayFromMibItem(MibItem.DR_ASYNC_PAIR_PENDING_DATA));
        paramCodeToKeyMap.put(ParameterCode.DR_ASYNC_PAIR_PENDING_PITS, this.makeKeyArrayFromMibItem(MibItem.DR_ASYNC_PAIR_PENDING_PITS));
        paramCodeToKeyMap.put(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, this.makeKeyArrayFromMibItem(MibItem.DR_ASYNC_PAIR_SNAPSHOT_ID));
        paramCodeToKeyMap.put(ParameterCode.DR_ASYNC_PAIR_LAST_PIT_MERGE, this.makeKeyArrayFromMibItem(MibItem.DR_ASYNC_PAIR_LAST_PIT_MERGE));
        paramCodeToKeyMap.put(ParameterCode.DR_SYNC_PAIR_ACTIVATE, this.makeKeyArrayFromMibItem(MibItem.DR_SYNC_PAIR_ACTIVATE));
        paramCodeToKeyMap.put(ParameterCode.DR_SYNC_PAIR_ROLE, this.makeKeyArrayFromMibItem(MibItem.DR_SYNC_PAIR_ROLE));
        paramCodeToKeyMap.put(ParameterCode.DR_SYNC_PAIR_REPLICATION_STATE, this.makeKeyArrayFromMibItem(MibItem.DR_SYNC_PAIR_REPLICATION_STATE));
        paramCodeToKeyMap.put(ParameterCode.POLICY_POINTER_TO_PARAM, this.makeKeyArrayFromMibItem(MibItem.DR_POLICY_PTR));
        paramCodeToKeyMap.put(ParameterCode.POLICY_START_AT, this.makeKeyArrayFromMibItem(MibItem.DR_POLICY_STARTING_AT));
        paramCodeToKeyMap.put(ParameterCode.POLICY_ROW_STATUS, this.makeKeyArrayFromMibItem(MibItem.DR_POLICY_ROW_STATUS));
        paramCodeToKeyMap.put(ParameterCode.POLICY_PARAM_TYPE, this.makeKeyArrayFromMibItem(MibItem.DR_POLICY_PARAM_TYPE));
        paramCodeToKeyMap.put(ParameterCode.POLICY_PARAM_PARAM1, this.makeKeyArrayFromMibItem(MibItem.DR_POLICY_PARAM_PARAM1));
        paramCodeToKeyMap.put(ParameterCode.POLICY_PARAM_PARAM2, this.makeKeyArrayFromMibItem(MibItem.DR_POLICY_PARAM_PARAM2));
        paramCodeToKeyMap.put(ParameterCode.POLICY_PARAM_ROW_STATUS, this.makeKeyArrayFromMibItem(MibItem.DR_POLICY_PARAM_ROW_STATUS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_CID, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_CID));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_DATA_INTEGRITY, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_DATA_INTEGRITY));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_HEADER_INTEGRITY, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_HEADER_INTEGRITY));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_LOCAL_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS_TYPE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_LOCAL_ADDRESS_TYPE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_LOCAL_PORT, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_LOCAL_PORT));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_MAX_RECEIVED_PDU_LENGTH, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_MAX_RECEIVED_PDU_LENGTH));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_MAX_TRANSMIT_PDU_LENGTH, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_MAX_TRANSMIT_PDU_LENGTH));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_REMOTE_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS_TYPE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_REMOTE_ADDRESS_TYPE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_REMOTE_PORT, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_REMOTE_PORT));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_STATE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_STATE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_AUTH_IDENTITY, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_AUTH_IDENTITY));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_CMD_PDUS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_CMD_PDUS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_DIGEST_ERRORS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_DIGEST_ERRORS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_INITIATOR_ALIAS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_INITIATOR_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_INITIATOR_NAME, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_INITIATOR_NAME));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_ISID, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_ISID));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_RSP_PDUS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_RSP_PDUS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_RX_DATA_OCTETS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_RX_DATA_OCTETS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_TARGET_ALIAS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_TARGET_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_TARGET_NAME, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_TARGET_NAME));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_TIMEOUT_ERRORS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_TIMEOUT_ERRORS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_TSIH, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_TSIH));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_TX_DATA_OCTETS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_TX_DATA_OCTETS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_TYPE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_TYPE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_DESCRIPTION, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_DESCRIPTION));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_REMOTE_NODE_NAME, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_LAST_FAILURE_REMOTE_NODE_NAME));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_TYPE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_LAST_FAILURE_TYPE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_NODES, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_NUM_OF_NODES));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_PORTALS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_NUM_OF_PORTALS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_REMOTE_NODE_NAME, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_LAST_FAILURE_REMOTE_NODE_NAME));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_TYPE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_LAST_FAILURE_TYPE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_NODES, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_NUM_OF_NODES));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_PORTALS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_NUM_OF_PORTALS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSIONS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_NUM_OF_SESSIONS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_VENDOR_ID, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_VENDOR_ID));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_VENDOR_VERSION, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_VENDOR_VERSION));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_VERSION_MAX, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_VERSION_MAX));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_INSTANCE_VERSION_MIN, this.makeKeyArrayFromMibItem(MibItem.ISCSI_INSTANCE_VERSION_MIN));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_PORTAL_IP_ADDRESS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_PORTAL_IP_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_PORTAL_PORT, this.makeKeyArrayFromMibItem(MibItem.ISCSI_PORTAL_PORT));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_REMOTE_INITIATOR_ATTACHED_TIMES, this.makeKeyArrayFromMibItem(MibItem.ISCSI_REMOTE_INITIATOR_ATTACHED_TIMES));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_REMOTE_INITIATOR_NAME, this.makeKeyArrayFromMibItem(MibItem.ISCSI_REMOTE_INITIATOR_NAME));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_REMOTE_OUT_COMMANDS, this.makeKeyArrayFromMibItem(MibItem.ISCSI_REMOTE_OUT_COMMANDS));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_REMOTE_READ_MB, this.makeKeyArrayFromMibItem(MibItem.ISCSI_REMOTE_READ_MB));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_REMOTE_WRITTEN_MB, this.makeKeyArrayFromMibItem(MibItem.ISCSI_REMOTE_WRITTEN_MB));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_SESSION_DIRECTION, this.makeKeyArrayFromMibItem(MibItem.ISCSI_SESSION_DIRECTION));
        paramCodeToKeyMap.put(ParameterCode.ISCSI_CONNECTION_LAST_CHANGE, this.makeKeyArrayFromMibItem(MibItem.ISCSI_CONNECTION_LAST_CHANGE));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TRANSPORT_TYPE, this.makeKeyArrayFromMibItem(MibItem.SCSI_TRANSPORT_TYPE));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TRANSPORT_POINTER, this.makeKeyArrayFromMibItem(MibItem.SCSI_TRANSPORT_POINTER));
        paramCodeToKeyMap.put(ParameterCode.SCSI_TRANSPORT_DEVICE_NAME, this.makeKeyArrayFromMibItem(MibItem.SCSI_TRANSPORT_DEVICE_NAME));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_IP_ADDRESS, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_IP_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_IP_MASK, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_IP_MASK));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_MAX_RETRIES, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_RETRIES));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_READ_COMMUNITY, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_READ_COMMUNITY));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_SNMP_UDP_PORT, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_SNMP_PORT));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_SNMP_VERSION, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_SNMP_VERSION));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_TIMEOUT, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_TIMEOUT));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_TRAP_UDP_PORT, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_TRAP_PORT));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_WRITE_COMMUNITY, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_WRITE_COMMUNITY));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_HOST_NAME, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_HOST_NAME));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_CONNECTIVITY_STATUS, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_STATE));
        paramCodeToKeyMap.put(ParameterCode.VSWITCH_GROUP_ID, this.makeKeyArrayFromDBItem(DBItem.VSWITCH_GROUP_ID));
        paramCodeToKeyMap.put(ParameterCode.PARENT_SITE_ID, this.makeKeyArrayFromDBItem(DBItem.PARENT_SITE_ID));
        paramCodeToKeyMap.put(ParameterCode.SITE_ALIAS, this.makeKeyArrayFromDBItem(DBItem.SITE_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.CLUSTER_ALIAS, this.makeKeyArrayFromDBItem(DBItem.CLUSTER_ALIAS));
        paramCodeToKeyMap.put(ParameterCode.CLUSTER_MODE, this.makeKeyArrayFromDBItem(DBItem.CLUSTER_MODE));
        paramCodeToKeyMap.put(ParameterCode.ALARM_TYPE_NAME, this.makeKeyArrayFromDBItem(DBItem.ALARM_TYPE_NAME));
        paramCodeToKeyMap.put(ParameterCode.ALARM_TYPE_CALL_HOME, this.makeKeyArrayFromDBItem(DBItem.ALARM_TYPE_CALL_HOME));
        paramCodeToKeyMap.put(ParameterCode.ALARM_TYPE_CATEGORY, this.makeKeyArrayFromDBItem(DBItem.ALARM_TYPE_CATEGORY));
        paramCodeToKeyMap.put(ParameterCode.ALARM_TYPE_EMAIL, this.makeKeyArrayFromDBItem(DBItem.ALARM_TYPE_EMAIL));
        paramCodeToKeyMap.put(ParameterCode.ALARM_TYPE_ID, this.makeKeyArrayFromDBItem(DBItem.ALARM_TYPE_ID));
        paramCodeToKeyMap.put(ParameterCode.ALARM_TYPE_SEVERITY, this.makeKeyArrayFromDBItem(DBItem.ALARM_TYPE_SEVERITY));
        paramCodeToKeyMap.put(ParameterCode.EMAIL_CONTACT_FROM_ADDRESS, this.makeKeyArrayFromDBItem(DBItem.EMAIL_CONTACT_FROM_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.EMAIL_CONTACT_SMTP_HOST, this.makeKeyArrayFromDBItem(DBItem.EMAIL_CONTACT_SMTP_HOST));
        paramCodeToKeyMap.put(ParameterCode.EMAIL_CONTACT_TO_ADDRESS, this.makeKeyArrayFromDBItem(DBItem.EMAIL_CONTACT_TO_ADDRESS));
        paramCodeToKeyMap.put(ParameterCode.EMAIL_CONTACT_SMTP_USER, this.makeKeyArrayFromDBItem(DBItem.EMAIL_CONTACT_SMTP_USER));
        paramCodeToKeyMap.put(ParameterCode.EMAIL_CONTACT_SMTP_PASSWORD, this.makeKeyArrayFromDBItem(DBItem.EMAIL_CONTACT_SMTP_PASSWORD));
        paramCodeToKeyMap.put(ParameterCode.ALARM_TYPE_TROUBLESHOOTING, this.makeKeyArrayFromDBItem(DBItem.ALARM_TYPE_TROUBLESHOOTING));
        paramCodeToKeyMap.put(ParameterCode.GENERAL_POLL_INTERVAL, this.makeKeyArrayFromDBItem(DBItem.GENERAL_POLL_INTERVAL));
        paramCodeToKeyMap.put(ParameterCode.VIRTUALIZATION_POLL_INTERVAL, this.makeKeyArrayFromDBItem(DBItem.VIRTUALIZATION_POLL_INTERVAL));
        paramCodeToKeyMap.put(ParameterCode.ACL_POLL_INTERVAL, this.makeKeyArrayFromDBItem(DBItem.ACL_POLL_INTERVAL));
        paramCodeToKeyMap.put(ParameterCode.NET_POLL_INTERVAL, this.makeKeyArrayFromDBItem(DBItem.NET_POLL_INTERVAL));
        paramCodeToKeyMap.put(ParameterCode.PIT_POLL_INTERVAL, this.makeKeyArrayFromDBItem(DBItem.PITS_POLL_INTERVAL));
        paramCodeToKeyMap.put(ParameterCode.STATISTIC_POLL_INTERVAL, this.makeKeyArrayFromDBItem(DBItem.STATISTIC_POLL_INTERVAL));
        paramCodeToKeyMap.put(ParameterCode.CLUSTER_STORAGE_COMPARISON, this.makeKeyArrayFromDBItem(DBItem.CLUSTER_STORAGE_COMPARISON));
    }

    private void initSnmpKeyToParamCodeMap() {
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_SYS_OID.toString(), ParameterCode.VSWITCH_SYS_OID);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_MANUAL_DISCOVERY.toString(), ParameterCode.PHYSICAL_STORAGE_MANUAL_DISCOVERY);
        snmpKeyToParamCodeMap.put(MibItem.SUB_DIRECT_ACCESS_DEVICE_LENGTH.toString(), ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH);
        snmpKeyToParamCodeMap.put(MibItem.SUB_DIRECT_ACCESS_DEVICE_INFO.toString(), ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO);
        snmpKeyToParamCodeMap.put(MibItem.SUB_DIRECT_ACCESS_DEVICE_ALIAS.toString(), ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS.toString(), ParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.SUB_DIRECT_ACCESS_DEVICE_LAST_UPDATE.toString(), ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LAST_UPDATE);
        snmpKeyToParamCodeMap.put(MibItem.SUB_DIRECT_ACCESS_DEVICE_TABLE_LAST_UPDATE.toString(), ParameterCode.LAST_UPDATE);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_VENDOR_NAME.toString(), ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_OPERATIONAL_STATUS.toString(), ParameterCode.PHYSICAL_STORAGE_OPERATIONAL_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_LUN.toString(), ParameterCode.PHYSICAL_STORAGE_LUN);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_INFO.toString(), ParameterCode.PHYSICAL_STORAGE_INFO);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_ENTITY_NAME.toString(), ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_ALIAS.toString(), ParameterCode.PHYSICAL_STORAGE_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_TRANSPORT_TYPE.toString(), ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_TYPE.toString(), ParameterCode.PHYSICAL_STORAGE_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.DIRECT_ACCESS_DEVICE_BLOCK_NUM.toString(), ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM);
        snmpKeyToParamCodeMap.put(MibItem.DIRECT_ACCESS_DEVICE_ALLOCABLE.toString(), ParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_TBL_LAST_UPDATE.toString(), ParameterCode.LAST_UPDATE);
        snmpKeyToParamCodeMap.put(MibItem.DIRECT_ACCESS_DEVICE_BLOCK_SIZE.toString(), ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_LAST_UPDATE.toString(), ParameterCode.PHYSICAL_STORAGE_LAST_UPDATE);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_COM_ADMIN_STATUS.toString(), ParameterCode.PHYSICAL_STORAGE_COM_ADMIN_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_COM_OPER_STATUS.toString(), ParameterCode.PHYSICAL_STORAGE_COM_OPER_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_COM_DURATION.toString(), ParameterCode.PHYSICAL_STORAGE_COM_DURATION);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_SERIAL_NUMBER.toString(), ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_PRODUCT_ID.toString(), ParameterCode.PHYSICAL_STORAGE_PRODUCT_ID);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_REVISION_LEVEL.toString(), ParameterCode.PHYSICAL_STORAGE_REVISION_LEVEL);
        snmpKeyToParamCodeMap.put(MibItem.PHYSICAL_STORAGE_SCSI_VER.toString(), ParameterCode.PHYSICAL_STORAGE_SCSI_VER);
        snmpKeyToParamCodeMap.put(MibItem.DIRECT_ACCESS_DEVICE_WCE_STATE.toString(), ParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE);
        snmpKeyToParamCodeMap.put(MibItem.DIRECT_ACCESS_DEVICE_WCE_STATE_ENABLE.toString(), ParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE_ENABLE);
        snmpKeyToParamCodeMap.put(MibItem.DIRECT_ACCESS_DEVICE_WP.toString(), ParameterCode.DIRECT_ACCESS_DEVICE_WP);
        snmpKeyToParamCodeMap.put(MibItem.LU_ID_CODE_SET.toString(), ParameterCode.LU_ID_CODE_SET);
        snmpKeyToParamCodeMap.put(MibItem.LU_ID_ASSOC.toString(), ParameterCode.LU_ID_ASSOC);
        snmpKeyToParamCodeMap.put(MibItem.LU_ID_TYPE.toString(), ParameterCode.LU_ID_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.LU_ID_VALUE.toString(), ParameterCode.LU_ID_VALUE);
        snmpKeyToParamCodeMap.put(MibItem.DISC_TARGET_NAME.toString(), ParameterCode.DISCOVERED_TARGET_NAME);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_ALIAS.toString(), ParameterCode.VOLUME_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_BLOCK_SIZE.toString(), ParameterCode.VIRTUAL_VOLUME_BLOCK_SIZE);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS.toString(), ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS.toString(), ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_STATE.toString(), ParameterCode.VOLUME_STATE);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_STRIPE_SIZE.toString(), ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_LAST_UPDATE.toString(), ParameterCode.LAST_UPDATE);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_CHILDREN_POSITION.toString(), ParameterCode.VOLUME_POSITION);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_LU_ID.toString(), ParameterCode.VIRTUAL_VOLUME_LU_ID);
        snmpKeyToParamCodeMap.put(MibItem.SNAPSHOT_VOLUME_DATE_AND_TIME.toString(), ParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME);
        snmpKeyToParamCodeMap.put(MibItem.SNAPSHOT_VOLUME_PERCENT_UTIL.toString(), ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD);
        snmpKeyToParamCodeMap.put(MibItem.SNAPSHOT_VOLUME_PERCENT_THRESH.toString(), ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH);
        snmpKeyToParamCodeMap.put(MibItem.SNAPSHOT_VOLUME_SOURCE.toString(), ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        snmpKeyToParamCodeMap.put(MibItem.SNAPSHOT_ACTIVATE.toString(), ParameterCode.SNAPSHOT_ACTIVATE);
        snmpKeyToParamCodeMap.put(MibItem.JOURNAL_VOLUME_DATE_AND_TIME.toString(), ParameterCode.JOURNAL_VOLUME_DATE_AND_TIME);
        snmpKeyToParamCodeMap.put(MibItem.JOURNAL_VOLUME_PRECENT_UTILIZATION.toString(), ParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION);
        snmpKeyToParamCodeMap.put(MibItem.JOURNAL_VOLUME_PRECENT_THRESH.toString(), ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH);
        snmpKeyToParamCodeMap.put(MibItem.JOURNAL_VOLUME_ACTIVITY.toString(), ParameterCode.JOURNAL_VOLUME_ACTIVITY);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_OPER_STATUS.toString(), ParameterCode.VOLUME_OPERATION_OPER_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_SRC_ALIAS.toString(), ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_SRC_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.VIRTUAL_VOLUME_MIRROR_PERCENTAGE_SYNC_COPIED.toString(), ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED);
        snmpKeyToParamCodeMap.put(MibItem.VOLUME_OPERATION_ADMIN_STATUS.toString(), ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.VOLUME_OPERATION_PERCENTAGE_COPIED.toString(), ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED);
        snmpKeyToParamCodeMap.put(MibItem.VOLUME_OPERATION_OPER_STATUS.toString(), ParameterCode.VOLUME_OPERATION_OPER_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.IDENTITY_ALIAS.toString(), ParameterCode.IDENTITY_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.IDENTITY_DESCRIPTION.toString(), ParameterCode.IDENTITY_DESCRIPTION);
        snmpKeyToParamCodeMap.put(MibItem.IDENTITY_NAME_VALUE.toString(), ParameterCode.IDENTITY_NAME_VALUE);
        snmpKeyToParamCodeMap.put(MibItem.IDENTITY_ENTRY_LAST_UPDATED.toString(), ParameterCode.IDENTITY_LAST_UPDATE);
        snmpKeyToParamCodeMap.put(MibItem.IDENTITY_PURPOSE.toString(), ParameterCode.IDENTITY_PURPOSE);
        snmpKeyToParamCodeMap.put(MibItem.CREDENTIALS_AUTH_METHOD.toString(), ParameterCode.CREDENTIALS_AUTH_METHOD);
        snmpKeyToParamCodeMap.put(MibItem.CHAP_CREDENTIALS_USER_NAME.toString(), ParameterCode.CHAP_CREDENTIALS_USER_NAME);
        snmpKeyToParamCodeMap.put(MibItem.SRP_CREDENTIALS_USER_NAME.toString(), ParameterCode.SRP_CREDENTIALS_USER_NAME);
        snmpKeyToParamCodeMap.put(MibItem.CHAP_CREDENTIALS_RADIUS_ENABLED.toString(), ParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED);
        snmpKeyToParamCodeMap.put(MibItem.RADIUS_SERVER_IP_ADDRESS.toString(), ParameterCode.RADIUS_SERVER_IP_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.RADIUS_SERVER_PORT.toString(), ParameterCode.RADIUS_SERVER_PORT);
        snmpKeyToParamCodeMap.put(MibItem.RADIUS_SERVER_KEY.toString(), ParameterCode.RADIUS_SERVER_KEY);
        snmpKeyToParamCodeMap.put(MibItem.ISNS_SERVER_IP_ADDRESS.toString(), ParameterCode.ISNS_SERVER_IP_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.ACL_ENTRY_ACCESS.toString(), ParameterCode.ACL_ENTRY_ACCESS);
        snmpKeyToParamCodeMap.put(MibItem.ACL_ENTRY_IDENTITY.toString(), ParameterCode.ACL_ENTRY_IDENTITY);
        snmpKeyToParamCodeMap.put(MibItem.ACL_ENTRY_POSITION.toString(), ParameterCode.ACL_ENTRY_POSITION);
        snmpKeyToParamCodeMap.put(MibItem.LUN_LU_NUMBER.toString(), ParameterCode.LU_LUN_NUMBER);
        snmpKeyToParamCodeMap.put(MibItem.LUN_OPER_STATUS.toString(), ParameterCode.LU_OPER_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.LUN_SERIAL_NUMBER.toString(), ParameterCode.LU_SERIAL_NUMBER);
        snmpKeyToParamCodeMap.put(MibItem.LUN_CREATION_DATE.toString(), ParameterCode.LU_CREATION_DATE);
        snmpKeyToParamCodeMap.put(MibItem.LUN_LAST_UPDATE.toString(), ParameterCode.LAST_UPDATE);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_TARGET_ALIAS.toString(), ParameterCode.ISCSI_TARGET_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_TARGET_DEFAULT_EXPOSED_ON.toString(), ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_TARGET_NAME.toString(), ParameterCode.ISCSI_TARGET_NAME);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_TARGET_TRANSPORT_TYPE.toString(), ParameterCode.ISCSI_TARGET_TRANSPORT_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TARGET_PORT_NAME.toString(), ParameterCode.SCSI_TARGET_PORT_NAME);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TARGET_PORT_IN_COMMANDS.toString(), ParameterCode.SCSI_TARGET_PORT_IN_COMMANDS);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TARGET_PORT_READ_MB.toString(), ParameterCode.SCSI_TARGET_PORT_READ_MB);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TARGET_PORT_WRITTEN_MB.toString(), ParameterCode.SCSI_TARGET_PORT_WRITTEN_MB);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TARGET_DEVICE_STATUS.toString(), ParameterCode.SCSI_TARGET_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_LUN_LU_NUMBER.toString(), ParameterCode.SCSI_LUN_LU_NUMBER);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_LUN_REVISION_ID.toString(), ParameterCode.SCSI_LUN_REVISION_ID);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_LUN_STATUS.toString(), ParameterCode.SCSI_LUN_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_LUN_STATE.toString(), ParameterCode.SCSI_LUN_STATE);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_DEVICE_ROLE.toString(), ParameterCode.SCSI_DEVICE_ROLE);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_DEVICE_ALIAS.toString(), ParameterCode.SCSI_DEVICE_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_DEVICE_PORT_NUMBER.toString(), ParameterCode.SCSI_DEVICE_NUM_OF_PORTS);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_PORT_ROLE.toString(), ParameterCode.SCSI_PORT_ROLE);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TARGET_PORT_NAME.toString(), ParameterCode.SCSI_TARGET_PORT_NAME);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TARGET_PORT_READ_MB.toString(), ParameterCode.SCSI_TARGET_PORT_READ_MB);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TARGET_PORT_WRITTEN_MB.toString(), ParameterCode.SCSI_TARGET_PORT_WRITTEN_MB);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INITAITOR_NUM_OF_LOGIN_FAILURES.toString(), ParameterCode.ISCSI_INITAITOR_NUM_OF_LOGIN_FAILURES);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_INITIATOR_DEVICE_TARGET_ACCESS_MODE.toString(), ParameterCode.SCSI_INITIATOR_TARGET_ACCESS_MODE);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_INITIATOR_PORT_NAME.toString(), ParameterCode.SCSI_INITIATOR_PORT_NAME);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_INITIATOR_PORT_READ_MEGA_BYTES.toString(), ParameterCode.SCSI_INITIATOR_PORT_READ_MB);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_INITIATOR_PORT_WRITTEN_MEGA_BYTES.toString(), ParameterCode.SCSI_INITIATOR_PORT_WRITTEN_MB);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_INITIATOR_PORT_OUT_COMMANDS.toString(), ParameterCode.SCSI_INITIATOR_PORT_OUT_COMMANDS);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TRANSPORT_TYPE.toString(), ParameterCode.SCSI_TRANSPORT_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TRANSPORT_POINTER.toString(), ParameterCode.SCSI_TRANSPORT_POINTER);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TRANSPORT_DEVICE_NAME.toString(), ParameterCode.SCSI_TRANSPORT_DEVICE_NAME);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_TARGET_ALIAS.toString(), ParameterCode.ISCSI_TARGET_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INITIATOR_LAST_TARGET_FAILURE_NAME.toString(), ParameterCode.ISCSI_INITAITOR_LAST_TARGET_FAILURE_NAME);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE.toString(), ParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_TARGET_LAST_FAILURE_TIME.toString(), ParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_TARGET_LAST_FAILURE_TYPE.toString(), ParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME.toString(), ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP.toString(), ParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_REMOTE_TARGET_LAST_CHANGE.toString(), ParameterCode.SCSI_REMOTE_TARGET_LAST_CHANGE);
        snmpKeyToParamCodeMap.put(MibItem.DISC_TARGET_NAME.toString(), ParameterCode.DISCOVERED_TARGET_NAME);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_REMOTE_TARGET_ALIAS.toString(), ParameterCode.SCSI_REMOTE_TARGET_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_DISCOVER_TARGET_CONFIGURED.toString(), ParameterCode.SCSI_REMOTE_TARGET_IS_CONFIGURED);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_DISCOVER_TARGET_DISCOVERED.toString(), ParameterCode.SCSI_REMOTE_TARGET_IS_DISCOVERED);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_REMOTE_TARGET_LOGIN_STATUS.toString(), ParameterCode.SCSI_REMOTE_TARGET_LOGIN_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_REMOTE_TARGET_FAILURE_TYPE.toString(), ParameterCode.SCSI_REMOTE_TARGET_FAILURE_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_REMOTE_TARGET_NUM_OF_PORTAL.toString(), ParameterCode.ISCSI_REMOTE_TARGET_NUM_OF_PORTALS);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_REMOTE_TARGET_IDENTITY.toString(), ParameterCode.IDENTITY_ID);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_REMOTE_TARGET_PORTAL_ADDRESS.toString(), ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_IP);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_REMOTE_TARGET_PORTAL_PORT.toString(), ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_PORT);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_REMOTE_TARGET_PG_TAG.toString(), ParameterCode.ISCSI_REMOTE_TARGET_PORTAL_GROUP_TAG);
        snmpKeyToParamCodeMap.put(MibItem.REMOTE_PORTAL_DISC_ACTIVATE.toString(), ParameterCode.REMOTE_PORTAL_DISC_ACTIVATE);
        snmpKeyToParamCodeMap.put(MibItem.REMOTE_PORTAL_DISC_PERIOD.toString(), ParameterCode.REMOTE_PORTAL_DISC_PERIOD);
        snmpKeyToParamCodeMap.put(MibItem.REMOTE_PORTAL_DISC_LAST_FAILURE.toString(), ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE);
        snmpKeyToParamCodeMap.put(MibItem.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME.toString(), ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME);
        snmpKeyToParamCodeMap.put(MibItem.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY.toString(), ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY);
        snmpKeyToParamCodeMap.put(MibItem.REMOTE_PORTAL_DISC_STATE.toString(), ParameterCode.REMOTE_PORTAL_DISC_STATE);
        snmpKeyToParamCodeMap.put(MibItem.REMOTE_PORTAL_DISC_ROW_STATUS.toString(), ParameterCode.REMOTE_PORTAL_DISC_ROW_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.REMOTE_PORTAL_DISC_LAST_CHANGED.toString(), ParameterCode.REMOTE_PORTAL_DISC_LAST_CHANGED);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_RESET.toString(), ParameterCode.VSWITCH_RESET);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_CONTACT.toString(), ParameterCode.VSWITCH_CONTACT);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_DATE_AND_TIME.toString(), ParameterCode.VSWITCH_DATE_AND_TIME);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_DESCRIPTION.toString(), ParameterCode.VSWITCH_DESCRIPTION);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_LOCATION.toString(), ParameterCode.VSWITCH_LOCATION);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_NAME.toString(), ParameterCode.VSWITCH_NAME);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_TELNET_PORT.toString(), ParameterCode.VSWITCH_TELNET_PORT);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_MGM_ADDRESS.toString(), ParameterCode.VSWITCH_TADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_SWITCH_ID.toString(), ParameterCode.VSWITCH_SWITCH_ID);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_REPORT_LUN_DISCOVERY.toString(), ParameterCode.VSWITCH_REPORT_LUN_DISCOVERY);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_STATUS.toString(), ParameterCode.VSWITCH_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.HW_PS_MAX_NUMBER.toString(), ParameterCode.MAX_NUM_OF_POWER_SUPPLIERS);
        snmpKeyToParamCodeMap.put(MibItem.HW_PS_CURRENT_NUMBER.toString(), ParameterCode.CURR_NUM_OF_WORKING_POWER_SUPPLIERS);
        snmpKeyToParamCodeMap.put(MibItem.HW_FAN_MAX_NUMBER.toString(), ParameterCode.MAX_NUM_OF_FANS);
        snmpKeyToParamCodeMap.put(MibItem.HW_FAN_CURRENT_NUMBER.toString(), ParameterCode.CURR_NUM_OF_WORKING_FANS);
        snmpKeyToParamCodeMap.put(MibItem.HW_ONBOARD_TEMP.toString(), ParameterCode.ON_BOARD_TEMP);
        snmpKeyToParamCodeMap.put(MibItem.HW_CPU_TEMP.toString(), ParameterCode.CPU_TEMP);
        snmpKeyToParamCodeMap.put(MibItem.HW_ONBOARD_TEMP_THRESH.toString(), ParameterCode.ON_BOARD_FACTORY_TEMP_TRESH);
        snmpKeyToParamCodeMap.put(MibItem.HW_CPU_TEMP_THRESH.toString(), ParameterCode.CPU_FACTORY_TEMP_TRESH);
        snmpKeyToParamCodeMap.put(MibItem.HW_TEMP_UNIT.toString(), ParameterCode.TEMPERATURE_UNITS);
        snmpKeyToParamCodeMap.put(MibItem.HW_ON_BOARD_WARN_TEMP.toString(), ParameterCode.ON_BOARD_WARNING_TEMP_TRESH);
        snmpKeyToParamCodeMap.put(MibItem.HW_FAN_CURRENT_NUMBER.toString(), ParameterCode.CURR_NUM_OF_WORKING_FANS);
        snmpKeyToParamCodeMap.put(MibItem.HW_CPU_WARN_TEMP.toString(), ParameterCode.CPU_WARNING_TEMP_TRESH);
        snmpKeyToParamCodeMap.put(MibItem.FC_NODE_WWNN.toString(), ParameterCode.FC_NODE_WWNN);
        snmpKeyToParamCodeMap.put(MibItem.FC_NODE_FUNCTIONS.toString(), ParameterCode.FC_NODE_FUNCTIONS);
        snmpKeyToParamCodeMap.put(MibItem.IP_TABLE_ACTIVITY.toString(), ParameterCode.NETWORK_CONFIG_ACTIVITY);
        snmpKeyToParamCodeMap.put(MibItem.IP_TABLE_IF_NAME.toString(), ParameterCode.NETWORK_CONFIG_INTERFACE);
        snmpKeyToParamCodeMap.put(MibItem.IP_TABLE_IP_ADDRESS.toString(), ParameterCode.NETWORK_CONFIG_IP_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.IP_TABLE_NET_MASK.toString(), ParameterCode.NETWORK_CONFIG_NET_MASK);
        snmpKeyToParamCodeMap.put(MibItem.IF_ALIAS.toString(), ParameterCode.IF_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.IF_TYPE.toString(), ParameterCode.IF_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.IF_OPER_STAT.toString(), ParameterCode.IF_OPER_STAT);
        snmpKeyToParamCodeMap.put(MibItem.IF_NAME.toString(), ParameterCode.IF_NAME);
        snmpKeyToParamCodeMap.put(MibItem.IF_HIGH_SPEED.toString(), ParameterCode.IF_HIGH_SPEED);
        snmpKeyToParamCodeMap.put(MibItem.IF_DESCRIPTION.toString(), ParameterCode.IF_DESCRIPTION);
        snmpKeyToParamCodeMap.put(MibItem.IF_PHYS_ADDRESS.toString(), ParameterCode.IF_PHYSICAL_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.IF_LAST_CHANGED.toString(), ParameterCode.IF_LAST_UPDATE);
        snmpKeyToParamCodeMap.put(MibItem.IF_CONNECTED_SFP_CONNECTOR.toString(), ParameterCode.IF_CONNECTED_SFP_CONNECTOR);
        snmpKeyToParamCodeMap.put(MibItem.IF_CONNECTED_SFP_VENDOR_NAME.toString(), ParameterCode.IF_CONNECTED_SFP_VENDOR_NAME);
        snmpKeyToParamCodeMap.put(MibItem.IF_CONNECTED_SFP_CAP_BIT_RATE.toString(), ParameterCode.IF_CONNECTED_SFP_SPEED);
        snmpKeyToParamCodeMap.put(MibItem.IF_CONNECTED_SFP_VENDOR_OUI.toString(), ParameterCode.IF_CONNECTED_SFP_VENDOR_OUI);
        snmpKeyToParamCodeMap.put(MibItem.FC_IF_CONNECT_MODE.toString(), ParameterCode.FC_IF_CONNECT_MODE);
        snmpKeyToParamCodeMap.put(MibItem.FC_IF_PORT_ADMIN_SPEED.toString(), ParameterCode.FC_IF_PORT_ADMIN_SPEED);
        snmpKeyToParamCodeMap.put(MibItem.FC_IF_PORT_ADMIN_TYPE.toString(), ParameterCode.FC_IF_PORT_ADMIN_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.FC_IF_PORT_OPER_TYPE.toString(), ParameterCode.FC_IF_PORT_OPER_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.FC_IF_PORT_WWN.toString(), ParameterCode.FC_IF_PORT_WWN);
        snmpKeyToParamCodeMap.put(MibItem.PSCSI_BUS_ID.toString(), ParameterCode.PSCSI_BUS_ID);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_PORTAL_IP_ADDRESS.toString(), ParameterCode.ISCSI_PORTAL_IP_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_PORTAL_PORT.toString(), ParameterCode.ISCSI_PORTAL_PORT);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_PORTAL_ROLES.toString(), ParameterCode.ISCSI_PORTAL_ROLE);
        snmpKeyToParamCodeMap.put(MibItem.STORAGE_DOMAIN_FAULTY_INTERVAL.toString(), ParameterCode.VSWITCH_FAULTY_INTERVAL);
        snmpKeyToParamCodeMap.put(MibItem.STORAGE_DOMAIN_KEEPALIVE_INTERVAL.toString(), ParameterCode.VSWITCH_KEEPALIVE_INTERVAL);
        snmpKeyToParamCodeMap.put(MibItem.STORAGE_DOMAIN_LAST_KEEPALIVE.toString(), ParameterCode.VSWITCH_LAST_KEEPALIVE);
        snmpKeyToParamCodeMap.put(MibItem.STORAGE_DOMAIN_SUSPICIOUS_INTERVAL.toString(), ParameterCode.VSWITCH_SUSPICIOUS_INTERVAL);
        snmpKeyToParamCodeMap.put(MibItem.STORAGE_DOMAIN_TAKE_OVER_STATE.toString(), ParameterCode.VSWITCH_TAKE_OVER_STATE);
        snmpKeyToParamCodeMap.put(MibItem.STORAGE_DOMAIN_FAILOVER_ENABLE.toString(), ParameterCode.VSWITCH_FAILOVER_ENABLE);
        snmpKeyToParamCodeMap.put(MibItem.NEIGHBOR_LAST_KEEPALIVE.toString(), ParameterCode.NEIGHBOR_LAST_KEEPALIVE);
        snmpKeyToParamCodeMap.put(MibItem.NEIGHBOR_RETRIES.toString(), ParameterCode.NEIGHBOR_RETRIES);
        snmpKeyToParamCodeMap.put(MibItem.NEIGHBOR_STATUS.toString(), ParameterCode.NEIGHBOR_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.NEIGHBOR_TIMEOUT.toString(), ParameterCode.NEIGHBOR_TIMEOUT);
        snmpKeyToParamCodeMap.put(MibItem.NEIGHBOR_TADDRESS.toString(), ParameterCode.NEIGHBOR_TADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.MANAGER_READ_COMMUNITY.toString(), ParameterCode.MANAGER_READ_COMMUNITY);
        snmpKeyToParamCodeMap.put(MibItem.MANAGER_TRAPS_ENABLE.toString(), ParameterCode.MANAGER_TRAP_ENABLE);
        snmpKeyToParamCodeMap.put(MibItem.MANAGER_TRAP_PORT.toString(), ParameterCode.MANAGER_TRAP_PORT);
        snmpKeyToParamCodeMap.put(MibItem.MANAGER_WRITE_COMMUNITY.toString(), ParameterCode.MANAGER_WRITE_COMMUNITY);
        snmpKeyToParamCodeMap.put(MibItem.MANAGER_IP_ADDRESS.toString(), ParameterCode.MANAGER_IP_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.IF_DISCONTINUITY.toString(), ParameterCode.IF_DISCONTINUITY);
        snmpKeyToParamCodeMap.put(MibItem.IF_IN_BROADCAST_PKTS.toString(), ParameterCode.IF_IN_BROADCAST_PKTS);
        snmpKeyToParamCodeMap.put(MibItem.VSWITCH_DATE_AND_TIME.toString(), ParameterCode.VSWITCH_DATE_AND_TIME);
        snmpKeyToParamCodeMap.put(MibItem.IF_IN_DISCARDS.toString(), ParameterCode.IF_IN_DISCARDS);
        snmpKeyToParamCodeMap.put(MibItem.IF_IN_ERRORS.toString(), ParameterCode.IF_IN_ERRORS);
        snmpKeyToParamCodeMap.put(MibItem.IF_IN_MULTICAST_PKTS.toString(), ParameterCode.IF_IN_MULTICAST_PKTS);
        snmpKeyToParamCodeMap.put(MibItem.IF_IN_OCTET.toString(), ParameterCode.IF_IN_OCTET);
        snmpKeyToParamCodeMap.put(MibItem.IF_IN_UNKNOWN_PROTOCOLS.toString(), ParameterCode.IF_IN_UNKNOWN_PROTOCOLS);
        snmpKeyToParamCodeMap.put(MibItem.IF_OUT_BROADCAST_PKTS.toString(), ParameterCode.IF_OUT_BROADCAST_PKTS);
        snmpKeyToParamCodeMap.put(MibItem.IF_OUT_DISCARDS.toString(), ParameterCode.IF_OUT_DISCARDS);
        snmpKeyToParamCodeMap.put(MibItem.IF_OUT_ERRORS.toString(), ParameterCode.IF_OUT_ERRORS);
        snmpKeyToParamCodeMap.put(MibItem.IF_OUT_MULTICAST_PKTS.toString(), ParameterCode.IF_OUT_MULTICAST_PKTS);
        snmpKeyToParamCodeMap.put(MibItem.IF_OUT_OCTET.toString(), ParameterCode.IF_OUT_OCTET);
        snmpKeyToParamCodeMap.put(MibItem.IF_OUT_UNICAST.toString(), ParameterCode.IF_OUT_UNICAST);
        snmpKeyToParamCodeMap.put(MibItem.IF_IN_UNICAST.toString(), ParameterCode.IF_IN_UNICAST);
        snmpKeyToParamCodeMap.put(MibItem.IP_ROUTING_DISCARDS.toString(), ParameterCode.IP_ROUTING_DISCARDS);
        snmpKeyToParamCodeMap.put(MibItem.IP_FRAG_CREATES.toString(), ParameterCode.IP_FRAG_CREATES);
        snmpKeyToParamCodeMap.put(MibItem.IP_FRAG_FAIL.toString(), ParameterCode.IP_FRAG_FAIL);
        snmpKeyToParamCodeMap.put(MibItem.IP_FRAG_OK.toString(), ParameterCode.IP_FRAG_OK);
        snmpKeyToParamCodeMap.put(MibItem.IP_IN_ADDRESS_ERROR.toString(), ParameterCode.IP_IN_ADDRESS_ERROR);
        snmpKeyToParamCodeMap.put(MibItem.IP_IN_DELIVERS.toString(), ParameterCode.IP_IN_DELIVERS);
        snmpKeyToParamCodeMap.put(MibItem.IP_IN_DISCARDS.toString(), ParameterCode.IP_IN_DISCARDS);
        snmpKeyToParamCodeMap.put(MibItem.IP_IN_HEADER_ERROR.toString(), ParameterCode.IP_IN_HEADER_ERROR);
        snmpKeyToParamCodeMap.put(MibItem.IP_IN_RECIVES.toString(), ParameterCode.IP_IN_RECIVES);
        snmpKeyToParamCodeMap.put(MibItem.IP_IN_UNKNOWN_PROTOCOLS.toString(), ParameterCode.IP_IN_UNKNOWN_PROTOCOLS);
        snmpKeyToParamCodeMap.put(MibItem.IP_OUT_DISCARDS.toString(), ParameterCode.IP_OUT_DISCARDS);
        snmpKeyToParamCodeMap.put(MibItem.IP_OUT_NO_ROUTES.toString(), ParameterCode.IP_OUT_NO_ROUTES);
        snmpKeyToParamCodeMap.put(MibItem.IP_OUT_REQUESTS.toString(), ParameterCode.IP_OUT_REQUESTS);
        snmpKeyToParamCodeMap.put(MibItem.IP_REASM_FAIL.toString(), ParameterCode.IP_REASM_FAIL);
        snmpKeyToParamCodeMap.put(MibItem.IP_REASM_OK.toString(), ParameterCode.IP_REASM_OK);
        snmpKeyToParamCodeMap.put(MibItem.IP_REASM_REQDS.toString(), ParameterCode.IP_REASM_REQDS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_ADDRESS_MASKS.toString(), ParameterCode.ICMP_IN_ADDRESS_MASKS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_ADDRESS_REPS.toString(), ParameterCode.ICMP_IN_ADDRESS_REPS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_DEST_UNREACH.toString(), ParameterCode.ICMP_IN_DEST_UNREACH);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_ECHO_REPS.toString(), ParameterCode.ICMP_IN_ECHO_REPS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_ECHOES.toString(), ParameterCode.ICMP_IN_ECHOES);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_ERRORS.toString(), ParameterCode.ICMP_IN_ERRORS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_MSGS.toString(), ParameterCode.ICMP_IN_MSGS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_PARAMS_PROBS.toString(), ParameterCode.ICMP_IN_PARAMS_PROBS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_REDIRECTS.toString(), ParameterCode.ICMP_IN_REDIRECTS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_SRC_QUENCHES.toString(), ParameterCode.ICMP_IN_SRC_QUENCHES);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_TIME_EXCDS.toString(), ParameterCode.ICMP_IN_TIME_EXCDS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_TIMESTAMP_REPS.toString(), ParameterCode.ICMP_IN_TIMESTAMP_REPS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_IN_TIMESTAMPS.toString(), ParameterCode.ICMP_IN_TIMESTAMPS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_ADDRESS_MASKS.toString(), ParameterCode.ICMP_OUT_ADDRESS_MASKS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_ADDRESS_REPS.toString(), ParameterCode.ICMP_OUT_ADDRESS_REPS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_DEST_UNREACHS.toString(), ParameterCode.ICMP_OUT_DEST_UNREACHS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_ECHO_REPS.toString(), ParameterCode.ICMP_OUT_ECHO_REPS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_ECHOES.toString(), ParameterCode.ICMP_OUT_ECHOES);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_ECHOES.toString(), ParameterCode.ICMP_OUT_ECHOES);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_ERRORS.toString(), ParameterCode.ICMP_OUT_ERRORS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_MSGS.toString(), ParameterCode.ICMP_OUT_MSGS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_PARAMS_PROBS.toString(), ParameterCode.ICMP_OUT_PARAMS_PROBS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_REDIRECTS.toString(), ParameterCode.ICMP_OUT_REDIRECTS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_SRC_QUENCHES.toString(), ParameterCode.ICMP_OUT_SRC_QUENCHES);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_TIME_EXCDS.toString(), ParameterCode.ICMP_OUT_TIME_EXCDS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_TIMESTAMP_REPS.toString(), ParameterCode.ICMP_OUT_TIMESTAMP_REPS);
        snmpKeyToParamCodeMap.put(MibItem.ICMP_OUT_TIMESTAMPS.toString(), ParameterCode.ICMP_OUT_TIMESTAMPS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_ACTIVE_OPENS.toString(), ParameterCode.TCP_ACTIVE_OPENS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_ATTEMPT_FAILS.toString(), ParameterCode.TCP_ATTEMPT_FAILS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_CURR_ESTAB.toString(), ParameterCode.TCP_CURR_ESTAB);
        snmpKeyToParamCodeMap.put(MibItem.TCP_ESTAB_RESETS.toString(), ParameterCode.TCP_ESTAB_RESETS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_IN_ERRORS.toString(), ParameterCode.TCP_IN_ERRORS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_IN_SEGS.toString(), ParameterCode.TCP_IN_SEGS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_OUT_RSTS.toString(), ParameterCode.TCP_OUT_RSTS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_OUT_SEGS.toString(), ParameterCode.TCP_OUT_SEGS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_PASSIVE_OPENS.toString(), ParameterCode.TCP_PASSIVE_OPENS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_RETRANS_SEGS.toString(), ParameterCode.TCP_RETRANS_SEGS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_CONN_LOCAL_ADDRESS.toString(), ParameterCode.TCP_CONN_LOCAL_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_CONN_LOCAL_PORTS.toString(), ParameterCode.TCP_CONN_LOCAL_PORTS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_CONN_REMOTE_ADDRESS.toString(), ParameterCode.TCP_CONN_REMOTE_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.TCP_CONN_REMOTE_PORT.toString(), ParameterCode.TCP_CONN_REMOTE_PORT);
        snmpKeyToParamCodeMap.put(MibItem.TCP_CONN_STATE.toString(), ParameterCode.TCP_CONN_STATE);
        snmpKeyToParamCodeMap.put(MibItem.UDP_IN_DATAGRAMS.toString(), ParameterCode.UDP_IN_DATAGRAMS);
        snmpKeyToParamCodeMap.put(MibItem.UDP_IN_ERRORS.toString(), ParameterCode.UDP_IN_ERRORS);
        snmpKeyToParamCodeMap.put(MibItem.UDP_NO_PORTS.toString(), ParameterCode.UDP_NO_PORTS);
        snmpKeyToParamCodeMap.put(MibItem.UDP_OUT_DATAGRAMS.toString(), ParameterCode.UDP_OUT_DATAGRAMS);
        snmpKeyToParamCodeMap.put(MibItem.UDP_LOCAL_ADDRESS.toString(), ParameterCode.UDP_LOCAL_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.UDP_LOCAL_PORT.toString(), ParameterCode.UDP_LOCAL_PORT);
        snmpKeyToParamCodeMap.put(MibItem.DR_ASYNC_PAIR_PIT_STATE.toString(), ParameterCode.DR_ASYNC_PAIR_PIT_STATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_ASYNC_PAIR_PIT_TOTAL_DATA.toString(), ParameterCode.DR_ASYNC_PAIR_PIT_TOTAL_DATA);
        snmpKeyToParamCodeMap.put(MibItem.DR_ASYNC_PAIR_PIT_PENDING_DATA.toString(), ParameterCode.DR_ASYNC_PAIR_PIT_PENDING_DATA);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_PIT_STATE.toString(), ParameterCode.DR_CONSISTENCY_GROUP_PIT_STATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_PIT_TOTAL_DATA.toString(), ParameterCode.DR_CONSISTENCY_GROUP_PIT_TOTAL_DATA);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_PIT_PENDING_DATA.toString(), ParameterCode.DR_CONSISTENCY_GROUP_PIT_PENDING_DATA);
        snmpKeyToParamCodeMap.put(MibItem.DR_VIRT_GROUP_TYPE.toString(), ParameterCode.DR_VIRT_GROUP_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.DR_VIRT_GROUP_ELEMENTS_COUNT.toString(), ParameterCode.DR_VIRT_GROUP_ELEMENTS_COUNT);
        snmpKeyToParamCodeMap.put(MibItem.DR_VIRT_GROUP_ALIAS.toString(), ParameterCode.DR_VIRT_GROUP_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.DR_VIRT_GROUP_STATE.toString(), ParameterCode.DR_VIRT_GROUP_STATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_ROLE.toString(), ParameterCode.DR_CONSISTENCY_GROUP_ROLE);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_PIT_POLICY.toString(), ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_TRANS_POLICY.toString(), ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_MERGE_POLICY.toString(), ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_ACTIVATE.toString(), ParameterCode.DR_CONSISTENCY_GROUP_ACTIVATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_MODE.toString(), ParameterCode.DR_CONSISTENCY_GROUP_MODE);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_OWNED_BY.toString(), ParameterCode.DR_CONSISTENCY_GROUP_OWNED_BY);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_REPLICATION_STATE.toString(), ParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_STATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_PENDING_DATA.toString(), ParameterCode.DR_CONSISTENCY_GROUP_PENDING_DATA);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_PENDING_PITS.toString(), ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_INITIAL_SYNC_STATE.toString(), ParameterCode.DR_CONSISTENCY_GROUP_INITIAL_SYNC_STATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_ROW_STATUS.toString(), ParameterCode.DR_CONSISTENCY_GROUP_ROW_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_NEXT_REPLICATION_SCHEDULE.toString(), ParameterCode.DR_CONSISTENCY_GROUP_NEXT_REPLICATION_SCHEDULE);
        snmpKeyToParamCodeMap.put(MibItem.DR_GROUP_LAST_PIT_MERGE.toString(), ParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE);
        snmpKeyToParamCodeMap.put(MibItem.DR_PAIR_TYPE.toString(), ParameterCode.DR_PAIR_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.DR_PAIR_PRIMARY_ID.toString(), ParameterCode.DR_PAIR_PRIMARY_ID);
        snmpKeyToParamCodeMap.put(MibItem.DR_PAIR_SCONDARY_ID.toString(), ParameterCode.DR_PAIR_SECONDARY_ID);
        snmpKeyToParamCodeMap.put(MibItem.DR_PAIR_INITIAL_SYNC_TYPE.toString(), ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.DR_PAIR_MODE.toString(), ParameterCode.DR_PAIR_MODE);
        snmpKeyToParamCodeMap.put(MibItem.DR_PAIR_STATE.toString(), ParameterCode.DR_PAIR_STATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_PAIR_INITIAL_SYNC_STATE.toString(), ParameterCode.DR_PAIR_INITIAL_SYNC_STATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED.toString(), ParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED);
        snmpKeyToParamCodeMap.put(MibItem.DR_PAIR_ROW_STATUS.toString(), ParameterCode.DR_PAIR_ROW_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.DR_ASYNC_PAIR_JOURNAL_ID.toString(), ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID);
        snmpKeyToParamCodeMap.put(MibItem.DR_ASYNC_PAIR_GROUP_ID.toString(), ParameterCode.DR_ASYNC_PAIR_GROUP_ID);
        snmpKeyToParamCodeMap.put(MibItem.DR_ASYNC_PAIR_ACTIVATE.toString(), ParameterCode.DR_ASYNC_PAIR_ACTIVATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_ASYNC_PAIR_REPLICATION_STATE.toString(), ParameterCode.DR_ASYNC_PAIR_REPLICATION_STATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_ASYNC_PAIR_PENDING_DATA.toString(), ParameterCode.DR_ASYNC_PAIR_PENDING_DATA);
        snmpKeyToParamCodeMap.put(MibItem.DR_ASYNC_PAIR_PENDING_PITS.toString(), ParameterCode.DR_ASYNC_PAIR_PENDING_PITS);
        snmpKeyToParamCodeMap.put(MibItem.DR_ASYNC_PAIR_SNAPSHOT_ID.toString(), ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID);
        snmpKeyToParamCodeMap.put(MibItem.DR_ASYNC_PAIR_LAST_PIT_MERGE.toString(), ParameterCode.DR_ASYNC_PAIR_LAST_PIT_MERGE);
        snmpKeyToParamCodeMap.put(MibItem.DR_SYNC_PAIR_ACTIVATE.toString(), ParameterCode.DR_SYNC_PAIR_ACTIVATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_SYNC_PAIR_ROLE.toString(), ParameterCode.DR_SYNC_PAIR_ROLE);
        snmpKeyToParamCodeMap.put(MibItem.DR_SYNC_PAIR_REPLICATION_STATE.toString(), ParameterCode.DR_SYNC_PAIR_REPLICATION_STATE);
        snmpKeyToParamCodeMap.put(MibItem.DR_POLICY_PTR.toString(), ParameterCode.POLICY_POINTER_TO_PARAM);
        snmpKeyToParamCodeMap.put(MibItem.DR_POLICY_STARTING_AT.toString(), ParameterCode.POLICY_START_AT);
        snmpKeyToParamCodeMap.put(MibItem.DR_POLICY_ROW_STATUS.toString(), ParameterCode.POLICY_ROW_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.DR_POLICY_PARAM_TYPE.toString(), ParameterCode.POLICY_PARAM_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.DR_POLICY_PARAM_PARAM1.toString(), ParameterCode.POLICY_PARAM_PARAM1);
        snmpKeyToParamCodeMap.put(MibItem.DR_POLICY_PARAM_PARAM2.toString(), ParameterCode.POLICY_PARAM_PARAM2);
        snmpKeyToParamCodeMap.put(MibItem.DR_POLICY_PARAM_ROW_STATUS.toString(), ParameterCode.POLICY_PARAM_ROW_STATUS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_CID.toString(), ParameterCode.ISCSI_CONNECTION_CID);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_DATA_INTEGRITY.toString(), ParameterCode.ISCSI_CONNECTION_DATA_INTEGRITY);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_HEADER_INTEGRITY.toString(), ParameterCode.ISCSI_CONNECTION_HEADER_INTEGRITY);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_LOCAL_ADDRESS.toString(), ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_LOCAL_ADDRESS_TYPE.toString(), ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_LOCAL_PORT.toString(), ParameterCode.ISCSI_CONNECTION_LOCAL_PORT);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_MAX_RECEIVED_PDU_LENGTH.toString(), ParameterCode.ISCSI_CONNECTION_MAX_RECEIVED_PDU_LENGTH);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_MAX_TRANSMIT_PDU_LENGTH.toString(), ParameterCode.ISCSI_CONNECTION_MAX_TRANSMIT_PDU_LENGTH);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_REMOTE_ADDRESS.toString(), ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_REMOTE_ADDRESS.toString(), ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_REMOTE_ADDRESS_TYPE.toString(), ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_REMOTE_PORT.toString(), ParameterCode.ISCSI_CONNECTION_REMOTE_PORT);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_STATE.toString(), ParameterCode.ISCSI_CONNECTION_STATE);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INSTANCE_DESCRIPTION.toString(), ParameterCode.ISCSI_INSTANCE_DESCRIPTION);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INSTANCE_LAST_FAILURE_REMOTE_NODE_NAME.toString(), ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_REMOTE_NODE_NAME);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INSTANCE_LAST_FAILURE_TYPE.toString(), ParameterCode.ISCSI_INSTANCE_LAST_FAILURE_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INSTANCE_NUM_OF_NODES.toString(), ParameterCode.ISCSI_INSTANCE_NUM_OF_NODES);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INSTANCE_NUM_OF_PORTALS.toString(), ParameterCode.ISCSI_INSTANCE_NUM_OF_PORTALS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE.toString(), ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSION_FAILURE);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INSTANCE_NUM_OF_SESSIONS.toString(), ParameterCode.ISCSI_INSTANCE_NUM_OF_SESSIONS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INSTANCE_VENDOR_ID.toString(), ParameterCode.ISCSI_INSTANCE_VENDOR_ID);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INSTANCE_VENDOR_VERSION.toString(), ParameterCode.ISCSI_INSTANCE_VENDOR_VERSION);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INSTANCE_VERSION_MAX.toString(), ParameterCode.ISCSI_INSTANCE_VERSION_MAX);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_INSTANCE_VERSION_MIN.toString(), ParameterCode.ISCSI_INSTANCE_VERSION_MIN);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_PORTAL_PORT.toString(), ParameterCode.ISCSI_PORTAL_PORT);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_PORTAL_IP_ADDRESS.toString(), ParameterCode.ISCSI_PORTAL_IP_ADDRESS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_REMOTE_INITIATOR_ATTACHED_TIMES.toString(), ParameterCode.ISCSI_REMOTE_INITIATOR_ATTACHED_TIMES);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_REMOTE_INITIATOR_NAME.toString(), ParameterCode.ISCSI_REMOTE_INITIATOR_NAME);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_REMOTE_OUT_COMMANDS.toString(), ParameterCode.ISCSI_REMOTE_OUT_COMMANDS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_REMOTE_READ_MB.toString(), ParameterCode.ISCSI_REMOTE_READ_MB);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_REMOTE_WRITTEN_MB.toString(), ParameterCode.ISCSI_REMOTE_WRITTEN_MB);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_AUTH_IDENTITY.toString(), ParameterCode.ISCSI_SESSION_AUTH_IDENTITY);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_CMD_PDUS.toString(), ParameterCode.ISCSI_SESSION_CMD_PDUS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_DIGEST_ERRORS.toString(), ParameterCode.ISCSI_SESSION_DIGEST_ERRORS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_INITIATOR_ALIAS.toString(), ParameterCode.ISCSI_SESSION_INITIATOR_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_INITIATOR_NAME.toString(), ParameterCode.ISCSI_SESSION_INITIATOR_NAME);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_ISID.toString(), ParameterCode.ISCSI_SESSION_ISID);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_RSP_PDUS.toString(), ParameterCode.ISCSI_SESSION_RSP_PDUS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_RX_DATA_OCTETS.toString(), ParameterCode.ISCSI_SESSION_RX_DATA_OCTETS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_DIRECTION.toString(), ParameterCode.ISCSI_SESSION_DIRECTION);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_TARGET_ALIAS.toString(), ParameterCode.ISCSI_SESSION_TARGET_ALIAS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_TARGET_NAME.toString(), ParameterCode.ISCSI_SESSION_TARGET_NAME);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_TIMEOUT_ERRORS.toString(), ParameterCode.ISCSI_SESSION_TIMEOUT_ERRORS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_TSIH.toString(), ParameterCode.ISCSI_SESSION_TSIH);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_TX_DATA_OCTETS.toString(), ParameterCode.ISCSI_SESSION_TX_DATA_OCTETS);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_SESSION_TYPE.toString(), ParameterCode.ISCSI_SESSION_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.ISCSI_CONNECTION_LAST_CHANGE.toString(), ParameterCode.ISCSI_CONNECTION_LAST_CHANGE);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TRANSPORT_TYPE.toString(), ParameterCode.SCSI_TRANSPORT_TYPE);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TRANSPORT_POINTER.toString(), ParameterCode.SCSI_TRANSPORT_POINTER);
        snmpKeyToParamCodeMap.put(MibItem.SCSI_TRANSPORT_DEVICE_NAME.toString(), ParameterCode.SCSI_TRANSPORT_DEVICE_NAME);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_HOST_NAME.toString(), ParameterCode.VSWITCH_HOST_NAME);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_IP_ADDRESS.toString(), ParameterCode.VSWITCH_IP_ADDRESS);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_IP_MASK.toString(), ParameterCode.VSWITCH_IP_MASK);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_READ_COMMUNITY.toString(), ParameterCode.VSWITCH_READ_COMMUNITY);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_RETRIES.toString(), ParameterCode.VSWITCH_MAX_RETRIES);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_SNMP_PORT.toString(), ParameterCode.VSWITCH_SNMP_UDP_PORT);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_SNMP_VERSION.toString(), ParameterCode.VSWITCH_SNMP_VERSION);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_TIMEOUT.toString(), ParameterCode.VSWITCH_TIMEOUT);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_TRAP_PORT.toString(), ParameterCode.VSWITCH_TRAP_UDP_PORT);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_WRITE_COMMUNITY.toString(), ParameterCode.VSWITCH_WRITE_COMMUNITY);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_HOST_NAME.toString(), ParameterCode.VSWITCH_HOST_NAME);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_STATE.toString(), ParameterCode.VSWITCH_CONNECTIVITY_STATUS);
        snmpKeyToParamCodeMap.put(DBItem.VSWITCH_GROUP_ID.toString(), ParameterCode.VSWITCH_GROUP_ID);
        snmpKeyToParamCodeMap.put(DBItem.PARENT_SITE_ID.toString(), ParameterCode.PARENT_SITE_ID);
        snmpKeyToParamCodeMap.put(DBItem.CLUSTER_ALIAS.toString(), ParameterCode.CLUSTER_ALIAS);
        snmpKeyToParamCodeMap.put(DBItem.SITE_ALIAS.toString(), ParameterCode.SITE_ALIAS);
        snmpKeyToParamCodeMap.put(DBItem.CLUSTER_MODE.toString(), ParameterCode.CLUSTER_MODE);
        snmpKeyToParamCodeMap.put(DBItem.ALARM_TYPE_NAME.toString(), ParameterCode.ALARM_TYPE_NAME);
        snmpKeyToParamCodeMap.put(DBItem.ALARM_TYPE_CALL_HOME.toString(), ParameterCode.ALARM_TYPE_CALL_HOME);
        snmpKeyToParamCodeMap.put(DBItem.ALARM_TYPE_CATEGORY.toString(), ParameterCode.ALARM_TYPE_CATEGORY);
        snmpKeyToParamCodeMap.put(DBItem.ALARM_TYPE_EMAIL.toString(), ParameterCode.ALARM_TYPE_EMAIL);
        snmpKeyToParamCodeMap.put(DBItem.ALARM_TYPE_ID.toString(), ParameterCode.ALARM_TYPE_ID);
        snmpKeyToParamCodeMap.put(DBItem.ALARM_TYPE_SEVERITY.toString(), ParameterCode.ALARM_TYPE_SEVERITY);
        snmpKeyToParamCodeMap.put(DBItem.EMAIL_CONTACT_FROM_ADDRESS.toString(), ParameterCode.EMAIL_CONTACT_FROM_ADDRESS);
        snmpKeyToParamCodeMap.put(DBItem.EMAIL_CONTACT_SMTP_HOST.toString(), ParameterCode.EMAIL_CONTACT_SMTP_HOST);
        snmpKeyToParamCodeMap.put(DBItem.EMAIL_CONTACT_TO_ADDRESS.toString(), ParameterCode.EMAIL_CONTACT_TO_ADDRESS);
        snmpKeyToParamCodeMap.put(DBItem.EMAIL_CONTACT_SMTP_USER.toString(), ParameterCode.EMAIL_CONTACT_SMTP_USER);
        snmpKeyToParamCodeMap.put(DBItem.EMAIL_CONTACT_SMTP_PASSWORD.toString(), ParameterCode.EMAIL_CONTACT_SMTP_PASSWORD);
        snmpKeyToParamCodeMap.put(DBItem.ALARM_TYPE_TROUBLESHOOTING.toString(), ParameterCode.ALARM_TYPE_TROUBLESHOOTING);
        snmpKeyToParamCodeMap.put(DBItem.GENERAL_POLL_INTERVAL.toString(), ParameterCode.GENERAL_POLL_INTERVAL);
        snmpKeyToParamCodeMap.put(DBItem.VIRTUALIZATION_POLL_INTERVAL.toString(), ParameterCode.VIRTUALIZATION_POLL_INTERVAL);
        snmpKeyToParamCodeMap.put(DBItem.ACL_POLL_INTERVAL.toString(), ParameterCode.ACL_POLL_INTERVAL);
        snmpKeyToParamCodeMap.put(DBItem.NET_POLL_INTERVAL.toString(), ParameterCode.NET_POLL_INTERVAL);
        snmpKeyToParamCodeMap.put(DBItem.PITS_POLL_INTERVAL.toString(), ParameterCode.PIT_POLL_INTERVAL);
        snmpKeyToParamCodeMap.put(DBItem.STATISTIC_POLL_INTERVAL.toString(), ParameterCode.STATISTIC_POLL_INTERVAL);
        snmpKeyToParamCodeMap.put(DBItem.CLUSTER_STORAGE_COMPARISON.toString(), ParameterCode.CLUSTER_STORAGE_COMPARISON);
    }

    public void addParameterCodeToKeyMap(ParameterCode code, MibItem mibItem) {
        this.addParameterCodeToKeyMap(code, this.makeKeyArrayFromMibItem(mibItem));
    }

    public void addParameterCodeToKeyMap(ParameterCode code, DBItem dbItem) {
        this.addParameterCodeToKeyMap(code, this.makeKeyArrayFromDBItem(dbItem));
    }

    private void addParameterCodeToKeyMap(ParameterCode code, Object item) {
        paramCodeToKeyMap.put(code, item);
        snmpKeyToParamCodeMap.put(item.toString(), code);
    }
}

