/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr;

import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.SrElementOperationErrorException;
import com.sanrad.nms.server.exception.SrElementOperationException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;

public class ClusterConfigurator
extends ElementConfigurator {
    public ClusterConfigurator() {
        super(ClassID.CLUSTER, "", null, null);
    }

    public ConfigElementDataList getAll() throws SrCommunicationException {
        CommVarBindList[] clusterList = CommMgr.getInstance('z').getAllClustersData();
        ConfigElementDataList elementList = new ConfigElementDataList();
        for (int i = 0; i < clusterList.length; ++i) {
            ConfigElementData element = this.createConfigElementFromTableRow(clusterList[i]);
            SrInteger key = (SrInteger)element.getValue(ParameterCode.VSWITCH_GROUP_ID);
            CommKey[] allKeys = new CommKey[]{new DataBaseCommKey(key.toString())};
            element.setCommKeys(allKeys);
            SrInteger parentKey = (SrInteger)element.getValue(ParameterCode.PARENT_SITE_ID);
            if (parentKey != null) {
                CommKey[] parentKeys = new CommKey[]{new DataBaseCommKey(parentKey.toString())};
                element.setValue(ParameterCode.PARENT_SITE_ID, new CommKeyClassId(parentKeys, ClassID.SITE));
            }
            elementList.add(element);
        }
        this.sendDiscoveredElementsToEventMgr(elementList, null);
        return elementList;
    }

    public void internalCreate(ConfigElementData element) throws SrCommunicationException, MissingValueException, SrElementOperationException {
        SrInteger clusterId = (SrInteger)element.getValue(ParameterCode.VSWITCH_GROUP_ID);
        DataBaseCommKey dbKey = new DataBaseCommKey(clusterId.toString());
        CommKey[] key = new CommKey[]{dbKey};
        element.setCommKeys(key);
        CommVarBindList varBindList = new CommVarBindList();
        this.convertParamsToVarBinds(element, varBindList);
        CommMgr.getInstance('z').addCluster(varBindList);
    }

    public boolean readAfterCreate(ConfigElementData element) throws SrCommunicationException {
        return false;
    }

    public void internalRemove(ConfigElementData element) throws SrCommunicationException {
        CommKey[] commKey = element.getCommKey();
        Integer vSwitchGroupId = new Integer(commKey[0].getKey());
        CommMgr.getInstance('z').removeCluster(vSwitchGroupId);
    }

    public void internalChange(ConfigElementData element) throws SrCommunicationException, SrElementOperationErrorException {
        CommVarBindList varBindList = new CommVarBindList();
        this.convertParamsToVarBinds(element, varBindList);
        this.addCommVarBindsToChangeList(varBindList, element);
        CommMgr.getInstance('z').changeClusterParams(varBindList);
    }

    public boolean readAfterChange(ConfigElementData element) throws SrCommunicationException {
        return false;
    }
}

