/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.statistics;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPConnectionStatisticsTableRow;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class TCPConnectionStatisticsTableRowImpl
extends TableRowImpl
implements TCPConnectionStatisticsTableRow {
    private static List parameterCodeList;

    public TCPConnectionStatisticsTableRowImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.STATISTIC_TCP_CONNECTION, parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        String localIP = this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.TCP_CONN_LOCAL_ADDRESS);
        Integer localPort = (Integer)this.getValueOf(null, ParameterCode.TCP_CONN_LOCAL_PORTS, true);
        String remoteIP = this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.TCP_CONN_REMOTE_ADDRESS);
        Integer remotePort = (Integer)this.getValueOf(null, ParameterCode.TCP_CONN_REMOTE_PORT, true);
        StringBuffer sb = new StringBuffer(this.getParentVSwitch().getName());
        sb.append(" TCP connection statistics ");
        sb.append(localIP);
        sb.append(":");
        sb.append(localPort);
        sb.append("<->");
        sb.append(remoteIP);
        sb.append(":");
        sb.append(remotePort);
        this.toStringValue = sb.toString();
        return changedValues;
    }

    protected String canBeDeleted() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.TCP_CONN_LOCAL_ADDRESS);
        parameterCodes.addElement(ParameterCode.TCP_CONN_LOCAL_PORTS);
        parameterCodes.addElement(ParameterCode.TCP_CONN_REMOTE_ADDRESS);
        parameterCodes.addElement(ParameterCode.TCP_CONN_REMOTE_PORT);
        parameterCodes.addElement(ParameterCode.TCP_CONN_STATE);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

