/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.statistics;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfaceStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfacesGroupStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.NetworkingStatisticsImpl;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class InterfacesGroupStatisticsImpl
extends NetworkingStatisticsImpl
implements InterfacesGroupStatistics {
    private static List emptyList = Collections.unmodifiableList(Arrays.asList(new Vector().toArray()));
    private static HashMap emptyHashMap = new HashMap();
    private VSwitchImpl vswitch = null;

    public InterfacesGroupStatisticsImpl(VSwitchImpl vswitch) throws RemoteException {
        super((ClusterImpl)vswitch.getCluster(), ClassID.STATISTIC_INTERFACES_GROUP, emptyList, emptyHashMap);
        this.vswitch = vswitch;
    }

    public VSwitch getParentVSwitch() throws RemoteException {
        return this.vswitch;
    }

    protected PollingGroupType getGroupType() {
        return PollingGroupType.INTERFACE_GROUP_TYPE;
    }

    public int stopPolling() throws RemoteException, IllegalValueException {
        int counter = super.stopPolling();
        if (counter == 0) {
            this.clearInterfacesData();
        }
        return counter;
    }

    private void clearInterfacesData() throws RemoteException {
        VSwitch vSwitch = this.getParentVSwitch();
        Vector interfaces = vSwitch.getInterfacesStatisticsTable();
        Iterator i = interfaces.iterator();
        while (i.hasNext()) {
            InterfaceStatisticsTableRowImpl currInterface = (InterfaceStatisticsTableRowImpl)i.next();
            currInterface.clearParameterListExceptForVSwitchID(vSwitch);
        }
    }
}

