/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.statistics;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ClientStateEvent;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfaceStatisticsTableRow;
import com.sanrad.nms.server.logic.vswitch.statistics.NetworkingStatisticsImpl;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class InterfaceStatisticsTableRowImpl
extends NetworkingStatisticsImpl
implements InterfaceStatisticsTableRow {
    private static List parameterCodeList;
    private static HashMap parametersToCalculateCodeMap;
    private InterfaceTableRow m_parentInterface;

    public InterfaceStatisticsTableRowImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.STATISTIC_INTERFACE, parameterCodeList, parametersToCalculateCodeMap);
    }

    protected PollingGroupType getGroupType() {
        return null;
    }

    public int stopPolling() throws RemoteException, IllegalValueException {
        throw new UnsupportedOperationException();
    }

    public void remoteClientClosed(ClientStateEvent e) {
    }

    public void startPolling() throws RemoteException {
    }

    public String getAlias() throws RemoteException {
        return (String)this.getValueOf(ParameterCode.IF_ALIAS);
    }

    public InterfaceTableRow getParentInterface() {
        return this.m_parentInterface;
    }

    public String getInterfaceAlias() throws RemoteException {
        return this.getParentInterface().getAlias();
    }

    public String getInterfaceType() throws RemoteException {
        return this.m_parentInterface.getType();
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        if (!parameterList.containsValue(null)) {
            HashMap changedValues = null;
            if (!this.getCluster().isDiscoverCompleted()) {
                Iterator i = parameterList.keySet().iterator();
                while (i.hasNext()) {
                    ParameterCode currParam = (ParameterCode)i.next();
                    if (currParam == ParameterCode.INTERFACE_ID || currParam == ParameterCode.VSWITCH_ID) continue;
                    parameterList.put(currParam, null);
                }
            }
            changedValues = super.setParameterList(parameterList);
            CommKeyClassId parentInterface = (CommKeyClassId)this.getSrValueOf(ParameterCode.INTERFACE_ID);
            this.m_parentInterface = (InterfaceTableRow)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(parentInterface);
            changedValues.put(ParameterCode.INTERFACE_ID, this.getSrValueOf(ParameterCode.INTERFACE_ID));
            return changedValues;
        }
        return new HashMap();
    }

    public String toStringValue() {
        try {
            return "InterfaceStatisticsRow: " + this.getAlias();
        }
        catch (RemoteException remoteException) {
            return "InterfaceStatisticsRow";
        }
    }

    public String toString() {
        return this.toStringValue();
    }

    static {
        parametersToCalculateCodeMap = new HashMap();
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.INTERFACE_ID);
        parameterCodes.addElement(ParameterCode.IF_OUT_OCTET);
        parameterCodes.addElement(ParameterCode.IF_IN_OCTET);
        parameterCodes.addElement(ParameterCode.IF_DISCONTINUITY);
        parameterCodes.addElement(ParameterCode.IF_IN_UNKNOWN_PROTOCOLS);
        parameterCodes.addElement(ParameterCode.IF_OUT_BROADCAST_PKTS);
        parameterCodes.addElement(ParameterCode.IF_OUT_MULTICAST_PKTS);
        parameterCodes.addElement(ParameterCode.IF_IN_BROADCAST_PKTS);
        parameterCodes.addElement(ParameterCode.IF_IN_MULTICAST_PKTS);
        parameterCodes.addElement(ParameterCode.IF_OUT_MULTICAST_PKTS);
        parameterCodes.addElement(ParameterCode.IF_IN_UNICAST);
        parameterCodes.addElement(ParameterCode.IF_OUT_UNICAST);
        parameterCodes.addElement(ParameterCode.IF_OUT_ERRORS);
        parameterCodes.addElement(ParameterCode.IF_OUT_DISCARDS);
        parameterCodes.addElement(ParameterCode.IF_IN_ERRORS);
        parameterCodes.addElement(ParameterCode.IF_IN_DISCARDS);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
        parametersToCalculateCodeMap.put(ParameterCode.IF_IN_OCTET, ClientParameterCode.IFC_STATISTICS_IN_OCTETS_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.IF_OUT_OCTET, ClientParameterCode.IFC_STATISTICS_OUT_OCTETS_PER_SEC);
        parametersToCalculateCodeMap.put(ParameterCode.IF_OUT_ERRORS, ClientParameterCode.IFC_STATISTICS_OUT_ERRORS_PER_SEC);
    }
}

