/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.pscsi;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.pscsi.PSCSIInterfaceTableRow;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import java.rmi.RemoteException;
import java.util.HashMap;

public class PSCSIInterfaceTableRowImpl
extends InterfaceTableRowImpl
implements PSCSIInterfaceTableRow {
    public PSCSIInterfaceTableRowImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.PSCSI_INTERFACE);
        this.addParameterCode(ParameterCode.PSCSI_BUS_ID);
    }

    public int getBusId() throws RemoteException {
        Integer busId = (Integer)this.getValueOf(ParameterCode.PSCSI_BUS_ID);
        return busId;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        Integer busId;
        String valid = super.isValid(parameterList);
        if (valid == null && (busId = (Integer)parameterList.get(ClientParameterCode.PSCSI_IF_BUS_ID)) != null) {
            if (busId > 15) {
                return ErrorMessage.ILLEGAL_BUS_ID.getMessage(busId.toString());
            }
            parameterList.put(ClientParameterCode.PSCSI_IF_BUS_ID, new SrInteger(busId));
        }
        return null;
    }
}

