/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.fc;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.logic.vswitch.fc.FCNode;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrOctetStringFormat;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class FCNodeImpl
extends LogicObjectImpl
implements FCNode {
    private static List parameterCodeList;
    private VSwitch parentVSwitch = null;

    public FCNodeImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.FC_NODE, parameterCodeList);
        this.addParameterCode(ParameterCode.VSWITCH_ID);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
        VSwitch vSwitch = (VSwitch)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
        this.setParentVSwitch(vSwitch);
        if (this.getValueOf(ParameterCode.FC_NODE_WWNN) != null) {
            this.toStringValue = this.getValueOf(ParameterCode.FC_NODE_WWNN).toString();
        }
        return changedValues;
    }

    private void setParentVSwitch(VSwitch vSwitch) throws RemoteException {
        if (this.parentVSwitch == null && vSwitch != null) {
            this.parentVSwitch = vSwitch;
            ((VSwitchImpl)this.parentVSwitch).setFCNode(this);
        } else if (vSwitch == null) {
            this.parentVSwitch = vSwitch;
        }
    }

    public String getWWNN() throws RemoteException {
        return this.getWWNN(null);
    }

    public String getWWNN(VSwitch vSwitch) throws RemoteException {
        SrOctetStringFormat wwnnValue = (SrOctetStringFormat)this.getSrValueOf(vSwitch, ParameterCode.FC_NODE_WWNN, vSwitch == null);
        if (wwnnValue == null) {
            return null;
        }
        return wwnnValue.toDisplayString();
    }

    public String getFunctions() throws RemoteException {
        return this.getFunctions(null);
    }

    public String getFunctions(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.FC_NODE_FUNCTIONS, vSwitch == null);
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.FC_NODE_WWNN);
        parameterCodes.addElement(ParameterCode.FC_NODE_FUNCTIONS);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

