/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch.fc;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.SFPConnectedInterfaceImpl;
import com.sanrad.nms.server.logic.vswitch.fc.FCInterfaceTableRow;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.FcAdminSpeedConstant;
import com.sanrad.nms.server.util.types.constants.FcConnectModeConstant;
import java.rmi.RemoteException;
import java.util.HashMap;

public class FCInterfaceTableRowImpl
extends SFPConnectedInterfaceImpl
implements FCInterfaceTableRow {
    public FCInterfaceTableRowImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.FC_INTERFACE);
        this.addParameterCode(ParameterCode.FC_IF_CONNECT_MODE);
        this.addParameterCode(ParameterCode.FC_IF_PORT_ADMIN_SPEED);
        this.addParameterCode(ParameterCode.FC_IF_PORT_ADMIN_TYPE);
        this.addParameterCode(ParameterCode.FC_IF_PORT_OPER_TYPE);
        this.addParameterCode(ParameterCode.FC_IF_PORT_WWN);
    }

    public String getConnectMode() throws RemoteException {
        return this.getSrValueOf(this.getParentVSwitch(), ParameterCode.FC_IF_CONNECT_MODE).toString();
    }

    public String getAdminSpeed() throws RemoteException {
        return this.getSrValueOf(this.getParentVSwitch(), ParameterCode.FC_IF_PORT_ADMIN_SPEED).toString();
    }

    public String getAdminType() throws RemoteException {
        return this.getSrValueOf(this.getParentVSwitch(), ParameterCode.FC_IF_PORT_ADMIN_TYPE).toString();
    }

    public String getOperType() throws RemoteException {
        return this.getSrValueOf(this.getParentVSwitch(), ParameterCode.FC_IF_PORT_OPER_TYPE).toString();
    }

    public String getWWPN() throws RemoteException {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.FC_IF_PORT_WWN).toString();
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String valid = super.isValid(parameterList);
        if (valid == null) {
            String connectMode;
            String speed = (String)parameterList.get(ClientParameterCode.FC_IF_SPEED);
            if (speed != null) {
                parameterList.put(ClientParameterCode.FC_IF_SPEED, FcAdminSpeedConstant.getSpeed(speed));
            }
            if ((connectMode = (String)parameterList.get(ClientParameterCode.FC_IF_TOPOLOGY)) != null) {
                parameterList.put(ClientParameterCode.FC_IF_TOPOLOGY, FcConnectModeConstant.getMode(connectMode));
            }
        }
        return valid;
    }
}

