/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.vswitch.VSwitchAlarmGenerator;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.PollingElement;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.hardware.Hardware;
import com.sanrad.nms.server.logic.hardware.HardwareImpl;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorStatistics;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorsGroupStatistics;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorsGroupStatisticsImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIInstance;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatistics;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionsGroupStatistics;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionsGroupStatisticsImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.vswitch.IPRouteTableRow;
import com.sanrad.nms.server.logic.vswitch.IPRouteTableRowValidator;
import com.sanrad.nms.server.logic.vswitch.IPTableRow;
import com.sanrad.nms.server.logic.vswitch.IPTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.IPTableRowValidator;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.Manager;
import com.sanrad.nms.server.logic.vswitch.ManagerImpl;
import com.sanrad.nms.server.logic.vswitch.Neighbor;
import com.sanrad.nms.server.logic.vswitch.NeighborImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRow;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowValidator;
import com.sanrad.nms.server.logic.vswitch.SFPConnectedInterfaceImpl;
import com.sanrad.nms.server.logic.vswitch.TableRow;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityEvent;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityListener;
import com.sanrad.nms.server.logic.vswitch.VSwitchValidator;
import com.sanrad.nms.server.logic.vswitch.fc.FCNode;
import com.sanrad.nms.server.logic.vswitch.statistics.EthernetStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.EthernetStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.ICMPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.ICMPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.IPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.IPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfaceStatisticsTableRow;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfaceStatisticsTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfacesGroupStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfacesGroupStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPConnectionStatisticsTableRow;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPStatisticsImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPListenerStatisticsTableRow;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPStatisticsImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLong;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.IscsiPortalRolesConstant;
import com.sanrad.nms.server.util.types.constants.ManualDiscoveryStatusConstant;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.nms.server.util.types.constants.ResetConstant;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.TempetureUnitConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchSysOID;
import com.sanrad.util.NetUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class VSwitchImpl
extends LogicObjectImpl
implements VSwitch,
PollingElement {
    private static List parameterCodeList;
    private static final int WAKE_ON_LAN_PORT = 9;
    private boolean connected = false;
    private boolean vSwitchDiscoverCompleted = false;
    private boolean virtualizationDiscoverCompleted = false;
    private String neighborValid = null;
    private Cluster watingMovingCluster = null;
    private VSwitch addNeighborPending = null;
    private Vector vSwitchConnectivityListeners = new Vector();
    private HardwareImpl hardwareObj = null;
    private TCPStatisticsImpl tcpImpl = null;
    private UDPStatisticsImpl udpImpl = null;
    private ICMPStatisticsImpl icmpImpl = null;
    private IPStatisticsImpl ipImpl = null;
    private EthernetStatisticsImpl ethernetImpl = null;
    private InterfacesGroupStatisticsImpl ifaceGroup = new InterfacesGroupStatisticsImpl(this);
    private FCNode fcNode;
    private Vector ipTable = new Vector();
    private Vector interfaceTable = new Vector();
    private Vector ipRouteTable = new Vector();
    private Vector portalTable = new Vector();
    private Vector neighborTable = new Vector();
    private Vector managerTable = new Vector();
    private Vector interfaceStatisticsTable = new Vector();
    private Vector m_udpListenerStatisticsTable = new Vector();
    private Vector m_tcpConnectionStatisticsTable = new Vector();
    private volatile Thread resetThread = null;
    private Vector m_iscsiInstances = new Vector();
    private Vector m_iscsiSessions = new Vector();
    private Vector m_iscsiRemoteInitiators = new Vector();
    private Vector m_iscsiRemoteInitiatorsStatistics = new Vector();
    private Vector m_iscsiSessionsStatistics = new Vector();
    private ISCSIRemoteInitiatorsGroupStatistics m_remoteInitiatorsGroupStatistics = new ISCSIRemoteInitiatorsGroupStatisticsImpl(this);
    private ISCSISessionsGroupStatisticsImpl m_sessionsGroupStatistics = new ISCSISessionsGroupStatisticsImpl(this);
    private ArrayList m_iscsiInitiators = new ArrayList();
    private String m_ipAddr = null;

    public boolean isInterfaceAliasExist(String alias) throws RemoteException {
        Enumeration e = this.getInterfaceTable().elements();
        while (e.hasMoreElements()) {
            InterfaceTableRow row = (InterfaceTableRow)e.nextElement();
            if (!row.getAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    public VSwitchImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.VSWITCH, parameterCodeList);
        this.addConnectivityListener(cluster);
    }

    public Hardware getHardware() throws RemoteException {
        return this.hardwareObj;
    }

    public void setHardware(HardwareImpl hardware) throws RemoteException {
        this.hardwareObj = hardware;
    }

    public void setTCPStatistics(TCPStatisticsImpl tcp) {
        this.tcpImpl = tcp;
    }

    public void setUDPStatistics(UDPStatisticsImpl udp) {
        this.udpImpl = udp;
    }

    public void setICMPStatistics(ICMPStatisticsImpl icmp) {
        this.icmpImpl = icmp;
    }

    public void setIPStatistics(IPStatisticsImpl ip) {
        this.ipImpl = ip;
    }

    public void setEthernetStatistics(EthernetStatisticsImpl ethernet) {
        this.ethernetImpl = ethernet;
    }

    public TempetureUnitConstant getTempUnits() throws RemoteException {
        return (TempetureUnitConstant)this.getSrValueOf(this, ParameterCode.TEMPERATURE_UNITS);
    }

    public void addConnectivityListener(VSwitchConnectivityListener listener) {
        this.vSwitchConnectivityListeners.add(listener);
    }

    public void removeConnectivityListener(VSwitchConnectivityListener listener) {
        this.vSwitchConnectivityListeners.remove(listener);
    }

    private void fireConnectivityChanged(boolean connectivityState) {
        VSwitchConnectivityEvent event = new VSwitchConnectivityEvent(this, this, connectivityState);
        Iterator itr = this.vSwitchConnectivityListeners.iterator();
        while (itr.hasNext()) {
            ((VSwitchConnectivityListener)itr.next()).vSwitchConnectivityChanged(event);
        }
    }

    private HashMap getManagerParameterList(HashMap parameterList) {
        HashMap managerParameterList = new HashMap();
        if (parameterList.containsKey(ClientParameterCode.VSWITCH_READ_COMMUNITY)) {
            managerParameterList.put(ClientParameterCode.MANAGER_READ_COMMUNITY, parameterList.get(ClientParameterCode.VSWITCH_READ_COMMUNITY));
        }
        if (parameterList.containsKey(ClientParameterCode.VSWITCH_WRITE_COMMUNITY)) {
            managerParameterList.put(ClientParameterCode.MANAGER_WRITE_COMMUNITY, parameterList.get(ClientParameterCode.VSWITCH_WRITE_COMMUNITY));
        }
        if (parameterList.containsKey(ClientParameterCode.VSWITCH_TRAP_PORT)) {
            managerParameterList.put(ClientParameterCode.MANAGER_TRAP_PORT, parameterList.get(ClientParameterCode.VSWITCH_TRAP_PORT));
        }
        return managerParameterList;
    }

    public void changeElement(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap tmpParameterList = new HashMap(parameterList);
        String msg = this.isValid(tmpParameterList);
        if (msg != null) {
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        HashMap managerParameterList = this.getManagerParameterList(parameterList);
        if (managerParameterList != null) {
            Vector managers = this.getThisMachineManagers();
            Enumeration e = managers.elements();
            while (e.hasMoreElements()) {
                Manager manager = (Manager)e.nextElement();
                manager.changeElement(managerParameterList);
            }
        }
        super.changeElement(parameterList);
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        Boolean reportLUNDiscovery;
        Boolean failover;
        Integer faulty;
        Integer suspicious;
        Integer keepAlive;
        BigInteger telnetPort;
        String writeCommunity;
        String readCommunity;
        Integer retries;
        Integer switchId;
        Integer trapPort;
        Integer snmpPort;
        Long timeout;
        Long time;
        String location;
        String contact;
        String name = (String)parameterList.get(ClientParameterCode.VSWITCH_NAME);
        if (name != null) {
            if (name.trim().equals("")) {
                return ClassID.VSWITCH + " name cannot be empty. Please select another name.";
            }
            if (this.cluster.isVSwitchNameExist(name)) {
                return "Name " + name + " already exists in Cluster. Please select another name.";
            }
            parameterList.put(ClientParameterCode.VSWITCH_NAME, new SrString(name));
        }
        if ((contact = (String)parameterList.get(ClientParameterCode.VSWITCH_CONTACT)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_CONTACT, new SrString(contact));
        }
        if ((location = (String)parameterList.get(ClientParameterCode.VSWITCH_LOCATION)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_LOCATION, new SrString(location));
        }
        if ((time = (Long)parameterList.get(ClientParameterCode.VSWITCH_DATE_AND_TIME)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_DATE_AND_TIME, new SrDateAndTime(time));
        }
        if ((timeout = (Long)parameterList.get(ClientParameterCode.VSWITCH_TIMEOUT)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_TIMEOUT, new SrLong(timeout));
        }
        if ((snmpPort = (Integer)parameterList.get(ClientParameterCode.VSWITCH_SNMP_PORT)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_SNMP_PORT, new SrInteger(snmpPort));
        }
        if ((trapPort = (Integer)parameterList.get(ClientParameterCode.VSWITCH_TRAP_PORT)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_TRAP_PORT, new SrInteger(trapPort));
        }
        if ((switchId = (Integer)parameterList.get(ClientParameterCode.VSWITCH_SWITCH_ID)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_SWITCH_ID, new SrInteger(switchId));
        }
        if ((retries = (Integer)parameterList.get(ClientParameterCode.VSWITCH_RETRIES)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_RETRIES, new SrInteger(retries));
        }
        if ((readCommunity = (String)parameterList.get(ClientParameterCode.VSWITCH_READ_COMMUNITY)) != null) {
            String errMsg = VSwitchValidator.isCommunityValid(readCommunity);
            if (errMsg == null) {
                parameterList.put(ClientParameterCode.VSWITCH_READ_COMMUNITY, new SrString(readCommunity));
            } else {
                return "Read Community '" + readCommunity + "' is not valid: " + errMsg;
            }
        }
        if ((writeCommunity = (String)parameterList.get(ClientParameterCode.VSWITCH_WRITE_COMMUNITY)) != null) {
            String errMsg = VSwitchValidator.isCommunityValid(writeCommunity);
            if (errMsg == null) {
                parameterList.put(ClientParameterCode.VSWITCH_WRITE_COMMUNITY, new SrString(writeCommunity));
            } else {
                return "Write Community '" + writeCommunity + "' string is not valid: " + errMsg;
            }
        }
        if ((telnetPort = (BigInteger)parameterList.get(ClientParameterCode.VSWITCH_TELNET_PORT)) != null) {
            parameterList.put(ClientParameterCode.VSWITCH_TELNET_PORT, new SrGauge(telnetPort.toString()));
        }
        if ((keepAlive = (Integer)parameterList.get(ClientParameterCode.KEEP_ALIVE)) != null) {
            if (keepAlive <= 0) {
                return "Keep alive interval " + keepAlive + " should be positive. Please select another interval.";
            }
            parameterList.put(ClientParameterCode.KEEP_ALIVE, new SrInteger(keepAlive));
        }
        if ((suspicious = (Integer)parameterList.get(ClientParameterCode.SUSPICIOUS_INTERVAL)) != null) {
            if (keepAlive == null) {
                keepAlive = this.getKeepAliveInterval();
            }
            if (suspicious <= keepAlive) {
                return "Suspicious interval " + suspicious + " should be bigger than keep alive interval. Please select another interval.";
            }
            parameterList.put(ClientParameterCode.SUSPICIOUS_INTERVAL, new SrInteger(suspicious));
        }
        if ((faulty = (Integer)parameterList.get(ClientParameterCode.FAULTY_INTERVAL)) != null) {
            if (suspicious == null) {
                suspicious = this.getSuspiciousInterval();
            }
            if (faulty <= suspicious) {
                return "Faulty interval " + faulty + " should be bigger than suspicious interval. Please select another interval.";
            }
            parameterList.put(ClientParameterCode.FAULTY_INTERVAL, new SrInteger(faulty));
        }
        if ((failover = (Boolean)parameterList.get(ClientParameterCode.FAILOVER_ENABLE)) != null) {
            int failoverValue = failover != false ? 1 : 2;
            parameterList.put(ClientParameterCode.FAILOVER_ENABLE, new SrInteger(failoverValue));
        }
        if ((reportLUNDiscovery = (Boolean)parameterList.get(ClientParameterCode.VSWITCH_REPORT_LUN_DISCOVERY)) != null) {
            int reportLUNs = reportLUNDiscovery != false ? 1 : 2;
            parameterList.put(ClientParameterCode.VSWITCH_REPORT_LUN_DISCOVERY, new SrInteger(reportLUNs));
        }
        return null;
    }

    private void readInitiator(ISCSIInitiator initiator) throws RemoteException {
        CommKeyClassId iscsiInitiatorCommKeyClassId = initiator.getCommKeyClassId();
        CommKeyClassId scsiInitiatorCommKeyClassId = this.cluster.getSCSIId(iscsiInitiatorCommKeyClassId);
        ConfigElementData element = new ConfigElementData(scsiInitiatorCommKeyClassId);
        DataMgr.getInstance().readElement(element);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        SrInteger switchId;
        String name;
        String oldName = this.getName();
        SDTakeOverStateConstant oldTakeoverState = this.getTakeOverState();
        HashMap changedValues = super.setParameterList(parameterList);
        if (this.m_ipAddr == null) {
            this.m_ipAddr = this.getDisplayStringOf(this, ParameterCode.VSWITCH_IP_ADDRESS);
        }
        this.toStringValue = this.m_ipAddr;
        SDTakeOverStateConstant newTakeoverState = this.getTakeOverState();
        if (this.isRediscoverNeeded(oldTakeoverState, newTakeoverState)) {
            this.cluster.rediscover();
        }
        if (this.isKeepaliveCheckNeeded(oldTakeoverState, newTakeoverState)) {
            ((VSwitchImpl)this.getOtherVSwitchFromCluster(this)).sendKeepAlive();
        }
        if (changedValues.containsKey(ParameterCode.VSWITCH_NAME)) {
            this.cluster.setClusterNeighbors();
            VSwitch vSwitch = this.cluster.getOtherVSwitch(this);
            if (vSwitch == null || vSwitch.getName().equals(this.getName())) {
                // empty if block
            }
        }
        if (oldName != null && !oldName.equals(this.getName())) {
            ISCSIInitiator[] iSCSIInitiators;
            this.cluster.getTargetListMgr().readExposedOn();
            if (this.cluster.isDiscoverCompleted() && (iSCSIInitiators = this.getISCSIInitiators()).length > 0) {
                ISCSIInitiator vswitchInitiator = this.getISCSIInitiators()[0];
                this.readInitiator(vswitchInitiator);
            }
        }
        if (this.cluster.isSingleVSwitchMode() && changedValues.containsKey(ParameterCode.VSWITCH_NAME) && !(name = this.getName()).equals(this.cluster.getAlias())) {
            this.cluster.changeElement(ClientParameterCode.CLUSTER_ALIAS, name);
        }
        if (changedValues.containsKey(ParameterCode.VSWITCH_SWITCH_ID) && (switchId = (SrInteger)parameterList.get(ParameterCode.VSWITCH_SWITCH_ID)) != null) {
            this.cluster.checkAndSetVSwitchSwitchIDConsistency(this);
        }
        return changedValues;
    }

    private boolean isRediscoverNeeded(SDTakeOverStateConstant oldTakeoverState, SDTakeOverStateConstant newTakeoverState) throws RemoteException {
        return this.cluster.getVSwitchesCount() > 1 && !this.cluster.getOtherVSwitch(this).isConnected() && oldTakeoverState != null && newTakeoverState != null && !oldTakeoverState.equals(newTakeoverState) && newTakeoverState.equals(SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER);
    }

    private boolean isKeepaliveCheckNeeded(SDTakeOverStateConstant oldTakeoverState, SDTakeOverStateConstant newTakeoverState) throws RemoteException {
        return this.cluster.getVSwitchesCount() > 1 && this.getOtherVSwitchFromCluster(this) != null && oldTakeoverState != null && newTakeoverState != null && !oldTakeoverState.equals(newTakeoverState) && newTakeoverState.equals(SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER);
    }

    void sendKeepAlive() throws RemoteException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeyClassId());
        ced.setValue(ParameterCode.VSWITCH_DATE_AND_TIME, (SrType)null);
        ced.setValue(ParameterCode.VSWITCH_ID, this.getCommKeyClassId());
        this.refreshFields(ced);
    }

    public Vector getEthernetInterfaces() throws RemoteException {
        Vector<InterfaceTableRowImpl> ethernetInterfaces = new Vector<InterfaceTableRowImpl>();
        Enumeration e = this.getInterfaceTable().elements();
        while (e.hasMoreElements()) {
            InterfaceTableRowImpl row = (InterfaceTableRowImpl)e.nextElement();
            if (!row.isEthernet()) continue;
            ethernetInterfaces.addElement(row);
        }
        return ethernetInterfaces;
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        String canDeleteMsg = this.canBeDeleted();
        if (!this.isDeletedFromDatabaseOnly() && canDeleteMsg == null) {
            Vector targetsExposeOn;
            VSwitchImpl otherVSwitch = (VSwitchImpl)this.cluster.getOtherVSwitch(this);
            if (otherVSwitch != null && !(targetsExposeOn = this.cluster.getOtherVSwitchTargetsExposedOnVSwitch(this)).isEmpty()) {
                this.setDeletionPending();
                Enumeration e = targetsExposeOn.elements();
                while (e.hasMoreElements()) {
                    Target target = (Target)e.nextElement();
                    try {
                        HashMap<ClientParameterCode, String> parameterList = new HashMap<ClientParameterCode, String>();
                        parameterList.put(ClientParameterCode.TARGET_EXPOSED_ON, otherVSwitch.getName());
                        target.changeElement(parameterList);
                    }
                    catch (IllegalValueException ive) {
                        logger.warning(ive.getMessage() + " when trying to delete " + ClassID.VSWITCH + " " + this);
                    }
                }
                return;
            }
        } else if (canDeleteMsg != null) {
            throw new IllegalValueException(canDeleteMsg);
        }
        super.deleteElement();
    }

    protected String canBeDeleted() throws RemoteException {
        VSwitchImpl otherVSwitch;
        if (!this.isDeletedFromDatabaseOnly() && (otherVSwitch = (VSwitchImpl)this.cluster.getOtherVSwitch(this)) != null && !otherVSwitch.isNeighborDead(this)) {
            return "You cannot remove " + ClassID.VSWITCH + " " + this.getName() + ", because it's not dead for " + otherVSwitch.getName() + ".";
        }
        return null;
    }

    private String checkIPValidity(String ip, String mask) throws RemoteException, IllegalValueException {
        if (!NetUtil.isNetworkIpValid(ip)) {
            throw new IllegalValueException("the ip is not valid");
        }
        if (!NetUtil.isMaskValid(mask)) {
            throw new IllegalValueException("the mask is not valid");
        }
        return null;
    }

    public void changeManagerIfInconsistent(Manager manager) throws RemoteException {
        String readCommunity = this.getReadCommunity();
        String writeCommunity = this.getWriteCommunity();
        HashMap<ClientParameterCode, Object> parameterList = new HashMap<ClientParameterCode, Object>();
        if (!manager.isTrapEnable().booleanValue()) {
            parameterList.put(ClientParameterCode.MANAGER_TRAP_ENABLE, new Boolean(true));
        }
        if (!readCommunity.equals(manager.getReadCommunity())) {
            parameterList.put(ClientParameterCode.MANAGER_READ_COMMUNITY, readCommunity);
        }
        if (!writeCommunity.equals(manager.getWriteCommunity())) {
            parameterList.put(ClientParameterCode.MANAGER_WRITE_COMMUNITY, writeCommunity);
        }
        if (!parameterList.isEmpty()) {
            try {
                manager.changeElement(parameterList);
            }
            catch (IllegalValueException ive) {
                logger.warning(ive.getMessage());
            }
        }
    }

    public void addManagerIfNoManagerIsDefinedYet() throws RemoteException {
        if (!this.isManagerDefined()) {
            ConfigElementData element = new ConfigElementData(ClassID.SNMP_MANAGER);
            element.addParameter(new Parameter(ParameterCode.MANAGER_READ_COMMUNITY, new SrString(this.getReadCommunity())));
            element.addParameter(new Parameter(ParameterCode.MANAGER_WRITE_COMMUNITY, new SrString(this.getWriteCommunity())));
            element.addParameter(new Parameter(ParameterCode.MANAGER_TRAP_ENABLE, new SrBoolean(true)));
            element.addParameter(new Parameter(ParameterCode.MANAGER_TRAP_PORT, new SrInteger(this.getTrapPort())));
            this.createElement(element, ClassID.SNMP_MANAGER, "for " + this.getName());
        }
    }

    public Neighbor getNeighbor(VSwitch neighbor) throws RemoteException {
        Enumeration e = this.getNeighborTable().elements();
        while (e.hasMoreElements()) {
            Neighbor n = (Neighbor)e.nextElement();
            if (!n.getIPAddress().equals(neighbor.getMgmIPAddr())) continue;
            return n;
        }
        return null;
    }

    public boolean isNeighborOf(VSwitch neighbor) throws RemoteException {
        Enumeration e = neighbor.getNeighborTable().elements();
        while (e.hasMoreElements()) {
            Neighbor neigh = (Neighbor)e.nextElement();
            if (!neigh.getName().equals(this.getName())) continue;
            return true;
        }
        if (!neighbor.isConnected()) {
            NeighborImpl n = (NeighborImpl)this.getNeighbor(neighbor);
            return n != null && n.isAlive();
        }
        return false;
    }

    public boolean isNeighborDead(VSwitch neighbor) throws RemoteException {
        NeighborImpl neighborImpl = (NeighborImpl)this.getNeighbor(neighbor);
        if (neighborImpl != null) {
            return neighborImpl.isDead();
        }
        return true;
    }

    public void createIPTableRow(String ip, String mask, String activity, String interfaceName) throws RemoteException, IllegalValueException {
        String msg = this.checkIPValidity(ip, mask);
        if (msg != null) {
            logger.debug(msg);
            throw new IllegalValueException(msg);
        }
        IPTableRowValidator validator = new IPTableRowValidator(this, ip, mask, interfaceName, activity);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        InterfaceTableRow interfaceRow = this.getInterfaceTableRowByName(interfaceName);
        if (interfaceRow == null) {
            throw new IllegalValueException("Interface name " + interfaceName + " not found");
        }
        ConfigElementData element = new ConfigElementData(ClassID.NETWORK_CONFIGURATION);
        element.addParameter(new Parameter(ParameterCode.NETWORK_CONFIG_IP_ADDRESS, new SrIpAddress(ip)));
        element.addParameter(new Parameter(ParameterCode.NETWORK_CONFIG_NET_MASK, new SrIpAddress(mask)));
        element.addParameter(new Parameter(ParameterCode.NETWORK_CONFIG_ACTIVITY, NetConfigActivityConstant.getNetConfigState(activity)));
        element.addParameter(new Parameter(ParameterCode.NETWORK_CONFIG_INTERFACE, new SrString(interfaceRow.getName())));
        this.createElement(element, ClassID.NETWORK_CONFIGURATION, ip + " for " + this.getName());
    }

    private CommKeyClassId getInterfaceTableRow(String interfaceName) throws RemoteException {
        InterfaceTableRow row = this.getInterfaceTableRowByName(interfaceName);
        if (row != null) {
            return new CommKeyClassId(row.getCommKeys(), row.getClassId());
        }
        return null;
    }

    public IPTableRow getIPTableRowFromSameSubnet(String ip, String mask) throws RemoteException {
        return this.innerGetIPTableRowFromSameSubnet(ip, mask, null);
    }

    public IPTableRow getIPTableRowFromSameSubnet(String ip, String mask, String interfaceName) throws RemoteException {
        return this.innerGetIPTableRowFromSameSubnet(ip, mask, interfaceName);
    }

    private IPTableRow innerGetIPTableRowFromSameSubnet(String ip, String mask, String interfaceName) throws RemoteException {
        String subnet = null;
        if (mask != null) {
            subnet = NetUtil.getSubnet(ip, mask);
        }
        Enumeration e = this.getIPTable().elements();
        while (e.hasMoreElements()) {
            IPTableRow row = (IPTableRow)e.nextElement();
            if (interfaceName != null && !row.getInterface().getName().equals(interfaceName)) continue;
            String rowSubnet = NetUtil.getSubnet(row.getIPAddress(), row.getIPMask());
            if (subnet == null) {
                subnet = NetUtil.getSubnet(ip, row.getIPMask());
            }
            if (!rowSubnet.equals(subnet)) continue;
            return row;
        }
        return null;
    }

    public IPTableRow getIPTableRow(String ip) throws RemoteException {
        Enumeration e = this.getIPTable().elements();
        while (e.hasMoreElements()) {
            IPTableRow row = (IPTableRow)e.nextElement();
            if (!row.getIPAddress().equals(ip)) continue;
            return row;
        }
        return null;
    }

    public Vector getIPTableRowsOfInterface(String interfaceName) throws RemoteException {
        Vector<IPTableRow> ips = new Vector<IPTableRow>();
        Enumeration e = this.getIPTable().elements();
        while (e.hasMoreElements()) {
            IPTableRow row = (IPTableRow)e.nextElement();
            if (!row.getInterface().getName().equals(interfaceName)) continue;
            ips.addElement(row);
        }
        return ips;
    }

    public Vector getPortalTableRows(String ip) throws RemoteException {
        Vector<PortalTableRowImpl> portals = new Vector<PortalTableRowImpl>();
        Enumeration e = this.getPortalTable().elements();
        while (e.hasMoreElements()) {
            PortalTableRowImpl row = (PortalTableRowImpl)e.nextElement();
            if (!row.isTargetRole() || !row.getIPAddress().equals(ip)) continue;
            portals.addElement(row);
        }
        return portals;
    }

    public Vector getIPRouteTableRows(IPTableRow ip) throws RemoteException {
        Vector<IPRouteTableRow> ipRoutes = new Vector<IPRouteTableRow>();
        Enumeration e = this.getIPRouteTable().elements();
        while (e.hasMoreElements()) {
            IPRouteTableRow row = (IPRouteTableRow)e.nextElement();
            String gatewaySubnet = NetUtil.getSubnet(row.getGateway(), ip.getIPMask());
            String ipSubnet = NetUtil.getSubnet(ip.getIPAddress(), ip.getIPMask());
            if (!ipSubnet.equals(gatewaySubnet)) continue;
            ipRoutes.addElement(row);
        }
        return ipRoutes;
    }

    public Vector getGwIPRouteTableRows(IPTableRow ip) throws RemoteException {
        Vector<IPRouteTableRow> ipGwRoutes = new Vector<IPRouteTableRow>();
        Enumeration e = this.getIPRouteTable().elements();
        while (e.hasMoreElements()) {
            String gwIPAddress;
            IPRouteTableRow row = (IPRouteTableRow)e.nextElement();
            String ipAddress = ip.getIPAddress();
            if (ipAddress.equals(gwIPAddress = row.getGateway())) {
                ipGwRoutes.addElement(row);
            }
            if (!NetUtil.isIPBelongsToSubnet(ipAddress, ip.getIPMask(), NetUtil.getSubnet(gwIPAddress, row.getDestIPMask()))) continue;
            ipGwRoutes.addElement(row);
        }
        return ipGwRoutes;
    }

    public IPRouteTableRow getIPRouteTableRow(String subnet) throws RemoteException {
        Enumeration e = this.getIPRouteTable().elements();
        while (e.hasMoreElements()) {
            IPRouteTableRow row = (IPRouteTableRow)e.nextElement();
            String rowSubnet = NetUtil.getSubnet(row.getDestIPAdress(), row.getDestIPMask());
            if (!rowSubnet.equals(subnet)) continue;
            return row;
        }
        return null;
    }

    public IPRouteTableRow getIPRouteTableRow(String destIp, String gateway) throws RemoteException {
        Enumeration e = this.getIPRouteTable().elements();
        while (e.hasMoreElements()) {
            IPRouteTableRow row = (IPRouteTableRow)e.nextElement();
            if (!row.getDestIPAdress().equals(destIp) || !row.getGateway().equals(gateway)) continue;
            return row;
        }
        return null;
    }

    public PortalTableRow getPortalTableRow(String ip, int port) throws RemoteException {
        Enumeration e = this.getPortalTable().elements();
        while (e.hasMoreElements()) {
            PortalTableRow row = (PortalTableRow)e.nextElement();
            if (!row.getIPAddress().equals(ip) || !row.getRole().equals(IscsiPortalRolesConstant.TARGET) || row.getPort() != port) continue;
            return row;
        }
        return null;
    }

    public InterfaceTableRow getInterfaceTableRowByName(String interfaceName) throws RemoteException {
        Enumeration e = this.getInterfaceTable().elements();
        while (e.hasMoreElements()) {
            InterfaceTableRow row = (InterfaceTableRow)e.nextElement();
            if (row.getName() == null) {
                logger.error(">>>> InterfaceTableRow name is null: row = " + row.getCommKeyClassId());
            }
            if (!row.getName().equals(interfaceName)) continue;
            return row;
        }
        logger.debug(ClassID.INTERFACE + " " + interfaceName + " not found");
        return null;
    }

    public Vector getIPsOfInterfaceAndSameSubnet(InterfaceTableRow interfaceRow, IPTableRow ipRow) throws RemoteException {
        Vector ips = this.getIPsOfInterface(interfaceRow);
        String ipMask = ipRow.getIPMask();
        String ipSubnet = NetUtil.getSubnet(ipRow.getIPAddress(), ipMask);
        Iterator iter = ips.iterator();
        while (iter.hasNext()) {
            IPTableRow ip = (IPTableRow)iter.next();
            String mask = ip.getIPMask();
            String subnet = NetUtil.getSubnet(ip.getIPAddress(), mask);
            if (ipSubnet.equals(subnet)) continue;
            iter.remove();
        }
        return ips;
    }

    public Vector getIPsOfInterface(InterfaceTableRow interfaceRow) throws RemoteException {
        Vector<IPTableRow> ips = new Vector<IPTableRow>();
        Enumeration e = this.getIPTable().elements();
        while (e.hasMoreElements()) {
            IPTableRow ip = (IPTableRow)e.nextElement();
            if (!ip.getInterface().getName().equals(interfaceRow.getName())) continue;
            ips.addElement(ip);
        }
        return ips;
    }

    public String getWWNN() throws RemoteException {
        if (this.fcNode == null) {
            return null;
        }
        return this.fcNode.getWWNN();
    }

    public String getFunctions() throws RemoteException {
        if (this.fcNode == null) {
            return null;
        }
        return this.fcNode.getFunctions();
    }

    public void setAllIPsActive() throws RemoteException {
        Enumeration e = this.getIPTable().elements();
        while (e.hasMoreElements()) {
            IPTableRowImpl ipTableRow = (IPTableRowImpl)e.nextElement();
            if (ipTableRow.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_ACTIVE.getDescriptionName())) continue;
            ipTableRow.setActive();
        }
    }

    public void createIPRouteTableRow(String destIp, String destMask, String gateway, String interfaceName) throws RemoteException, IllegalValueException {
        IPRouteTableRowValidator validator = new IPRouteTableRowValidator(this, destIp, destMask, gateway, interfaceName);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.IP_ROUTE);
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_DESTINATION_IP, new SrIpAddress(destIp)));
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_DESTINATION_IP_MASK, new SrIpAddress(destMask)));
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_GATEWAY, new SrIpAddress(gateway)));
        CommKeyClassId interfaceCommKeyClassId = this.getInterfaceTableRow(interfaceName);
        element.addParameter(new Parameter(ParameterCode.IP_ROUTE_INTERFACE, interfaceCommKeyClassId));
        this.createElement(element, ClassID.IP_ROUTE, destIp + " for " + this.getName());
    }

    public void createPortalTableRow(String ip, int port) throws RemoteException, IllegalValueException {
        PortalTableRowValidator validator = new PortalTableRowValidator(this, ip, port);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.PORTAL);
        element.addParameter(new Parameter(ParameterCode.ISCSI_PORTAL_IP_ADDRESS, new SrIpAddress(ip)));
        element.addParameter(new Parameter(ParameterCode.ISCSI_PORTAL_PORT, new SrGauge(port)));
        this.createElement(element, ClassID.PORTAL, ip + ":" + port + " for " + this.getName());
    }

    private void createElement(ConfigElementData element, String details) throws RemoteException {
        if (this.isConnected()) {
            logger.debug(details);
            CommKeyClassId[] vSwitchCommKeyClassId = new CommKeyClassId[]{new CommKeyClassId(this.getCommKeys(), this.getClassId())};
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchCommKeyClassId));
            DataMgr.getInstance().createElement(element);
        } else {
            logger.debug(this.getClassId() + " " + this.getName() + " is not connected - ignor element creation (" + details + ")");
        }
    }

    private void createElement(ConfigElementData element, ClassID classId, String details) throws RemoteException {
        this.createElement(element, "Trying to create " + classId + " " + details);
    }

    public void removeTableRow(TableRow row) throws RemoteException {
        if (row instanceof IPTableRow) {
            this.removeIPTableRow((IPTableRow)row);
        } else if (row instanceof InterfaceTableRow) {
            this.removeInterfaceTableRow((InterfaceTableRow)row);
        } else if (row instanceof IPRouteTableRow) {
            this.removeIPRouteTableRow((IPRouteTableRow)row);
        } else if (row instanceof PortalTableRow) {
            this.removePortalTableRow((PortalTableRow)row);
        } else if (row instanceof Neighbor) {
            this.removeNeighbor((Neighbor)row);
        } else if (row instanceof Manager) {
            this.removeManager((Manager)row);
        } else if (row instanceof ISCSIInstance) {
            this.removeISCSIInstance((ISCSIInstance)((Object)row));
        } else if (row instanceof ISCSISession) {
            this.removeISCSISession((ISCSISession)((Object)row));
        } else if (row instanceof ISCSIRemoteInitiator) {
            this.removeISCSIRemoteInitiator((ISCSIRemoteInitiator)((Object)row));
        } else if (row instanceof ISCSIRemoteInitiatorStatistics) {
            this.removeISCSIRemoteInitiatorStatistics((ISCSIRemoteInitiatorStatistics)row);
        } else if (row instanceof ISCSISessionStatistics) {
            this.removeISCSISessionStatistics((ISCSISessionStatistics)row);
        } else if (row instanceof TCPConnectionStatisticsTableRow) {
            this.removeTCPConnectionStatisticsTableRow((TCPConnectionStatisticsTableRow)row);
        } else if (row instanceof UDPListenerStatisticsTableRow) {
            this.removeUDPListenerStatisticsTableRow((UDPListenerStatisticsTableRow)row);
        } else {
            logger.debug(row.getClassId() + " not found in " + this.getClass() + "::removeTableRow()");
        }
    }

    public synchronized void addNeighbor(VSwitch neighbor) throws RemoteException, IllegalValueException {
        if (this.isVSwitchDiscoverCompleted() && ((VSwitchImpl)neighbor).isRealNameSet() && !this.getName().equals(neighbor.getName())) {
            if (this.getSwitchID() != null && this.getSwitchID() > -1) {
                this.addNeighborPending = null;
                ConfigElementData element = new ConfigElementData(ClassID.NEIGHBORE);
                element.addParameter(new Parameter(ParameterCode.NEIGHBOR_IP_ADDRESS, new SrIpAddress(neighbor.getMgmIPAddr())));
                element.addParameter(new Parameter(ParameterCode.NEIGHBOR_NAME, new SrString(neighbor.getName())));
                element.addParameter(new Parameter(ParameterCode.NEIGHBOR_PORT, new SrInteger(neighbor.getSnmpPort())));
                element.addParameter(new Parameter(ParameterCode.NEIGHBOR_RETRIES, new SrInteger(neighbor.getNumberOfRetries())));
                element.addParameter(new Parameter(ParameterCode.NEIGHBOR_TIMEOUT, new SrInteger(new Long(neighbor.getTimeout()).intValue())));
                this.createElement(element, ClassID.NEIGHBORE, neighbor.getMgmIPAddr());
            } else {
                logger.debug("Add neighbor " + neighbor + " is pending");
                this.addNeighborPending = neighbor;
            }
        }
    }

    public synchronized void addNeighborIfPending() throws RemoteException, IllegalValueException {
        if (this.addNeighborPending != null) {
            this.addNeighbor(this.addNeighborPending);
        }
    }

    private boolean isRowExist(TableRow row) {
        if (this.ipTable.contains(row)) {
            return true;
        }
        if (this.interfaceTable.contains(row)) {
            return true;
        }
        if (this.ipRouteTable.contains(row)) {
            return true;
        }
        if (this.portalTable.contains(row)) {
            return true;
        }
        if (this.neighborTable.contains(row)) {
            return true;
        }
        if (this.managerTable.contains(row)) {
            return true;
        }
        if (this.m_iscsiInstances.contains(row)) {
            return true;
        }
        if (this.m_iscsiSessions.contains(row)) {
            return true;
        }
        if (this.m_iscsiRemoteInitiators.contains(row)) {
            return true;
        }
        if (this.m_iscsiRemoteInitiatorsStatistics.contains(row)) {
            return true;
        }
        if (this.m_iscsiSessionsStatistics.contains(row)) {
            return true;
        }
        if (this.m_tcpConnectionStatisticsTable.contains(row)) {
            return true;
        }
        return this.m_udpListenerStatisticsTable.contains(row);
    }

    public void addTableRow(TableRow row) throws RemoteException {
        if (!this.isRowExist(row)) {
            if (row instanceof HardwareImpl) {
                this.setHardware((HardwareImpl)row);
            } else if (row instanceof TCPStatisticsImpl) {
                this.setTCPStatistics((TCPStatisticsImpl)row);
            } else if (row instanceof UDPStatisticsImpl) {
                this.setUDPStatistics((UDPStatisticsImpl)row);
            } else if (row instanceof ICMPStatisticsImpl) {
                this.setICMPStatistics((ICMPStatisticsImpl)row);
            } else if (row instanceof IPStatisticsImpl) {
                this.setIPStatistics((IPStatisticsImpl)row);
            } else if (row instanceof EthernetStatisticsImpl) {
                this.setEthernetStatistics((EthernetStatisticsImpl)row);
            } else if (row instanceof IPTableRow) {
                this.addIPTableRow((IPTableRow)row);
            } else if (row instanceof InterfaceTableRow) {
                this.addInterfaceTableRow((InterfaceTableRow)row);
            } else if (row instanceof InterfaceStatisticsTableRowImpl) {
                this.addInterfaceStatisticsTableRow((InterfaceStatisticsTableRowImpl)row);
            } else if (row instanceof IPRouteTableRow) {
                this.addIPRouteTableRow((IPRouteTableRow)row);
            } else if (row instanceof PortalTableRow) {
                this.addPortalTableRow((PortalTableRow)row);
            } else if (row instanceof Neighbor) {
                this.addNeighbor((Neighbor)row);
            } else if (row instanceof Manager) {
                this.addManager((Manager)row);
            } else if (row instanceof ISCSIInstance) {
                this.addISCSIInstance((ISCSIInstance)((Object)row));
            } else if (row instanceof ISCSISession) {
                this.addISCSISession((ISCSISession)((Object)row));
            } else if (row instanceof ISCSISessionStatistics) {
                this.addISCSISessionStatistics((ISCSISessionStatistics)row);
            } else if (row instanceof ISCSIRemoteInitiator) {
                this.addISCSIRemoteInitiator((ISCSIRemoteInitiator)((Object)row));
            } else if (row instanceof ISCSIRemoteInitiatorStatistics) {
                this.addISCSIRemoteInitiatorStatistics((ISCSIRemoteInitiatorStatistics)row);
            } else if (row instanceof TCPConnectionStatisticsTableRow) {
                this.addTCPConnectionStatisticsTableRow((TCPConnectionStatisticsTableRow)row);
            } else if (row instanceof UDPListenerStatisticsTableRow) {
                this.addUDPListenerStatisticsTableRow((UDPListenerStatisticsTableRow)row);
            } else {
                logger.debug(row.getClassId() + " not found in " + this.getClass() + "::addTableRow()");
            }
        } else {
            logger.debug("Table row " + row.getClassId() + " " + row + " already exists in " + ClassID.VSWITCH + " " + this.getMgmIPAddr());
        }
    }

    private void addNeighbor(Neighbor neighbor) {
        this.neighborTable.addElement(neighbor);
    }

    private void removeNeighbor(Neighbor neighbor) {
        this.neighborTable.removeElement(neighbor);
    }

    private void addManager(Manager manager) {
        this.managerTable.addElement(manager);
    }

    private void removeManager(Manager manager) {
        this.managerTable.removeElement(manager);
    }

    private void addIPTableRow(IPTableRow row) {
        this.ipTable.addElement(row);
    }

    private void removeIPTableRow(IPTableRow row) {
        this.ipTable.removeElement(row);
    }

    private void addInterfaceTableRow(InterfaceTableRow row) {
        this.interfaceTable.addElement(row);
    }

    private void addInterfaceStatisticsTableRow(InterfaceStatisticsTableRowImpl row) throws RemoteException {
        this.getInterfacesStatisticsTable().addElement(row);
    }

    public void setFCNode(FCNode fcNode) {
        this.fcNode = fcNode;
    }

    private void removeInterfaceTableRow(InterfaceTableRow row) throws RemoteException {
        Iterator i = this.getInterfacesStatisticsTable().iterator();
        while (i.hasNext()) {
            InterfaceStatisticsTableRowImpl currIface = (InterfaceStatisticsTableRowImpl)i.next();
            if (!currIface.getParentInterface().equals(row)) continue;
            i.remove();
        }
        this.interfaceTable.removeElement(row);
    }

    public Vector getInterfacesStatisticsTable() throws RemoteException {
        return this.interfaceStatisticsTable;
    }

    public Vector getUDPListenerStatisticsTable() throws RemoteException {
        return this.m_udpListenerStatisticsTable;
    }

    public Vector getTCPConnectionStatisticsTable() throws RemoteException {
        return this.m_tcpConnectionStatisticsTable;
    }

    public InterfacesGroupStatistics getInterfacesGroupStatistics() throws RemoteException {
        return this.ifaceGroup;
    }

    public IPStatistics getIPStatistics() throws RemoteException {
        return this.ipImpl;
    }

    public EthernetStatistics getEthernetStatistics() throws RemoteException {
        return this.ethernetImpl;
    }

    public ICMPStatistics getICMPStatistics() throws RemoteException {
        return this.icmpImpl;
    }

    public TCPStatistics getTCPStatistics() throws RemoteException {
        return this.tcpImpl;
    }

    public UDPStatistics getUDPStatistics() throws RemoteException {
        return this.udpImpl;
    }

    private void removeInterfaceStatisticsTableRow(InterfaceStatisticsTableRow row) {
        this.interfaceStatisticsTable.removeElement(row);
    }

    private void addUDPListenerStatisticsTableRow(UDPListenerStatisticsTableRow row) {
        this.m_udpListenerStatisticsTable.addElement(row);
    }

    private void removeUDPListenerStatisticsTableRow(UDPListenerStatisticsTableRow row) {
        this.m_udpListenerStatisticsTable.removeElement(row);
    }

    private void addTCPConnectionStatisticsTableRow(TCPConnectionStatisticsTableRow row) {
        this.m_tcpConnectionStatisticsTable.addElement(row);
    }

    private void removeTCPConnectionStatisticsTableRow(TCPConnectionStatisticsTableRow row) {
        this.m_tcpConnectionStatisticsTable.removeElement(row);
    }

    private void addPortalTableRow(PortalTableRow row) {
        this.portalTable.addElement(row);
    }

    private void removePortalTableRow(PortalTableRow row) {
        this.portalTable.removeElement(row);
    }

    private void addIPRouteTableRow(IPRouteTableRow row) {
        this.ipRouteTable.addElement(row);
    }

    private void removeIPRouteTableRow(IPRouteTableRow row) {
        this.ipRouteTable.removeElement(row);
    }

    public Vector getNeighborTable() throws RemoteException {
        return this.neighborTable;
    }

    public Vector getManagerTable() throws RemoteException {
        return this.managerTable;
    }

    public Vector getIPTable() throws RemoteException {
        return this.ipTable;
    }

    public Vector getInterfaceTable() throws RemoteException {
        return this.interfaceTable;
    }

    public Vector getPortalTable() throws RemoteException {
        return this.portalTable;
    }

    public Vector getIPRouteTable() throws RemoteException {
        return this.ipRouteTable;
    }

    public boolean isConnected() throws RemoteException {
        return this.connected;
    }

    public void setConnected(boolean connected) throws RemoteException {
        if (this.connected != connected) {
            logger.debug(this.getClassId() + " " + this.getMgmIPAddr() + " connection status is " + connected);
            this.connected = connected;
            AlarmMgrImpl.getInstance().generateAlarms((ClusterImpl)this.getCluster(), 2, this, this);
            if (this.cluster.isDiscoverCompleted()) {
                if (connected || SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER.equals(this.cluster.getTakeoverState())) {
                    this.cluster.rediscover();
                }
            } else {
                this.fireConnectivityChanged(this.isConnected());
            }
            ElementEventImpl event = new ElementEventImpl(this, this);
            HashMap<ClientParameterCode, Boolean> parameterList = new HashMap<ClientParameterCode, Boolean>();
            parameterList.put(ClientParameterCode.VSWITCH_CONNECTED, new Boolean(connected));
            event.setParameterList(parameterList);
            EventServiceImpl.getInstance().fireElementChanged(event);
        }
    }

    public String getMgmIPAddr() throws RemoteException {
        return this.m_ipAddr;
    }

    public String getMgmMask() throws RemoteException {
        return this.getDisplayStringOf(this, ParameterCode.VSWITCH_IP_MASK);
    }

    public int getSnmpPort() throws RemoteException {
        return ((SrInteger)this.getSrValueOf(this, ParameterCode.VSWITCH_SNMP_UDP_PORT)).intValue();
    }

    public Integer getTrapPort() throws RemoteException {
        SrInteger trapPort = (SrInteger)this.getSrValueOf(this, ParameterCode.VSWITCH_TRAP_UDP_PORT);
        if (trapPort == null) {
            return null;
        }
        return new Integer(trapPort.intValue());
    }

    public String getReadCommunity() throws RemoteException {
        String readCommunity = (String)this.getValueOf(this, ParameterCode.VSWITCH_READ_COMMUNITY);
        if (readCommunity == null || readCommunity.equals("")) {
            String debugMsg = "Read Community of " + this + " is empty (" + readCommunity + ") !!!! (class: " + this.getClass() + ")";
            System.err.println(debugMsg);
            logger.warning(debugMsg);
            Thread.dumpStack();
        }
        return readCommunity;
    }

    public String getWriteCommunity() throws RemoteException {
        String writeCommunity = (String)this.getValueOf(this, ParameterCode.VSWITCH_WRITE_COMMUNITY);
        if (writeCommunity == null || writeCommunity.equals("")) {
            String debugMsg = "Write Community of " + this + " is empty (" + writeCommunity + ") !!!! (class: " + this.getClass() + ")";
            System.err.println(debugMsg);
            logger.warning(debugMsg);
            Thread.dumpStack();
        }
        return writeCommunity;
    }

    public long getTimeout() throws RemoteException {
        return ((SrLong)this.getSrValueOf(this, ParameterCode.VSWITCH_TIMEOUT)).longValue();
    }

    public int getNumberOfRetries() throws RemoteException {
        return ((SrInteger)this.getSrValueOf(this, ParameterCode.VSWITCH_MAX_RETRIES)).intValue();
    }

    public SnmpVersion getSnmpVersion() throws RemoteException {
        return (SnmpVersion)this.getSrValueOf(this, ParameterCode.VSWITCH_SNMP_VERSION);
    }

    public String getDescription() throws RemoteException {
        return (String)this.getValueOf(this, ParameterCode.VSWITCH_DESCRIPTION);
    }

    public String getContact() throws RemoteException {
        return (String)this.getValueOf(this, ParameterCode.VSWITCH_CONTACT);
    }

    public String getLocation() throws RemoteException {
        return (String)this.getValueOf(this, ParameterCode.VSWITCH_LOCATION);
    }

    public Long getLastReset() throws RemoteException {
        return (Long)this.getValueOf(this, ParameterCode.VSWITCH_LAST_RESET);
    }

    public Long getLastKeepAlive() throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_LAST_KEEPALIVE));
        this.refreshFields(element);
        Object value = this.getValueOf(this, ParameterCode.VSWITCH_LAST_KEEPALIVE);
        if (value instanceof BigInteger) {
            return new Long(((BigInteger)value).longValue());
        }
        return (Long)value;
    }

    public Long getPreviousDateAndTime() throws RemoteException {
        return (Long)this.getValueOf(this, ParameterCode.VSWITCH_DATE_AND_TIME);
    }

    public BigInteger getTelnetPort() throws RemoteException {
        Object obj = this.getValueOf(this, ParameterCode.VSWITCH_TELNET_PORT);
        if (obj != null) {
            return (BigInteger)this.getValueOf(this, ParameterCode.VSWITCH_TELNET_PORT);
        }
        return null;
    }

    public Long getDateAndTime() throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_DATE_AND_TIME));
        this.refreshFields(element);
        return (Long)this.getValueOf(this, ParameterCode.VSWITCH_DATE_AND_TIME);
    }

    public VSwitchSysOID getVSwitchType() throws RemoteException {
        Integer integerVal = (Integer)this.getValueOf(this, ParameterCode.VSWITCH_SYS_OID);
        VSwitchSysOID vSwitchSysOID = VSwitchSysOID.intToVSwitchSysOID(integerVal);
        return vSwitchSysOID;
    }

    public boolean is2000() throws RemoteException {
        return this.getVSwitchType().equals(VSwitchSysOID.VSWITCH_SYS_OID_2000);
    }

    public boolean is3000() throws RemoteException {
        return this.getVSwitchType().equals(VSwitchSysOID.VSWITCH_SYS_OID_3000);
    }

    public boolean is3400() throws RemoteException {
        return this.getVSwitchType().equals(VSwitchSysOID.VSWITCH_SYS_OID_3400);
    }

    public boolean is3800() throws RemoteException {
        return this.getVSwitchType().equals(VSwitchSysOID.VSWITCH_SYS_OID_3800);
    }

    public Vector getIPActivityOptions() throws RemoteException {
        Vector<String> activities = new Vector<String>();
        activities.addElement(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_ACTIVE.toString());
        activities.addElement(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_INACTIVE.toString());
        return activities;
    }

    public void reset() throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_RESET, ResetConstant.RESET_HW));
        logger.info("Start reset " + ClassID.VSWITCH + " " + this.toString());
        ElementEventImpl elementEvent = new ElementEventImpl(this, this);
        elementEvent.setVSwitchIp(this.getMgmIPAddr());
        EventServiceImpl.getInstance().fireStartReset(elementEvent);
        DataMgr.getInstance().changeElement(element);
    }

    public void shutdown() throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VSWITCH_RESET, ResetConstant.SHUTDOWN));
        logger.info("Shutdown VSwitch " + this.toString());
        DataMgr.getInstance().changeElement(element);
    }

    public void wakeOnLAN() throws RemoteException, IllegalValueException {
        int i;
        InterfaceTableRowImpl mgntInterface = (InterfaceTableRowImpl)this.getInterfaceTableRowByName("mgnt");
        if (mgntInterface == null) {
            throw new IllegalValueException("Mgnt interface not found");
        }
        String ipStr = this.getMgmIPAddr();
        IPTableRowImpl mgntIp = (IPTableRowImpl)this.getIPTableRow(ipStr);
        InterfaceTableRow mgntIpInterface = mgntIp.getInterface();
        if (!mgntInterface.equals(mgntIpInterface)) {
            throw new IllegalValueException("Mgnt IP is not configured on Mgnt interface");
        }
        String macStr = mgntInterface.getPhysicalAddress();
        byte[] macBytes = null;
        try {
            macBytes = NetUtil.getMacBytes(macStr);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalValueException(iae.getMessage());
        }
        byte[] bytes = new byte[6 + 16 * macBytes.length];
        for (i = 0; i < 6; ++i) {
            bytes[i] = -1;
        }
        for (i = 6; i < bytes.length; i += macBytes.length) {
            System.arraycopy(macBytes, 0, bytes, i, macBytes.length);
        }
        try {
            InetAddress address = InetAddress.getByName(ipStr);
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, address, 9);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            socket.close();
        }
        catch (IOException ioe) {
            logger.warning(ioe);
            throw new IllegalValueException(ioe.getMessage());
        }
        logger.info("Wake-on-LAN packet sent to ip " + ipStr);
    }

    public boolean isInResetProcess() {
        return this.resetThread != null;
    }

    public void resetProcessDone() throws RemoteException {
        if (this.resetThread != null) {
            this.resetThread = null;
            this.cluster.rediscover();
        }
    }

    public void manualDiscover() throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.PHYSICAL_STORAGE_MANUAL_DISCOVERY, ManualDiscoveryStatusConstant.MANUAL_DISCOVERY_STATUS_ON));
        logger.info("Start manual discovery on " + this.getClassId() + " " + this.toString());
        ElementEventImpl elementEvent = new ElementEventImpl(this, this);
        elementEvent.setVSwitchIp(this.getMgmIPAddr());
        EventServiceImpl.getInstance().fireStartManualDiscovering(elementEvent);
        DataMgr.getInstance().changeElement(element);
    }

    protected void removePropagationStateDependentObject() throws RemoteException {
    }

    public void rediscover() throws RemoteException {
        this.setStateSeverity(AlarmSeverity.OK);
        this.vSwitchDiscovery();
        this.virtualizationDiscovery();
    }

    private void vSwitchDiscovery() throws RemoteException {
        if (this.isVSwitchDiscoverCompleted()) {
            return;
        }
        logger.debug("Starting discover for " + this.getClassId() + " " + this.getMgmIPAddr());
        DataMgr.getInstance().vSwitchDiscovery(new CommKeyClassId(this.getCommKeys(), this.getClassId()));
    }

    private void virtualizationDiscovery() throws RemoteException {
        if (this.isVirtualizationDiscoverCompleted()) {
            return;
        }
        StringBuffer msg = new StringBuffer("Start discover virtualization for ");
        msg.append(ClassID.VSWITCH);
        msg.append(" ");
        msg.append(this.getMgmIPAddr());
        logger.debug(msg.toString());
        SystemRootImpl.setStatusInProcess(msg.toString());
        DataMgr.getInstance().discoverConfiguration(new CommKeyClassId(this.getCommKeys(), this.getClassId()));
    }

    private boolean isRealNameSet() throws RemoteException {
        return this.getValueOf(this, ParameterCode.VSWITCH_NAME) != null;
    }

    public void readIPsState() throws RemoteException {
        Enumeration e = this.getIPTable().elements();
        while (e.hasMoreElements()) {
            IPTableRowImpl ipRow = (IPTableRowImpl)e.nextElement();
            ipRow.readState();
        }
    }

    public String getName() throws RemoteException {
        String name = (String)this.getValueOf(this, ParameterCode.VSWITCH_NAME);
        if (name == null) {
            return this.getMgmIPAddr();
        }
        return name;
    }

    public void clear() throws RemoteException {
        this.ipTable.clear();
        this.interfaceTable.clear();
        this.ipRouteTable.clear();
        this.portalTable.clear();
        this.neighborTable.clear();
        this.managerTable.clear();
        this.hardwareObj = null;
        this.interfaceStatisticsTable.clear();
        this.m_udpListenerStatisticsTable.clear();
        this.m_tcpConnectionStatisticsTable.clear();
        this.m_iscsiInstances.clear();
        this.m_iscsiSessions.clear();
        this.m_iscsiRemoteInitiators.clear();
        this.m_iscsiRemoteInitiatorsStatistics.clear();
        this.m_iscsiSessionsStatistics.clear();
        this.m_iscsiInitiators.clear();
        this.m_sessionsGroupStatistics.clear();
        this.ifaceGroup.clear();
        if (this.icmpImpl != null) {
            this.icmpImpl.clear();
        }
        if (this.udpImpl != null) {
            this.udpImpl.clear();
        }
        if (this.m_remoteInitiatorsGroupStatistics != null) {
            ((ISCSIRemoteInitiatorsGroupStatisticsImpl)this.m_remoteInitiatorsGroupStatistics).clear();
        }
        this.addParameterCode(ParameterCode.VSWITCH_CONTACT);
        this.addParameterCode(ParameterCode.VSWITCH_DATE_AND_TIME);
        this.addParameterCode(ParameterCode.VSWITCH_DESCRIPTION);
        this.addParameterCode(ParameterCode.VSWITCH_LAST_RESET);
        this.addParameterCode(ParameterCode.VSWITCH_LOCATION);
        this.addParameterCode(ParameterCode.VSWITCH_NAME);
        this.addParameterCode(ParameterCode.VSWITCH_CONNECTIVITY_STATUS);
        this.addParameterCode(ParameterCode.VSWITCH_TELNET_PORT);
        this.addParameterCode(ParameterCode.VSWITCH_LAST_KEEPALIVE);
        this.addParameterCode(ParameterCode.VSWITCH_KEEPALIVE_INTERVAL);
        this.addParameterCode(ParameterCode.VSWITCH_SUSPICIOUS_INTERVAL);
        this.addParameterCode(ParameterCode.VSWITCH_FAULTY_INTERVAL);
        this.addParameterCode(ParameterCode.VSWITCH_TAKE_OVER_STATE);
        this.addParameterCode(ParameterCode.VSWITCH_FAILOVER_ENABLE);
        this.addParameterCode(ParameterCode.VSWITCH_SWITCH_ID);
        this.addParameterCode(ParameterCode.VSWITCH_REPORT_LUN_DISCOVERY);
        this.addParameterCode(ParameterCode.VSWITCH_STATUS);
    }

    public boolean isVirtualizationDiscoverCompleted() {
        return this.virtualizationDiscoverCompleted;
    }

    public void setVSwitchDiscoverCompleted(boolean complete) {
        this.vSwitchDiscoverCompleted = complete;
    }

    public boolean isVSwitchDiscoverCompleted() {
        return this.vSwitchDiscoverCompleted;
    }

    public void setVirtualizationDiscoverCompleted(boolean complete) {
        this.virtualizationDiscoverCompleted = complete;
    }

    public Integer getKeepAliveInterval() throws RemoteException {
        return (Integer)this.getValueOf(this, ParameterCode.VSWITCH_KEEPALIVE_INTERVAL);
    }

    public Integer getSuspiciousInterval() throws RemoteException {
        return (Integer)this.getValueOf(this, ParameterCode.VSWITCH_SUSPICIOUS_INTERVAL);
    }

    public Integer getFaultyInterval() throws RemoteException {
        return (Integer)this.getValueOf(this, ParameterCode.VSWITCH_FAULTY_INTERVAL);
    }

    public void removeNeighbor(String neighborIp) throws RemoteException {
        Enumeration e = this.neighborTable.elements();
        while (e.hasMoreElements()) {
            Neighbor neighbor = (Neighbor)e.nextElement();
            if (!neighbor.getIPAddress().equals(neighborIp)) continue;
            try {
                logger.info("Wait 2sec. before deleting neighbor " + neighbor);
                Thread.sleep(2000L);
                logger.info("Trying to delete neighbor " + neighbor + " (after waiting 2sec.)");
                neighbor.deleteElement();
            }
            catch (IllegalValueException ive) {
                logger.warning(ive.getMessage());
            }
            catch (InterruptedException ie) {
                logger.debug(ie);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof VSwitch) {
            if (super.equals(obj)) {
                return true;
            }
            if (this.m_ipAddr == null || ((VSwitchImpl)obj).m_ipAddr == null) {
                return false;
            }
            return this.m_ipAddr.equals(((VSwitchImpl)obj).m_ipAddr);
        }
        return false;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    public AlarmGenerator getAlarmGenerator() {
        return VSwitchAlarmGenerator.getInstance();
    }

    public boolean isUnderTakeover() throws RemoteException {
        SDTakeOverStateConstant takeOver = this.getTakeOverState();
        return takeOver == null ? true : takeOver.equals(SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER);
    }

    public SDTakeOverStateConstant getTakeOverState() throws RemoteException {
        SDTakeOverStateConstant takeover = (SDTakeOverStateConstant)this.getSrValueOf(this, ParameterCode.VSWITCH_TAKE_OVER_STATE);
        return takeover;
    }

    public void setNeighborInvalid(String neighborIp) {
        this.neighborValid = neighborIp;
    }

    public boolean isNeighborValid() {
        return this.neighborValid == null;
    }

    public String getInvalidNeighborIp() {
        return this.neighborValid;
    }

    public Boolean isFailoverEnable() throws RemoteException {
        SrInteger value = (SrInteger)this.getSrValueOf(this, ParameterCode.VSWITCH_FAILOVER_ENABLE);
        if (value != null) {
            return value.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public Integer getSwitchID() throws RemoteException {
        return (Integer)this.getValueOf(this, ParameterCode.VSWITCH_SWITCH_ID);
    }

    public Boolean isReportLUNsDiscoveryEnable() throws RemoteException {
        Integer enable = (Integer)this.getValueOf(this, ParameterCode.VSWITCH_REPORT_LUN_DISCOVERY);
        if (enable == null) {
            return null;
        }
        return new Boolean(enable == 1);
    }

    public void deleteFromDatabase() throws RemoteException, IllegalValueException {
        this.deleteFromDatabase = true;
        this.deleteElement();
    }

    public void moveToCluster(Integer clusterVSwitchGroupId) throws RemoteException, IllegalValueException {
        ClusterImpl dstCluster = (ClusterImpl)SystemRootImpl.getInstance().getVSwitchGroup(clusterVSwitchGroupId);
        this.setWatingMovingCluster(dstCluster);
        this.deleteFromDatabase();
    }

    private Vector getThisMachineManagers() throws RemoteException {
        Vector<ManagerImpl> managers = new Vector<ManagerImpl>();
        Integer trapPort = this.getTrapPort();
        String[] ips = Server.getHostAddressListAsStringArray();
        Enumeration e = this.getManagerTable().elements();
        while (e.hasMoreElements()) {
            ManagerImpl manager = (ManagerImpl)e.nextElement();
            if (!manager.isEqualTo(ips, trapPort)) continue;
            managers.addElement(manager);
        }
        return managers;
    }

    public boolean isPendingMovingToCluster() {
        return this.watingMovingCluster != null;
    }

    public Cluster getWatingMovingCluster() {
        return this.watingMovingCluster;
    }

    public void setWatingMovingCluster(Cluster moveToCluster) {
        this.watingMovingCluster = moveToCluster;
    }

    private boolean isManagerDefined() throws RemoteException {
        if (this.getManagerTable().isEmpty()) {
            return false;
        }
        String managerIP = DataMgr.getSnmpManagerIPAddress(this.getCommKeys());
        if (managerIP != null) {
            Enumeration e = this.getManagerTable().elements();
            while (e.hasMoreElements()) {
                Manager manager = (Manager)e.nextElement();
                if (!manager.getIPAddress().equals(managerIP) || manager.getTrapPort().compareTo(this.getTrapPort()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public Vector getLinkDownInterfaces() throws RemoteException {
        Vector<InterfaceTableRowImpl> interfaces = new Vector<InterfaceTableRowImpl>();
        Enumeration e = this.getInterfaceTable().elements();
        while (e.hasMoreElements()) {
            InterfaceTableRowImpl inter = (InterfaceTableRowImpl)e.nextElement();
            if (!inter.isLinkDown()) continue;
            interfaces.addElement(inter);
        }
        return interfaces;
    }

    public Vector getMismatchSpeedSFPInterfaces() throws RemoteException {
        Vector<InterfaceTableRowImpl> interfaces = new Vector<InterfaceTableRowImpl>();
        Enumeration e = this.getInterfaceTable().elements();
        while (e.hasMoreElements()) {
            InterfaceTableRowImpl inter = (InterfaceTableRowImpl)e.nextElement();
            if (!(inter instanceof SFPConnectedInterfaceImpl) || inter.isManagementInterface()) continue;
            SFPConnectedInterfaceImpl sfpConnectedInterface = (SFPConnectedInterfaceImpl)inter;
            BigInteger interfaceSpeed = sfpConnectedInterface.getHighSpeed();
            Integer connectorSpeed = sfpConnectedInterface.getConnectedSFPSpeed();
            if (sfpConnectedInterface.isConnctorTypeUnkonwn() || interfaceSpeed.intValue() == connectorSpeed.intValue()) continue;
            interfaces.addElement(inter);
        }
        return interfaces;
    }

    public Vector getUnknownInterfacesInterfaces() throws RemoteException {
        Vector<InterfaceTableRowImpl> interfaces = new Vector<InterfaceTableRowImpl>();
        Enumeration e = this.getInterfaceTable().elements();
        while (e.hasMoreElements()) {
            InterfaceTableRowImpl inter = (InterfaceTableRowImpl)e.nextElement();
            if (!inter.isUnknown()) continue;
            interfaces.addElement(inter);
        }
        return interfaces;
    }

    public SrInteger getIntervalValue(ParameterCode pollIntervalParam, VSwitch vSwitch) throws RemoteException {
        SrInteger interval;
        Parameter pollInterval = this.getParameter(this, pollIntervalParam);
        if (pollInterval != null && (interval = (SrInteger)pollInterval.getValue()) != null && !interval.equals(0)) {
            return interval;
        }
        return this.cluster.getIntervalValue(pollIntervalParam, this);
    }

    public Vector getRemoteInitiators() throws RemoteException {
        Vector<ISCSIRemoteInitiator> initiators = new Vector<ISCSIRemoteInitiator>();
        try {
            Vector targets = this.getCluster().getStorage().getTargetList();
            for (int i = 0; i < targets.size(); ++i) {
                ISCSIRemoteInitiator[] targetInitiators;
                boolean isTargetConnectedToOneVSwitchInCluster;
                ISCSITargetImpl target = (ISCSITargetImpl)targets.get(i);
                boolean bl = isTargetConnectedToOneVSwitchInCluster = target.getConnectedVSwitches().length == 1;
                if (!target.getExposedOnVSwitch().equalsIgnoreCase(this.getName()) && !isTargetConnectedToOneVSwitchInCluster || (targetInitiators = target.getISCSIRemoteInitiators()).length <= 0) continue;
                for (int index = 0; index < targetInitiators.length; ++index) {
                    initiators.add(targetInitiators[index]);
                }
            }
        }
        catch (RemoteException re) {
            logger.info("No targets availabe in cluster!");
        }
        return initiators;
    }

    public Boolean isRemoteInitiatorKnownByVSwitch(String remoteInitiatorName) throws RemoteException {
        Vector knownRemoteInitiators = this.getRemoteInitiators();
        for (int index = 0; index < knownRemoteInitiators.size(); ++index) {
            ISCSIRemoteInitiator remoteInitiator = (ISCSIRemoteInitiator)knownRemoteInitiators.get(index);
            if (remoteInitiator.getInitiatorName() == null) {
                logger.warning("Couldn't create an inbound session element: ISCSIRemoteInitiator without a name value.");
                return null;
            }
            if (!remoteInitiator.getInitiatorName().equals(remoteInitiatorName)) continue;
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    private void addISCSIInstance(ISCSIInstance iscsiInstance) {
        this.m_iscsiInstances.addElement(iscsiInstance);
    }

    private void removeISCSIInstance(ISCSIInstance iscsiInstance) {
        this.m_iscsiInstances.removeElement(iscsiInstance);
    }

    private void addISCSISession(ISCSISession iscsiSession) {
        this.m_iscsiSessions.addElement(iscsiSession);
    }

    private void removeISCSISession(ISCSISession iscsiSession) {
        this.m_iscsiSessions.removeElement(iscsiSession);
    }

    public void addISCSIInitiator(ISCSIInitiator iscsiInitiator) {
        this.m_iscsiInitiators.add(iscsiInitiator);
    }

    public void removeISCSIInitiator(ISCSIInitiator iscsiInitiator) {
        this.m_iscsiInitiators.remove(iscsiInitiator);
    }

    private void addISCSIRemoteInitiator(ISCSIRemoteInitiator iscsiRemoteInitiator) {
        this.m_iscsiRemoteInitiators.addElement(iscsiRemoteInitiator);
    }

    private void removeISCSIRemoteInitiator(ISCSIRemoteInitiator iscsiRemoteInitiator) {
        this.m_iscsiRemoteInitiators.removeElement(iscsiRemoteInitiator);
    }

    public Vector getISCSIInstancesTable() throws RemoteException {
        return this.m_iscsiInstances;
    }

    public Vector getISCSISessionsTable() throws RemoteException {
        return this.m_iscsiSessions;
    }

    public Vector getISCSIRemoteInitiatorsTable() throws RemoteException {
        return this.m_iscsiRemoteInitiators;
    }

    public Vector getISCSIRemoteInitiatorsStatisticsTable() throws RemoteException {
        return this.m_iscsiRemoteInitiatorsStatistics;
    }

    public ISCSIInitiator[] getISCSIInitiators() throws RemoteException {
        ISCSIInitiator[] initiators = new ISCSIInitiator[this.m_iscsiInitiators.size()];
        return this.m_iscsiInitiators.toArray(initiators);
    }

    private void addISCSIRemoteInitiatorStatistics(ISCSIRemoteInitiatorStatistics iscsiRemoteInitiatorStatistics) {
        this.m_iscsiRemoteInitiatorsStatistics.addElement(iscsiRemoteInitiatorStatistics);
    }

    private void removeISCSIRemoteInitiatorStatistics(ISCSIRemoteInitiatorStatistics iscsiRemoteInitiatorStatistics) {
        this.m_iscsiRemoteInitiatorsStatistics.removeElement(iscsiRemoteInitiatorStatistics);
    }

    public ISCSIRemoteInitiatorsGroupStatistics getISCSIRemoteInitiatorsGroupStatistics() throws RemoteException {
        return this.m_remoteInitiatorsGroupStatistics;
    }

    public ISCSISessionsGroupStatistics getISCSISessionsGroupStatistics() throws RemoteException {
        return this.m_sessionsGroupStatistics;
    }

    public Vector getISCSISessionsStatisticsTable() throws RemoteException {
        return this.m_iscsiSessionsStatistics;
    }

    private void addISCSISessionStatistics(ISCSISessionStatistics iscsiSessionStatistics) {
        this.m_iscsiSessionsStatistics.addElement(iscsiSessionStatistics);
    }

    private void removeISCSISessionStatistics(ISCSISessionStatistics iscsiSessionStatistics) {
        this.m_iscsiSessionsStatistics.removeElement(iscsiSessionStatistics);
    }

    public boolean hasJournal() throws RemoteException {
        return true;
    }

    public boolean hasPortalTarget() throws RemoteException {
        Vector portals = this.getPortalTable();
        int portalSize = portals.size();
        if (portals != null) {
            for (int i = 0; i < portalSize; ++i) {
                if ((PortalTableRowImpl)portals.get(i) == null || !((PortalTableRowImpl)portals.get(i)).isTargetRole()) continue;
                return true;
            }
        }
        return false;
    }

    public void refreshRemoteDiscoveryPortalsTable() throws RemoteException {
        ConfigElementData element = new ConfigElementData(ClassID.ISCSI_REMOTE_DISCOVERY_PORTAL);
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_LAST_FAILURE, (SrType)null);
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_LAST_DISCOVERY_SUCCESS_TIME, (SrType)null);
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_NEXT_PLANNED_DISCOVERY, (SrType)null);
        element.setValue(ParameterCode.REMOTE_PORTAL_DISC_STATE, (SrType)null);
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, this.getCommKeyClassId()));
        DataMgr.getInstance().refreshTableFields(element);
    }

    public boolean isIPExistedAsLocalIP(String ip) throws RemoteException {
        Vector ipTable = this.getIPTable();
        for (int index = 0; index < ipTable.size(); ++index) {
            IPTableRow vswitchIP = (IPTableRow)ipTable.get(index);
            if (!vswitchIP.getIPAddress().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsRoutIP(String ip) throws RemoteException {
        Vector ipRoutTable = this.getIPRouteTable();
        for (int index = 0; index < ipRoutTable.size(); ++index) {
            IPRouteTableRow routIP = (IPRouteTableRow)ipRoutTable.get(index);
            if (!routIP.getDestIPAdress().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsLocalPortal(String ip) throws RemoteException {
        Vector portalTable = this.getPortalTable();
        for (int index = 0; index < portalTable.size(); ++index) {
            PortalTableRow portal = (PortalTableRow)portalTable.get(index);
            if (!portal.getIPAddress().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsLocalPortal(String ip, int port) throws RemoteException {
        Vector portalTable = this.getPortalTable();
        for (int index = 0; index < portalTable.size(); ++index) {
            PortalTableRow portal = (PortalTableRow)portalTable.get(index);
            if (!portal.getIPAddress().equals(ip) || portal.getPort() != port) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsSNMPManager(String ip) throws RemoteException {
        Vector managerTable = this.getManagerTable();
        for (int index = 0; index < managerTable.size(); ++index) {
            ManagerImpl manager = (ManagerImpl)managerTable.get(index);
            if (!manager.getIPAddress().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPExistedAsNeighbor(String ip) throws RemoteException {
        Vector neigborsTable = this.getNeighborTable();
        for (int index = 0; index < neigborsTable.size(); ++index) {
            NeighborImpl neighbor = (NeighborImpl)neigborsTable.get(index);
            if (!neighbor.getIPAddress().equals(ip)) continue;
            return true;
        }
        return false;
    }

    public void changeRemotetargetPortalsIfNeeded() throws RemoteException {
        Vector portalTable = this.getPortalTable();
        ArrayList clustersInOtherSites = SystemRootImpl.getInstance().getClustersInOtherSites(this.getCluster().getParentSite());
        for (int index0 = 0; index0 < clustersInOtherSites.size(); ++index0) {
            ClusterImpl remoteCluster = (ClusterImpl)clustersInOtherSites.get(index0);
            for (int index1 = 0; index1 < portalTable.size(); ++index1) {
                PortalTableRowImpl portal = (PortalTableRowImpl)portalTable.get(index1);
                portal.synchronizeNewElementOnRemoteCluster(remoteCluster);
            }
        }
    }

    public void refreshFields(ConfigElementData element) throws RemoteException {
        if (this.isConnected()) {
            super.refreshFields(element);
        }
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.VSWITCH_SYS_OID);
        parameterCodes.addElement(ParameterCode.VSWITCH_IP_ADDRESS);
        parameterCodes.addElement(ParameterCode.VSWITCH_IP_MASK);
        parameterCodes.addElement(ParameterCode.VSWITCH_READ_COMMUNITY);
        parameterCodes.addElement(ParameterCode.VSWITCH_WRITE_COMMUNITY);
        parameterCodes.addElement(ParameterCode.VSWITCH_SNMP_UDP_PORT);
        parameterCodes.addElement(ParameterCode.VSWITCH_TRAP_UDP_PORT);
        parameterCodes.addElement(ParameterCode.VSWITCH_SNMP_VERSION);
        parameterCodes.addElement(ParameterCode.VSWITCH_MAX_RETRIES);
        parameterCodes.addElement(ParameterCode.VSWITCH_TIMEOUT);
        parameterCodes.addElement(ParameterCode.VSWITCH_CONTACT);
        parameterCodes.addElement(ParameterCode.VSWITCH_DATE_AND_TIME);
        parameterCodes.addElement(ParameterCode.VSWITCH_DESCRIPTION);
        parameterCodes.addElement(ParameterCode.VSWITCH_LAST_RESET);
        parameterCodes.addElement(ParameterCode.VSWITCH_LOCATION);
        parameterCodes.addElement(ParameterCode.VSWITCH_NAME);
        parameterCodes.addElement(ParameterCode.VSWITCH_CONNECTIVITY_STATUS);
        parameterCodes.addElement(ParameterCode.VSWITCH_TELNET_PORT);
        parameterCodes.addElement(ParameterCode.VSWITCH_LAST_KEEPALIVE);
        parameterCodes.addElement(ParameterCode.VSWITCH_KEEPALIVE_INTERVAL);
        parameterCodes.addElement(ParameterCode.VSWITCH_SUSPICIOUS_INTERVAL);
        parameterCodes.addElement(ParameterCode.VSWITCH_FAULTY_INTERVAL);
        parameterCodes.addElement(ParameterCode.VSWITCH_TAKE_OVER_STATE);
        parameterCodes.addElement(ParameterCode.VSWITCH_FAILOVER_ENABLE);
        parameterCodes.addElement(ParameterCode.VSWITCH_SWITCH_ID);
        parameterCodes.addElement(ParameterCode.VSWITCH_REPORT_LUN_DISCOVERY);
        parameterCodes.addElement(ParameterCode.VSWITCH_STATUS);
        parameterCodes.addElement(ParameterCode.TEMPERATURE_UNITS);
        parameterCodes.addElement(ParameterCode.GENERAL_POLL_INTERVAL);
        parameterCodes.addElement(ParameterCode.VIRTUALIZATION_POLL_INTERVAL);
        parameterCodes.addElement(ParameterCode.ACL_POLL_INTERVAL);
        parameterCodes.addElement(ParameterCode.NET_POLL_INTERVAL);
        parameterCodes.addElement(ParameterCode.STATISTIC_POLL_INTERVAL);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

