/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.hardware.Hardware;
import com.sanrad.nms.server.logic.initiator.ISCSIInitiator;
import com.sanrad.nms.server.logic.initiator.ISCSIRemoteInitiatorsGroupStatistics;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionsGroupStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.ICMPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.IPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfacesGroupStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.TCPStatistics;
import com.sanrad.nms.server.logic.vswitch.statistics.UDPStatistics;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.TempetureUnitConstant;
import com.sanrad.nms.server.util.types.constants.VSwitchSysOID;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Vector;

public interface VSwitch
extends LogicObject {
    public String getMgmIPAddr() throws RemoteException;

    public String getMgmMask() throws RemoteException;

    public int getSnmpPort() throws RemoteException;

    public Integer getTrapPort() throws RemoteException;

    public String getReadCommunity() throws RemoteException;

    public String getWriteCommunity() throws RemoteException;

    public long getTimeout() throws RemoteException;

    public int getNumberOfRetries() throws RemoteException;

    public SnmpVersion getSnmpVersion() throws RemoteException;

    public void rediscover() throws RemoteException;

    public void manualDiscover() throws RemoteException;

    public void reset() throws RemoteException;

    public void shutdown() throws RemoteException;

    public void wakeOnLAN() throws RemoteException, IllegalValueException;

    public String getName() throws RemoteException;

    public String getDescription() throws RemoteException;

    public String getContact() throws RemoteException;

    public String getLocation() throws RemoteException;

    public Long getLastReset() throws RemoteException;

    public Long getLastKeepAlive() throws RemoteException;

    public Long getDateAndTime() throws RemoteException;

    public SDTakeOverStateConstant getTakeOverState() throws RemoteException;

    public VSwitchSysOID getVSwitchType() throws RemoteException;

    public Hardware getHardware() throws RemoteException;

    public TempetureUnitConstant getTempUnits() throws RemoteException;

    public Long getPreviousDateAndTime() throws RemoteException;

    public boolean isConnected() throws RemoteException;

    public Vector getIPTable() throws RemoteException;

    public Vector getInterfaceTable() throws RemoteException;

    public Vector getPortalTable() throws RemoteException;

    public Vector getIPRouteTable() throws RemoteException;

    public Vector getNeighborTable() throws RemoteException;

    public Vector getManagerTable() throws RemoteException;

    public void createIPTableRow(String var1, String var2, String var3, String var4) throws RemoteException, IllegalValueException;

    public void createIPRouteTableRow(String var1, String var2, String var3, String var4) throws RemoteException, IllegalValueException;

    public void createPortalTableRow(String var1, int var2) throws RemoteException, IllegalValueException;

    public Vector getEthernetInterfaces() throws RemoteException;

    public Vector getIPActivityOptions() throws RemoteException;

    public BigInteger getTelnetPort() throws RemoteException;

    public Integer getSwitchID() throws RemoteException;

    public Boolean isReportLUNsDiscoveryEnable() throws RemoteException;

    public String getWWNN() throws RemoteException;

    public String getFunctions() throws RemoteException;

    public Vector getInterfacesStatisticsTable() throws RemoteException;

    public InterfacesGroupStatistics getInterfacesGroupStatistics() throws RemoteException;

    public IPStatistics getIPStatistics() throws RemoteException;

    public ICMPStatistics getICMPStatistics() throws RemoteException;

    public TCPStatistics getTCPStatistics() throws RemoteException;

    public UDPStatistics getUDPStatistics() throws RemoteException;

    public Vector getUDPListenerStatisticsTable() throws RemoteException;

    public Vector getTCPConnectionStatisticsTable() throws RemoteException;

    public Vector getISCSIInstancesTable() throws RemoteException;

    public Vector getISCSISessionsTable() throws RemoteException;

    public Vector getISCSIRemoteInitiatorsTable() throws RemoteException;

    public Vector getISCSIRemoteInitiatorsStatisticsTable() throws RemoteException;

    public Vector getISCSISessionsStatisticsTable() throws RemoteException;

    public ISCSIRemoteInitiatorsGroupStatistics getISCSIRemoteInitiatorsGroupStatistics() throws RemoteException;

    public ISCSISessionsGroupStatistics getISCSISessionsGroupStatistics() throws RemoteException;

    public ISCSIInitiator[] getISCSIInitiators() throws RemoteException;

    public void refreshRemoteDiscoveryPortalsTable() throws RemoteException;

    public boolean isUnderTakeover() throws RemoteException;
}

