/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.TableRow;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public abstract class TableRowImpl
extends LogicObjectImpl
implements TableRow {
    private VSwitch parentVSwitch = null;

    protected TableRowImpl(ClusterImpl cluster, ClassID classId, List parameterCodeList) throws RemoteException {
        super(cluster, classId, parameterCodeList);
        this.addParameterCode(ParameterCode.VSWITCH_ID);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        CommKeyClassId vSwitchCommKeyClassId = (CommKeyClassId)parameterList.get(ParameterCode.VSWITCH_ID);
        VSwitch vSwitch = (VSwitch)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(vSwitchCommKeyClassId);
        this.setParentVSwitch(vSwitch);
        return changedValues;
    }

    protected void setParentVSwitch(VSwitch vSwitch) throws RemoteException {
        if (this.parentVSwitch == null && vSwitch != null) {
            this.parentVSwitch = vSwitch;
            ((VSwitchImpl)this.parentVSwitch).addTableRow(this);
        }
    }

    public VSwitch getParentVSwitch() throws RemoteException {
        return this.parentVSwitch;
    }

    public void clear() throws RemoteException {
        super.clear();
    }

    public int decrementConnectedVSwitchCounter(CommKey[] vSwitchCommKeys) {
        int vSwitchCounter = super.decrementConnectedVSwitchCounter(vSwitchCommKeys);
        if (vSwitchCounter == 0) {
            try {
                ((VSwitchImpl)this.parentVSwitch).removeTableRow(this);
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        return vSwitchCounter;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }
}

