/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.vswitch.IPTableRow;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.util.NetUtil;
import java.rmi.RemoteException;

public class PortalTableRowValidator
extends LogicObjectValidator {
    private static final int MAX_NUMBER = 100;
    private String ip;
    private int port;
    private VSwitchImpl vSwitch;

    public PortalTableRowValidator(VSwitchImpl vSwitch, String ip, int port) {
        this.vSwitch = vSwitch;
        this.ip = ip;
        this.port = port;
    }

    public boolean isValid() throws RemoteException {
        if (this.vSwitch.getPortalTable().size() >= 100) {
            this.setErrorMsg("You cannot create more than 100 portals in " + ClassID.VSWITCH + " " + this.vSwitch.getName());
            return false;
        }
        if (this.vSwitch.getPortalTableRow(this.ip, this.port) != null) {
            this.setErrorMsg(ClassID.PORTAL + " " + this.ip + ":" + this.port + " already exists in " + ClassID.VSWITCH + " " + this.vSwitch.getName());
            return false;
        }
        if (this.ip.equals(this.vSwitch.getMgmIPAddr())) {
            this.setErrorMsg("You cannot create a portal on the management ip address " + this.ip);
            return false;
        }
        if (!NetUtil.isNetworkIpValid(this.ip)) {
            this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.ip));
            return false;
        }
        IPTableRow ipTableRow = this.vSwitch.getIPTableRow(this.ip);
        if (this.vSwitch.isUnderTakeover() && ipTableRow.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_SWITCHED.getDescriptionName())) {
            this.setErrorMsg("Cannot add portal on IP that is " + ipTableRow.getActivity());
            return false;
        }
        return true;
    }
}

