/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SitesSynchronizeable;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortal;
import com.sanrad.nms.server.logic.target.ISCSITarget;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.vswitch.IPTableRow;
import com.sanrad.nms.server.logic.vswitch.PortalTableRow;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.IscsiPortalRolesConstant;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class PortalTableRowImpl
extends TableRowImpl
implements PortalTableRow,
SitesSynchronizeable {
    private static List parameterCodeList;

    public PortalTableRowImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.PORTAL, parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.getIPAddress() + ":" + this.getPort();
        return changedValues;
    }

    protected String canBeDeleted() throws RemoteException {
        IPTableRow ipTableRow = ((VSwitchImpl)this.getParentVSwitch()).getIPTableRow(this.getIPAddress());
        if (((VSwitchImpl)this.getParentVSwitch()).isUnderTakeover() && ipTableRow.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_SWITCHED.getDescriptionName())) {
            return "You cannot remove portal on IP that is " + ipTableRow.getActivity();
        }
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public String getIPAddress() throws RemoteException {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.ISCSI_PORTAL_IP_ADDRESS);
    }

    public Integer getPort() throws RemoteException {
        BigInteger port = (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_PORTAL_PORT);
        return port == null ? null : new Integer(port.toString());
    }

    public IscsiPortalRolesConstant getRole() throws RemoteException {
        IscsiPortalRolesConstant role = (IscsiPortalRolesConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_PORTAL_ROLE);
        return role;
    }

    public Integer getTag() throws RemoteException {
        Integer retTag = null;
        VSwitchImpl parentVSwitch = (VSwitchImpl)this.getParentVSwitch();
        if (parentVSwitch != null) {
            IPTableRow ipTableRow = parentVSwitch.getIPTableRow(this.getIPAddress());
            if (ipTableRow.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_ACTIVE.getDescriptionName())) {
                retTag = parentVSwitch.getSwitchID();
            } else if (ipTableRow.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_SWITCHED.getDescriptionName())) {
                Integer activeVSwitchTag = parentVSwitch.getSwitchID();
                retTag = activeVSwitchTag == 1 ? new Integer(0) : new Integer(1);
            } else {
                VSwitchImpl otherVSwitch = (VSwitchImpl)((ClusterImpl)this.getCluster()).getOtherVSwitch(parentVSwitch);
                if (otherVSwitch != null) {
                    retTag = otherVSwitch.getSwitchID();
                }
            }
        }
        return retTag;
    }

    public boolean isTargetRole() throws RemoteException {
        IscsiPortalRolesConstant role = this.getRole();
        return role.equals(IscsiPortalRolesConstant.TARGET) || role.equals(IscsiPortalRolesConstant.TARGET_AND_INITIATOR);
    }

    public void synchronizeNewElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
        if (this.isTargetRole() && remoteCluster.isDiscoverCompleted()) {
            Vector localTargets = this.getCluster().getStorage().getTargetList();
            for (int index0 = 0; index0 < localTargets.size(); ++index0) {
                ISCSITarget target = (ISCSITarget)localTargets.get(index0);
                VSwitch vswitch = ((ISCSITargetImpl)target).getExposedOnVSwitchObject();
                ArrayList targetPortals = ((ClusterImpl)this.getCluster()).getAllTargetPortals(vswitch);
                ISCSIRemoteTargetImpl equivalentRemoteTarget = (ISCSIRemoteTargetImpl)((ClusterImpl)this.getCluster()).findLocalTargetInRemoteCluster(remoteCluster, target.getName());
                if (equivalentRemoteTarget == null || !targetPortals.contains(this)) continue;
                VSwitch[] createOnVSwitch = equivalentRemoteTarget.getConnectedVSwitches();
                equivalentRemoteTarget.createLocalPortalInRemoteCluster(this, createOnVSwitch);
            }
        }
    }

    public void synchronizeChangeElementOnRemoteCluster(Cluster remoteCluster, HashMap changedValues) throws RemoteException {
    }

    public void synchronizePreRemoveElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
        if (this.isTargetRole()) {
            Vector localTargets = this.getCluster().getStorage().getTargetList();
            for (int index1 = 0; index1 < localTargets.size(); ++index1) {
                ISCSITarget target = (ISCSITarget)localTargets.get(index1);
                ISCSIRemoteTarget equivalentRemoteTarget = ((ClusterImpl)this.getCluster()).findLocalTargetInRemoteCluster(remoteCluster, target.getName());
                if (equivalentRemoteTarget == null) continue;
                try {
                    ISCSIRemoteTargetPortal[] remotePortals = equivalentRemoteTarget.getISCSIPortals();
                    for (int index = 0; index < remotePortals.length; ++index) {
                        ISCSIRemoteTargetPortal remotePortal = remotePortals[index];
                        if (!this.equivalentTo(remotePortal)) continue;
                        remotePortal.deleteElement();
                    }
                    continue;
                }
                catch (IllegalValueException ive) {
                    // empty catch block
                }
            }
        }
    }

    public void synchronizeDiscoveryElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
        this.synchronizeNewElementOnRemoteCluster(remoteCluster);
    }

    public void synchronizePostRemoveElementOnRemoteCluster(Cluster remoteCluster) throws RemoteException {
    }

    private boolean equivalentTo(ISCSIRemoteTargetPortal remotePortal) throws RemoteException {
        String ip = remotePortal.getIPAddress();
        BigInteger port = remotePortal.getPort();
        Integer tag = remotePortal.getPortalGroupTag();
        return ip.equals(this.getIPAddress()) && port.intValue() == this.getPort().intValue() && tag.intValue() == this.getTag().intValue();
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.ISCSI_PORTAL_IP_ADDRESS);
        parameterCodes.addElement(ParameterCode.ISCSI_PORTAL_PORT);
        parameterCodes.addElement(ParameterCode.ISCSI_PORTAL_ROLE);
        parameterCodes.addElement(ParameterCode.NETWORK_CONFIG_INTERFACE);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

