/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.vswitch.NeighborAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.Neighbor;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.constants.SDNeighborStatusConstant;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class NeighborImpl
extends TableRowImpl
implements Neighbor {
    private static List parameterCodeList;
    private String ip = null;

    public NeighborImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.NEIGHBORE, parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.ip = this.getIPAddress();
        return changedValues;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public String getName() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_NAME);
    }

    public String getIPAddress() throws RemoteException {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_IP_ADDRESS);
    }

    public Long getLastKeepAliveReceived() throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.NEIGHBOR_LAST_KEEPALIVE));
        DataMgr.getInstance().refreshTableFields(element);
        return (Long)this.getValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_LAST_KEEPALIVE);
    }

    private SDNeighborStatusConstant getStatusConst() throws RemoteException {
        if ((SDNeighborStatusConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_STATUS) == null) {
            return SDNeighborStatusConstant.SD_NEIGHBOR_STATUS_UNKNOWN;
        }
        return (SDNeighborStatusConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_STATUS);
    }

    private boolean isInStatus(SDNeighborStatusConstant status) throws RemoteException {
        return this.getStatusConst().equals(status);
    }

    public boolean isDead() throws RemoteException {
        return this.isInStatus(SDNeighborStatusConstant.SD_NEIGHBOR_STATUS_DEAD);
    }

    public boolean isAlive() throws RemoteException {
        return this.isInStatus(SDNeighborStatusConstant.SD_NEIGHBOR_STATUS_ALIVE);
    }

    public boolean isMissConfigured() {
        return false;
    }

    public boolean isSuspicious() throws RemoteException {
        return this.isInStatus(SDNeighborStatusConstant.SD_NEIGHBOR_STATUS_SUSPICIOUS);
    }

    public boolean isUnknown() throws RemoteException {
        return this.isInStatus(SDNeighborStatusConstant.SD_NEIGHBOR_STATUS_UNKNOWN);
    }

    public String getStatus() throws RemoteException {
        return this.getStatusConst().toString();
    }

    public long getTimeout() throws RemoteException {
        int timeout = ((SrInteger)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_TIMEOUT)).intValue();
        return Long.parseLong(Integer.toString(timeout));
    }

    public int getNumberOfRetries() throws RemoteException {
        return ((SrInteger)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_RETRIES)).intValue();
    }

    public int getSnmpPort() throws RemoteException {
        return ((SrInteger)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NEIGHBOR_PORT)).intValue();
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Neighbor) {
            return ((NeighborImpl)obj).ip.equals(this.ip);
        }
        return false;
    }

    public AlarmGenerator getAlarmGenerator() {
        return NeighborAlarmGenerator.getInstance();
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.NEIGHBOR_IP_ADDRESS);
        parameterCodes.addElement(ParameterCode.NEIGHBOR_NAME);
        parameterCodes.addElement(ParameterCode.NEIGHBOR_LAST_KEEPALIVE);
        parameterCodes.addElement(ParameterCode.NEIGHBOR_PORT);
        parameterCodes.addElement(ParameterCode.NEIGHBOR_RETRIES);
        parameterCodes.addElement(ParameterCode.NEIGHBOR_STATUS);
        parameterCodes.addElement(ParameterCode.NEIGHBOR_TIMEOUT);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

