/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.Manager;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ManagerImpl
extends TableRowImpl
implements Manager {
    private static List parameterCodeList;
    private String ip = null;

    public ManagerImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.SNMP_MANAGER, parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.ip = this.getIPAddress();
        return changedValues;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String writeCommunity;
        String readCommunity;
        Boolean trapEnable;
        Integer trapPort = (Integer)parameterList.get(ClientParameterCode.MANAGER_TRAP_PORT);
        if (trapPort != null) {
            parameterList.put(ClientParameterCode.MANAGER_TRAP_PORT, new SrInteger(trapPort));
        }
        if ((trapEnable = (Boolean)parameterList.get(ClientParameterCode.MANAGER_TRAP_ENABLE)) != null) {
            parameterList.put(ClientParameterCode.MANAGER_TRAP_ENABLE, new SrBoolean((boolean)trapEnable));
        }
        if ((readCommunity = (String)parameterList.get(ClientParameterCode.MANAGER_READ_COMMUNITY)) != null) {
            parameterList.put(ClientParameterCode.MANAGER_READ_COMMUNITY, new SrString(readCommunity));
        }
        if ((writeCommunity = (String)parameterList.get(ClientParameterCode.MANAGER_WRITE_COMMUNITY)) != null) {
            parameterList.put(ClientParameterCode.MANAGER_WRITE_COMMUNITY, new SrString(writeCommunity));
        }
        return null;
    }

    protected String canBeDeleted() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public String getIPAddress() throws RemoteException {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.MANAGER_IP_ADDRESS);
    }

    public String getReadCommunity() throws RemoteException {
        String readCommunity = (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.MANAGER_READ_COMMUNITY);
        if (readCommunity == null || readCommunity.equals("")) {
            String debugMsg = "Read Community (2) of " + this + " is empty (" + readCommunity + ") !!!! (class: " + this.getClass() + ")";
            System.err.println(debugMsg);
            logger.warning(debugMsg);
            Thread.dumpStack();
        }
        return readCommunity;
    }

    public String getWriteCommunity() throws RemoteException {
        String writeCommunity = (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.MANAGER_WRITE_COMMUNITY);
        if (writeCommunity == null || writeCommunity.equals("")) {
            String debugMsg = "Write Community (2) of " + this + " is empty (" + writeCommunity + ") !!!! (class: " + this.getClass() + ")";
            System.err.println(debugMsg);
            logger.warning(debugMsg);
            Thread.dumpStack();
        }
        return writeCommunity;
    }

    public Integer getTrapPort() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.MANAGER_TRAP_PORT);
    }

    public Boolean isTrapEnable() throws RemoteException {
        boolean result = (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.MANAGER_TRAP_ENABLE) == 1;
        return new Boolean(result);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Manager) {
            return ((ManagerImpl)obj).ip.equals(this.ip);
        }
        return false;
    }

    public boolean isEqualTo(String[] ips, Integer trapPort) throws RemoteException {
        Integer managerTrapPort = this.getTrapPort();
        String managerIp = this.getIPAddress();
        if (managerTrapPort == null || trapPort == null || trapPort.compareTo(managerTrapPort) == 0) {
            for (int i = 0; i < ips.length; ++i) {
                if (!ips[i].equals(managerIp)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.MANAGER_IP_ADDRESS);
        parameterCodes.addElement(ParameterCode.MANAGER_READ_COMMUNITY);
        parameterCodes.addElement(ParameterCode.MANAGER_TRAP_ENABLE);
        parameterCodes.addElement(ParameterCode.MANAGER_TRAP_PORT);
        parameterCodes.addElement(ParameterCode.MANAGER_WRITE_COMMUNITY);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

