/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.logic.AliasObjectValidator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import com.sanrad.nms.server.util.types.constants.IfOperStatConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class InterfaceTableRowImpl
extends TableRowImpl
implements InterfaceTableRow {
    private static List parameterCodeList;
    private String equalsValue = null;
    private String name = null;

    public InterfaceTableRowImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.INTERFACE, parameterCodeList);
    }

    public InterfaceTableRowImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        if (parameterList.get(ParameterCode.IF_NAME) == null && parameterList.containsKey(ParameterCode.IF_NAME)) {
            if (parameterList.get(ParameterCode.IF_DESCRIPTION) == null) {
                parameterList.put(ParameterCode.IF_DESCRIPTION, this.getSrValueOf(ParameterCode.IF_DESCRIPTION));
            }
            if (parameterList.get(ParameterCode.IF_HIGH_SPEED) == null) {
                parameterList.put(ParameterCode.IF_HIGH_SPEED, this.getSrValueOf(ParameterCode.IF_HIGH_SPEED));
            }
            if (parameterList.get(ParameterCode.IF_NAME) == null) {
                parameterList.put(ParameterCode.IF_NAME, this.getSrValueOf(ParameterCode.IF_NAME));
            }
            if (parameterList.get(ParameterCode.IF_OPER_STAT) == null) {
                parameterList.put(ParameterCode.IF_OPER_STAT, this.getSrValueOf(ParameterCode.IF_OPER_STAT));
            }
            if (parameterList.get(ParameterCode.IF_TYPE) == null) {
                parameterList.put(ParameterCode.IF_TYPE, this.getSrValueOf(ParameterCode.IF_TYPE));
            }
            if (parameterList.get(ParameterCode.IF_PHYSICAL_ADDRESS) == null) {
                parameterList.put(ParameterCode.IF_PHYSICAL_ADDRESS, this.getSrValueOf(ParameterCode.IF_PHYSICAL_ADDRESS));
            }
            this.equalsValue = this.getName();
            logger.debug("Inside the PATCH:" + this);
        }
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.getAlias();
        Object nameValue = this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_NAME);
        if (nameValue != null) {
            this.name = nameValue.toString();
        }
        return changedValues;
    }

    protected String canBeDeleted() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String alias = (String)parameterList.get(ClientParameterCode.INTERFACE_ALIAS);
        if (alias != null) {
            String errorMsg = AliasObjectValidator.isAliasValid(alias);
            if (errorMsg != null) {
                return errorMsg;
            }
            VSwitchImpl vSwitch = (VSwitchImpl)this.getParentVSwitch();
            if (vSwitch.isInterfaceAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            parameterList.put(ClientParameterCode.INTERFACE_ALIAS, new SrString(alias));
        }
        return null;
    }

    public String getAlias() throws RemoteException {
        return (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_ALIAS);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.IF_ALIAS);
    }

    public String getPhysicalAddress() throws RemoteException {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.IF_PHYSICAL_ADDRESS);
    }

    public String getDescriptor() throws RemoteException {
        Object value = this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_DESCRIPTION);
        return value == null ? null : value.toString();
    }

    public String getName() throws RemoteException {
        Object nameVal;
        if (this.name == null && (nameVal = this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_NAME)) != null) {
            return nameVal.toString();
        }
        return this.name;
    }

    public BigInteger getHighSpeed() throws RemoteException {
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), ParameterCode.IF_HIGH_SPEED);
    }

    public boolean isEthernet() throws RemoteException {
        IANAifTypeConstant type = (IANAifTypeConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.IF_TYPE);
        return type != null && type.equals(IANAifTypeConstant.IANA_IF_TYPE_ETHERNET);
    }

    public String getType() throws RemoteException {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.IF_TYPE);
    }

    public String getOperationalStatus() throws RemoteException {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.IF_OPER_STAT);
    }

    public boolean isLinkDown() throws RemoteException {
        IfOperStatConstant status = (IfOperStatConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.IF_OPER_STAT);
        return status != null && status.equals(IfOperStatConstant.IF_OPER_STAT_DOWN);
    }

    public boolean isUnknown() throws RemoteException {
        IANAifTypeConstant type = (IANAifTypeConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.IF_TYPE);
        return type != null && type.equals(IANAifTypeConstant.IANA_IF_TYPE_UNKNOWN);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof InterfaceTableRow && this.equalsValue != null) {
            return this.equalsValue.equals(((InterfaceTableRowImpl)obj).equalsValue);
        }
        return false;
    }

    public String[] checkAliasConsistencyBetweenVSwitches() throws RemoteException {
        return null;
    }

    public boolean isManagementInterface() throws RemoteException {
        return this.getName().equals("mgnt");
    }

    protected void setVswitchesToPerformOperation(ConfigElementData element, HashMap parameterList) throws RemoteException, IllegalValueException {
        CommKeyClassId[] vswitches = this.getConnectedVswitchesData();
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vswitches));
    }

    public void changeElement(HashMap parameterList) throws RemoteException, IllegalValueException {
        super.changeElement(parameterList);
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.IF_ALIAS);
        parameterCodes.addElement(ParameterCode.IF_DESCRIPTION);
        parameterCodes.addElement(ParameterCode.IF_HIGH_SPEED);
        parameterCodes.addElement(ParameterCode.IF_NAME);
        parameterCodes.addElement(ParameterCode.IF_OPER_STAT);
        parameterCodes.addElement(ParameterCode.IF_TYPE);
        parameterCodes.addElement(ParameterCode.IF_PHYSICAL_ADDRESS);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

