/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.IPTableRow;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class IPTableRowImpl
extends TableRowImpl
implements IPTableRow {
    private static List parameterCodeList;

    public IPTableRowImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.NETWORK_CONFIGURATION, parameterCodeList);
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.getIPAddress();
        return changedValues;
    }

    public void readState() throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.NETWORK_CONFIG_ACTIVITY));
        ((VSwitchImpl)this.getParentVSwitch()).refreshFields(element);
    }

    protected String canBeDeleted() throws RemoteException {
        Vector ips;
        if (this.getIPAddress().equals(this.getParentVSwitch().getMgmIPAddr())) {
            return "You cannot delete management ip " + this.getIPAddress();
        }
        if (((VSwitchImpl)this.getParentVSwitch()).getPortalTableRows(this.getIPAddress()).size() > 0) {
            return "You cannot delete an ip (" + this.getIPAddress() + ") that has a portal on it. Please remove the portal first";
        }
        if (((VSwitchImpl)this.getParentVSwitch()).getGwIPRouteTableRows(this).size() > 0 && (ips = ((VSwitchImpl)this.getParentVSwitch()).getIPsOfInterfaceAndSameSubnet(this.getInterface(), this)).size() == 1) {
            return "You cannot delete last ip (" + this.getIPAddress() + ") that has an IP route on it. Please delete the IP route first";
        }
        if (((VSwitchImpl)this.getParentVSwitch()).isUnderTakeover() && this.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_SWITCHED.getDescriptionName())) {
            return "You cannot remove " + this.getActivity() + " IP";
        }
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public String getIPAddress() throws RemoteException {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.NETWORK_CONFIG_IP_ADDRESS);
    }

    public String getIPMask() throws RemoteException {
        return this.getDisplayStringOf(this.getParentVSwitch(), ParameterCode.NETWORK_CONFIG_NET_MASK);
    }

    public String getActivity() throws RemoteException {
        LogMgr.getServerLog().debug(ClassID.VSWITCH + " " + this.getParentVSwitch() + " - trying to get NetConfigActivityConstant of " + this.getIPAddress());
        NetConfigActivityConstant activity = (NetConfigActivityConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.NETWORK_CONFIG_ACTIVITY);
        LogMgr.getServerLog().debug(ClassID.VSWITCH + " " + this.getParentVSwitch() + " - NetConfigActivityConstant of " + this.getIPAddress() + " is " + activity);
        if (activity != null) {
            return activity.toString();
        }
        LogMgr.getServerLog().warning("Null value for Activiy in IP Table Row for " + this.getIPAddress());
        return NetConfigActivityConstant.NET_CONFIG_ACTIVITY_UNKNOWN.toString();
    }

    public InterfaceTableRow getInterface() throws RemoteException {
        String interfaceName = (String)this.getValueOf(this.getParentVSwitch(), ParameterCode.NETWORK_CONFIG_INTERFACE);
        InterfaceTableRow interfaceTableRow = ((VSwitchImpl)this.getParentVSwitch()).getInterfaceTableRowByName(interfaceName);
        return interfaceTableRow;
    }

    public void setActive() throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.NETWORK_CONFIG_ACTIVITY, NetConfigActivityConstant.NET_CONFIG_ACTIVITY_ACTIVE));
        DataMgr.getInstance().changeElement(element);
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.NETWORK_CONFIG_IP_ADDRESS);
        parameterCodes.addElement(ParameterCode.NETWORK_CONFIG_NET_MASK);
        parameterCodes.addElement(ParameterCode.NETWORK_CONFIG_ACTIVITY);
        parameterCodes.addElement(ParameterCode.NETWORK_CONFIG_INTERFACE);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

