/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.vswitch;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.vswitch.IPTableRow;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.constants.IANAifTypeConstant;
import com.sanrad.nms.server.util.types.constants.NetConfigActivityConstant;
import com.sanrad.util.NetUtil;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class IPRouteTableRowValidator
extends LogicObjectValidator {
    private VSwitchImpl vSwitch;
    private String destIp;
    private String destMask;
    private String gateway;
    private String interfaceName;

    public IPRouteTableRowValidator(VSwitchImpl vSwitch, String destIp, String destMask, String gateway, String interfaceAlias) {
        this.vSwitch = vSwitch;
        this.destIp = destIp;
        this.destMask = destMask;
        this.gateway = gateway;
        this.interfaceName = interfaceAlias;
    }

    private boolean hasIPActive(InterfaceTableRow interfaceRow) throws RemoteException {
        Vector ips = this.vSwitch.getIPsOfInterface(interfaceRow);
        Enumeration e = ips.elements();
        while (e.hasMoreElements()) {
            IPTableRow ipRow = (IPTableRow)e.nextElement();
            if (!ipRow.getActivity().equals(NetConfigActivityConstant.NET_CONFIG_ACTIVITY_ACTIVE.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() throws RemoteException {
        if (!NetUtil.isNetworkIpValid(this.destIp) && !this.destIp.equals("0.0.0.0")) {
            this.setErrorMsg(ErrorMessage.IP_IS_NOT_VALID.getMessage(this.destIp));
            return false;
        }
        if (!NetUtil.isNetworkIpValid(this.gateway)) {
            this.setErrorMsg(ErrorMessage.GATEWAY_IS_NOT_VALID.getMessage(this.gateway));
            return false;
        }
        if (!NetUtil.isMaskValid(this.destMask)) {
            this.setErrorMsg(ErrorMessage.MASK_IS_NOT_VALID.getMessage(this.destMask));
            return false;
        }
        if (this.vSwitch.getIPRouteTableRow(this.destIp, this.gateway) != null) {
            this.setErrorMsg(ClassID.IP_ROUTE + " (dest. ip " + this.destIp + "; gateway " + this.gateway + ") already exists in " + ClassID.VSWITCH + " " + this.vSwitch.getName());
            return false;
        }
        String subnet = NetUtil.getSubnet(this.destIp, this.destMask);
        if (this.vSwitch.getIPRouteTableRow(subnet) != null) {
            this.setErrorMsg(ClassID.IP_ROUTE + " (dest. subnet " + subnet + ") already exists in " + ClassID.VSWITCH + " " + this.vSwitch.getName());
            return false;
        }
        if (this.vSwitch.getIPTableRowFromSameSubnet(this.destIp, this.destMask) != null) {
            this.setErrorMsg("Predefined " + ClassID.IP_ROUTE + " (dest. ip " + this.destIp + "; mask " + this.destMask + ") already exists in " + ClassID.VSWITCH + " " + this.vSwitch.getName());
            return false;
        }
        if (this.vSwitch.getIPTableRowFromSameSubnet(this.gateway, null, this.interfaceName) == null) {
            this.setErrorMsg("Gateway " + this.gateway + " must be accessible to the " + ClassID.VSWITCH + " " + this.vSwitch.getName());
            return false;
        }
        if (!NetUtil.isValidRoute(this.destIp, this.destMask)) {
            this.setErrorMsg("The mask " + this.destMask + " does not match the IP address " + this.destIp + ".  Please change either the mask or the IP address");
            return false;
        }
        InterfaceTableRow interfaceRow = this.vSwitch.getInterfaceTableRowByName(this.interfaceName);
        if (interfaceRow == null) {
            this.setErrorMsg(ClassID.INTERFACE + " " + interfaceRow.getAlias() + " not found");
            return false;
        }
        if (!((InterfaceTableRowImpl)interfaceRow).isEthernet()) {
            this.setErrorMsg(ClassID.INTERFACE + " is of type " + interfaceRow.getType() + ".  It should be of type " + IANAifTypeConstant.IANA_IF_TYPE_ETHERNET.toDisplayString());
            return false;
        }
        if (!this.hasIPActive(interfaceRow)) {
            this.setErrorMsg("There is no active ip on " + ClassID.INTERFACE + " " + interfaceRow.getAlias());
            return false;
        }
        return true;
    }
}

