/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.NonVirtualVolume;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.CreateVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.util.SrConstantsBundleKeys;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public abstract class VirtualVolumeValidator
extends CreateVolumeValidator {
    protected int MAX_NUM_OF_CHILDREN = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.VOLUME_MAX_NUM_OF_CHILDREN));

    protected VirtualVolumeValidator(String alias) {
        super(alias);
    }

    protected VirtualVolumeValidator(ClusterImpl cluster, ClassID classId, String alias, Vector children, VolumeManager volumeMgr) {
        super(cluster, classId, alias, children, volumeMgr);
    }

    protected VirtualVolumeValidator(ClusterImpl cluster, ClassID classId, String alias, Object child, VolumeManager volumeMgr) {
        super(cluster, classId, alias, child, volumeMgr);
    }

    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        if (this.children instanceof Vector) {
            if (this.isNotEnoughChildren()) {
                this.setErrorMsg(this.classId + " cannot have less than 2 children");
                return false;
            }
            if (((Vector)this.children).size() > this.MAX_NUM_OF_CHILDREN) {
                String[] msg = new String[]{this.classId.toString(), Integer.toString(this.MAX_NUM_OF_CHILDREN)};
                this.setErrorMsg(ErrorMessage.CANNOT_CREATE_VOLUME_WITH_MORE_THEN_X_CHILDREN.getMessage(msg));
                return false;
            }
            int blockSize = ((VolumeNode)((Vector)this.children).firstElement()).getBlockSize();
            Enumeration e = ((Vector)this.children).elements();
            while (e.hasMoreElements()) {
                LogicObject child = (LogicObject)e.nextElement();
                if (child instanceof NonVirtualVolume) {
                    this.setErrorMsg(child.getClassId() + " cannot be a child of " + this.classId);
                    return false;
                }
                VolumeNode volume = (VolumeNode)child;
                if (volume.getBlockSize() == blockSize) continue;
                this.setErrorMsg(ErrorMessage.CANNOT_CREATE_VOLUMES_OF_DIFFERENT_BLOCK_SIZE.getMessage(this.classId.toString()));
                return false;
            }
        } else if (this.children instanceof NonVirtualVolume) {
            this.setErrorMsg(((VolumeNodeImpl)this.children).getClassId() + " cannot be a child of " + this.classId);
            return false;
        }
        return true;
    }

    protected boolean isNotEnoughChildren() {
        return this.children instanceof Vector && ((Vector)this.children).size() < 2;
    }

    public VSwitch[] forWhichVswitchIsValid() throws RemoteException {
        if (!this.isValid()) {
            return null;
        }
        Vector<VSwitch> vSwitchesToSet = new Vector<VSwitch>();
        Enumeration e = ((Vector)this.children).elements();
        while (e.hasMoreElements()) {
            VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
            Vector childVSwitches = child.getConnectedVSwitchesAsVector();
            Enumeration iter = childVSwitches.elements();
            while (iter.hasMoreElements()) {
                VSwitch vSwitch = (VSwitch)iter.nextElement();
                if (vSwitchesToSet.contains(vSwitch)) continue;
                vSwitchesToSet.addElement(vSwitch);
            }
        }
        Iterator allVswitches = this.cluster.getVSwitches().iterator();
        while (allVswitches.hasNext()) {
            VSwitchImpl vSwitch = (VSwitchImpl)allVswitches.next();
            Enumeration e2 = ((Vector)this.children).elements();
            while (e2.hasMoreElements()) {
                String[] msgParts;
                VolumeNodeImpl child = (VolumeNodeImpl)e2.nextElement();
                if (!child.isKnownByVSwitch(vSwitch)) {
                    msgParts = new String[]{child.getAlias(), vSwitch.getClassId() + " " + vSwitch.getMgmIPAddr()};
                    this.setErrorMsg(ErrorMessage.CHILD_NOT_REDUNDANT.getMessage(msgParts));
                    vSwitchesToSet.remove(vSwitch);
                    return null;
                }
                if (!child.isLegitimateForVolumeOperation()) {
                    msgParts = new String[]{child.getClassId().toString() + child.getAlias(), vSwitch.getClassId() + vSwitch.getMgmIPAddr()};
                    this.setErrorMsg(ErrorMessage.ILLEGAL_VOLUME_IN_HIERARCHY.getMessage(msgParts));
                    vSwitchesToSet.remove(vSwitch);
                    return null;
                }
                if (!child.isDiskMissingDownHierarchy(vSwitch)) continue;
                msgParts = new String[]{child.getClassId().toString() + child.getAlias(), vSwitch.getClassId() + vSwitch.getMgmIPAddr()};
                this.setErrorMsg(ErrorMessage.CHILD_OVER_MISSING_STORAGE.getMessage(msgParts));
                vSwitchesToSet.remove(vSwitch);
                return null;
            }
        }
        if (vSwitchesToSet.size() > 0) {
            VSwitch[] retVal = new VSwitch[vSwitchesToSet.size()];
            vSwitchesToSet.toArray(retVal);
            return retVal;
        }
        return null;
    }
}

