/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.VirtualVolumeValidator;
import com.sanrad.nms.server.util.ClassID;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class StripeVolumeValidator
extends VirtualVolumeValidator {
    private BigInteger stripeSize;

    public StripeVolumeValidator(ClusterImpl cluster, String alias, Vector children, BigInteger stripeSize, VolumeManager volumeMgr) {
        super(cluster, ClassID.STRIPE_VOLUME, alias, children, volumeMgr);
        this.stripeSize = stripeSize;
    }

    public boolean isValid() throws RemoteException {
        BigInteger accessibleSpace = ((VolumeNode)((Vector)this.children).firstElement()).getAccessibleSpace();
        Enumeration e = ((Vector)this.children).elements();
        while (e.hasMoreElements()) {
            VolumeNode child = (VolumeNode)e.nextElement();
            if (((VolumeNodeImpl)child).isDROfflineLocalCopy()) {
                this.setErrorMsg(ErrorMessage.CANNOT_REMOVE_CHILD_VOLUME_IS_PART_OF_COPY_OPER.getMessage(this.stripeSize.toString() + " Bytes"));
            }
            if (child.getAccessibleSpace().compareTo(this.stripeSize) == 1) continue;
            this.setErrorMsg(ErrorMessage.STRIPE_SIZE_IS_TOO_HIGH.getMessage(this.stripeSize.toString() + " Bytes"));
            return false;
        }
        int blockSize = ((VolumeNode)((Vector)this.children).firstElement()).getBlockSize();
        BigInteger blkSize = new BigInteger(Integer.toString(blockSize));
        BigInteger limit = new BigInteger("2");
        if (this.stripeSize.divide(blkSize).compareTo(limit) != 1) {
            this.setErrorMsg("Stripe size should be bigger than " + limit.toString() + "KB.  Please select a different value");
            return false;
        }
        return super.isValid();
    }
}

