/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.volume.ConcatinationVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.AddChildValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;

public class ResizeVolumeValidator
extends AddChildValidator {
    public ResizeVolumeValidator(ClusterImpl cluster, VolumeNodeImpl source, String alias, Object child, VolumeManager volumeMgr, VolumeNodeImpl newChild) {
        super(cluster, source, alias, child, volumeMgr, newChild);
    }

    public VSwitch[] forWhichVswitchIsValid() throws RemoteException {
        VolumeImpl sourceVol;
        VSwitch[] validVs = super.forWhichVswitchIsValid();
        if (validVs != null && validVs.length > 0 && this.source instanceof VolumeImpl && (sourceVol = (VolumeImpl)this.source).isInconsistent()) {
            if (this.source instanceof ConcatinationVolumeImpl) {
                HashMap childrenListByVswitch = sourceVol.getChildrenCommKeyClassIdListByVSwitch();
                Iterator itr = childrenListByVswitch.keySet().iterator();
                while (itr.hasNext()) {
                    Object key = itr.next();
                    if (!(key instanceof VSwitch) || ((CommKeyClassId[])childrenListByVswitch.get(key)).length == 0) continue;
                    VSwitch existOn = (VSwitch)key;
                    VSwitch toSet = this.cluster.getOtherVSwitch(existOn);
                    VSwitch[] vSwitchToSet = new VSwitch[]{toSet};
                    for (int i = 0; i < validVs.length; ++i) {
                        if (!validVs[i].equals(toSet)) continue;
                        return vSwitchToSet;
                    }
                }
            }
            String msg = sourceVol.getAlias();
            this.setErrorMsg(ErrorMessage.VOLUME_INCONSISTANT.getMessage(msg));
            return null;
        }
        return validVs;
    }

    public boolean isAllowedByDR() throws RemoteException, IllegalValueException {
        if (super.isValid()) {
            DRPairImpl pair = DRRootImpl.getInstance().getPairUseingVolume(this.source);
            if (pair != null) {
                if (pair.isParameterEqual(new Parameter(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE, DRInitialSyncStateConstant.IN_PROGRESS), this.source.getActiveVswitch())) {
                    throw new IllegalValueException("you cannot resize " + this.source + " since the pair is synchronizing ");
                }
            } else {
                pair = DRRootImpl.getInstance().getPairUseingVolume(this.source.getRootVolume());
                if (pair != null) {
                    throw new IllegalValueException("you cannot resize " + this.source + " since it's part of pair ");
                }
            }
        }
        return false;
    }
}

