/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeTreeImpl;
import com.sanrad.nms.server.logic.volume.validators.VirtualVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class JournalVolumeValidator
extends VirtualVolumeValidator {
    private VSwitch m_vswitchActiveOn;
    private VSwitch m_otherVswitch;
    private Integer m_thresholdPrecent;
    private boolean m_vswitchActiveOnChanged = false;
    private boolean m_createInActiveJournalOnly = false;

    public JournalVolumeValidator(ClusterImpl cluster, String volAlias, Integer threshold, Vector children, boolean vswitchActiveOnChanged, VSwitch vswitchActiveOn, VSwitch vswitchInActiveOn, VolumeManager volumeMgr) {
        super(cluster, ClassID.JOURNAL_VOLUME, volAlias, children, volumeMgr);
        this.m_thresholdPrecent = threshold;
        this.m_vswitchActiveOnChanged = vswitchActiveOnChanged;
        this.m_vswitchActiveOn = vswitchActiveOn;
        this.m_otherVswitch = vswitchInActiveOn;
        this.m_createInActiveJournalOnly = this.m_vswitchActiveOn == null && this.m_otherVswitch != null;
    }

    public boolean isValid() throws RemoteException {
        VolumeNode child;
        if (!super.isValid() && !this.isNotEnoughChildren()) {
            return false;
        }
        if (this.m_thresholdPrecent == null) {
            this.setErrorMsg("Journal volume threshold precentage is missing for the new volume");
            return false;
        }
        if (this.m_vswitchActiveOn == null && !this.m_createInActiveJournalOnly) {
            this.setErrorMsg("Journal volume " + ClassID.VSWITCH + " activate on is missing for the new volume");
            return false;
        }
        if (this.m_thresholdPrecent < 6 || this.m_thresholdPrecent >= 100) {
            this.setErrorMsg(ErrorMessage.JOURNAL_THRESHOLD_INVALID.getMessage());
            return false;
        }
        Vector volChildren = (Vector)this.children;
        int i = volChildren.size();
        while (i-- > 0) {
            child = (VolumeNodeImpl)volChildren.elementAt(i);
            if (this.m_vswitchActiveOn == null) continue;
            if (this.m_vswitchActiveOn != null && !((LogicObjectImpl)((Object)child)).isKnownByVSwitch(this.m_vswitchActiveOn)) {
                StringBuffer sb = new StringBuffer("Cannot create Journal ");
                sb.append(this.alias).append(" active on " + ClassID.VSWITCH + " ").append(this.m_vswitchActiveOn.getName());
                sb.append(" ,the volume ").append(child.getAlias()).append(" is not defined this " + ClassID.VSWITCH);
                this.setErrorMsg(sb.toString());
                return false;
            }
            if (this.m_otherVswitch == null || !this.m_otherVswitch.isConnected() || ((LogicObjectImpl)((Object)child)).isKnownByVSwitch(this.m_otherVswitch)) continue;
            StringBuffer sb = new StringBuffer("Cannot create Journal ");
            sb.append(this.alias).append(" inactive on " + ClassID.VSWITCH + " ").append(this.m_vswitchActiveOn.getName());
            sb.append(" ,the volume ").append(child.getAlias()).append(" is not defined this " + ClassID.VSWITCH);
            this.setErrorMsg(sb.toString());
            return false;
        }
        Enumeration e = ((Vector)this.children).elements();
        while (e.hasMoreElements()) {
            child = (VolumeNode)e.nextElement();
            if (child.getClassId().equals(ClassID.TRANSPARENT_VOLUME)) {
                this.setErrorMsg(ErrorMessage.VOLUME_CANNOT_BE_A_CHILD_OF_JOURNAL_VOLUME.getMessage(ClassID.TRANSPARENT_VOLUME.toString()));
                return false;
            }
            if (child.getClassId().equals(ClassID.SNAPSHOT_VOLUME)) {
                this.setErrorMsg(ErrorMessage.VOLUME_CANNOT_BE_A_CHILD_OF_JOURNAL_VOLUME.getMessage(ClassID.SNAPSHOT_VOLUME.toString()));
                return false;
            }
            if (child.getClassId().equals(ClassID.JOURNAL_VOLUME)) {
                this.setErrorMsg(ErrorMessage.VOLUME_CANNOT_BE_A_CHILD_OF_JOURNAL_VOLUME.getMessage(ClassID.JOURNAL_VOLUME.toString()));
                return false;
            }
            if (child.isExposed()) {
                this.setErrorMsg(ErrorMessage.VOLUME_CANNOT_BE_A_CHILD_OF_JOURNAL_VOLUME.getMessage("an exposed child"));
                return false;
            }
            if (!child.isNonFunctional()) continue;
            this.setErrorMsg(ErrorMessage.VOLUME_CANNOT_BE_A_CHILD_OF_JOURNAL_VOLUME.getMessage("a nonfunctional child"));
            return false;
        }
        if (!this.m_createInActiveJournalOnly && this.isThereActiveJournalVolOnVSwitch(this.m_vswitchActiveOn.getName())) {
            this.setErrorMsg(ErrorMessage.VSWITCH_HAS_ACTIVE_JOURNAL.getMessage(this.m_vswitchActiveOn.getName()));
            return false;
        }
        VolumeNodeImpl child2 = (VolumeNodeImpl)((Vector)this.children).elementAt(0);
        if (this.m_otherVswitch != null && child2.isKnownByVSwitch(this.m_otherVswitch) && this.isThereInActiveJournalVolOnVSwitch(this.m_otherVswitch.getName())) {
            this.setErrorMsg(ErrorMessage.VSWITCH_HAS_INACTIVE_JOURNAL.getMessage(this.m_otherVswitch.getName()));
            return false;
        }
        return true;
    }

    protected boolean isNotEnoughChildren() {
        return false;
    }

    public String isValid(HashMap parameterList) throws RemoteException {
        if (this.alias != null) {
            String errMsg = JournalVolumeValidator.isAliasValid(this.alias);
            if (errMsg != null) {
                return errMsg;
            }
            if (this.volumeMgr.isAliasExist(this.alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(this.alias);
            }
            if (this.cluster.getStoragePool().isAliasExist(this.alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(this.alias);
            }
            parameterList.put(ClientParameterCode.VOLUME_ALIAS, new SrString(this.alias));
        }
        if (this.m_thresholdPrecent != null) {
            int val = this.m_thresholdPrecent;
            if (val < 6 || val > 100) {
                return ErrorMessage.JOURNAL_THRESHOLD_INVALID.getMessage();
            }
            parameterList.put(ClientParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, new SrInteger(this.m_thresholdPrecent));
        }
        if (this.m_vswitchActiveOnChanged) {
            if (!this.m_createInActiveJournalOnly && this.isThereActiveJournalVolOnVSwitch(this.m_vswitchActiveOn.getName())) {
                return ErrorMessage.VSWITCH_HAS_ACTIVE_JOURNAL.getMessage(this.m_vswitchActiveOn.getName());
            }
            if (this.m_otherVswitch != null && this.isThereInActiveJournalVolOnVSwitch(this.m_otherVswitch.getName())) {
                return ErrorMessage.VSWITCH_HAS_INACTIVE_JOURNAL.getMessage(this.m_otherVswitch.getName());
            }
            parameterList.put(ClientParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, this.m_vswitchActiveOn.getCommKeyClassId());
        }
        return null;
    }

    private boolean isThereActiveJournalVolOnVSwitch(String vswitchName) throws RemoteException {
        Vector allJournalVolumesInCluster = this.cluster.getStorage().getInteranlVolumesByType(ClassID.JOURNAL_VOLUME);
        for (int index = 0; index < allJournalVolumesInCluster.size(); ++index) {
            VolumeTreeImpl tree = (VolumeTreeImpl)allJournalVolumesInCluster.elementAt(index);
            JournalVolumeImpl volume = (JournalVolumeImpl)tree.getRoot();
            VSwitch vswitchActiveOn = volume.getActiveOnVSwitch();
            if (vswitchActiveOn == null) {
                return false;
            }
            if (!vswitchName.equals(vswitchActiveOn.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isThereInActiveJournalVolOnVSwitch(String vswitchName) throws RemoteException {
        Vector allJournalVolumesInCluster = this.cluster.getStorage().getInteranlVolumesByType(ClassID.JOURNAL_VOLUME);
        for (int index = 0; index < allJournalVolumesInCluster.size(); ++index) {
            VolumeTreeImpl tree = (VolumeTreeImpl)allJournalVolumesInCluster.elementAt(index);
            JournalVolumeImpl volume = (JournalVolumeImpl)tree.getRoot();
            VSwitch vswitchInctiveOn = volume.getInactiveOnVSwitch();
            if (vswitchInctiveOn == null) {
                return false;
            }
            if (!vswitchName.equals(vswitchInctiveOn.getName())) continue;
            return true;
        }
        return false;
    }
}

