/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.validators.VolumeOperationValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import java.rmi.RemoteException;
import java.util.Vector;

public class ExpandVolumeValidator
extends VolumeOperationValidator {
    public ExpandVolumeValidator(ClusterImpl cluster, VolumeNodeImpl source, String alias, Object children, VolumeManager volumeMgr) {
        super(cluster, source, alias, children, volumeMgr);
    }

    public boolean isValid() throws RemoteException {
        return super.isValid();
    }

    public CommKeyClassId[] forWhichVswitchIsValidData() {
        try {
            VSwitch[] vSwitchesToSet = super.forWhichVswitchIsValid();
            if (vSwitchesToSet == null || vSwitchesToSet.length == 0) {
                return new CommKeyClassId[0];
            }
            Vector<VSwitch> vSwitchToExpand = new Vector<VSwitch>();
            for (int i = 0; i < vSwitchesToSet.length; ++i) {
                if (!this.source.isInState(vSwitchesToSet[i], VolumeStateConstant.VOLUME_STATE_EXPANDABLE) || !vSwitchesToSet[i].isConnected()) continue;
                vSwitchToExpand.add(vSwitchesToSet[i]);
            }
            if (vSwitchToExpand.size() == 0) {
                return new CommKeyClassId[0];
            }
            CommKeyClassId[] vSwitches = new CommKeyClassId[vSwitchToExpand.size()];
            for (int i = 0; i < vSwitches.length; ++i) {
                vSwitches[i] = ((VSwitch)vSwitchToExpand.get(i)).getCommKeyClassId();
            }
            return vSwitches;
        }
        catch (RemoteException re) {
            logger.error(re);
            return new CommKeyClassId[0];
        }
    }
}

