/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.validators;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.VolumeManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.validators.VolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.rmi.RemoteException;
import java.util.Vector;

public class CreateVolumeValidator
extends VolumeValidator {
    public CreateVolumeValidator(String alias) {
        super(alias);
    }

    public CreateVolumeValidator(ClusterImpl cluster, ClassID classId, String alias, Object children, VolumeManager volumeMgr) {
        super(cluster, classId, alias, children, volumeMgr);
    }

    public boolean isValid() throws RemoteException {
        if (!super.isValid()) {
            return false;
        }
        if (this.isAliasExists()) {
            this.setErrorMsg(ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(this.alias));
            return false;
        }
        VolumeNode nonFunctionVolumeChild = this.getChildNonFunction();
        if (this.getChildNonFunction() != null) {
            String[] msgParama = new String[]{this.classId.toString(), nonFunctionVolumeChild.getClassId().toString(), nonFunctionVolumeChild.getAlias()};
            this.setErrorMsg(ErrorMessage.VOLUME_OVER_NONFUNCTIONAL_VOLUME.getMessage(msgParama));
            return false;
        }
        VolumeNode localCopyVolumeChild = this.getChildLocalCopy();
        if (localCopyVolumeChild != null) {
            String[] msgParama = new String[]{this.classId.toString(), localCopyVolumeChild.getClassId().toString(), localCopyVolumeChild.getAlias()};
            this.setErrorMsg(ErrorMessage.VOLUME_OVER_NONFUNCTIONAL_VOLUME.getMessage(msgParama));
            return false;
        }
        VolumeNode missingStorageChild = this.getChildStorageIsMissing();
        if (missingStorageChild != null) {
            String[] msgParama = new String[]{this.classId.toString(), missingStorageChild.getClassId().toString(), missingStorageChild.getAlias()};
            this.setErrorMsg(ErrorMessage.VOLUME_OVER_MISSING_STORAGE.getMessage(msgParama));
            return false;
        }
        return true;
    }

    public CommKeyClassId[] getLegalVSwitchesForOperation(Vector vSwitchToSet) throws RemoteException, IllegalValueException {
        CommKeyClassId[] toSet = new CommKeyClassId[vSwitchToSet.size()];
        for (int i = 0; i < vSwitchToSet.size(); ++i) {
            toSet[i] = ((VSwitchImpl)vSwitchToSet.get(i)).getCommKeyClassId();
        }
        return this.getLegalVSwitchesForOperation(toSet);
    }

    public CommKeyClassId[] getLegalVSwitchesForOperation(CommKeyClassId[] vSwitchToSet) throws RemoteException, IllegalValueException {
        CommKeyClassId[] allChildrenExistOn = this.getVSwitchesAllElementsExistIn(this.children, this.cluster);
        int numOfLegalVSwitches = 0;
        for (int i = 0; i < allChildrenExistOn.length; ++i) {
            VSwitch vSwitch = (VSwitch)SystemRootImpl.getInstance().getRefByStub(allChildrenExistOn[i]);
            if (this.getChildNonFunction(vSwitch) != null) {
                allChildrenExistOn[i] = null;
                continue;
            }
            ++numOfLegalVSwitches;
        }
        if (numOfLegalVSwitches < allChildrenExistOn.length) {
            CommKeyClassId[] newList = new CommKeyClassId[numOfLegalVSwitches];
            int j = 0;
            for (int i = 0; i < allChildrenExistOn.length; ++i) {
                if (allChildrenExistOn[i] == null) continue;
                newList[j++] = allChildrenExistOn[i];
            }
        }
        return this.getVSwitchesToSet(vSwitchToSet, allChildrenExistOn);
    }
}

