/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.copy;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.exception.CopyAlreadyExistException;
import com.sanrad.nms.server.logic.AlreadyKnownByVSwitch;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperation;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManager;
import com.sanrad.nms.server.logic.volume.copy.MirrorSyncOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.OfflineCopyOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.RestoreOperationImpl;
import com.sanrad.nms.server.logic.volume.validators.SnapshotVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityEvent;
import com.sanrad.nms.server.logic.vswitch.VSwitchConnectivityListener;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class CopyOperationManagerImpl
extends LogicObjectImpl
implements CopyOperationManager,
VSwitchConnectivityListener {
    private Vector allCopyOpers = new Vector();

    public CopyOperationManagerImpl(Cluster cluster) throws RemoteException {
        this.cluster = (ClusterImpl)cluster;
        ((ClusterImpl)cluster).addVSwitchConnectivityListener(this);
    }

    public void clear() {
        this.allCopyOpers.clear();
    }

    public synchronized Vector getAllCopyOpers() throws RemoteException {
        return this.allCopyOpers;
    }

    public synchronized Vector getMirrorSyncCopyOpers() throws RemoteException {
        Vector opers = this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, VolumeOperationType.VOL_OPER_MIRROR_SYNC);
        opers.addAll(this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC));
        return opers;
    }

    public synchronized Vector getOfflineCopyOpers() throws RemoteException {
        Vector opers = this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, VolumeOperationType.VOL_OPER_OFFLINE_COPY);
        opers.addAll(this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, VolumeOperationType.VOL_OPER_ABORT_COPY));
        return opers;
    }

    public synchronized Vector getRestoreOpers() throws RemoteException {
        Vector opers = this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, VolumeOperationType.VOL_OPER_RESTORE);
        opers.addAll(this.getByParameter(ParameterCode.COPY_OPERATION_TYPE, VolumeOperationType.VOL_OPER_ABORT_RESTORE));
        return opers;
    }

    public synchronized void removeCopyOper(CopyOperationImpl copyOper) throws RemoteException {
        this.allCopyOpers.remove(copyOper);
        if (copyOper instanceof RestoreOperationImpl) {
            CommKeyClassId src = copyOper.getCopySrc();
            SnapshotVolumeImpl snapshotVolume = (SnapshotVolumeImpl)SystemRootImpl.getInstance().getRefByStub(src);
            if (snapshotVolume != null) {
                snapshotVolume.setRestoreOperation(null);
                AlarmMgrImpl.getInstance().generateAlarms((ClusterImpl)snapshotVolume.getCluster(), 2, snapshotVolume, copyOper.getActiveVswitch());
                if (snapshotVolume.getSourceVolume() != null) {
                    AlarmMgrImpl.getInstance().generateAlarms((ClusterImpl)snapshotVolume.getSourceVolume().getCluster(), 2, (VolumeNodeImpl)snapshotVolume.getSourceVolume(), copyOper.getActiveVswitch());
                }
            }
        }
    }

    public synchronized boolean isCopyLegitimate(CopyOperationImpl copyOper) throws RemoteException, IllegalValueException {
        boolean result = this.isCopyLegitimate(copyOper.getCopySrc(), copyOper.getCopyDst(), copyOper.getVSwitchCommKeyClassId(), copyOper.getCopyType());
        return result;
    }

    public synchronized boolean isCopyLegitimate(CommKeyClassId src, CommKeyClassId dst, CommKeyClassId vSwitch, VolumeOperationType copyType) throws RemoteException, IllegalValueException {
        if (copyType.isRestore()) {
            SnapshotVolumeImpl sourceOfRestore = (SnapshotVolumeImpl)SystemRootImpl.getInstance().getRefByStub(src);
            SnapshotVolumeValidator snapshotVolumeValidator = new SnapshotVolumeValidator(sourceOfRestore.getAlias());
            if (!snapshotVolumeValidator.isValidForRestoreOperation(sourceOfRestore)) {
                throw new IllegalValueException(snapshotVolumeValidator.getErrorMsg());
            }
            if (this.isInvolvedInActiveCopyOper(sourceOfRestore.getCommKeyClassId())) {
                throw new IllegalValueException("Snapshot volume is involved in another active copy operation");
            }
            if (this.isInvolvedInActiveCopyOper(sourceOfRestore.getSourceVolume().getCommKeyClassId())) {
                throw new IllegalValueException("Snapshot source volume is involved in another copy operation");
            }
        }
        return true;
    }

    private CopyOperationImpl[] getOperIfAlreadyExist(VolumeNodeImpl src, VolumeNodeImpl dst, VSwitchImpl vSwitch, VolumeOperationType copyType) throws RemoteException, IllegalValueException {
        Vector<CopyOperationImpl> copyOpers = new Vector<CopyOperationImpl>();
        Iterator opers = this.allCopyOpers.iterator();
        while (opers.hasNext()) {
            CopyOperationImpl current = (CopyOperationImpl)opers.next();
            if (dst != null) {
                if (!((VolumeNodeImpl)current.getCopyDstNode()).equals(dst) || !((VolumeNodeImpl)current.getCopySrcNode()).equals(src) || !this.isSameCopyType(current.getCopyType(), copyType)) continue;
                copyOpers.add(current);
                continue;
            }
            if (!((VolumeNodeImpl)current.getCopySrcNode()).equals(src) || !this.isSameCopyType(current.getCopyType(), copyType)) continue;
            copyOpers.add(current);
        }
        CopyOperationImpl[] retVal = new CopyOperationImpl[copyOpers.size()];
        for (int i = 0; i < copyOpers.size(); ++i) {
            retVal[i] = (CopyOperationImpl)copyOpers.get(i);
        }
        return retVal;
    }

    private boolean isSameCopyType(VolumeOperationType oper1, VolumeOperationType oper2) {
        return oper1.isMirrSyncOper() && oper2.isMirrSyncOper() || oper1.isOfflineCopy() && oper2.isOfflineCopy() || oper1.isRestore() && oper2.isRestore();
    }

    private boolean isValidSrcForMirrSync(CommKeyClassId srcVol, CommKeyClassId vSwitchToTest) {
        try {
            VolumeNodeImpl src = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(srcVol);
            VSwitch vSwitch = (VSwitch)SystemRootImpl.getInstance().getRefByStub(vSwitchToTest);
            return !src.isNeedSync(vSwitch) && !src.isNonFunctional(vSwitch);
        }
        catch (RemoteException re) {
            logger.error(re);
            return false;
        }
    }

    private boolean isValidDstForMirrSync(CommKeyClassId dstVol, CommKeyClassId vSwitchToTest) {
        try {
            VolumeNodeImpl dst = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(dstVol);
            VSwitch vSwitch = (VSwitch)SystemRootImpl.getInstance().getRefByStub(vSwitchToTest);
            return dst.isNeedSync(vSwitch) && !dst.isNonFunctional(vSwitch);
        }
        catch (RemoteException re) {
            logger.error(re);
            return false;
        }
    }

    public void abortCopyOper(CopyOperation oper) throws RemoteException {
        CopyOperationImpl copyOper = (CopyOperationImpl)oper;
        ConfigElementData element = new ConfigElementData(copyOper.getCommKeys(), copyOper.getClassId());
        VolumeOperationType abortType = copyOper.getAbortType();
        try {
            copyOper.setOneParameter(ParameterCode.COPY_OPERATION_TYPE, abortType, (VSwitch)copyOper.getVSwitches().get(0));
        }
        catch (IllegalValueException ive) {
            LogMgr.getServerLog().warning("Failed to set new Copy Operation type for abort operation " + ive.getMessage());
        }
        DataMgr.getInstance().operate(element, abortType);
    }

    public void refreshCopyTable() throws RemoteException {
        if (!this.getCluster().getVSwitches().isEmpty()) {
            ConfigElementData element = new ConfigElementData(ClassID.COPY_OPERATION);
            element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, (SrType)null);
            element.setValue(ParameterCode.VOLUME_OPERATION_OPER_STATUS, (SrType)null);
            element.setValue(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED, (SrType)null);
            Vector vSwitches = this.getCluster().getVSwitches();
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwitches.size()];
            for (int i = 0; i < vSwitches.size(); ++i) {
                vSwitchesData[i] = new CommKeyClassId(((VSwitch)vSwitches.get(i)).getCommKeys(), ((VSwitch)vSwitches.get(i)).getClassId());
            }
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesData));
            DataMgr.getInstance().refreshTableFields(element);
        }
    }

    public synchronized boolean addCopyOperation(VolumeNodeImpl src, VolumeNodeImpl dst, VSwitch vSwitch, VolumeOperationType copyType) throws IllegalValueException, CopyAlreadyExistException {
        try {
            CommKeyClassId vSwitchCommKeyClassId;
            if (copyType.isRestore() && dst == null) {
                dst = (VolumeNodeImpl)((SnapshotVolumeImpl)src).getSourceVolume();
            }
            CommKeyClassId[] vSwitchData = new CommKeyClassId[]{vSwitchCommKeyClassId = new CommKeyClassId(vSwitch.getCommKeys(), vSwitch.getClassId())};
            boolean sendToVSwitch = true;
            ConfigElementData element = null;
            CopyOperationImpl[] opers = this.getOperIfAlreadyExist(src, dst, (VSwitchImpl)vSwitch, copyType);
            if (opers.length > 0) {
                LogicObjectImpl operToRestart = null;
                for (int i = 0; i < opers.length; ++i) {
                    CopyOperationImpl oper = opers[i];
                    if (oper.getCopyStatus().isActive()) {
                        String destinationStr = dst != null ? dst.toString() : ((VolumeNodeImpl)oper.getCopyDstNode()).toString();
                        String sourceStr = src != null ? src.toString() : ((VolumeNodeImpl)oper.getCopySrcNode()).toString();
                        String[] errData = new String[]{copyType.toString(), sourceStr, destinationStr, oper.getVSwitches().get(0).toString()};
                        throw new CopyAlreadyExistException(ErrorMessage.COPY_ALREADY_RUN_FOR_DST_OR_SRC.getMessage(errData));
                    }
                    if (!oper.getVSwitches().get(0).equals(vSwitch)) continue;
                    operToRestart = oper;
                    break;
                }
                if (operToRestart != null) {
                    if (vSwitch.isConnected()) {
                        element = new ConfigElementData(operToRestart.getCommKeys(), operToRestart.getClassId());
                        vSwitchData[0] = ((CopyOperationImpl)operToRestart).getVSwitchCommKeyClassId();
                        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
                    } else {
                        StringBuffer msg = new StringBuffer(copyType.toString());
                        msg.append(" cannot be restarted. ");
                        msg.append(ClassID.VSWITCH);
                        msg.append(" ");
                        msg.append(vSwitch);
                        msg.append(" is not connected.");
                        throw new IllegalValueException(msg.toString());
                    }
                }
            }
            if (element == null) {
                CommKeyClassId dstData = dst != null ? dst.getCommKeyClassId() : null;
                CommKeyClassId srcData = src.getCommKeyClassId();
                if (this.isCopyLegitimate(srcData, dstData, vSwitchCommKeyClassId, copyType)) {
                    element = new ConfigElementData(src.getCommKeys(), src.getClassId());
                    element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchData));
                    if (srcData != null) {
                        element.setValue(ParameterCode.VOLUME_OPERATION_SRC, srcData);
                    }
                    if (dstData != null) {
                        element.setValue(ParameterCode.VOLUME_OPERATION_DST, dstData);
                    }
                } else {
                    throw new IllegalValueException("Copy Operation cannot be created in cluster " + this.getCluster().getAlias());
                }
            }
            DataMgr.getInstance().operate(element, copyType);
            return sendToVSwitch;
        }
        catch (RemoteException re) {
            logger.error(re);
            throw new IllegalValueException("Cannot add the Copy Operation");
        }
    }

    public void restartOperation(CopyOperationImpl copyOper) throws RemoteException, IllegalValueException {
        CopyOperationImpl[] opers = this.getOperIfAlreadyExist((VolumeNodeImpl)copyOper.getCopySrcNode(), (VolumeNodeImpl)copyOper.getCopyDstNode(), (VSwitchImpl)copyOper.getConnectedVSwitches()[0], copyOper.getCopyType());
        for (int i = 0; i < opers.length; ++i) {
            CopyOperationImpl oper = opers[i];
            if (!oper.getCopyStatus().isActive()) continue;
            StringBuffer msg = new StringBuffer(copyOper.getRestartType().toString());
            msg.append(" for the same source and destination is currently running in ");
            msg.append(ClassID.VSWITCH);
            msg.append(" ");
            msg.append(oper.getVSwitches().get(0).toString());
            throw new IllegalValueException(msg.toString());
        }
        ConfigElementData element = new ConfigElementData(copyOper.getCommKeys(), copyOper.getClassId());
        CommKeyClassId[] vSwithcData = new CommKeyClassId[]{copyOper.getVSwitchCommKeyClassId()};
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwithcData));
        DataMgr.getInstance().operate(element, copyOper.getRestartType());
    }

    public synchronized LogicObject newCopyOper(HashMap parameterList) throws AlreadyKnownByVSwitch, RemoteException, IllegalValueException {
        Object copyType = parameterList.get(ParameterCode.COPY_OPERATION_TYPE);
        Object dst = parameterList.get(ParameterCode.VOLUME_OPERATION_DST);
        Object status = parameterList.get(ParameterCode.VOLUME_OPERATION_OPER_STATUS);
        Object vswitch = parameterList.get(ParameterCode.VSWITCH_ID);
        Object src = parameterList.get(ParameterCode.VOLUME_OPERATION_SRC);
        Object perCopy = parameterList.get(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED);
        if (perCopy == null) {
            perCopy = new SrInteger(0);
        }
        CopyOperationImpl current = null;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            current = (CopyOperationImpl)this.allCopyOpers.get(i);
            if (!current.getCopySrc().equals(src) || !current.getCopyDst().equals(dst) || !current.getCopyType().equals(copyType) || !current.getVSwitchCommKeyClassId().equals(vswitch)) continue;
            throw new AlreadyKnownByVSwitch(current);
        }
        CopyOperationImpl newOper = null;
        if (copyType.equals(VolumeOperationType.VOL_OPER_MIRROR_SYNC) || copyType.equals(VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC)) {
            newOper = new MirrorSyncOperationImpl((ClusterImpl)this.getCluster(), (CommKeyClassId)src, (CommKeyClassId)dst, (CommKeyClassId)vswitch, (VolumeOperationType)copyType, (VolumeOperationOperStatusConstant)status, (SrInteger)perCopy);
        } else if (copyType.equals(VolumeOperationType.VOL_OPER_OFFLINE_COPY) || copyType.equals(VolumeOperationType.VOL_OPER_ABORT_COPY)) {
            newOper = new OfflineCopyOperationImpl((ClusterImpl)this.getCluster(), (CommKeyClassId)src, (CommKeyClassId)dst, (CommKeyClassId)vswitch, (VolumeOperationType)copyType, (VolumeOperationOperStatusConstant)status, (SrInteger)perCopy);
        } else if (copyType.equals(VolumeOperationType.VOL_OPER_RESTORE) || copyType.equals(VolumeOperationType.VOL_OPER_ABORT_RESTORE)) {
            newOper = new RestoreOperationImpl((ClusterImpl)this.getCluster(), (CommKeyClassId)src, (CommKeyClassId)dst, (CommKeyClassId)vswitch, (VolumeOperationType)copyType, (VolumeOperationOperStatusConstant)status, (SrInteger)perCopy);
            SnapshotVolumeImpl snapshotVolume = (SnapshotVolumeImpl)SystemRootImpl.getInstance().getRefByStub((CommKeyClassId)src);
            snapshotVolume.setRestoreOperation((RestoreOperationImpl)newOper);
        }
        if (newOper != null) {
            this.allCopyOpers.add(newOper);
        }
        if (copyType.equals(VolumeOperationType.VOL_OPER_RESTORE) || copyType.equals(VolumeOperationType.VOL_OPER_ABORT_RESTORE)) {
            VSwitchImpl vswitchImpl = (VSwitchImpl)SystemRootImpl.getInstance().getRefByStub((CommKeyClassId)vswitch);
            SnapshotVolumeImpl snapshotVolume = (SnapshotVolumeImpl)SystemRootImpl.getInstance().getRefByStub((CommKeyClassId)src);
            ClusterImpl clusterImpl = (ClusterImpl)snapshotVolume.getCluster();
            GeneralLogicObjectImpl snapshotSource = (GeneralLogicObjectImpl)((Object)snapshotVolume.getSourceVolume());
            if (snapshotVolume != null) {
                AlarmMgrImpl.getInstance().generateAlarms(clusterImpl, 2, snapshotVolume, vswitchImpl);
            }
            if (snapshotSource != null) {
                AlarmMgrImpl.getInstance().generateAlarms(clusterImpl, 2, snapshotSource, vswitchImpl);
            }
        }
        return newOper;
    }

    public synchronized Vector getByParameter(ParameterCode parameter, SrType value) {
        Vector opers = new Vector();
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            try {
                if (!((CopyOperationImpl)this.allCopyOpers.get(i)).getSrValueOf(parameter).equals(value)) continue;
                opers.add(this.allCopyOpers.get(i));
                continue;
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        return opers;
    }

    protected synchronized String canBeDeleted() throws RemoteException {
        return null;
    }

    protected synchronized String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public boolean synchronize() throws RemoteException, IllegalValueException {
        return true;
    }

    public void removeAllCopyOpersForVolume(VolumeNodeImpl vol, VSwitch vSwitch, boolean removeAlsoFromDataMgr) {
        try {
            Vector opersToRemove = new Vector();
            if (vol instanceof MirrorVolumeImpl) {
                Vector mirChildren = vol.getChildren();
                Iterator children = mirChildren.iterator();
                while (children.hasNext()) {
                    int i;
                    VolumeNodeImpl child = (VolumeNodeImpl)children.next();
                    Vector opers = this.getByParameter(ParameterCode.VOLUME_OPERATION_DST, child.getCommKeyClassId());
                    for (i = 0; i < opers.size(); ++i) {
                        if (opersToRemove.contains(opers.get(i))) continue;
                        opersToRemove.add(opers.get(i));
                    }
                    opers = this.getByParameter(ParameterCode.VOLUME_OPERATION_SRC, child.getCommKeyClassId());
                    for (i = 0; i < opers.size(); ++i) {
                        if (opersToRemove.contains(opers.get(i))) continue;
                        opersToRemove.add(opers.get(i));
                    }
                }
                Iterator opers = opersToRemove.iterator();
                while (opers.hasNext()) {
                    CopyOperationImpl oper = (CopyOperationImpl)opers.next();
                    SrType operType = oper.getSrValueOf(ParameterCode.COPY_OPERATION_TYPE);
                    if (operType.equals(VolumeOperationType.VOL_OPER_MIRROR_SYNC) || operType.equals(VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC)) continue;
                    opers.remove();
                }
            }
            opersToRemove.addAll(this.getByParameter(ParameterCode.VOLUME_OPERATION_DST, vol.getCommKeyClassId()));
            opersToRemove.addAll(this.getByParameter(ParameterCode.VOLUME_OPERATION_SRC, vol.getCommKeyClassId()));
            CommKeyClassId[] opers = opersToRemove.iterator();
            while (opers.hasNext()) {
                CopyOperationImpl oper = (CopyOperationImpl)opers.next();
                if (vSwitch.equals(oper.getConnectedVSwitches()[0])) continue;
                opers.remove();
            }
            if (removeAlsoFromDataMgr) {
                opers = new CommKeyClassId[opersToRemove.size()];
                for (int i = 0; i < opersToRemove.size(); ++i) {
                    opers[i] = ((CopyOperationImpl)opersToRemove.get(i)).getCommKeyClassId();
                }
                try {
                    this.cluster.deleteObjects(opers);
                }
                catch (IllegalValueException ive) {
                    LogMgr.getServerLog().warning(ive.getMessage());
                }
            } else {
                Iterator itr = opersToRemove.iterator();
                while (itr.hasNext()) {
                    this.cluster.removeElement((CopyOperationImpl)itr.next(), vSwitch);
                }
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public boolean isInvolvedInCopyOper(CommKeyClassId node) {
        ParameterCode src = ParameterCode.VOLUME_OPERATION_SRC;
        ParameterCode dst = ParameterCode.VOLUME_OPERATION_DST;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            try {
                CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
                if (!oper.getSrValueOf(src).equals(node) && !oper.getSrValueOf(dst).equals(node)) continue;
                return true;
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        return false;
    }

    public boolean isInvolvedInCopyOper(CommKeyClassId node, CommKeyClassId vSwitch) {
        ParameterCode src = ParameterCode.VOLUME_OPERATION_SRC;
        ParameterCode dst = ParameterCode.VOLUME_OPERATION_DST;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            try {
                CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
                if (!oper.getSrValueOf(src).equals(node) && !oper.getSrValueOf(dst).equals(node) || !vSwitch.equals(oper.getConnectedVSwitches()[0].getCommKeyClassId())) continue;
                return true;
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        return false;
    }

    public boolean isInvolvedInActiveCopyOper(CommKeyClassId node, CommKeyClassId vSwitch) {
        ParameterCode src = ParameterCode.VOLUME_OPERATION_SRC;
        ParameterCode dst = ParameterCode.VOLUME_OPERATION_DST;
        ParameterCode status = ParameterCode.VOLUME_OPERATION_OPER_STATUS;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            try {
                CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
                if (!oper.getSrValueOf(src).equals(node) && !oper.getSrValueOf(dst).equals(node) || !vSwitch.equals(oper.getConnectedVSwitches()[0].getCommKeyClassId()) || !((VolumeOperationOperStatusConstant)oper.getSrValueOf(status)).isActive()) continue;
                return true;
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        return false;
    }

    public boolean isInvolvedInActiveCopyOper(CommKeyClassId node) {
        ParameterCode src = ParameterCode.VOLUME_OPERATION_SRC;
        ParameterCode dst = ParameterCode.VOLUME_OPERATION_DST;
        ParameterCode status = ParameterCode.VOLUME_OPERATION_OPER_STATUS;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            try {
                CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
                if (!oper.getSrValueOf(src).equals(node) && !oper.getSrValueOf(dst).equals(node) || !((VolumeOperationOperStatusConstant)oper.getSrValueOf(status)).isActive()) continue;
                return true;
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        return false;
    }

    public CopyOperationImpl getCopyForNode(CommKeyClassId node) {
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
            if (!oper.getCopySrc().equals(node) && !oper.getCopyDst().equals(node)) continue;
            return oper;
        }
        return null;
    }

    public boolean isExistedAsSrcInOtherActivrCopyOperation(CommKeyClassId node) {
        CopyOperationImpl existedCopyOperation = this.getActiveCopyForNode(node);
        if (existedCopyOperation != null) {
            try {
                return existedCopyOperation.getSrValueOf(ParameterCode.VOLUME_OPERATION_SRC).equals(node);
            }
            catch (RemoteException e) {
                logger.error(e);
                return false;
            }
        }
        return false;
    }

    public boolean isExistedAsDstInOtherActivrCopyOperation(CommKeyClassId node) {
        CopyOperationImpl existedCopyOperation = this.getActiveCopyForNode(node);
        if (existedCopyOperation != null) {
            try {
                return existedCopyOperation.getSrValueOf(ParameterCode.VOLUME_OPERATION_DST).equals(node);
            }
            catch (RemoteException e) {
                logger.error(e);
                return false;
            }
        }
        return false;
    }

    public CopyOperationImpl getActiveCopyForNode(CommKeyClassId node) {
        ParameterCode src = ParameterCode.VOLUME_OPERATION_SRC;
        ParameterCode dst = ParameterCode.VOLUME_OPERATION_DST;
        ParameterCode status = ParameterCode.VOLUME_OPERATION_OPER_STATUS;
        for (int i = 0; i < this.allCopyOpers.size(); ++i) {
            try {
                CopyOperationImpl oper = (CopyOperationImpl)this.allCopyOpers.get(i);
                if (!oper.getSrValueOf(src).equals(node) && !oper.getSrValueOf(dst).equals(node) || !((VolumeOperationOperStatusConstant)oper.getSrValueOf(status)).isActive()) continue;
                return oper;
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        return null;
    }

    public void setOperStatForAllCopyOfVswitch(VSwitch vSwitch, VolumeOperationOperStatusConstant operStat) {
        try {
            Iterator itr = this.allCopyOpers.iterator();
            while (itr.hasNext()) {
                CopyOperationImpl oper = (CopyOperationImpl)itr.next();
                if (!oper.getConnectedVSwitches()[0].equals(vSwitch)) continue;
                Parameter param = new Parameter(ParameterCode.VOLUME_OPERATION_OPER_STATUS, operStat);
                oper.setOneParameter(param, vSwitch);
                try {
                    HashMap<ParameterCode, VolumeOperationOperStatusConstant> changedValues = new HashMap<ParameterCode, VolumeOperationOperStatusConstant>();
                    changedValues.put(ParameterCode.VOLUME_OPERATION_OPER_STATUS, operStat);
                    ElementEventImpl elementEvent = new ElementEventImpl(this, oper);
                    elementEvent.setParameterList(changedValues);
                    EventServiceImpl.getInstance().fireElementChanged(elementEvent);
                }
                catch (RemoteException re) {
                    LogMgr.getServerLog().debug("Failed to update Client with the new state of Concatenation volume", re);
                }
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
        }
    }

    public void vSwitchConnectivityChanged(VSwitchConnectivityEvent event) {
        boolean isConnected = event.getConnectivityStatus();
        if (!isConnected) {
            this.setOperStatForAllCopyOfVswitch(event.getVSwitch(), VolumeOperationOperStatusConstant.VOLUME_OPERATION_UNKNOWN);
        } else {
            try {
                this.refreshCopyTable();
            }
            catch (RemoteException e) {
                LogMgr.getServerLog().debug(e);
            }
        }
    }

    public boolean isInvolvedInActiveRestoreOperation(VolumeNodeImpl nodeImpl) throws RemoteException {
        Iterator itr = this.allCopyOpers.iterator();
        while (itr.hasNext()) {
            CopyOperationImpl oper = (CopyOperationImpl)itr.next();
            if (!this.operationStatusActive(oper.getCopyStatus()) || !(oper instanceof RestoreOperationImpl)) continue;
            RestoreOperationImpl restoreOperation = (RestoreOperationImpl)oper;
            VolumeNodeImpl src = (VolumeNodeImpl)restoreOperation.getCopySrcNode();
            if (src.equals(nodeImpl)) {
                return true;
            }
            VolumeNodeImpl dst = (VolumeNodeImpl)restoreOperation.getCopyDstNode();
            if (!dst.equals(nodeImpl)) continue;
            return true;
        }
        return false;
    }

    public boolean operationStatusActive(VolumeOperationOperStatusConstant operStat) {
        return operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_OPERATING) || operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_WAITING);
    }

    public void restoreSnapshots(SnapshotVolume[] snapshots) throws RemoteException, IllegalValueException {
        if (snapshots != null && snapshots.length > 0) {
            for (int index = 0; index < snapshots.length; ++index) {
                snapshots[index].restore();
            }
        }
    }
}

