/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume.copy;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.exception.CopyAlreadyExistException;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperation;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public abstract class CopyOperationImpl
extends LogicObjectImpl
implements CopyOperation {
    private static List parameterCodeList;
    private CommKeyClassId dst;
    private String m_copyTypeName;
    private VolumeNode m_copySrcNode;
    private VolumeNode m_copyDstNode;
    private String m_copyStatusName;

    public CopyOperationImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    public CopyOperationImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.COPY_OPERATION, parameterCodeList);
    }

    public CopyOperationImpl(ClusterImpl cluster, CommKeyClassId src, CommKeyClassId dst, CommKeyClassId vSwitch, VolumeOperationType copyType, VolumeOperationOperStatusConstant status, SrInteger percentageCopied) throws RemoteException, IllegalValueException {
        super(cluster, ClassID.COPY_OPERATION, parameterCodeList);
        HashMap<ParameterCode, SrType> params = new HashMap<ParameterCode, SrType>(5);
        params.put(ParameterCode.VOLUME_OPERATION_SRC, src);
        params.put(ParameterCode.VOLUME_OPERATION_DST, dst);
        params.put(ParameterCode.VSWITCH_ID, vSwitch);
        params.put(ParameterCode.COPY_OPERATION_TYPE, copyType);
        params.put(ParameterCode.VOLUME_OPERATION_OPER_STATUS, status);
        params.put(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED, percentageCopied);
        if (copyType.equals(this.getAbortType())) {
            if (status.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK)) {
                params.put(ParameterCode.VOLUME_OPERATION_OPER_STATUS, VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED);
            } else {
                params.put(ParameterCode.VOLUME_OPERATION_OPER_STATUS, VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTE_FAILED);
            }
        }
        this.setParameterList(params);
        this.dst = dst;
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        VSwitch vSwitch = this.getVSwitch(parameterList);
        HashMap changedValues = super.setParameterList(parameterList);
        this.m_copyTypeName = this.getSrValueOf(ParameterCode.COPY_OPERATION_TYPE).toDisplayString();
        this.m_copySrcNode = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)this.getSrValueOf(ParameterCode.VOLUME_OPERATION_SRC));
        this.m_copyDstNode = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID((CommKeyClassId)this.getSrValueOf(ParameterCode.VOLUME_OPERATION_DST));
        this.m_copyStatusName = this.getSrValueOf(ParameterCode.VOLUME_OPERATION_OPER_STATUS).toDisplayString();
        if (this.getCopyType().equals(this.getAbortType())) {
            this.setOneParameter(ParameterCode.VOLUME_OPERATION_OPER_STATUS, VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED, vSwitch);
            changedValues.put(ParameterCode.VOLUME_OPERATION_OPER_STATUS, VolumeOperationOperStatusConstant.VOLUME_OPERATION_ABORTED);
        }
        return changedValues;
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        ced.setValue(ParameterCode.COPY_OPERATION_TYPE, this.getCopyType());
        ced.setValue(ParameterCode.VOLUME_OPERATION_SRC, this.getCopySrc());
        ced.setValue(ParameterCode.VOLUME_OPERATION_DST, this.getCopyDst());
        this.deleteElement(ced);
    }

    public SrType getSrValueOf(ParameterCode code) throws RemoteException {
        VSwitch[] connectedVs = this.getConnectedVSwitches();
        if (connectedVs.length > 0) {
            VSwitch vSwitch = connectedVs[0];
            return super.getSrValueOf(vSwitch, code);
        }
        return null;
    }

    public VolumeNode getCopySrcNode() throws RemoteException {
        return this.m_copySrcNode;
    }

    public VolumeNode getCopyDstNode() throws RemoteException {
        return this.m_copyDstNode;
    }

    public CommKeyClassId getCopySrc() {
        try {
            return (CommKeyClassId)this.getSrValueOf(ParameterCode.VOLUME_OPERATION_SRC);
        }
        catch (RemoteException re) {
            logger.error(re);
            return null;
        }
    }

    public VolumeOperationType getCopyType() throws RemoteException {
        return (VolumeOperationType)this.getSrValueOf(ParameterCode.COPY_OPERATION_TYPE);
    }

    public String getCopyTypeName() throws RemoteException {
        return this.m_copyTypeName;
    }

    public CommKeyClassId getVSwitchCommKeyClassId() {
        try {
            VSwitch vSwitch = this.getConnectedVSwitches()[0];
            return new CommKeyClassId(vSwitch.getCommKeys(), vSwitch.getClassId());
        }
        catch (RemoteException re) {
            logger.error(re);
            return null;
        }
    }

    public VSwitch getCopyVSwitch() throws RemoteException {
        return this.getConnectedVSwitches()[0];
    }

    public CommKeyClassId getCopyDst() {
        return this.dst;
    }

    public Integer getCopyPercentage() throws RemoteException {
        return (Integer)this.getSrValueOf(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED).value();
    }

    public VolumeOperationOperStatusConstant getCopyStatus() throws RemoteException {
        return (VolumeOperationOperStatusConstant)this.getSrValueOf(ParameterCode.VOLUME_OPERATION_OPER_STATUS);
    }

    public String getCopyStatusName() throws RemoteException {
        return this.m_copyStatusName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CopyOperationImpl) {
            try {
                return ((CopyOperationImpl)obj).getCommKeys().equals(this.getCommKeys());
            }
            catch (RemoteException re) {
                logger.error(re);
                return false;
            }
        }
        return false;
    }

    protected String canBeDeleted() throws RemoteException {
        return null;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        return null;
    }

    public void registerToPropagatedStateChange() throws RemoteException {
    }

    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    public boolean synchronize() throws RemoteException, IllegalValueException {
        return true;
    }

    public abstract VolumeOperationType getAbortType();

    public abstract VolumeOperationType getRestartType();

    public String toStringWhenError() {
        try {
            StringBuffer str = new StringBuffer("CopyOperImpl. CommKey is: ");
            str.append(this.getCommKeys().toString());
            str.append("\n params are: ");
            VSwitch[] vSwitches = this.getConnectedVSwitches();
            for (int i = 0; i < vSwitches.length; ++i) {
                str.append("\n Params are:");
                str.append(this.getParameterListValuesMap(vSwitches[i]).toString());
            }
            return str.toString();
        }
        catch (RemoteException re) {
            logger.error(re);
            return "";
        }
    }

    public void abortOperation() throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        DataMgr.getInstance().operate(element, this.getAbortType());
    }

    public void restartOperation() throws RemoteException, IllegalValueException {
        VSwitch vSwitch = this.getConnectedVSwitches()[0];
        if (vSwitch.isConnected()) {
            ((CopyOperationManagerImpl)((ClusterImpl)this.getCluster()).getCopyOperManager()).restartOperation(this);
            return;
        }
        VSwitch otherVswitch = this.cluster.getOtherVSwitch(vSwitch);
        if (!otherVswitch.isConnected()) {
            throw new IllegalValueException("Cannot find any active " + ClassID.VSWITCH + " to set the operation to.");
        }
        try {
            ((CopyOperationManagerImpl)((ClusterImpl)this.getCluster()).getCopyOperManager()).addCopyOperation((VolumeNodeImpl)this.getCopySrcNode(), (VolumeNodeImpl)this.getCopyDstNode(), otherVswitch, this.getRestartType());
        }
        catch (CopyAlreadyExistException copyAlreadyExistException) {
            // empty catch block
        }
    }

    public String toString() {
        try {
            StringBuffer str = new StringBuffer(this.getCopyTypeName());
            str.append(": src = ");
            str.append(this.getCopySrcNode());
            str.append(": dst = ");
            str.append(this.getCopyDstNode());
            str.append(": status = ");
            str.append(this.getCopyStatusName());
            return str.toString();
        }
        catch (RemoteException re) {
            logger.error(re);
            return "Copy Operation";
        }
        catch (NullPointerException npe) {
            logger.error(npe);
            return this.toStringWhenError();
        }
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED);
        parameterCodes.addElement(ParameterCode.VOLUME_OPERATION_DST);
        parameterCodes.addElement(ParameterCode.VOLUME_OPERATION_SRC);
        parameterCodes.addElement(ParameterCode.VOLUME_OPERATION_OPER_STATUS);
        parameterCodes.addElement(ParameterCode.COPY_OPERATION_TYPE);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

