/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.physstorage.Storageable;
import com.sanrad.nms.server.logic.volume.VirtualVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeTree;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class VolumeTreeImpl
extends RemoteObjectImpl
implements VolumeTree {
    private VolumeNode root;

    public VolumeTreeImpl(VolumeNode root) throws RemoteException {
        this.root = root;
    }

    public int getChildCount(Object parent) {
        return ((VolumeImpl)parent).getChildCount();
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return ((VolumeImpl)node).isLeaf();
    }

    public boolean isInTree(Volume volume) {
        if (this.root.equals(volume)) {
            return true;
        }
        if (this.root instanceof VolumeImpl && volume instanceof VirtualVolume) {
            return ((VolumeImpl)this.root).isVolumeDescendant((VirtualVolume)volume);
        }
        return false;
    }

    public boolean addChild(VirtualVolume child) throws RemoteException {
        VirtualVolumeImpl directParentOfChild;
        VolumeImpl parent;
        if (this.root instanceof VolumeImpl && (parent = ((VolumeImpl)this.root).getDescendantVolume(directParentOfChild = (VirtualVolumeImpl)((VirtualVolumeImpl)child).getParentVolume())) != null) {
            parent.insert(child);
            parent.updateChild(child);
            return true;
        }
        return false;
    }

    public VolumeNode getTreeRoot() throws RemoteException {
        return (VolumeNode)this.getRoot();
    }

    public Vector getRootChildren() throws RemoteException {
        return ((VolumeImpl)this.getTreeRoot()).getChildren();
    }

    private Volume getVolumeByAlias(String alias, Volume parent, Vector children) throws RemoteException {
        if (parent.getAlias().equals(alias)) {
            return parent;
        }
        if (children != null) {
            Enumeration e = children.elements();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                if (obj instanceof VirtualVolume) {
                    VirtualVolume volume = (VirtualVolume)obj;
                    return this.getVolumeByAlias(alias, volume, volume.getChildren());
                }
                if (obj instanceof Storageable) continue;
                logger.error(obj.getClass() + " not found in " + this.getClass() + "::getVolumeByAlias()");
            }
        }
        return null;
    }

    public Volume getVolumeByAlias(String alias) throws RemoteException {
        Volume root = (Volume)this.getRoot();
        return this.getVolumeByAlias(alias, root, root.getChildren());
    }

    public boolean isAliasExist(String alias) throws RemoteException {
        VolumeImpl root = (VolumeImpl)this.getTreeRoot();
        return root.isAliasExist(alias);
    }

    public void clear() throws RemoteException {
        this.root = null;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        int retVal = this.root.synchronize();
        return retVal;
    }

    public int getTotalVolumeCount() throws RemoteException {
        return this.root.getChildrenOfVirtualVolumeTypeCount() + 1;
    }
}

