/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.exception.CopyAlreadyExistException;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VirtualizationHierarchyObject;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.Storageable;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.ConcatinationVolume;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotManager;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeTreeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.volume.validators.AddMirrorValidator;
import com.sanrad.nms.server.logic.volume.validators.CreateVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.ReplaceVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.ResizeVolumeValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.volume.MirrVolConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class VolumeNodeImpl
extends SynchronizeableImpl
implements VolumeNode,
VirtualizationHierarchyObject {
    private static List parameterCodeList;
    private boolean exposed = false;
    private boolean free = true;
    private VolumeImpl volumeParent = null;
    private LU parentLU = null;

    protected VolumeNodeImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId, parameterCodeList);
    }

    protected String canBeDeleted() throws RemoteException {
        if (this.isExposed()) {
            return this.getClassId().toString() + " " + this.getAlias() + " is exposed - cannot be deleted";
        }
        if (this.getParentVolume() != null) {
            return this.getClassId().toString() + " " + this.getAlias() + " has parent - cannot be deleted";
        }
        if (this.isSnapshotSource()) {
            return this.getClassId().toString() + " " + this.getAlias() + " is a source of " + ClassID.SNAPSHOT_VOLUME + ".  You have to delete the " + ClassID.SNAPSHOT_VOLUME + " first";
        }
        if (this.isDROfflineLocalCopy()) {
            return this.getClassId().toString() + " " + this.getAlias() + " is used as a local copy of " + ClassID.ASYNC_PAIR + ".  You have to delete the " + ClassID.ASYNC_PAIR + " first";
        }
        return null;
    }

    public boolean isInternal() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (this.isInternal(vSwitches[i])) continue;
            return false;
        }
        return true;
    }

    public synchronized void setExposed(boolean exposed) throws RemoteException {
        if (exposed != this.exposed) {
            this.exposed = exposed;
            ElementEventImpl event = new ElementEventImpl(this, this);
            HashMap<ClientParameterCode, Serializable> parameterList = new HashMap<ClientParameterCode, Serializable>();
            parameterList.put(ClientParameterCode.VOLUME_EXPOSED, new Boolean(exposed));
            parameterList.put(ClientParameterCode.VOLUME_STATE, this.getVolumeState());
            event.setParameterList(parameterList);
            EventServiceImpl.getInstance().fireElementChanged(event);
        }
    }

    public boolean isFree() throws RemoteException {
        return this.free;
    }

    public void setFree(boolean free) throws RemoteException {
        this.free = free;
    }

    public int getBlockSize() throws RemoteException {
        return this.getBlockSize(null);
    }

    public abstract int getBlockSize(VSwitch var1) throws RemoteException;

    public double getBlockNum() throws RemoteException {
        return this.getBlockNum(null);
    }

    public abstract double getBlockNum(VSwitch var1) throws RemoteException;

    public abstract BigInteger getNumberOfBlocks(VSwitch var1) throws RemoteException;

    public void setParent(VolumeNode parent, int stam) throws RemoteException {
        this.volumeParent = (VolumeImpl)parent;
    }

    public void removeParent() throws RemoteException {
        this.setParent(null, 0);
    }

    public Volume getParentVolume() throws RemoteException {
        return this.volumeParent;
    }

    public Volume getParentVolume(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId parentCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_PARENT, vSwitch == null);
        if (parentCommKeyClassId == null) {
            return null;
        }
        return (Volume)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(parentCommKeyClassId);
    }

    public LU getParentLU() throws RemoteException {
        return this.parentLU;
    }

    public LU getParentLU(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId parentCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_LU, vSwitch == null);
        if (parentCommKeyClassId == null) {
            return this.parentLU;
        }
        return (LU)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(parentCommKeyClassId);
    }

    public void setParentLU(LU parent) throws RemoteException {
        this.parentLU = parent;
    }

    public boolean isChildOfMirror() throws RemoteException {
        if (this.getParentVolume() == null) {
            return false;
        }
        if (this.getParentVolume().getClassId().equals(ClassID.MIRROR_VOLUME)) {
            return true;
        }
        return this.getParentVolume().isChildOfMirror();
    }

    public boolean isInvolvedInCopy() throws RemoteException {
        return ((CopyOperationManagerImpl)this.cluster.getCopyOperManager()).isInvolvedInCopyOper(this.getCommKeyClassId());
    }

    public boolean isInvolvedInCopy(VSwitch vSwitch) throws RemoteException {
        return ((CopyOperationManagerImpl)this.cluster.getCopyOperManager()).isInvolvedInCopyOper(this.getCommKeyClassId(), vSwitch.getCommKeyClassId());
    }

    public boolean isInvolvedInActiveCopy(VSwitch vSwitch) throws RemoteException {
        return ((CopyOperationManagerImpl)this.cluster.getCopyOperManager()).isInvolvedInActiveCopyOper(this.getCommKeyClassId(), vSwitch.getCommKeyClassId());
    }

    public VSwitch isInvolvedInActiveCopyDownHirarchy() throws RemoteException {
        VSwitch[] volumeVSwitches = this.getConnectedVSwitchesList();
        for (int i = 0; i < volumeVSwitches.length; ++i) {
            if (!this.isInvolvedInActiveCopyDownHirarchy(volumeVSwitches[i])) continue;
            return volumeVSwitches[i];
        }
        return null;
    }

    public boolean isInvolvedInActiveCopyDownHirarchy(VSwitch vSwitch) throws RemoteException {
        if (this.getChildren() != null) {
            Iterator iter = this.getChildren().iterator();
            while (iter.hasNext()) {
                VolumeNodeImpl child = (VolumeNodeImpl)iter.next();
                if (!child.isInvolvedInActiveCopyDownHirarchy(vSwitch)) continue;
                return true;
            }
        }
        return ((CopyOperationManagerImpl)this.cluster.getCopyOperManager()).isInvolvedInActiveCopyOper(this.getCommKeyClassId(), vSwitch.getCommKeyClassId());
    }

    public CopyOperationImpl getCopyOperIfInvolved() throws RemoteException {
        return ((CopyOperationManagerImpl)this.cluster.getCopyOperManager()).getCopyForNode(this.getCommKeyClassId());
    }

    public boolean isSnapshotSource() {
        return this.cluster.getVolumeMgr().getSnapshotManager().isSourceOfSnapshot(this);
    }

    public boolean isSnapshotSource(VSwitch vSwitch) {
        return this.cluster.getVolumeMgr().getSnapshotManager().isSourceOfSnapshot(this, vSwitch);
    }

    public Vector getSnapshotsIfSource() {
        return this.cluster.getVolumeMgr().getSnapshotManager().getSnapshotsForSourceVolume(this);
    }

    private SrBITSConstant getState(VSwitch vSwitch) throws RemoteException {
        SrBITSConstant state = (SrBITSConstant)this.getSrValueOf(vSwitch, ParameterCode.VOLUME_STATE, vSwitch == null);
        return state;
    }

    public boolean isInState(VSwitch vSwitch, SrType state) throws RemoteException {
        SrBITSConstant volState = this.getState(vSwitch);
        if (volState != null) {
            return volState.contains((SrBITSConstant)state);
        }
        return false;
    }

    public boolean isInState(SrType state) throws RemoteException {
        VSwitch[] connectedVs = this.getConnectedVSwitches();
        for (int i = 0; i < connectedVs.length; ++i) {
            if (!this.isInState(connectedVs[i], state)) continue;
            return true;
        }
        return false;
    }

    public boolean isNonFunctional() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isNonFunctional(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isNonFunctional(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, VolumeStateConstant.VOLUME_STATE_NONFUNCTIONAL);
    }

    protected boolean isNeedSync() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isNeedSync(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isNeedSync(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, VolumeStateConstant.VOLUME_STATE_NEED_SYNC);
    }

    public boolean isInternal(VSwitch vSwitch) throws RemoteException {
        if (this.volumeParent == null) {
            return this.parentLU == null;
        }
        return false;
    }

    public boolean isSuspended(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, VolumeStateConstant.VOLUME_STATE_SUSPENDED);
    }

    private SrBITSConstant getVolumeState(VSwitch vSwitch) throws RemoteException {
        VSwitch vSwitchToGet = vSwitch;
        if (vSwitchToGet == null) {
            vSwitchToGet = this.isExposed() ? this.getExposedOnVSwitch() : this.getFirstVSwitch();
        }
        SrBITSConstant state = (SrBITSConstant)this.getSrValueOf(vSwitchToGet, ParameterCode.VOLUME_STATE, vSwitchToGet == null);
        return state;
    }

    public SrBITSConstant getVolumeState() throws RemoteException {
        return this.getVolumeState(null);
    }

    public boolean isExposed() throws RemoteException {
        return this.exposed;
    }

    public boolean isExposed(VSwitch vSwitch) throws RemoteException {
        if (this.getParentLU(vSwitch) == null) {
            Volume parent = this.getParentVolume(vSwitch);
            if (parent != null) {
                return parent.isExposed(vSwitch);
            }
            return false;
        }
        return true;
    }

    public boolean isRetractable(VSwitch vs) throws RemoteException {
        return this.isInState(vs, VolumeStateConstant.VOLUME_STATE_RETRACTABLE);
    }

    protected VolumeNode getHeadOfVolumeTree() throws RemoteException {
        VolumeNodeImpl headNode = this;
        for (Volume tmpParentNode = this.volumeParent; tmpParentNode != null; tmpParentNode = tmpParentNode.getParentVolume()) {
            headNode = tmpParentNode;
        }
        return headNode;
    }

    public LU getHeadLU() throws RemoteException {
        VolumeNode treeHead = this.getHeadOfVolumeTree();
        return ((VolumeNodeImpl)treeHead).getParentLU();
    }

    protected Target getHeadTarget() throws RemoteException {
        if (this.parentLU != null) {
            return this.parentLU.getParentTarget();
        }
        return null;
    }

    public VSwitch getExposedOnVSwitch() throws RemoteException {
        LU lu = this.getHeadLU();
        if (lu != null) {
            String vSwitchName = lu.getParentTarget().getExposedOnVSwitch();
            return ((ClusterImpl)this.getCluster()).getVSwitchByName(vSwitchName);
        }
        return null;
    }

    public VSwitch getVSwitchToSetForOfflineCopy() throws RemoteException {
        return this.getExposedOnVSwitch();
    }

    public void replace(CommKeyClassId newVol) throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        ReplaceVolumeValidator validator = new ReplaceVolumeValidator(this.cluster, this, this.getAlias(), (Object)this.getChildren(), storage.getVolumeMgr(), (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(newVol));
        SrType[] vSwitchToSet = validator.forWhichVswitchIsValidData();
        if (vSwitchToSet == null || vSwitchToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData oldVol = new ConfigElementData(this.getCommKeys(), this.getClassId());
        oldVol.setValue(ParameterCode.VOLUME_OPERATION_DST, newVol);
        oldVol.setValues(ParameterCode.VSWITCH_ID, vSwitchToSet);
        if (this.volumeParent != null) {
            CommKeyClassId parentVol = new CommKeyClassId(this.volumeParent.getCommKeys(), this.volumeParent.getClassId());
            oldVol.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, parentVol);
            Vector myParentChildren = this.volumeParent.getChildren();
            CommKeyClassId[] childrenData = new CommKeyClassId[myParentChildren.size()];
            for (int i = 0; i < myParentChildren.size(); ++i) {
                childrenData[i] = ((VolumeNodeImpl)myParentChildren.get(i)).getCommKeyClassId();
            }
            oldVol.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN, childrenData));
        } else if (this.parentLU != null) {
            CommKeyClassId parentLu = new CommKeyClassId(this.parentLU.getCommKeys(), this.parentLU.getClassId());
            oldVol.setValue(ParameterCode.VIRTUAL_VOLUME_LU, parentLu);
        } else {
            throw new IllegalValueException("Volume does not have any parent Volume or LU!");
        }
        DataMgr.getInstance().operate(oldVol, VolumeOperationType.VOL_OPER_REPLACE_VOLUME);
    }

    public void addMirror(CommKeyClassId newChild, String mirrVolAlias, boolean autoSync) throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        VolumeNodeImpl newChildVolume = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(newChild);
        Vector<VolumeNodeImpl> children = this.getChildren();
        if (children == null) {
            children = new Vector<VolumeNodeImpl>(2);
            children.addElement(this);
        }
        children.addElement(newChildVolume);
        AddMirrorValidator validator = new AddMirrorValidator(this.cluster, this, this.getAlias(), (Object)this.getChildren(), storage.getVolumeMgr(), newChildVolume);
        VSwitch[] vSwitchToSet = validator.forWhichVswitchIsValid();
        if (vSwitchToSet == null || vSwitchToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        MirrVolConfigElementData vol = null;
        if (this.volumeParent != null) {
            if (this.volumeParent instanceof MirrorVolumeImpl) {
                this.volumeParent.addMirror(newChild, mirrVolAlias, autoSync);
                return;
            }
            vol = new MirrVolConfigElementData(this.getCommKeys(), this.getClassId());
            CommKeyClassId parentVol = new CommKeyClassId(this.volumeParent.getCommKeys(), this.volumeParent.getClassId());
            vol.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, parentVol);
            Vector myParentChildren = this.volumeParent.getChildren();
            CommKeyClassId[] childrenData = new CommKeyClassId[myParentChildren.size()];
            for (int i = 0; i < myParentChildren.size(); ++i) {
                childrenData[i] = ((VolumeNodeImpl)myParentChildren.get(i)).getCommKeyClassId();
            }
            vol.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN, childrenData));
        } else if (this.parentLU != null) {
            vol = new MirrVolConfigElementData(this.getCommKeys(), this.getClassId());
            CommKeyClassId luData = new CommKeyClassId(this.parentLU.getCommKeys(), this.parentLU.getClassId());
            vol.setValue(ParameterCode.VIRTUAL_VOLUME_LU, luData);
        } else {
            throw new IllegalValueException("Cannot Upgrade Internal volume into Mirror volume.");
        }
        if (mirrVolAlias == null || mirrVolAlias.equals("")) {
            mirrVolAlias = CreateVolumeValidator.getDefaultAlias();
        }
        vol.setValue(ParameterCode.VOLUME_ALIAS, new SrString(mirrVolAlias));
        vol.setAutoSync(autoSync);
        vol.setValue(ParameterCode.VOLUME_OPERATION_DST, newChild);
        DataMgr.getInstance().operate(vol, VolumeOperationType.VOL_OPER_ADD_MIRROR);
    }

    public void resize(CommKeyClassId newChild, String cubeVolAlias) throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        VolumeNodeImpl newChildNode = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(newChild);
        ResizeVolumeValidator validator = new ResizeVolumeValidator(this.cluster, this, this.getAlias(), (Object)this.getChildren(), storage.getVolumeMgr(), newChildNode);
        CommKeyClassId[] vSToSet = validator.forWhichVswitchIsValidData(this.getConnectedVswitchesData());
        validator.isAllowedByDR();
        if (vSToSet == null || vSToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        ConfigElementData vol = null;
        VolumeImpl parent = (VolumeImpl)this.getParentVolume();
        if (parent != null) {
            if (parent instanceof ConcatinationVolume) {
                vol = new ConfigElementData(parent.getCommKeys(), parent.getClassId());
                Vector parentChildren = parent.getChildren();
                CommKeyClassId[] childrenData = new CommKeyClassId[parentChildren.size()];
                for (int i = 0; i < parentChildren.size(); ++i) {
                    childrenData[i] = ((VolumeNodeImpl)parentChildren.get(i)).getCommKeyClassId();
                }
                vol.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, childrenData));
            } else {
                vol = new ConfigElementData(this.getCommKeys(), this.getClassId());
                CommKeyClassId parentVol = new CommKeyClassId(parent.getCommKeys(), parent.getClassId());
                vol.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, parentVol);
                Vector myParentChildren = parent.getChildren();
                CommKeyClassId[] childrenData = new CommKeyClassId[myParentChildren.size()];
                for (int i = 0; i < myParentChildren.size(); ++i) {
                    childrenData[i] = ((VolumeNodeImpl)myParentChildren.get(i)).getCommKeyClassId();
                }
                vol.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN, childrenData));
            }
        } else {
            vol = new ConfigElementData(this.getCommKeys(), this.getClassId());
            if (this.parentLU != null) {
                CommKeyClassId luData = new CommKeyClassId(this.parentLU.getCommKeys(), this.parentLU.getClassId());
                vol.setValue(ParameterCode.VIRTUAL_VOLUME_LU, luData);
            }
        }
        if (cubeVolAlias == null || cubeVolAlias.equals("")) {
            cubeVolAlias = CreateVolumeValidator.getDefaultAlias();
        }
        vol.setValue(ParameterCode.VOLUME_ALIAS, new SrString(cubeVolAlias));
        vol.setValue(ParameterCode.VOLUME_OPERATION_DST, newChild);
        DataMgr.getInstance().operate(vol, VolumeOperationType.VOL_OPER_RESIZE);
    }

    public void mirrorSync() throws RemoteException, IllegalValueException {
        Volume parentVolume = this.getParentVolume();
        if (!(parentVolume instanceof MirrorVolumeImpl)) {
            throw new IllegalValueException("Volume is not a child of Mirror Volume");
        }
        try {
            this.mirrorSync((MirrorVolumeImpl)parentVolume, this);
        }
        catch (CopyAlreadyExistException copyE) {
            throw new IllegalValueException(copyE.getMessage());
        }
    }

    public void mirrorSync(MirrorVolumeImpl mirrVol, VolumeNodeImpl childToSync) throws RemoteException, IllegalValueException, CopyAlreadyExistException {
        VSwitch vSwitchToSet = this.getVSwitchToSetForMirrSync(mirrVol, childToSync);
        VolumeNodeImpl syncSrc = mirrVol.getSyncSource(vSwitchToSet, childToSync);
        if (syncSrc == null) {
            throw new IllegalValueException("Cannot find source volume for the Mirror Sync on " + vSwitchToSet);
        }
        Vector snapshots = mirrVol.getSnapshotsIfSource();
        if (snapshots != null) {
            for (int i = 0; i < snapshots.size(); ++i) {
                SnapshotVolumeImpl sns = (SnapshotVolumeImpl)snapshots.get(i);
                if (!sns.isInvolvedInAnotherRestoreOperation()) continue;
                throw new IllegalValueException("You cannot mirror sync while the snapshot " + sns + " is copy data");
            }
        }
        ((CopyOperationManagerImpl)((ClusterImpl)this.getCluster()).getCopyOperManager()).addCopyOperation(syncSrc, childToSync, vSwitchToSet, VolumeOperationType.VOL_OPER_MIRROR_SYNC);
    }

    protected VSwitch getVSwitchToSetForMirrSync(MirrorVolumeImpl mirrVol, VolumeNodeImpl childToSync) throws RemoteException, IllegalValueException, CopyAlreadyExistException {
        VSwitch vSwitchToSet = mirrVol.getDominentVswitch();
        if (vSwitchToSet == null) {
            VSwitch[] vswitches = this.getConnectedVSwitches();
            for (int i = 0; i < vswitches.length; ++i) {
                if (!childToSync.isKnownByVSwitch(vswitches[i])) continue;
                return vswitches[i];
            }
        } else if (!childToSync.isKnownByVSwitch(vSwitchToSet)) {
            throw new IllegalValueException(" You cannot activate mirror sync, since the child is not defined on " + ClassID.VSWITCH + " " + vSwitchToSet);
        }
        return vSwitchToSet;
    }

    public void offlineCopy(CommKeyClassId dst) throws RemoteException, IllegalValueException {
        VSwitch vSwitchToSet;
        DRAsyncPairImpl pair = (DRAsyncPairImpl)DRRootImpl.getInstance().getPairUsingLocalCopy((VolumeNodeImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(dst.getCommKeys(), dst.getClassID()));
        if (pair != null) {
            if (!pair.getLocalSnapshot().equals(this)) {
                throw new IllegalValueException("Cannot do offline copy on a local copy volume of pair " + pair);
            }
            if (pair.getLocalSnapshot().isInvolvedInCopy()) {
                return;
            }
        }
        if ((vSwitchToSet = this.getVSwitchToSetForOfflineCopy()) == null) {
            vSwitchToSet = this.getFirstVSwitch();
        }
        if (!vSwitchToSet.isConnected()) {
            vSwitchToSet = this.cluster.getOtherVSwitch(vSwitchToSet);
        }
        if (vSwitchToSet == null || !vSwitchToSet.isConnected()) {
            throw new IllegalValueException("Cannot find vSwitch for the Copy operation.");
        }
        VolumeNodeImpl dstNode = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(dst);
        try {
            ((CopyOperationManagerImpl)((ClusterImpl)this.getCluster()).getCopyOperManager()).addCopyOperation(this, dstNode, vSwitchToSet, VolumeOperationType.VOL_OPER_OFFLINE_COPY);
        }
        catch (CopyAlreadyExistException copyE) {
            throw new IllegalValueException(copyE.getMessage());
        }
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        Vector mySnapshots;
        SnapshotManager snapshotMgr;
        SynchronizeableImpl parent;
        VSwitch vSwitch = this.getVSwitch(parameterList);
        SrType myParent = this.getSrValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_PARENT);
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.getAlias();
        if (parameterList.containsKey(ParameterCode.VOLUME_STATE)) {
            parent = (VolumeImpl)this.getParentVolume();
            if (parent == null) {
                parent = (LUImpl)this.getParentLU();
            }
            if (parent != null) {
                parent.childVolumeStateWasChanged();
            }
        }
        if (parameterList.containsKey(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS) || parameterList.containsKey(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS)) {
            parent = (VolumeImpl)this.getParentVolume();
            if (parent == null) {
                parent = (LUImpl)this.getParentLU();
            }
            if (parent != null) {
                parent.childCapacityWasChanged();
            }
        }
        if (changedValues.containsKey(ParameterCode.VIRTUAL_VOLUME_PARENT) && (myParent == null || myParent != null && !((Object)myParent).equals(changedValues.get(ParameterCode.VIRTUAL_VOLUME_PARENT))) && (snapshotMgr = ((StorageImpl)this.cluster.getStorage()).getVolumeMgr().getSnapshotManager()).isSourceOfSnapshot(this) && (mySnapshots = snapshotMgr.getSnapshotsForSourceVolume(this)) != null) {
            Iterator itr = mySnapshots.iterator();
            while (itr.hasNext()) {
                VolumeNodeImpl snapshotVol = (VolumeNodeImpl)itr.next();
                if (!snapshotVol.isKnownByVSwitch(vSwitch) || !vSwitch.isConnected()) continue;
                ConfigElementData element = new ConfigElementData(snapshotVol.getCommKeyClassId());
                element.setValue(ParameterCode.SNAPSHOT_VOLUME_SOURCE, (SrType)null);
                SrType[] vSwitchData = new CommKeyClassId[]{vSwitch.getCommKeyClassId()};
                element.setValues(ParameterCode.VSWITCH_ID, vSwitchData);
                this.refreshFields(element);
            }
        }
        return changedValues;
    }

    public Volume getParentInVSwitch(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId parent = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_PARENT, vSwitch == null);
        return (Volume)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(parent);
    }

    public Integer getPositionInParent(VSwitch vSwitch) throws RemoteException {
        return (Integer)this.getValueOf(vSwitch, ParameterCode.VOLUME_POSITION, vSwitch == null);
    }

    public Integer getPositionInParent() throws RemoteException {
        return this.getPositionInParent(null);
    }

    public boolean isIllegalDownHierarchy() {
        return false;
    }

    public boolean isIllegalUpHierarchy() {
        try {
            if (this.volumeParent != null) {
                return this.volumeParent.isIllegalUpHierarchy();
            }
            if (this.parentLU != null) {
                return !((LUImpl)this.getHeadLU()).isLegitimateForVolumeOperation();
            }
        }
        catch (RemoteException re) {
            logger.error(re);
            return false;
        }
        return false;
    }

    public boolean isLegitimateForVolumeOperation() {
        return !this.isIllegalDownHierarchy() && !this.isIllegalUpHierarchy();
    }

    public boolean isDiskMissingDownHierarchy(VSwitch vswitch) {
        try {
            return this.isInState(vswitch, PhysicalStorageOperStatusConstant.PHYS_STOR_OPER_STAT_MISSING);
        }
        catch (RemoteException re) {
            logger.error(re);
            return false;
        }
    }

    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (!this.isSynchronizePending()) {
            return;
        }
        try {
            if (this.isNeedToSynchronize()) {
                int retVal = this.synchronizeMe();
                switch (retVal) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        this.errorInSynchronizing();
                    }
                }
                return;
            }
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            this.errorInSynchronizing();
            return;
        }
        this.doneSynchronizing();
    }

    public void doneSynchronizing() throws RemoteException {
        super.doneSynchronizing();
        LUImpl luParent = (LUImpl)this.getParentLU();
        try {
            if (luParent != null) {
                luParent.synchronizeMe();
            }
        }
        catch (IllegalValueException illegalValueException) {
            // empty catch block
        }
    }

    public VSwitch getDominentVswitch() throws RemoteException {
        if (this.volumeParent != null) {
            return ((VolumeNodeImpl)((Object)this.getParentVolume())).getDominentVswitch();
        }
        VSwitch[] vswitches = this.getConnectedVSwitches();
        LU parentLu = this.getParentLU();
        if (parentLu != null) {
            String result = parentLu.getParentTarget().getExposedOnVSwitch();
            for (int i = 0; i < vswitches.length; ++i) {
                if (!vswitches[i].getName().equals(result) || !vswitches[i].isConnected()) continue;
                return vswitches[i];
            }
        }
        return super.getDominentVswitch();
    }

    public boolean isUsedByAPair() throws RemoteException {
        return DRRootImpl.getInstance().getPairUseingVolume(this) != null;
    }

    public boolean isDROfflineLocalCopy() throws RemoteException {
        return DRRootImpl.getInstance().getPairUsingLocalCopy(this) != null;
    }

    public ConfigElementData getDuplicationConfigElementData(HashMap devices, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        logger.debug("building CED for " + this);
        ConfigElementData element = new ConfigElementData(ClassID.VOLUME_OPERATION);
        Vector children = this.getChildren();
        if (children != null && !children.isEmpty()) {
            ConfigElementDataList childrenElementList = new ConfigElementDataList();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                VolumeNodeImpl child = (VolumeNodeImpl)iter.next();
                childrenElementList.addElement(child.getDuplicationConfigElementData(devices, remoteCluster));
            }
            element.setValue(ParameterCode.VOLUME_CHILDREN, childrenElementList);
        } else {
            try {
                this.createIscsiDisk(devices, element, remoteCluster);
            }
            catch (IllegalAccessException e) {
                logger.debug(e);
            }
        }
        this.updateElementWithCreationParameters(element, remoteCluster);
        return element;
    }

    protected void createIscsiDisk(HashMap devices, ConfigElementData element, Cluster remoteCluster) throws RemoteException, IllegalAccessException, IllegalValueException {
        this.updateElementWithCreationParameters(element, remoteCluster);
    }

    public void updateElementWithCreationParameters(ConfigElementData element, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        super.updateElementWithCreationParameters(element, remoteCluster);
        String alias = this.getAliasForRemote(remoteCluster, this.getAlias());
        element.addParameter(new Parameter(MasterParameterCode.ALIAS.getParameterCode(this), new SrString(alias)));
    }

    private String getAliasForRemote(Cluster remoteCluster, String alias) throws RemoteException, IllegalValueException {
        if (this.isAliasAlreadyExsist(remoteCluster, alias)) {
            alias = this.getAliasForRemote(remoteCluster, alias + "_cfg");
        }
        return alias;
    }

    protected boolean isAliasAlreadyExsist(Cluster remoteCluster, String alias) throws RemoteException, IllegalValueException {
        Storageable remoteStorage = ((StorageImpl)remoteCluster.getStorage()).getStorageByAlias(alias);
        return remoteStorage != null;
    }

    protected LogicObject findEquivelentElement(Cluster cluster, LogicObject volChild) throws RemoteException, IllegalValueException {
        if (volChild != null) {
            if (this.equals(((VolumeNode)volChild).getParentVolume())) {
                return ((VolumeNode)volChild).getParentVolume();
            }
            throw new IllegalValueException(" the configured volume you gave has already exsist with a diffrent parameters");
        }
        return null;
    }

    public ConfigElementDataList removeVolumeTree() throws RemoteException {
        ConfigElementDataList elementList = new ConfigElementDataList();
        if (this.isExposed()) {
            ConfigElementData element = new ConfigElementData(this.getParentLU().getCommKeyClassId());
            element.setValue(ParameterCode.LU_VOLUME_ID, this.getCommKeyClassId());
            elementList.addElement(element);
        }
        elementList = this.buildCedListForRemoveVolumeTree(new Vector(), elementList);
        elementList.removeEqualElements();
        return elementList;
    }

    public ConfigElementDataList removeVolumeTree(SnapshotVolumeImpl sns) throws RemoteException {
        ConfigElementDataList elementList = new ConfigElementDataList();
        elementList.addElement(new ConfigElementData(sns.getCommKeyClassId()));
        elementList.addAll((Collection)this.buildCedListForRemoveVolumeTree(new Vector(), elementList));
        elementList.removeEqualElements();
        return elementList;
    }

    public VolumeNodeImpl findEquivelentInternalVolume(Cluster cluster) throws RemoteException {
        Vector volumes = cluster.getStorage().getInteranlVolumesByType(this.getClassId());
        for (int i = 0; i < volumes.size(); ++i) {
            Object obj = volumes.get(i);
            VolumeNode vol = null;
            vol = obj instanceof VolumeNode ? (VolumeNode)obj : ((VolumeTreeImpl)volumes.get(i)).getTreeRoot();
            if (!this.equals(vol)) continue;
            return (VolumeNodeImpl)vol;
        }
        return null;
    }

    public VolumeNodeImpl getRootVolume() throws RemoteException {
        VolumeNodeImpl parent = (VolumeNodeImpl)((Object)this.getParentVolume());
        if (parent != null) {
            return parent.getRootVolume();
        }
        return this;
    }

    public abstract ConfigElementDataList buildCedListForRemoveVolumeTree(Vector var1, ConfigElementDataList var2) throws RemoteException;

    public GeneralSCSIDevice[] getPhisycalDevicesOfVolume() throws RemoteException {
        ArrayList devices = this.getDevicesOfVolume();
        ArrayList<DirectAccessDevice> disks = new ArrayList<DirectAccessDevice>();
        for (int i = 0; i < devices.size(); ++i) {
            if (devices.get(i) instanceof SubDirectAccessDeviceImpl) {
                disks.add(i, ((SubDirectAccessDeviceImpl)devices.get(i)).getDirectAccessDeviceParent());
                continue;
            }
            disks.add(i, (DirectAccessDevice)devices.get(i));
        }
        return disks.toArray(new GeneralSCSIDevice[disks.size()]);
    }

    public ArrayList getDevicesOfVolume() throws RemoteException {
        ArrayList<VolumeNodeImpl> devices = new ArrayList<VolumeNodeImpl>();
        if (this.getChildren() == null || this.getChildren().isEmpty()) {
            devices.add(this);
        } else {
            Iterator children = this.getChildren().iterator();
            while (children.hasNext()) {
                VolumeNodeImpl child = (VolumeNodeImpl)children.next();
                devices.addAll(child.getDevicesOfVolume());
            }
        }
        return devices;
    }

    public boolean isPreventLocalCopy(HashSet set, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        if (this.isExposed() || this.getClassId().equals(ClassID.JOURNAL_VOLUME) || this.getClassId().equals(ClassID.SNAPSHOT_VOLUME) || this.isUsedByAPair() || this.isSnapshotSource() || this.isInvolvedInCopy()) {
            return false;
        }
        if (this.getPairUseingLocalCopy() != null && this.getPairUseingLocalCopy().getRemoteElement() != null && !this.getPairUseingLocalCopy().getRemoteElement().getCluster().equals(remoteCluster)) {
            return false;
        }
        if (this.getChildren() != null) {
            DRRootImpl.getInstance().localCopyAllowed(set, this, remoteCluster);
        }
        return true;
    }

    public DRAsyncPairImpl getPairUseingLocalCopy() throws RemoteException {
        return (DRAsyncPairImpl)DRRootImpl.getInstance().getPairUsingLocalCopy(this);
    }

    static {
        Vector<ParameterCode> parameterCodes = new Vector<ParameterCode>();
        parameterCodes.addElement(ParameterCode.VOLUME_STATE);
        parameterCodes.addElement(ParameterCode.VIRTUAL_VOLUME_MIRROR_SYNCH_OPER_STATUS);
        parameterCodes.addElement(ParameterCode.VIRTUAL_VOLUME_PARENT);
        parameterCodes.addElement(ParameterCode.VOLUME_POSITION);
        parameterCodeList = Collections.unmodifiableList(Arrays.asList(parameterCodes.toArray()));
    }
}

