/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.target.TargetList;
import com.sanrad.nms.server.logic.volume.SnapshotManager;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeForest;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrType;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class VolumeManager {
    private VolumeForest volumeForest;
    private TargetList targetList;
    private Cluster cluster;
    private SnapshotManager snapshotManger = new SnapshotManager();

    public VolumeManager(TargetList targetList, VolumeForest volumeForest, Cluster cluster) {
        this.volumeForest = volumeForest;
        this.targetList = targetList;
        this.cluster = cluster;
    }

    public SnapshotManager getSnapshotManager() {
        return this.snapshotManger;
    }

    public void clear() {
        this.volumeForest.removeAll();
        this.targetList.removeAll();
        this.snapshotManger.removeAll();
    }

    public boolean isAliasExist(String alias) throws RemoteException {
        if (this.volumeForest.isAliasExist(alias)) {
            return true;
        }
        if (this.targetList.isVolumeAliasExist(alias)) {
            return true;
        }
        Vector allDevices = ((ClusterImpl)this.cluster).getStoragePool().getAll();
        Enumeration e = allDevices.elements();
        while (e.hasMoreElements()) {
            SubDirectAccessDeviceImpl subDisk;
            GeneralSCSIDevice device = (GeneralSCSIDevice)e.nextElement();
            if (device instanceof DirectAccessDeviceImpl && (subDisk = ((DirectAccessDeviceImpl)device).getSubDirectAccessDevice(alias)) != null) {
                CopyOperationImpl copyOper = ((CopyOperationManagerImpl)((ClusterImpl)this.cluster).getCopyOperManager()).getCopyForNode(subDisk.getCommKeyClassId());
                if (subDisk.getParentLU() != null || subDisk.getParentVolume() != null || copyOper != null) {
                    return true;
                }
            }
            CopyOperationImpl copyOper = ((CopyOperationManagerImpl)((ClusterImpl)this.cluster).getCopyOperManager()).getCopyForNode(device.getCommKeyClassId());
            if (!device.getAlias().equals(alias) || device.getParentLU() == null && device.getParentVolume() == null && copyOper == null) continue;
            return true;
        }
        return false;
    }

    public int getTotalVolumeCount(TargetList targetList) throws RemoteException {
        return this.volumeForest.getTotalVolumeCount() + targetList.getTotalVolumeCount();
    }

    public boolean removeVolumeFromForest(VolumeNodeImpl volume) throws RemoteException {
        if (volume instanceof Volume) {
            ((VolumeImpl)volume).unRegisterToPropagatedStateListenerForAllLeafs((ClusterImpl)this.cluster);
            return this.volumeForest.removeVolumeTree((Volume)((Object)volume));
        }
        ((ClusterImpl)this.cluster).removePropagationStateDependentObjectAndListener(volume);
        return false;
    }

    public void readSnapshotVolumes() throws RemoteException {
        if (!this.cluster.getVSwitches().isEmpty()) {
            ConfigElementData element = new ConfigElementData(ClassID.SNAPSHOT_VOLUME);
            element.setValue(ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD, (SrType)null);
            Vector vSwitches = this.cluster.getVSwitches();
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwitches.size()];
            for (int i = 0; i < vSwitches.size(); ++i) {
                vSwitchesData[i] = new CommKeyClassId(((VSwitch)vSwitches.get(i)).getCommKeys(), ((VSwitch)vSwitches.get(i)).getClassId());
            }
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchesData));
            DataMgr.getInstance().refreshTableFields(element);
        }
    }
}

