/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SynchronizeEvent;
import com.sanrad.nms.server.logic.SynchronizeListener;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.Storageable;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.VirtualVolume;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeParentable;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.volume.validators.CreateVolumeValidator;
import com.sanrad.nms.server.logic.volume.validators.RemovChildValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public abstract class VolumeImpl
extends VolumeNodeImpl
implements Volume,
SynchronizeListener,
VolumeParentable {
    private Vector childrenVec = new Vector();
    public static final Integer BELONG_TO_ALL_VSWITCHES = new Integer(100);

    protected VolumeImpl(ClusterImpl cluster, ClassID classId) throws RemoteException {
        super(cluster, classId);
        this.addParameterCode(ParameterCode.VOLUME_ALIAS);
        this.addParameterCode(ParameterCode.VOLUME_CHILDREN);
        this.addParameterCode(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS);
        this.addParameterCode(ParameterCode.VIRTUAL_VOLUME_BLOCK_SIZE);
        this.addParameterCode(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS);
    }

    public String getAlias() throws RemoteException {
        return this.getAlias(null);
    }

    public String getAlias(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.VOLUME_ALIAS, vSwitch == null);
    }

    public int getBlockSize(VSwitch vSwitch) throws RemoteException {
        SrInteger blockSize = (SrInteger)this.getSrValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_BLOCK_SIZE, vSwitch == null);
        return blockSize == null ? -1 : blockSize.intValue();
    }

    public double getBlockNum(VSwitch vSwitch) throws RemoteException {
        return this.getNumberOfBlocks(vSwitch).doubleValue();
    }

    public double getBlockNum() throws RemoteException {
        return this.getBlockNum(null);
    }

    public BigInteger getNumberOfBlocks() throws RemoteException {
        return this.getNumberOfBlocks(null);
    }

    public BigInteger getNumberOfBlocks(VSwitch vSwitch) throws RemoteException {
        Object blockNumber = this.getValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS, vSwitch == null);
        if (blockNumber instanceof String) {
            return new BigInteger((String)blockNumber);
        }
        return (BigInteger)blockNumber;
    }

    public BigInteger getCapacityInBlocks() throws RemoteException {
        return this.getNumberOfBlocks();
    }

    public BigInteger getPotentialCapacity() throws RemoteException {
        return this.getPotentialCapacity(null);
    }

    public BigInteger getPotentialCapacity(VSwitch vSwitch) throws RemoteException {
        BigInteger numOfBlocks = (BigInteger)this.getValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS, vSwitch == null);
        return Util.blocksToBytes(numOfBlocks, this.getBlockSize(vSwitch));
    }

    public BigInteger getCapacityInBytes() throws RemoteException {
        BigInteger blockSize = new BigInteger(Integer.toString(this.getBlockSize()));
        return blockSize.multiply(this.getNumberOfBlocks());
    }

    public void setLeafsFree(boolean free) throws RemoteException {
        Vector storageDevices = new Vector();
        this.getLeafs(storageDevices);
        Enumeration e = storageDevices.elements();
        while (e.hasMoreElements()) {
            VolumeNode storageDevice = (VolumeNode)e.nextElement();
            storageDevice.setFree(free);
        }
    }

    public void getLeafs(Vector leafs) {
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            Object node = e.nextElement();
            try {
                if (!this.equals(((VolumeNodeImpl)node).getParentVolume())) {
                    continue;
                }
            }
            catch (RemoteException re) {
                logger.error(re);
            }
            if (node instanceof Storageable) {
                leafs.addElement(node);
                continue;
            }
            if (!(node instanceof VolumeImpl)) continue;
            ((VolumeImpl)node).getLeafs(leafs);
        }
    }

    public boolean isOneOfTheVolumesInHierarchyNeedSync() throws RemoteException {
        if (this.isNeedSync()) {
            return true;
        }
        Enumeration e = this.getChildren().elements();
        while (e.hasMoreElements()) {
            VolumeNode child = (VolumeNode)e.nextElement();
            if (!child.isOneOfTheVolumesInHierarchyNeedSync()) continue;
            return true;
        }
        return false;
    }

    public Vector getLeafs() throws RemoteException {
        Vector leafs = new Vector();
        this.getLeafs(leafs);
        return leafs;
    }

    public Vector getChildren() throws RemoteException {
        return this.childrenVec;
    }

    public Vector getChildren(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId[] childrenCommKeyClassId = (CommKeyClassId[])this.getSrArrayValueOf(vSwitch, ParameterCode.VOLUME_CHILDREN, false);
        Vector<Object> childrenInParamList = new Vector<Object>();
        for (int i = 0; childrenCommKeyClassId != null && i < childrenCommKeyClassId.length; ++i) {
            Object child = this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
            childrenInParamList.add(child);
        }
        return childrenInParamList;
    }

    public Enumeration children() {
        return this.childrenVec.elements();
    }

    public int getChildCount() {
        return this.childrenVec.size();
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public void insert(VolumeNode child) throws RemoteException {
        if (!this.childrenVec.contains(child)) {
            this.childrenVec.insertElementAt(child, 0);
        }
    }

    public void updateChild(VolumeNode child) throws RemoteException {
        if (child == null) {
            return;
        }
        this.addPropagationStateDependentObjectAndListener((VolumeNodeImpl)child);
        child.setParent(this, 0);
        child.setFree(false);
        child.setParentLU(null);
    }

    public void removeChild(int index) {
        this.childrenVec.removeElementAt(index);
    }

    public void removeChild(VolumeNodeImpl volume) throws RemoteException {
        for (int i = 0; i < this.childrenVec.size(); ++i) {
            if (volume != this.childrenVec.get(i)) continue;
            this.childrenVec.removeElementAt(i);
            this.removePropagationStateDependentObjectAndListener(volume);
            return;
        }
    }

    public boolean isVolumeChild(VolumeNode volume) {
        return this.childrenVec.contains(volume);
    }

    public boolean isVolumeChild(VSwitch vSwitch, VolumeNode volume) throws RemoteException {
        Vector children = this.getChildren(vSwitch);
        return children.contains(volume);
    }

    public boolean isVolumeDescendant(VirtualVolume volume) {
        if (this.isVolumeChild(volume)) {
            return true;
        }
        Enumeration e = this.childrenVec.elements();
        while (e.hasMoreElements()) {
            VolumeImpl v;
            Object child = e.nextElement();
            if (!(child instanceof Volume) || !(v = (VolumeImpl)child).isVolumeDescendant(volume)) continue;
            return true;
        }
        return false;
    }

    public VolumeImpl getDescendantVolume(VolumeImpl volume) {
        if (volume.equals(this)) {
            return this;
        }
        Enumeration e = this.childrenVec.elements();
        while (e.hasMoreElements()) {
            VolumeImpl v = (VolumeImpl)e.nextElement();
            if (!v.equals(volume)) continue;
            return v;
        }
        return null;
    }

    protected void setChild(Object child) throws RemoteException {
        if (child != null) {
            if (child instanceof VolumeNode) {
                VolumeNodeImpl childNode = (VolumeNodeImpl)child;
                if (childNode.getParentVolume() == null && childNode.getParentLU() == null) {
                    this.cluster.getVolumeMgr().removeVolumeFromForest(childNode);
                }
                this.insert(childNode);
                ((VolumeNodeImpl)child).addSynchronizeListener(this);
                childNode.setExposed(this.isExposed());
            } else {
                logger.error("Unknown type " + child.getClass() + " of volume child in " + this.getClass() + "::setChild()");
            }
        }
    }

    protected void setChildrenByCommKeyClassId(CommKeyClassId childrenCommKeyClassId) throws RemoteException {
        Object child = this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId);
        if (child != null) {
            this.setChild(child);
        } else {
            ConfigElementData rebuildElement = new ConfigElementData(ClassID.GENERAL_VOLUME);
            rebuildElement.setValue(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(childrenCommKeyClassId));
        }
    }

    public boolean setChildren(VSwitch vSwitch, Vector childrenOldListbyVSwitch) throws RemoteException {
        VolumeNodeImpl node;
        Vector childrenInParamList = this.getChildren(vSwitch);
        Vector oldChildren = (Vector)this.childrenVec.clone();
        if (!this.childrenVec.containsAll(childrenInParamList) || !childrenInParamList.containsAll(this.childrenVec)) {
            int i;
            this.childrenVec.clear();
            CommKeyClassId[] childrenCommKeyClassId = (CommKeyClassId[])this.getSrArrayValueOf(vSwitch, ParameterCode.VOLUME_CHILDREN, false);
            for (i = 0; i < childrenCommKeyClassId.length; ++i) {
                this.setChildrenByCommKeyClassId(childrenCommKeyClassId[i]);
            }
            for (i = 0; i < childrenCommKeyClassId.length; ++i) {
                VolumeNode childRef = (VolumeNode)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(childrenCommKeyClassId[i]);
                this.updateChild(childRef);
            }
            Enumeration iter = oldChildren.elements();
            while (iter.hasMoreElements()) {
                node = (VolumeNodeImpl)iter.nextElement();
                if (this.childrenVec.contains(node)) continue;
                if (node.getParentVolume().equals(this)) {
                    ((StorageImpl)this.cluster.getStorage()).returnVolumeToForest(node);
                    continue;
                }
                this.removePropagationStateDependentObjectAndListener(node);
            }
        }
        if (childrenOldListbyVSwitch != null && !childrenOldListbyVSwitch.isEmpty()) {
            CopyOperationManagerImpl copyMgr = (CopyOperationManagerImpl)this.cluster.getCopyOperManager();
            for (int index = 0; index < this.childrenVec.size(); ++index) {
                node = (VolumeNodeImpl)this.childrenVec.get(index);
                if (childrenOldListbyVSwitch.contains(node)) continue;
            }
        }
        return true;
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        VSwitch vSwitch = this.getVSwitch(parameterList);
        Vector childrenOldList = this.getChildren(vSwitch);
        HashMap changedValues = super.setParameterList(parameterList);
        this.toStringValue = this.getAlias();
        boolean childrenWasSet = parameterList.containsKey(ParameterCode.VOLUME_CHILDREN);
        if (childrenWasSet) {
            this.setChildren(this.getVSwitch(parameterList), childrenOldList);
        }
        if (changedValues.containsKey(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS) || changedValues.containsKey(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS) || childrenWasSet) {
            changedValues.put(ParameterCode.VOLUME_SPACE, null);
        }
        return changedValues;
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        CommKeyClassId[] childrenCommKeyClassId = new CommKeyClassId[this.childrenVec.size()];
        for (int i = 0; i < this.childrenVec.size(); ++i) {
            LogicObject child = (LogicObject)this.childrenVec.elementAt(i);
            childrenCommKeyClassId[i] = new CommKeyClassId(child.getCommKeys(), child.getClassId());
        }
        Parameter childrenParameter = new Parameter(ParameterCode.VOLUME_CHILDREN, childrenCommKeyClassId);
        ced.addParameter(childrenParameter);
        this.deleteElement(ced);
    }

    public boolean isAliasExist(String alias) throws RemoteException {
        if (alias.equals(this.getAlias())) {
            return true;
        }
        Vector children = this.getChildren();
        Enumeration e = children.elements();
        while (e.hasMoreElements()) {
            VolumeNode child = (VolumeNode)e.nextElement();
            if (!(child instanceof VolumeImpl) || !((VolumeImpl)child).isAliasExist(alias)) continue;
            return true;
        }
        return false;
    }

    protected boolean isChildOfVolume(VolumeNode child) throws RemoteException {
        Enumeration e = this.getChildren().elements();
        while (e.hasMoreElements()) {
            VolumeNode volChild = (VolumeNode)e.nextElement();
            if (!volChild.equals(child)) continue;
            return true;
        }
        return false;
    }

    public void setExposed(boolean exposed) throws RemoteException {
        Enumeration e = this.childrenVec.elements();
        while (e.hasMoreElements()) {
            VolumeNode child = (VolumeNode)e.nextElement();
            if (!this.equals(child.getParentVolume())) continue;
            child.setExposed(exposed);
        }
        super.setExposed(exposed);
    }

    public BigInteger getAccessibleSpace() throws RemoteException {
        return this.getAccessibleSpace(null);
    }

    public BigInteger getAccessibleSpace(VSwitch vSwitch) throws RemoteException {
        BigInteger numOfBlocks = (BigInteger)this.getValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS, vSwitch == null);
        return Util.blocksToBytes(numOfBlocks, this.getBlockSize(vSwitch));
    }

    public BigInteger getAllocatedSpace() throws RemoteException {
        BigInteger allocatedSpace = BigInteger.ZERO;
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            VolumeNode child = (VolumeNode)e.nextElement();
            if (child.getAllocatedSpace() == null) continue;
            allocatedSpace = allocatedSpace.add(child.getAllocatedSpace());
        }
        return allocatedSpace;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String alias = (String)parameterList.get(ClientParameterCode.VOLUME_ALIAS);
        if (alias != null) {
            String errorMsg = this.isAliasValid(alias);
            if (errorMsg != null) {
                return errorMsg;
            }
            if (alias.equals("")) {
                alias = CreateVolumeValidator.getDefaultAlias();
            }
            if (this.cluster.getVolumeMgr().isAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            if (this.cluster.getStoragePool().isAliasExist(alias)) {
                return ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(alias);
            }
            parameterList.put(ClientParameterCode.VOLUME_ALIAS, new SrString(alias));
        }
        return null;
    }

    public void clear() throws RemoteException {
        this.setParent(null, -1);
        this.childrenVec.clear();
        super.clear();
    }

    public int getChildrenOfVirtualVolumeTypeCount() throws RemoteException {
        int childrenCount = 0;
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            VolumeNode child = (VolumeNode)e.nextElement();
            if (child instanceof Volume) {
                ++childrenCount;
            }
            childrenCount += child.getChildrenOfVirtualVolumeTypeCount();
        }
        return childrenCount;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Volume) {
            try {
                if (((Volume)obj).getClassId().equals(this.getClassId()) && ((Volume)obj).getChildren().size() == this.getChildren().size()) {
                    boolean equal = false;
                    Enumeration e = ((Volume)obj).getChildren().elements();
                    while (e.hasMoreElements()) {
                        equal = this.getChildren().contains(e.nextElement());
                        if (equal) continue;
                        return super.equals(obj);
                    }
                    return true;
                }
                return super.equals(obj);
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        return false;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        LogMgr.getServerLog().debug("Start Sync volume " + this.getAlias());
        if (this.isSynchronizePending()) {
            logger.debug("Already synchronizing " + this.getClassId() + " " + this.toString());
            return 1;
        }
        logger.debug("Start to synchronize " + this.getClassId() + " " + this.toString());
        this.setSynchronizePending(true);
        int syncChildrenRetVal = 0;
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            try {
                VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
                int childRetVal = child.synchronize();
                LogMgr.getServerLog().debug("Sync of volume " + this.getAlias() + " Child" + child.getAlias() + " status " + childRetVal);
                if (childRetVal <= syncChildrenRetVal) continue;
                syncChildrenRetVal = childRetVal;
            }
            catch (IllegalValueException ive) {
                logger.warning(ive.getMessage());
                errMsg.append(" \n");
                errMsg.append(ive.getMessage());
                errOccured = true;
            }
        }
        if (errOccured) {
            this.setSynchronizePending(false);
            throw new IllegalValueException(errMsg.toString());
        }
        switch (syncChildrenRetVal) {
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                this.setSynchronizePending(false);
                return 3;
            }
        }
        if (!this.isNeedToSynchronize()) {
            this.setSynchronizePending(false);
            return 0;
        }
        int retVal = this.synchronizeMe();
        LogMgr.getServerLog().debug("Sync of volume " + this.getAlias() + " SyncMe status " + retVal);
        return retVal;
    }

    public synchronized boolean isNeedToSynchronize() throws RemoteException {
        if (this.cluster.getVSwitches().size() > CommKeyUtil.getSnmpCommKeys(this.getCommKeys()).length) {
            return true;
        }
        return this.isInconsistent();
    }

    protected abstract int createMeOnOtherVswitch() throws RemoteException, IllegalValueException;

    protected synchronized int synchronizeMe() throws RemoteException, IllegalValueException {
        try {
            if (this.canBeSynchronized() != null) {
                return 2;
            }
            if (super.isNeedToSynchronize() && !this.isInSynchronizingMode()) {
                this.setSynchronizingMode(true);
                int retVal = this.createMeOnOtherVswitch();
                switch (retVal) {
                    case 1: 
                    case 2: {
                        retVal = 2;
                        break;
                    }
                    case 3: {
                        this.setSynchronizePending(false);
                    }
                }
                return retVal;
            }
            HashMap childrenByVswitch = this.getChildrenListByVSwitch();
            Iterator iter = childrenByVswitch.keySet().iterator();
            while (iter.hasNext()) {
                VolumeNodeImpl[] existOnThis;
                Object key = iter.next();
                if (!(key instanceof VSwitch) || (existOnThis = (VolumeNodeImpl[])childrenByVswitch.get(key)).length == 0) continue;
                CommKeyClassId thisVswitchData = ((VSwitch)key).getCommKeyClassId();
                Vector vSwitches = this.getVSwitches();
                Vector<CommKeyClassId> vSwitchesToSync = new Vector<CommKeyClassId>();
                for (int i = 0; i < vSwitches.size(); ++i) {
                    CommKeyClassId current = ((VSwitch)vSwitches.get(i)).getCommKeyClassId();
                    if (thisVswitchData.equals(current)) continue;
                    vSwitchesToSync.add(current);
                }
                CommKeyClassId[] vSwitchesToSyncData = new CommKeyClassId[vSwitchesToSync.size()];
                vSwitchesToSync.toArray(vSwitchesToSyncData);
                int lowestPosition = 100;
                VolumeNodeImpl childToSync = null;
                for (int i = 0; i < existOnThis.length; ++i) {
                    int currPosition = existOnThis[i].getPositionInParent((VSwitch)key);
                    if (currPosition >= lowestPosition) continue;
                    lowestPosition = currPosition;
                    childToSync = existOnThis[i];
                }
                if (vSwitchesToSyncData.length <= 0) {
                    return 2;
                }
                this.addChild(childToSync, VolumeOperationType.VOL_OPER_ADD_CHILD, vSwitchesToSyncData, this.getCommKeyClassId());
                return 2;
            }
            return 0;
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
            this.setSynchronizePending(false);
            throw ive;
        }
    }

    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
            if (!child.isNeedToSynchronize()) continue;
            if (!child.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("Volume ");
                msg.append(this.getAlias());
                msg.append(" cannot be synchronized. ");
                msg.append(child.getClassId());
                msg.append(" ");
                msg.append(child);
                msg.append("is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            return child.getClassId() + " " + child + " is not synchronized yet";
        }
        return null;
    }

    public synchronized void synchronizingCompleted(SynchronizeEvent event) {
        try {
            this.syncDataWasChanged();
        }
        catch (RemoteException re) {
            logger.error(re);
        }
        catch (IllegalValueException ive) {
            logger.warning(ive.getMessage());
        }
    }

    public void registerToPropagatedStateChange() throws RemoteException {
        Enumeration e = this.getChildren().elements();
        while (e.hasMoreElements()) {
            LogicObjectImpl child = (LogicObjectImpl)e.nextElement();
            this.addPropagationStateDependentObjectAndListener(child);
        }
    }

    public void registerToPropagatedStateListenerForAllLeafs(LogicObjectImpl obj) throws RemoteException {
        obj.addPropagationStateDependentObjectAndListener(this);
        Vector leafs = this.getLeafs();
        Enumeration e = leafs.elements();
        while (e.hasMoreElements()) {
            obj.addPropagationStateDependentObjectAndListener((LogicObjectImpl)e.nextElement());
        }
    }

    public void unRegisterToPropagatedStateListenerForAllLeafs(LogicObjectImpl obj) throws RemoteException {
        obj.removePropagationStateDependentObjectAndListener(this);
        Vector leafs = this.getLeafs();
        Enumeration e = leafs.elements();
        while (e.hasMoreElements()) {
            obj.removePropagationStateDependentObjectAndListener((LogicObjectImpl)e.nextElement());
        }
    }

    public void resize(CommKeyClassId newChild, String cubeVolAlias) throws RemoteException, IllegalValueException {
    }

    public boolean isInconsistent() throws RemoteException {
        if (this.isRedundant() && this.getConnectedVSwitchCounter() > 1) {
            VSwitch[] vSwitches = this.getConnectedVSwitches();
            Object[] allChildren = new Object[vSwitches.length];
            for (int i = 0; i < vSwitches.length; ++i) {
                allChildren[i] = this.getSrArrayValueOf(vSwitches[i], ParameterCode.VOLUME_CHILDREN, false);
            }
            int childrenCount = ((CommKeyClassId[])allChildren[0]).length;
            for (int i = 1; i < allChildren.length; ++i) {
                if (childrenCount == ((CommKeyClassId[])allChildren[i]).length) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isIllegal() throws RemoteException {
        Enumeration e = this.getChildren().elements();
        while (e.hasMoreElements()) {
            int i;
            VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
            if (!child.isRedundant() || child.getConnectedVSwitchCounter() <= 1) continue;
            VSwitch[] vSwitches = child.getConnectedVSwitches();
            VolumeImpl[] parents = new VolumeImpl[vSwitches.length];
            for (i = 0; i < vSwitches.length; ++i) {
                parents[i] = (VolumeImpl)child.getParentVolume(vSwitches[i]);
            }
            for (i = 0; i < parents.length; ++i) {
                if (parents[i] != null && !parents[i].equals(this)) {
                    return true;
                }
                if (parents[i] != null) continue;
                logger.debug(child.getClassId() + " " + child + " has a null parent volume in " + ClassID.VSWITCH + " " + vSwitches[i]);
            }
        }
        return false;
    }

    public boolean isExistOneChildNonFunctional(VSwitch vSwitch) {
        Enumeration iter = this.children();
        while (iter.hasMoreElements()) {
            VolumeNodeImpl child = (VolumeNodeImpl)iter.nextElement();
            try {
                if (!child.isInState(vSwitch, VolumeStateConstant.VOLUME_STATE_NONFUNCTIONAL)) continue;
                return true;
            }
            catch (RemoteException e) {
                return true;
            }
        }
        return false;
    }

    public void addChild(VolumeNodeImpl childToAdd, VolumeOperationType oper, CommKeyClassId[] vSwitchesToSet, CommKeyClassId operationInvoker) throws RemoteException, IllegalValueException {
        CommKeyClassId newchild = childToAdd.getCommKeyClassId();
        ConfigElementData vol = new ConfigElementData(this.getCommKeys(), this.getClassId());
        CommKeyClassId[] childrenData = null;
        if (vSwitchesToSet == null || vSwitchesToSet.length != 1) {
            Vector volChildren = this.getChildren();
            childrenData = new CommKeyClassId[volChildren.size()];
            for (int i = 0; i < volChildren.size(); ++i) {
                childrenData[i] = ((VolumeNodeImpl)volChildren.get(i)).getCommKeyClassId();
            }
        } else {
            VSwitch vs = (VSwitch)SystemRootImpl.getInstance().getRefByStub(vSwitchesToSet[0]);
            childrenData = (CommKeyClassId[])this.getSrArrayValueOf(vs, ParameterCode.VOLUME_CHILDREN);
        }
        vol.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, childrenData));
        vol.setValue(ParameterCode.VOLUME_OPERATION_DST, newchild);
        vol.setValues(ParameterCode.VSWITCH_ID, vSwitchesToSet);
        vol.setOperationInvoker(operationInvoker);
        DataMgr.getInstance().operate(vol, oper);
    }

    public void removeChildren(CommKeyClassId[] childrenToRemove, VolumeOperationType operType) throws RemoteException, IllegalValueException {
        int i;
        VSwitch[] connectedVSwitches;
        VolumeNodeImpl[] children = new VolumeNodeImpl[childrenToRemove.length];
        for (int i2 = 0; i2 < children.length; ++i2) {
            children[i2] = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(childrenToRemove[i2]);
        }
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        RemovChildValidator validator = new RemovChildValidator(this.cluster, (VolumeNodeImpl)this, this.getAlias(), (Object)this.getChildren(), storage.getVolumeMgr(), children);
        VSwitch[] vSwitchToSet = validator.forWhichVswitchIsValid();
        if (vSwitchToSet == null || vSwitchToSet.length == 0) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        CommKeyClassId[] newListToRemove = childrenToRemove;
        VSwitch[] vSwitchToRemove = connectedVSwitches = this.getConnectedVSwitches();
        Object[] allChildren = new Object[connectedVSwitches.length];
        for (i = 0; i < connectedVSwitches.length; ++i) {
            allChildren[i] = this.getSrArrayValueOf(connectedVSwitches[i], ParameterCode.VOLUME_CHILDREN, false);
        }
        for (i = 0; i < childrenToRemove.length; ++i) {
            Vector<VSwitch> existInVSwitch = new Vector<VSwitch>();
            block3: for (int j = 0; j < allChildren.length; ++j) {
                CommKeyClassId[] oneVSchildrenList = (CommKeyClassId[])allChildren[j];
                for (int k = 0; k < oneVSchildrenList.length; ++k) {
                    if (!oneVSchildrenList[k].equals(childrenToRemove[i])) continue;
                    existInVSwitch.add(connectedVSwitches[j]);
                    continue block3;
                }
            }
            if (existInVSwitch.size() >= connectedVSwitches.length) continue;
            newListToRemove = new CommKeyClassId[]{childrenToRemove[i]};
            vSwitchToRemove = new VSwitch[existInVSwitch.size()];
            existInVSwitch.toArray(vSwitchToRemove);
            break;
        }
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.VOLUME_OPERATION_DST, newListToRemove));
        element.setValue(ParameterCode.VOLUME_OPERATION_SRC, this.getCommKeyClassId());
        CommKeyClassId[] vSwitchList = new CommKeyClassId[vSwitchToRemove.length];
        for (int i3 = 0; i3 < vSwitchToRemove.length; ++i3) {
            vSwitchList[i3] = vSwitchToRemove[i3].getCommKeyClassId();
        }
        element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchList));
        Vector myChildren = this.getChildren();
        CommKeyClassId[] myChildrenList = new CommKeyClassId[myChildren.size()];
        for (int i4 = 0; i4 < myChildren.size(); ++i4) {
            myChildrenList[i4] = ((VolumeNodeImpl)myChildren.get(i4)).getCommKeyClassId();
        }
        element.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, myChildrenList));
        if (this.getParentVolume() != null) {
            Volume parent = this.getParentVolume();
            element.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, parent.getCommKeyClassId());
            Vector myParentChildren = parent.getChildren();
            CommKeyClassId[] childrenData = new CommKeyClassId[myParentChildren.size()];
            for (int i5 = 0; i5 < myParentChildren.size(); ++i5) {
                childrenData[i5] = ((VolumeNodeImpl)myParentChildren.get(i5)).getCommKeyClassId();
            }
            element.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN, childrenData));
        } else if (this.getParentLU() != null) {
            element.setValue(ParameterCode.VIRTUAL_VOLUME_LU, this.getParentLU().getCommKeyClassId());
        }
        DataMgr.getInstance().operate(element, operType);
    }

    public HashMap getChildrenCommKeyClassIdListByVSwitch() throws RemoteException {
        HashMap listByNodes = this.getChildrenListByVSwitch();
        HashMap listByCommKeyClassId = new HashMap();
        Iterator keys = listByNodes.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            VolumeNodeImpl[] keyList = (VolumeNodeImpl[])listByNodes.get(key);
            CommKeyClassId[] commKeyClassIdList = new CommKeyClassId[keyList.length];
            for (int i = 0; i < keyList.length; ++i) {
                commKeyClassIdList[i] = keyList[i].getCommKeyClassId();
            }
            listByCommKeyClassId.put(key, commKeyClassIdList);
        }
        return listByCommKeyClassId;
    }

    public HashMap getChildrenListByVSwitch() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        Object[] allChildren = new Object[vSwitches.length];
        for (int i = 0; i < vSwitches.length; ++i) {
            try {
                allChildren[i] = this.getSrArrayValueOf(vSwitches[i], ParameterCode.VOLUME_CHILDREN, false);
                continue;
            }
            catch (RemoteException re) {
                logger.error(re);
            }
        }
        HashMap<Object, VolumeNodeImpl[]> listByVSwitch = new HashMap<Object, VolumeNodeImpl[]>(vSwitches.length + 1);
        Vector<VolumeNodeImpl> existInAll = new Vector<VolumeNodeImpl>();
        for (int i = 0; i < allChildren.length; ++i) {
            Vector<VolumeNodeImpl> existOnlyInThis = new Vector<VolumeNodeImpl>();
            CommKeyClassId[] oneVSchildrenList = (CommKeyClassId[])allChildren[i];
            for (int k = 0; k < oneVSchildrenList.length; ++k) {
                VolumeNodeImpl child = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(oneVSchildrenList[k]);
                if (child == null) continue;
                boolean childExist = true;
                for (int j = 0; j < allChildren.length; ++j) {
                    if (j == i) continue;
                    childExist = false;
                    CommKeyClassId[] otherVSchildrenList = (CommKeyClassId[])allChildren[j];
                    for (int p = 0; p < otherVSchildrenList.length; ++p) {
                        VolumeNodeImpl otherChild = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(otherVSchildrenList[p]);
                        if (!child.equals(otherChild)) continue;
                        childExist = true;
                        break;
                    }
                    if (childExist) continue;
                    existOnlyInThis.add(child);
                    break;
                }
                if (!childExist || i != 0) continue;
                existInAll.add(child);
            }
            VolumeNodeImpl[] exitInThisList = new VolumeNodeImpl[existOnlyInThis.size()];
            existOnlyInThis.toArray(exitInThisList);
            listByVSwitch.put(vSwitches[i], exitInThisList);
        }
        VolumeNodeImpl[] existInAllList = new VolumeNodeImpl[existInAll.size()];
        existInAll.toArray(existInAllList);
        listByVSwitch.put(BELONG_TO_ALL_VSWITCHES, existInAllList);
        return listByVSwitch;
    }

    public void childVolumeStateWasChanged() {
    }

    public void childCapacityWasChanged() {
        this.reReadVolumeCapacity();
    }

    public void reReadVolumeCapacity() {
        try {
            if (this.getCommKeys() != null) {
                ConfigElementData element = new ConfigElementData(this.getCommKeyClassId());
                element.setValue(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS, (SrType)null);
                element.setValue(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS, (SrType)null);
                this.refreshFields(element);
            }
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    public boolean isIllegalDownHierarchy() {
        Enumeration iter = this.children();
        while (iter.hasMoreElements()) {
            if (!((VolumeNodeImpl)iter.nextElement()).isIllegalDownHierarchy()) continue;
            return true;
        }
        try {
            return this.isIllegal();
        }
        catch (RemoteException re) {
            logger.error(re);
            return true;
        }
    }

    public boolean isIllegalUpHierarchy() {
        try {
            if (super.isIllegalUpHierarchy()) {
                return true;
            }
            return this.isIllegal();
        }
        catch (RemoteException re) {
            logger.error(re);
            return true;
        }
    }

    public boolean isDiskMissingDownHierarchy(VSwitch vswitch) {
        Enumeration iter = this.children();
        while (iter.hasMoreElements()) {
            if (!((VolumeNodeImpl)iter.nextElement()).isDiskMissingDownHierarchy(vswitch)) continue;
            return true;
        }
        return false;
    }

    protected Vector getNonFunctionalChildren(VSwitch vSwitch) throws RemoteException {
        Vector<VolumeNode> nonFuncChildren = new Vector<VolumeNode>();
        Enumeration e = this.getChildren().elements();
        while (e.hasMoreElements()) {
            VolumeNode child = (VolumeNode)e.nextElement();
            if (!child.isNonFunctional(vSwitch)) continue;
            nonFuncChildren.addElement(child);
        }
        return nonFuncChildren;
    }

    protected Vector getChildrenListForClusterSync(VSwitch vSwitchToSync) {
        Vector<VolumeNodeImpl> childrenForAutoSync = new Vector<VolumeNodeImpl>();
        try {
            VolumeStateConstant specialState = this.getMyTypeSpecialStateAfterAddChild();
            Enumeration e = this.getChildren().elements();
            while (e.hasMoreElements()) {
                VolumeNodeImpl child = (VolumeNodeImpl)e.nextElement();
                if (specialState != null && child.isInState(specialState)) continue;
                VSwitch[] vSwitchesChildExistOn = child.getConnectedVSwitches();
                boolean existOnVSToSync = false;
                for (int i = 0; i < vSwitchesChildExistOn.length; ++i) {
                    if (!vSwitchesChildExistOn[i].equals(vSwitchToSync)) continue;
                    existOnVSToSync = true;
                }
                if (!existOnVSToSync) {
                    return null;
                }
                childrenForAutoSync.add(child);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return childrenForAutoSync;
    }

    protected VolumeStateConstant getMyTypeSpecialStateAfterAddChild() {
        return null;
    }

    public void updateElementWithCreationParameters(ConfigElementData element, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        super.updateElementWithCreationParameters(element, remoteCluster);
    }

    protected boolean isAliasAlreadyExsist(Cluster remoteCluster, String alias) throws RemoteException {
        return ((StorageImpl)remoteCluster.getStorage()).getVolumeByAlias(alias) != null;
    }

    public ConfigElementDataList buildCedListForRemoveVolumeTree(Vector subdisks, ConfigElementDataList elementList) throws RemoteException {
        Vector children = this.getChildren();
        ConfigElementData element = new ConfigElementData(this.getCommKeyClassId());
        elementList.addElement(element);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            VolumeNodeImpl child = (VolumeNodeImpl)iter.next();
            elementList.addAll((Collection)child.buildCedListForRemoveVolumeTree(subdisks, elementList));
        }
        ((ClusterImpl)this.getCluster()).prepareVSwitchIDs(element, "prepare element for remove volume tree", this.getConnectedVSwitchesAsVector());
        return elementList;
    }

    public boolean isProvisioned() throws RemoteException {
        return ((VolumeNode)this.getDevicesOfVolume().get(0)).isProvisioned();
    }

    public boolean isMismatch(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, VolumeStateConstant.VOLUME_STATE_MISMATCH);
    }

    public boolean isNonValidate(VSwitch vswitch) throws RemoteException {
        return this.isInState(vswitch, VolumeStateConstant.VOLUME_STATE_NON_VALIDATE);
    }
}

