/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.volume.VirtualVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeTree;
import com.sanrad.nms.server.logic.volume.VolumeTreeImpl;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class VolumeForest {
    private Vector forest = new Vector();

    public boolean addVolumeTree(VolumeTreeImpl tree) throws RemoteException {
        Vector children = tree.getRootChildren();
        Enumeration child = children.elements();
        while (child.hasMoreElements()) {
            Object element = child.nextElement();
            if (!(element instanceof Volume)) continue;
            Volume volume = (Volume)element;
            Enumeration e = this.forest.elements();
            while (e.hasMoreElements()) {
                VolumeTreeImpl treeElement = (VolumeTreeImpl)e.nextElement();
                if (!volume.equals(treeElement.getRoot())) continue;
                this.moveVolumeTreeRootToBeChild(treeElement);
            }
        }
        this.forest.addElement(tree);
        return true;
    }

    private void createTreeAndAddVolumeAsRoot(Volume volume) throws RemoteException {
        VolumeTreeImpl newTree = new VolumeTreeImpl(volume);
        this.addVolumeTree(newTree);
    }

    public void addVolume(Volume volume) throws RemoteException {
        VolumeTreeImpl tree;
        if (volume instanceof VirtualVolume && (tree = this.getTreeOf(((VirtualVolumeImpl)volume).getParentVolume())) != null) {
            tree.addChild((VirtualVolume)volume);
        }
        this.createTreeAndAddVolumeAsRoot(volume);
    }

    private void moveVolumeTreeRootToBeChild(VolumeTree tree) throws RemoteException {
        this.forest.remove(tree);
    }

    public boolean removeVolumeTreeRoot(VolumeTree tree) throws RemoteException {
        Vector children = tree.getRootChildren();
        VolumeNode parent = tree.getTreeRoot();
        if (children != null) {
            Enumeration e = children.elements();
            while (e.hasMoreElements()) {
                Object node = e.nextElement();
                if (!(node instanceof Volume) || !parent.equals(((VolumeNodeImpl)node).getParentVolume())) continue;
                VolumeImpl volume = (VolumeImpl)node;
                volume.removeParent();
                this.addVolume(volume);
            }
        }
        return this.forest.remove(tree);
    }

    public boolean removeVolumeTree(VolumeTree tree) throws RemoteException {
        return this.forest.remove(tree);
    }

    public boolean removeVolumeTreeRoot(Volume root) throws RemoteException {
        VolumeTreeImpl tree = this.getTreeOf(root);
        if (tree != null) {
            return this.removeVolumeTreeRoot(tree);
        }
        return false;
    }

    public boolean removeVolumeTree(Volume root) throws RemoteException {
        VolumeTreeImpl tree = this.getTreeOf(root);
        return this.removeVolumeTree(tree);
    }

    public void removeAll() {
        this.forest.removeAllElements();
    }

    public int size() {
        return this.forest.size();
    }

    public Vector getAll() {
        return this.forest;
    }

    public VolumeTreeImpl getTreeOf(Volume volume) {
        if (volume != null) {
            Enumeration e = this.forest.elements();
            while (e.hasMoreElements()) {
                VolumeTreeImpl tree = (VolumeTreeImpl)e.nextElement();
                if (!tree.isInTree(volume)) continue;
                return tree;
            }
        }
        return null;
    }

    public Volume getVolumeByAlias(String alias) throws RemoteException {
        VolumeTreeImpl tree;
        Volume volume = null;
        Enumeration e = this.forest.elements();
        while (e.hasMoreElements() && (volume = (tree = (VolumeTreeImpl)e.nextElement()).getVolumeByAlias(alias)) == null) {
        }
        return volume;
    }

    public boolean isAliasExist(String alias) throws RemoteException {
        Enumeration e = this.forest.elements();
        while (e.hasMoreElements()) {
            VolumeTreeImpl tree = (VolumeTreeImpl)e.nextElement();
            if (!tree.isAliasExist(alias)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean synchronize() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        Enumeration e = this.forest.elements();
        while (e.hasMoreElements()) {
            try {
                VolumeTreeImpl tree = (VolumeTreeImpl)e.nextElement();
                tree.synchronize();
            }
            catch (IllegalValueException ive) {
                LogMgr.getServerLog().warning(ive.getMessage());
                errMsg.append(" \n");
                errMsg.append(ive.getMessage());
                errOccured = true;
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return false;
    }

    public int getTotalVolumeCount() throws RemoteException {
        int totalVolumeCount = 0;
        Enumeration e = this.forest.elements();
        while (e.hasMoreElements()) {
            VolumeTreeImpl tree = (VolumeTreeImpl)e.nextElement();
            totalVolumeCount += tree.getTotalVolumeCount();
        }
        return totalVolumeCount;
    }

    public Vector getAllVolumeRoots() {
        Vector<Object> roots = new Vector<Object>();
        Enumeration e = this.forest.elements();
        while (e.hasMoreElements()) {
            VolumeTreeImpl tree = (VolumeTreeImpl)e.nextElement();
            roots.addElement(tree.getRoot());
        }
        return roots;
    }
}

