/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.TransparentVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.NonVirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.TransparentVolume;
import com.sanrad.nms.server.logic.volume.validators.TransparentVolumeSyncValidator;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;

public class TransparentVolumeImpl
extends NonVirtualVolumeImpl
implements TransparentVolume {
    public TransparentVolumeImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.TRANSPARENT_VOLUME);
    }

    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        TransparentVolumeSyncValidator validator = new TransparentVolumeSyncValidator(this.cluster, this.getAlias(), (GeneralSCSIDevice)this.getChildren().elementAt(0), storage.getVolumeMgr(), this.cluster.getOtherVSwitches(this.getVSwitches()));
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        storage.createTransparentVolume(this.getAlias(), (GeneralSCSIDevice)this.getChildren().elementAt(0), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getConnectedVSwitches()[0], this.getCommKeyClassId());
        return 2;
    }

    public AlarmGenerator getAlarmGenerator() {
        return TransparentVolumeAlarmGenerator.getInstance();
    }
}

