/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.StripeVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.StripeVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.validators.StripeVolumeSyncValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.Util;
import java.math.BigInteger;
import java.rmi.RemoteException;

public class StripeVolumeImpl
extends VirtualVolumeImpl
implements StripeVolume {
    public StripeVolumeImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.STRIPE_VOLUME);
        this.addParameterCode(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE);
    }

    public BigInteger getStripeSize() throws RemoteException {
        return this.getStripeSize(null);
    }

    public BigInteger getStripeSize(VSwitch vSwitch) throws RemoteException {
        BigInteger stripeSizeBlocks = (BigInteger)this.getValueOf(vSwitch, ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, vSwitch == null);
        return Util.blocksToBytes(stripeSizeBlocks, this.getBlockSize());
    }

    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        StripeVolumeSyncValidator validator = new StripeVolumeSyncValidator(this.cluster, this.getAlias(), this.getChildren(), this.getStripeSize(), storage.getVolumeMgr(), this.cluster.getOtherVSwitches(this.getVSwitches()));
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        storage.createStripeVolume(this.getAlias(), this.getChildren(), this.getStripeSize(), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getConnectedVSwitches()[0], this.getCommKeyClassId());
        return 2;
    }

    public AlarmGenerator getAlarmGenerator() {
        return StripeVolumeAlarmGenerator.getInstance();
    }

    public boolean isIllegal() throws RemoteException {
        boolean inconsistent = super.isInconsistent();
        if (!inconsistent) {
            return super.isIllegal();
        }
        return inconsistent;
    }

    public boolean isInconsistent() throws RemoteException {
        return false;
    }

    public void updateElementWithCreationParameters(ConfigElementData element, Cluster remoteCluster) throws RemoteException, IllegalValueException {
        super.updateElementWithCreationParameters(element, remoteCluster);
        element.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, this.getSrArrayValueOf(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE)));
    }
}

