/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.volume.SnapshotAlarmGenerator;
import com.sanrad.nms.server.exception.CopyAlreadyExistException;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.VirtualVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.volume.copy.RestoreOperation;
import com.sanrad.nms.server.logic.volume.validators.SnapshotVolumeSyncValidator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.mgr.volume.SnapshotVolConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class SnapshotVolumeImpl
extends VirtualVolumeImpl
implements SnapshotVolume {
    private RestoreOperation m_restoreOperation = null;

    public SnapshotVolumeImpl(ClusterImpl cluster) throws RemoteException {
        super(cluster, ClassID.SNAPSHOT_VOLUME);
        this.addParameterCode(ParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME);
        this.addParameterCode(ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD);
        this.addParameterCode(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH);
        this.addParameterCode(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        this.addParameterCode(ParameterCode.SNAPSHOT_ACTIVATE);
    }

    public Long getDateAndTime() throws RemoteException {
        return this.getDateAndTime(this.getSourceExposedOnVSwitch());
    }

    public Long getDateAndTime(VSwitch vSwitch) throws RemoteException {
        Long dateAndTime = (Long)this.getValueOf(vSwitch, ParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, vSwitch == null);
        return dateAndTime;
    }

    public int getPercentageLoad() throws RemoteException {
        return this.getPercentageLoad(this.getSourceExposedOnVSwitch());
    }

    public int getPercentageLoad(VSwitch vSwitch) throws RemoteException {
        Integer percentLoad = (Integer)this.getValueOf(vSwitch, ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD, vSwitch == null);
        if (percentLoad != null) {
            return percentLoad;
        }
        return -1;
    }

    public int getPercentageThreshold() throws RemoteException {
        return this.getPercentageThreshold(this.getSourceExposedOnVSwitch());
    }

    public int getPercentageThreshold(VSwitch vSwitch) throws RemoteException {
        Integer percentThresh = (Integer)this.getValueOf(vSwitch, ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, vSwitch == null);
        if (percentThresh != null) {
            return percentThresh;
        }
        return -1;
    }

    public VolumeNode getSourceVolume() throws RemoteException {
        return this.getSourceVolume(null);
    }

    public VolumeNode getSourceVolume(VSwitch vSwitch) throws RemoteException {
        CommKeyClassId sourceCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.SNAPSHOT_VOLUME_SOURCE, vSwitch == null);
        if (sourceCommKeyClassId == null) {
            return null;
        }
        Object source = this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(sourceCommKeyClassId);
        if (source == null) {
            source = this.cluster.getVolumeMgr().getSnapshotManager().getSourceOfSnapshot(this, vSwitch);
        }
        return (VolumeNode)source;
    }

    public boolean isOutOfSync() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isOutOfSync(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isOutOfSync(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, VolumeStateConstant.VOLUME_STATE_OUT_OF_SYNC);
    }

    public boolean isModified() throws RemoteException {
        VSwitch[] vSwitches = this.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            if (!this.isModified(vSwitches[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isModified(VSwitch vSwitch) throws RemoteException {
        return this.isInState(vSwitch, VolumeStateConstant.VOLUME_STATE_WRITTEN);
    }

    public boolean isIllegalSnapshotSource() throws RemoteException {
        VSwitch[] connectedVs = this.getConnectedVSwitches();
        VolumeNode source = this.getSourceVolume(connectedVs[0]);
        if (source == null) {
            return true;
        }
        for (int i = 1; i < connectedVs.length; ++i) {
            if (source.equals(this.getSourceVolume(connectedVs[i]))) continue;
            return true;
        }
        return false;
    }

    public AlarmGenerator getAlarmGenerator() {
        return SnapshotAlarmGenerator.getInstance();
    }

    protected void setVswitchesToPerformOperation(ConfigElementData element, HashMap parameterList) throws RemoteException, IllegalValueException {
        if (parameterList.containsKey(ClientParameterCode.SNAPSHOT_ACTIVATE)) {
            SnapshotActivateTypeConstants sat = (SnapshotActivateTypeConstants)parameterList.get(ClientParameterCode.SNAPSHOT_ACTIVATE);
            VSwitch[] connectedVswitch = this.getConnectedVSwitches();
            ArrayList<CommKeyClassId> vswitchesToChangeSnapshotActiveState = new ArrayList<CommKeyClassId>(connectedVswitch.length);
            for (int index = 0; index < connectedVswitch.length; ++index) {
                VSwitch currentVSwitch = connectedVswitch[index];
                SnapshotActivateTypeConstants currentActiveStateByVSwitch = this.getActivatedState(currentVSwitch);
                if (currentActiveStateByVSwitch.equals(sat)) continue;
                vswitchesToChangeSnapshotActiveState.add(new CommKeyClassId(currentVSwitch.getCommKeys(), currentVSwitch.getClassId()));
            }
            CommKeyClassId[] vSwitchCommKeyClassId = new CommKeyClassId[vswitchesToChangeSnapshotActiveState.size()];
            vSwitchCommKeyClassId = vswitchesToChangeSnapshotActiveState.toArray(vSwitchCommKeyClassId);
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchCommKeyClassId));
        }
    }

    protected int createMeOnOtherVswitch() throws RemoteException, IllegalValueException {
        StorageImpl storage = (StorageImpl)this.cluster.getStorage();
        SnapshotVolumeSyncValidator validator = new SnapshotVolumeSyncValidator(this.cluster, this.getSourceVolume(), this.getAlias(), (VolumeNode)this.getChildren().get(0), this.getPercentageThreshold(), storage.getVolumeMgr(), this.cluster.getOtherVSwitches(this.getVSwitches()));
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        storage.createSnapshotVolume(this.getAlias(), this.getSourceVolume(), (VolumeNode)this.getChildren().get(0), this.getPercentageThreshold(), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getConnectedVSwitches()[0], this.getCommKeyClassId());
        return 2;
    }

    protected String isValid(HashMap parameterList) throws RemoteException {
        String valid = super.isValid(parameterList);
        if (valid == null) {
            SnapshotActivateTypeConstants activateOpType;
            Integer threshold = (Integer)parameterList.get(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD);
            if (threshold != null) {
                int val = threshold;
                if (val < 0 || val > 100) {
                    return ErrorMessage.SNAPSHOT_THRESHOLD_INVALID.getMessage(threshold.toString());
                }
                parameterList.put(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD, new SrInteger(threshold));
            }
            if ((activateOpType = (SnapshotActivateTypeConstants)parameterList.get(ClientParameterCode.SNAPSHOT_ACTIVATE)) != null) {
                boolean isNowInActiveOp = this.getActivatedState().equals(SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE);
                if (activateOpType.equals(SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE) && isNowInActiveOp || activateOpType.equals(SnapshotActivateTypeConstants.SNAPSHOT_INACTIVE) && !isNowInActiveOp) {
                    String[] parts = new String[]{this.toString(), activateOpType.toString()};
                    return ErrorMessage.SNAPSHOT_ACTIVATE_INVALID.getMessage(parts);
                }
                parameterList.put(ClientParameterCode.SNAPSHOT_ACTIVATE, activateOpType);
            }
        }
        return valid;
    }

    public BigInteger getAccessibleSpace() throws RemoteException {
        return this.getAccessibleSpace(this.getSourceExposedOnVSwitch());
    }

    public BigInteger getAccessibleSpace(VSwitch vSwitch) throws RemoteException {
        VolumeNode sourceVolume = this.getSourceVolume(vSwitch);
        if (sourceVolume != null) {
            return sourceVolume.getAccessibleSpace();
        }
        return null;
    }

    public HashMap setParameterList(HashMap parameterList) throws RemoteException, IllegalValueException {
        boolean isVSwitchAddedForRedundancy;
        VolumeNodeImpl newSourceVolume;
        int oldNumberOfVSwitches = this.getConnectedVSwitchCounter();
        Long oldDate = this.getDateAndTime();
        int oldPercentageLoad = this.getPercentageLoad();
        int oldPercentageThreshold = this.getPercentageThreshold();
        SnapshotActivateTypeConstants oldActivate = this.getActivatedState();
        VSwitch vSwitch = this.getVSwitch(parameterList);
        VolumeNodeImpl oldSource = (VolumeNodeImpl)this.getSourceVolume(vSwitch);
        HashMap changedValues = super.setParameterList(parameterList);
        if (changedValues.containsKey(ParameterCode.SNAPSHOT_VOLUME_SOURCE) && (newSourceVolume = (VolumeNodeImpl)this.getSourceVolume(vSwitch)) != null) {
            this.cluster.getVolumeMgr().getSnapshotManager().addSnapshot(newSourceVolume, this, vSwitch);
            newSourceVolume.addSynchronizeListener(this);
            if (oldSource != null && !oldSource.equals(newSourceVolume)) {
                this.cluster.getVolumeMgr().getSnapshotManager().removeSnapshotBySource(this, oldSource, vSwitch);
                VolumeNode otherVsSource = this.getSourceVolume(this.cluster.getOtherVSwitch(vSwitch));
                if (!oldSource.equals(otherVsSource)) {
                    oldSource.removeSynchronizeListener(this);
                }
            }
        }
        int newNumberOfVSwitches = this.getConnectedVSwitchCounter();
        boolean bl = isVSwitchAddedForRedundancy = oldNumberOfVSwitches > 0 && oldNumberOfVSwitches < newNumberOfVSwitches;
        if (isVSwitchAddedForRedundancy) {
            HashMap<Serializable, Serializable> paramsForChangeEvent = new HashMap<Serializable, Serializable>();
            Long newDate = this.getDateAndTime();
            int newPercentageLoad = this.getPercentageLoad();
            int newPercentageThreshold = this.getPercentageThreshold();
            SnapshotActivateTypeConstants newActivate = this.getActivatedState();
            if (oldDate == null && newDate != null) {
                paramsForChangeEvent.put(ParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, newDate);
            }
            if (oldPercentageLoad < 0 && newPercentageLoad >= 0) {
                paramsForChangeEvent.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD, new Integer(newPercentageLoad));
            }
            if (oldPercentageThreshold < 0 && newPercentageThreshold >= 0) {
                paramsForChangeEvent.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, new Integer(newPercentageThreshold));
            }
            if (oldActivate == null && newActivate != null) {
                paramsForChangeEvent.put(ClientParameterCode.SNAPSHOT_ACTIVATE, newActivate);
            }
            if (!paramsForChangeEvent.isEmpty()) {
                ElementEventImpl elementEvent = new ElementEventImpl(this, this);
                elementEvent.setParameterList(paramsForChangeEvent);
                EventServiceImpl.getInstance().fireElementChanged(elementEvent);
            }
        }
        return changedValues;
    }

    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        VolumeNodeImpl sourceVol;
        String msg = super.canBeSynchronized();
        if (msg == null && (sourceVol = (VolumeNodeImpl)this.getSourceVolume()).isNeedToSynchronize()) {
            if (!sourceVol.isSynchronizePending()) {
                StringBuffer message = new StringBuffer("Cannot synchronize Snapshot volume ");
                message.append(this.getAlias());
                message.append(". Source volume ");
                message.append(sourceVol.getAlias());
                message.append(" need to be synchronized first.");
                msg = message.toString();
                throw new IllegalValueException(msg.toString());
            }
            return sourceVol.getClassId() + " " + sourceVol + " is not synchronized yet";
        }
        return msg;
    }

    public void deleteElement() throws RemoteException, IllegalValueException {
        SnapshotVolConfigElementData ced = new SnapshotVolConfigElementData(this.getCommKeys(), this.getClassId());
        Vector childrenVec = this.getChildren();
        CommKeyClassId[] childrenCommKeyClassId = new CommKeyClassId[childrenVec.size()];
        for (int i = 0; i < childrenVec.size(); ++i) {
            LogicObject child = (LogicObject)childrenVec.elementAt(i);
            childrenCommKeyClassId[i] = new CommKeyClassId(child.getCommKeys(), child.getClassId());
        }
        Parameter childrenParameter = new Parameter(ParameterCode.VOLUME_CHILDREN, childrenCommKeyClassId);
        ced.addParameter(childrenParameter);
        VolumeNode srcVol = this.getSourceVolume();
        ced.setValue(ParameterCode.SNAPSHOT_VOLUME_SOURCE, srcVol.getCommKeyClassId());
        ced.setSourceExposed(srcVol.isExposed());
        this.deleteElement(ced);
    }

    public boolean isOverUsed(VSwitch vSwitch) throws RemoteException {
        int thresh;
        int load = this.getPercentageLoad(vSwitch);
        return load >= (thresh = this.getPercentageThreshold(vSwitch));
    }

    public boolean isFull(VSwitch vSwitch) throws RemoteException {
        int load = this.getPercentageLoad(vSwitch);
        return this.isOutOfSync(vSwitch) && load == 100;
    }

    public void setActivedState(SnapshotActivateTypeConstants state) throws RemoteException {
        ConfigElementData element = new ConfigElementData(this.getCommKeys(), this.getClassId());
        element.addParameter(new Parameter(ParameterCode.SNAPSHOT_ACTIVATE, state));
        DataMgr.getInstance().changeElement(element);
    }

    public SnapshotActivateTypeConstants getActivatedState() throws RemoteException {
        return this.getActivatedState(this.getSourceExposedOnVSwitch());
    }

    public SnapshotActivateTypeConstants getActivatedState(VSwitch vSwitch) throws RemoteException {
        SnapshotActivateTypeConstants snapShotActiveState = (SnapshotActivateTypeConstants)this.getSrValueOf(vSwitch, ParameterCode.SNAPSHOT_ACTIVATE, vSwitch == null);
        return snapShotActiveState;
    }

    public boolean isInActiveState() throws RemoteException {
        SnapshotActivateTypeConstants snapshotActiveState = this.getActivatedState();
        return snapshotActiveState != null && snapshotActiveState.equals(SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE);
    }

    private VSwitch getSourceExposedOnVSwitch() throws RemoteException {
        VSwitchImpl vSwitch = null;
        VolumeNodeImpl sourceVolume = (VolumeNodeImpl)this.getSourceVolume();
        if (sourceVolume != null && sourceVolume.isExposed() && sourceVolume.getParentLU() != null && sourceVolume.getParentLU().getParentTarget() != null) {
            String vSwitchName = sourceVolume.getParentLU().getParentTarget().getExposedOnVSwitch();
            ClusterImpl cluster = (ClusterImpl)this.getCluster();
            vSwitch = (VSwitchImpl)cluster.getVSwitchByName(vSwitchName);
            if (vSwitch != null && !vSwitch.isConnected()) {
                vSwitch = (VSwitchImpl)cluster.getOtherVSwitch(vSwitch);
            }
        }
        return vSwitch;
    }

    public HashMap getClientParameterList() throws RemoteException {
        HashMap list = super.getClientParameterList();
        list.put(ClientParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, this.getDateAndTime());
        list.put(ClientParameterCode.SNAPSHOT_VOLUME_LOAD, new Integer(this.getPercentageLoad()));
        list.put(ClientParameterCode.SNAPSHOT_VOLUME_THRESHOLD, new Integer(this.getPercentageThreshold()));
        list.put(ClientParameterCode.SNAPSHOT_ACTIVATE, this.getActivatedState());
        if (this.m_restoreOperation != null) {
            list.put(ClientParameterCode.SNAPSHOT_RESTORE_OPERATION, this.m_restoreOperation);
        }
        return list;
    }

    public void restore() throws RemoteException, IllegalValueException {
        VSwitch vSwitchToSet = this.getExposedOnVSwitch();
        if (vSwitchToSet == null) {
            vSwitchToSet = this.getFirstVSwitch();
        }
        if (!vSwitchToSet.isConnected()) {
            vSwitchToSet = this.cluster.getOtherVSwitch(vSwitchToSet);
        }
        if (vSwitchToSet == null || !vSwitchToSet.isConnected()) {
            throw new IllegalValueException("Cannot find vSwitch for the Restore operation.");
        }
        try {
            ((CopyOperationManagerImpl)((ClusterImpl)this.getCluster()).getCopyOperManager()).addCopyOperation(this, (VolumeNodeImpl)this.getSourceVolume(), vSwitchToSet, VolumeOperationType.VOL_OPER_RESTORE);
        }
        catch (CopyAlreadyExistException copyE) {
            throw new IllegalValueException(copyE.getMessage());
        }
    }

    public void setRestoreOperation(RestoreOperation restoreOperation) {
        this.m_restoreOperation = restoreOperation;
    }

    public RestoreOperation getRestoreOperation() {
        return this.m_restoreOperation;
    }

    public boolean isInvolvedInAnotherRestoreOperation() throws RemoteException {
        if (this.getRestoreOperation() != null) {
            VSwitch[] connectedVswitches = this.m_restoreOperation.getConnectedVSwitches();
            for (int index = 0; index < connectedVswitches.length; ++index) {
                VSwitch vswitch = connectedVswitches[index];
                if (!vswitch.isConnected()) continue;
                return !this.getRestoreOperation().getCopyStatus().equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK);
            }
        }
        return false;
    }

    public VSwitch getVSwitchToSetForOfflineCopy() throws RemoteException {
        VSwitch vswitch = super.getExposedOnVSwitch();
        if (vswitch == null) {
            VolumeNodeImpl snapshotSource = (VolumeNodeImpl)this.getSourceVolume();
            return snapshotSource.getExposedOnVSwitch();
        }
        return null;
    }

    public synchronized boolean isNeedToSynchronize() throws RemoteException {
        boolean isVolumeNeedToSync = super.isNeedToSynchronize();
        if (!isVolumeNeedToSync) {
            return !this.isConsistentBetweenVSwitches(ParameterCode.SNAPSHOT_ACTIVATE);
        }
        return true;
    }

    protected synchronized int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!super.isNeedToSynchronize()) {
            if (!this.isConsistentBetweenVSwitches(ParameterCode.SNAPSHOT_ACTIVATE)) {
                SnapshotActivateTypeConstants activeVSwitchActivate = (SnapshotActivateTypeConstants)((Parameter)this.getParameters(this.getActiveVswitch()).get(ParameterCode.SNAPSHOT_ACTIVATE)).getValue();
                HashMap<ParameterCode, SnapshotActivateTypeConstants> activateParamList = new HashMap<ParameterCode, SnapshotActivateTypeConstants>();
                activateParamList.put(ParameterCode.SNAPSHOT_ACTIVATE, SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE);
                ParameterList list = new ParameterList(activateParamList);
                if (activeVSwitchActivate.equals(SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE)) {
                    this.changeElementInInactiveVswitch(list);
                } else {
                    this.changeElementForActiveVswitch(list);
                }
                return 2;
            }
            return 0;
        }
        return super.synchronizeMe();
    }

    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (this.isConsistentBetweenVSwitches(ParameterCode.SNAPSHOT_ACTIVATE)) {
            super.syncDataWasChanged();
        }
    }

    public VSwitch getDominentVswitch() throws RemoteException {
        if (this.isInternal()) {
            VSwitch result;
            CommKeyClassId volCommKeyClassId = this.getCommKeyClassIdValueOf(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
            VolumeNode vol = (VolumeNode)this.getCluster().getCommKeyRefMap().getRefByCommKeyClassID(volCommKeyClassId);
            if (vol != null && this.isKnownByVSwitch(result = vol.getActiveVswitch())) {
                return result;
            }
        }
        return super.getDominentVswitch();
    }
}

