/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.volume;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

class SnapshotMap {
    private Hashtable snapshotMap = new Hashtable();

    public void removeAll() {
        this.snapshotMap.clear();
    }

    public void addSnapshot(VolumeNode sourceVolume, SnapshotVolume snapshotVolume) {
        if (sourceVolume == null) {
            return;
        }
        Vector snapshotList = null;
        if (this.snapshotMap.containsKey(sourceVolume)) {
            snapshotList = (Vector)this.snapshotMap.get(sourceVolume);
            if (!snapshotList.contains(snapshotVolume)) {
                snapshotList.addElement(snapshotVolume);
            }
            return;
        }
        snapshotList = new Vector();
        snapshotList.addElement(snapshotVolume);
        this.snapshotMap.put(sourceVolume, snapshotList);
    }

    public Vector getSnapshotsForSourceVolume(VolumeNode sourceVolume) {
        return (Vector)this.snapshotMap.get(sourceVolume);
    }

    public boolean isSourceOfSnapshot(VolumeNode sourceVolume) {
        return this.snapshotMap.containsKey(sourceVolume);
    }

    public void removeSnapshot(SnapshotVolume snapshotVolume) throws RemoteException {
        block3: {
            block2: {
                VolumeNode source = snapshotVolume.getSourceVolume();
                if (source == null) break block2;
                if (!this.snapshotMap.containsKey(source)) break block3;
                Vector sourceEntry = (Vector)this.snapshotMap.get(source);
                sourceEntry.remove(snapshotVolume);
                if (sourceEntry.isEmpty()) {
                    this.snapshotMap.remove(source);
                }
                break block3;
            }
            Iterator i = this.snapshotMap.keySet().iterator();
            while (i.hasNext()) {
                Object snapSource = i.next();
                Vector snapList = (Vector)this.snapshotMap.get(snapSource);
                if (!snapList.contains(snapshotVolume)) continue;
                i.remove();
                break;
            }
        }
    }

    public void removeSnapshotBySource(SnapshotVolume snapshotVolume, VolumeNode source) {
        if (this.snapshotMap.containsKey(source)) {
            Vector sourceEntry = (Vector)this.snapshotMap.get(source);
            sourceEntry.remove(snapshotVolume);
            if (sourceEntry.isEmpty()) {
                this.snapshotMap.remove(source);
            }
        }
    }

    public VolumeNode getSourceOfSnapshot(SnapshotVolume snap) {
        VolumeNode source;
        block3: {
            Vector snapsOfSource;
            source = null;
            try {
                source = snap.getSourceVolume();
            }
            catch (RemoteException e) {
                LogMgr.getServerLog().warning("Failed to get snapshot source", e);
                return null;
            }
            if (source != null) break block3;
            Iterator itr = this.snapshotMap.keySet().iterator();
            while (itr.hasNext() && !(snapsOfSource = (Vector)this.snapshotMap.get(source = (VolumeNode)itr.next())).contains(snap)) {
            }
        }
        return source;
    }
}

